/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.modelassignee.service.ModelAssigneeService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.constant.BpmEnum;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/model"})
public class ModelController {
    @Autowired
    private ModelService modelService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private ModelAssigneeService modelAssigneeService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private BussinessLogService businessLog;

    @RequestMapping(value={"/modelQuery"})
    @ManageBusinessLog(key="/model/modelQuery", value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> queryModelList(@RequestParam(required=false) String modelName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            Map map = this.modelService.queryModelList(modelName, page, limit);
            return ApiResponse.data((Object)map);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    @ManageBusinessLog(key="/model/modelDeploy", value="\u90e8\u7f72\u6d41\u7a0b", type="\u53d1\u5e03")
    public ApiResponse<?> deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            this.modelService.deployModel(modelId, BaseShiroKit.getUser().getTenantId());
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        return ApiResponse.success((int)BpmEnum.DEPLOY_SUCCESS.getCode(), (String)BpmEnum.DEPLOY_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/batchImport"})
    @ManageBusinessLog(key="/model/batchImport", value="\u6279\u91cf\u5bfc\u5165", type="\u6279\u91cf\u5bfc\u5165")
    public ApiResponse<?> batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        return this.modelService.importModel(BaseShiroKit.getUser().getTenantId(), file, request);
    }

    @RequestMapping(value={"/exportFiles"})
    @ManageBusinessLog(key="/model/exportFiles", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    public void exportAllFile(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportAllFileModel(BaseShiroKit.getUser().getTenantId(), modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBusinessLog(key="/model/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    public ApiResponse<?> deleteModel(String modelId, String processKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9a\u4e49\u7684\u7c7b\u578b\u64cd\u4f5c,\u5bf9");
        b.append(processDefinition.getName());
        b.append("\u8fdb\u884c\u4e86\u5220\u9664\u6d41\u7a0b\u6a21\u578b\u53ca\u5176\u6240\u6709\u7248\u672c\u7684\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("23", "/processDefinition/cancelMain", b.toString(), processDefinition.getName());
        try {
            return this.modelService.deleteModel(BaseShiroKit.getUser().getTenantId(), modelId, processKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @RequestMapping(value={"/deleteModelWithVersion"})
    @ManageBusinessLog(key="/model/deleteModelWithVersion", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    public ApiResponse<?> deleteModelWithVersion(String processDefId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefId.split(":")[0]).latestVersion().singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9a\u4e49\u7c7b\u578b\u7684\u64cd\u4f5c,\u5bf9");
        b.append(processDefinition.getName());
        b.append("\u7684\u7248\u672c");
        b.append(processDefId.split(":")[1]);
        b.append("\u8fdb\u884c\u4e86\u5220\u9664\u6d41\u7a0b\u6a21\u578b\u7684\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("23", "/processDefinition/cancelMain", b.toString(), processDefinition.getName());
        try {
            return this.modelService.deleteModelWithVersion(BaseShiroKit.getUser().getTenantId(), processDefId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @RequestMapping(value={"/getAllModel"})
    @ManageBusinessLog(key="/model/getAllModel", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="\u67e5\u8be2")
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.data((Object)this.modelService.getAllModel());
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBusinessLog(key="/model/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, String variables) {
        Map body = (Map)JSON.parseObject((String)variables, HashMap.class);
        HashMap map = new HashMap();
        if (body != null) {
            for (Map.Entry vo : body.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, map, BaseShiroKit.getUser().getTenantId());
    }

    @RequestMapping(value={"/doneList"})
    public ApiResponse<?> doneList(String businessKey) {
        return this.modelService.doneList(businessKey, BaseShiroKit.getUser().getTenantId());
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @ManageBusinessLog(key="/model/deleteProcessInstanceByBusinessKey", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/getProcessAssignee"})
    @ManageBusinessLog(key="/model/getProcessAssignee", value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult getProcessAssignee(String procDefKey, String taskDefKey, HttpServletRequest request) {
        return this.modelAssigneeService.getAssigneeModel(procDefKey, taskDefKey, request.getHeader("appid"));
    }

    @RequestMapping(value={"/downloadFiles"})
    @ManageBusinessLog(key="/model/downloadFiles", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    public void downloadXmlTest(HttpServletRequest request, HttpServletResponse response) {
        this.modelService.downloadFiles(BaseShiroKit.getUser().getTenantId(), request, response);
    }
}

