/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.check.model;

import com.jxdinfo.hussar.flowmodel.enums.BpmNodeTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class NodeMessage {
    private String nodeId;
    private String nodeType;
    private List<String> nextNodeIds;
    private List<String> prevNodeIds;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public List<String> getNextNodeIds() {
        return this.nextNodeIds;
    }

    public void setNextNodeIds(List<String> nextNodeIds) {
        this.nextNodeIds = nextNodeIds;
    }

    public List<String> getPrevNodeIds() {
        return this.prevNodeIds;
    }

    public void setPrevNodeIds(List<String> prevNodeIds) {
        this.prevNodeIds = prevNodeIds;
    }

    public NodeMessage(String nodeId, String nodeType) {
        this.nodeId = nodeId;
        this.nodeType = nodeType;
        this.nextNodeIds = new ArrayList<String>();
        this.prevNodeIds = new ArrayList<String>();
    }

    public boolean isUnRunNode() {
        return BpmNodeTypeEnum.BPM_START.getType().equals(this.nodeType) || BpmNodeTypeEnum.BPM_END.getType().equals(this.nodeType) || (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(this.nodeType) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(this.nodeType)) && (this.prevNodeIds.size() > 1 || this.nextNodeIds.size() > 1);
    }

    public boolean isMergeGateWay() {
        return this.prevNodeIds.size() > 1 && (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(this.nodeType) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(this.nodeType));
    }

    public boolean isDistributeGateWay() {
        return this.nextNodeIds.size() > 1 && (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(this.nodeType) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(this.nodeType));
    }
}

