/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.definition.controller;

import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.constant.BpmEnum;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.response.ApiResponse;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processDefinition"})
public class ProcessDefinitionsController
extends BaseController {
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private BussinessLogService businessLog;

    @RequestMapping(value={"/queryProcessDefinitionsList"})
    @ManageBusinessLog(key="/processDefinition/queryProcessDefinitionsList", value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> queryProcessDefinitionsList(@RequestParam(value="definitionKey", required=false) String definitionKey, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        Map map = this.processDefinitionsService.queryProcessDefinitionsList(definitionKey, page, limit);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/setMain"})
    @ManageBusinessLog(key="/processDefinition/setMain", value="\u8bbe\u7f6e\u4e3b\u7248\u672c", type="\u4fee\u6539")
    public ApiResponse<?> setMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.setMain(processDefKey, id);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefKey).latestVersion().singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9a\u4e49\u7c7b\u578b\u7684\u64cd\u4f5c,\u5bf9");
        b.append(processDefinition.getName());
        b.append("\u6d41\u7a0b\u7684");
        b.append(id.split(":")[1]);
        b.append("\u7248\u672c\u8fdb\u884c\u4e86\u8bbe\u7f6e\u4e3b\u7248\u672c\u7684\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("21", "/processDefinition/setMain", b.toString(), processDefinition.getName());
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, id, BaseShiroKit.getUser().getTenantId())) {
                return ApiResponse.success((int)BpmEnum.SET_SUCCESS.getCode(), (String)BpmEnum.SET_SUCCESS.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.FILES_NOT_FOUND.getCode(), (String)BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        return ApiResponse.fail((int)BpmEnum.SET_FAIL.getCode(), (String)BpmEnum.SET_FAIL.getMessage());
    }

    @RequestMapping(value={"/cancelMain"})
    @ManageBusinessLog(key="/processDefinition/cancelMain", value="\u53d6\u6d88\u4e3b\u7248\u672c", type="\u4fee\u6539")
    public ApiResponse<?> cancelMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.cancelMain(processDefKey, id);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefKey).latestVersion().singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9a\u4e49\u7684\u64cd\u4f5c,\u5bf9");
        b.append(processDefinition.getName());
        b.append("\u6d41\u7a0b\u7684");
        b.append(id.split(":")[1]);
        b.append("\u7248\u672c\u8fdb\u884c\u4e86\u53d6\u6d88\u4e3b\u7248\u672c\u7684\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("22", "/processDefinition/cancelMain", b.toString(), processDefinition.getName());
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, processDefinition.getId(), BaseShiroKit.getUser().getTenantId())) {
                return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.FILES_NOT_FOUND.getCode(), (String)BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
    }

    @RequestMapping(value={"/getNewVersion"})
    @ManageBusinessLog(key="/processDefinition/getNewVersion", value="\u67e5\u8be2\u6d41\u7a0b\u6700\u9ad8\u7248\u672c", type="\u67e5\u8be2")
    public ApiResponse<Map<String, String>> getNewVersion(@RequestParam(value="processDefKeys", required=true) String processDefKeys) {
        Map map = this.processDefinitionsService.getNewVersion(processDefKeys);
        return ApiResponse.data((Object)map);
    }
}

