/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.assignee.controller;

import com.jxdinfo.hussar.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assignee"})
public class AssigneeChooseController {
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;

    @RequestMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam String id, String applicationId, String dbName) {
        if (ToolUtil.isNotEmpty((Object)dbName)) {
            return this.iAssigneeChooseService.userTree(id, BaseShiroKit.getUser().getTenantId(), false, dbName, true);
        }
        return this.iAssigneeChooseService.userTree(id, BaseShiroKit.getUser().getTenantId(), false, applicationId, false, true);
    }

    @RequestMapping(value={"/tenantUser"})
    public List<BpmTreeModel> tenantUserTree(@RequestParam String id, @RequestParam(required=false) String isSecurity) {
        Boolean isSecuritys = ToolUtil.isNotEmpty((Object)isSecurity) && Boolean.parseBoolean(isSecurity);
        return this.iAssigneeChooseService.userTree(id, BaseShiroKit.getUser().getTenantId(), false, null, true, isSecuritys.booleanValue());
    }

    @RequestMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.iAssigneeChooseService.deptTree(id, BaseShiroKit.getUser().getTenantId(), false, null);
    }

    @RequestMapping(value={"/role"})
    public List<BpmTreeModel> roleTree() {
        return this.iAssigneeChooseService.roleTree(BaseShiroKit.getUser().getTenantId(), false, null);
    }

    @RequestMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(String userId) {
        return String.valueOf(this.iAssigneeChooseService.getSecurityLevel(userId));
    }
}

