DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_EVT_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_EVT_LOG';
END IF;
END;
CREATE TABLE "ACT_EVT_LOG"
(
 "LOG_NR_" NUMBER(20,0) NOT NULL,
 "TYPE_" VARCHAR(128) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "TIME_STAMP_" TIMESTAMP(0) NOT NULL,
 "USER_ID_" VARCHAR(510) NULL,
 "DATA_" BLOB NULL,
 "LOCK_OWNER_" VARCHAR(510) NULL,
 "LOCK_TIME_" TIMESTAMP(0) NULL,
 "IS_PROCESSED_" NUMBER(4,0) DEFAULT '0'
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_URGE_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_URGE_TASK';
END IF;
END;
CREATE TABLE "SYS_ACT_URGE_TASK"
(
 "ID" VARCHAR(64) NOT NULL,
 "TASK_ID" VARCHAR(128) NULL,
 "PROC_INST_ID" VARCHAR(128) NULL,
 "PROC_NAME" VARCHAR(510) NULL,
 "TASK_NAME" VARCHAR(510) NULL,
 "SEND_USER" VARCHAR(64) NULL,
 "RECEIVE_USER" VARCHAR(64) NULL,
 "SEND_TIME" TIMESTAMP(0) NULL,
 "FORM_KEY" VARCHAR(2000) NULL,
 "PROC_DEF_KEY" VARCHAR(128) NULL,
 "BUSINESS_ID" VARCHAR(255) NULL,
 "TASK_DEF_KEY" VARCHAR(128) NULL,
 "TEXT" CLOB NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_MANAGE_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_MANAGE_LOG';
END IF;
END;
CREATE TABLE "SYS_ACT_MANAGE_LOG"
(
 "LOG_ID" VARCHAR(64) NOT NULL,
 "SESSION_ID" VARCHAR(256) NULL,
 "USER_ID" VARCHAR(64) NULL,
 "USER_NAME" VARCHAR(64) NULL,
 "CORPORATION_ID" VARCHAR(64) NULL,
 "CORPORATION_NAME" VARCHAR(256) NULL,
 "LOG_TIME" TIMESTAMP(0) NULL,
 "REMOTEADDR" VARCHAR(256) NULL,
 "REMOTEHOST" VARCHAR(256) NULL,
 "REMOTEPORT" VARCHAR(16) NULL,
 "LOCALADDR" VARCHAR(256) NULL,
 "LOCALHOST" VARCHAR(256) NULL,
 "LOCALPORT" VARCHAR(16) NULL,
 "RESOURCE_ID" VARCHAR(64) NULL,
 "RESOURCE_ALIAS" VARCHAR(256) NULL,
 "SECURITY_LEVEL" NUMBER(11,0) NULL,
 "LOG_TYPE" VARCHAR(64) NULL,
 "LOG_TYPE_NAME" VARCHAR(128) NULL,
 "LOG_CONTENT" CLOB NULL,
 "USER_ACCOUNT" VARCHAR(64) NULL,
 "LEVEL_EVENT" VARCHAR(2) NULL,
 "STATE" VARCHAR(2) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_INTERFACE_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_INTERFACE_LOG';
END IF;
END;
CREATE TABLE "SYS_ACT_INTERFACE_LOG"
(
 "LOG_ID" VARCHAR(64) NOT NULL,
 "SESSION_ID" VARCHAR(256) NULL,
 "USER_ID" VARCHAR(64) NULL,
 "USER_NAME" VARCHAR(64) NULL,
 "CORPORATION_ID" VARCHAR(64) NULL,
 "CORPORATION_NAME" VARCHAR(256) NULL,
 "LOG_TIME" TIMESTAMP(0) NULL,
 "REMOTEADDR" VARCHAR(256) NULL,
 "REMOTEHOST" VARCHAR(256) NULL,
 "REMOTEPORT" VARCHAR(16) NULL,
 "LOCALADDR" VARCHAR(256) NULL,
 "LOCALHOST" VARCHAR(256) NULL,
 "LOCALPORT" VARCHAR(16) NULL,
 "RESOURCE_ID" VARCHAR(64) NULL,
 "RESOURCE_ALIAS" VARCHAR(256) NULL,
 "SECURITY_LEVEL" NUMBER(11,0) NULL,
 "LOG_TYPE" VARCHAR(64) NULL,
 "LOG_TYPE_NAME" VARCHAR(128) NULL,
 "LOG_CONTENT" CLOB NULL,
 "USER_ACCOUNT" VARCHAR(64) NULL,
 "LEVEL_EVENT" VARCHAR(2) NULL,
 "STATE" VARCHAR(2) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_HI_LINE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_HI_LINE';
END IF;
END;
CREATE TABLE "SYS_ACT_HI_LINE"
(
 "ID" VARCHAR(64) NULL,
 "PROC_INST_ID" VARCHAR(128) NULL,
 "PROC_DEF_ID" VARCHAR(128) NULL,
 "PROC_DEF_KEY" VARCHAR(128) NULL,
 "LINE_ID" VARCHAR(128) NULL,
 "COMPLETE_TIME" TIMESTAMP(0) NULL,
 "COMPLETE_USER" VARCHAR(128) NULL,
 "LINE_NAME" VARCHAR(512) NULL,
 "PROCESS_NAME" VARCHAR(512) NULL,
 "OUT_NODE" VARCHAR(128) NULL,
 "OUT_NODE_NAME" VARCHAR(512) NULL,
 "IN_NODE" VARCHAR(128) NULL,
 "IN_NODE_NAME" VARCHAR(512) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_EXTEND_PROPERTIES');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_EXTEND_PROPERTIES';
END IF;
END;
CREATE TABLE "SYS_ACT_EXTEND_PROPERTIES"
(
 "ID" VARCHAR(400) NULL,
 "PROC_DEF_ID" VARCHAR(128) NULL,
 "TASK_DEF_KEY" VARCHAR(128) NULL,
 "TASK_DEF_NAME" VARCHAR(2000) NULL,
 "FORM_DETAIL_KEY" CLOB NULL,
 "ATTRIBUTE" VARCHAR(64) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_ENTRUST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_ENTRUST';
END IF;
END;
CREATE TABLE "SYS_ACT_ENTRUST"
(
 "ID" VARCHAR(72) NOT NULL,
 "CONSIGNOR" VARCHAR(72) NULL,
 "PROCESS_ID" VARCHAR(510) NULL,
 "PROCESS_NAME" VARCHAR(510) NULL,
 "CONSIGNEE" VARCHAR(72) NULL,
 "CONSIGNEE_NAME" VARCHAR(510) NULL,
 "START_TIME" TIMESTAMP(0) NULL,
 "END_TIME" TIMESTAMP(0) NULL,
 "STATE" CHAR(1) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_CONFIG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_CONFIG';
END IF;
END;
CREATE TABLE "SYS_ACT_CONFIG"
(
 "TENANT_ID" VARCHAR(64) NOT NULL,
 "PROJECT_ADDRESS" VARCHAR(510) NULL,
 "IS_MQ_USE" VARCHAR(510) NULL,
 "IS_GOD_AXE" VARCHAR(510) NULL,
 "IS_MULTI_TENANT" CHAR(1) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_CC_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_CC_TASK';
END IF;
END;
CREATE TABLE "SYS_ACT_CC_TASK"
(
 "ID" VARCHAR(64) NOT NULL,
 "TASK_ID" VARCHAR(128) NULL,
 "PROC_INST_ID" VARCHAR(128) NULL,
 "PROC_NAME" VARCHAR(510) NULL,
 "TASK_NAME" VARCHAR(510) NULL,
 "SEND_USER" VARCHAR(64) NULL,
 "RECEIVE_USER" VARCHAR(64) NULL,
 "SEND_TIME" TIMESTAMP(0) NULL,
 "FORM_KEY" VARCHAR(2000) NULL,
 "PROC_DEF_KEY" VARCHAR(128) NULL,
 "BUSINESS_ID" VARCHAR(255) NULL,
 "TASK_DEF_KEY" VARCHAR(128) NULL,
 "TEXT" CLOB NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_PROCESS_FILE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_PROCESS_FILE';
END IF;
END;
CREATE TABLE "SYS_ACT_PROCESS_FILE"
(
 "FILE_ID" VARCHAR(64) NOT NULL,
 "PROCESS_KEY" VARCHAR(64) NULL,
 "PROCESS_ID" VARCHAR(64) NULL,
 "VERSION" NUMBER(11,0) NULL,
 "TYPE" VARCHAR(8) NULL,
 "CONTENT" BLOB NULL,
 "MODEL_ID" VARCHAR(64) NULL,
 "TENANT_ID" VARCHAR(64) NULL,
 "CREATE_TIME" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_VARIABLE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_VARIABLE';
END IF;
END;
CREATE TABLE "ACT_RU_VARIABLE"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "TYPE_" VARCHAR(510) NOT NULL,
 "NAME_" VARCHAR(510) NOT NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "BYTEARRAY_ID_" VARCHAR(128) NULL,
 "DOUBLE_" NUMBER NULL,
 "LONG_" NUMBER(20,0) NULL,
 "TEXT_" VARCHAR(4000) NULL,
 "TEXT2_" VARCHAR(4000) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_TASK';
END IF;
END;
CREATE TABLE "ACT_RU_TASK"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "NAME_" VARCHAR(510) NULL,
 "PARENT_TASK_ID_" VARCHAR(128) NULL,
 "DESCRIPTION_" VARCHAR(2000) NULL,
 "TASK_DEF_KEY_" VARCHAR(510) NULL,
 "OWNER_" VARCHAR(510) NULL,
 "ASSIGNEE_" VARCHAR(510) NULL,
 "DELEGATION_" VARCHAR(128) NULL,
 "PRIORITY_" NUMBER(11,0) NULL,
 "CREATE_TIME_" TIMESTAMP(0) NULL,
 "DUE_DATE_" TIMESTAMP(0) NULL,
 "CATEGORY_" VARCHAR(510) NULL,
 "SUSPENSION_STATE_" NUMBER(11,0) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT '',
 "FORM_KEY_" VARCHAR(510) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_JOB');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_JOB';
END IF;
END;
CREATE TABLE "ACT_RU_JOB"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "TYPE_" VARCHAR(510) NOT NULL,
 "LOCK_EXP_TIME_" TIMESTAMP(0) NULL,
 "LOCK_OWNER_" VARCHAR(510) NULL,
 "EXCLUSIVE_" NUMBER(4,0) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "PROCESS_INSTANCE_ID_" VARCHAR(128) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "RETRIES_" NUMBER(11,0) NULL,
 "EXCEPTION_STACK_ID_" VARCHAR(128) NULL,
 "EXCEPTION_MSG_" VARCHAR(4000) NULL,
 "DUEDATE_" TIMESTAMP(0) NULL,
 "REPEAT_" VARCHAR(510) NULL,
 "HANDLER_TYPE_" VARCHAR(510) NULL,
 "HANDLER_CFG_" VARCHAR(4000) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT ''
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_IDENTITYLINK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_IDENTITYLINK';
END IF;
END;
CREATE TABLE "ACT_RU_IDENTITYLINK"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "GROUP_ID_" VARCHAR(510) NULL,
 "TYPE_" VARCHAR(510) NULL,
 "USER_ID_" VARCHAR(510) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_EXECUTION');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_EXECUTION';
END IF;
END;
CREATE TABLE "ACT_RU_EXECUTION"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "BUSINESS_KEY_" VARCHAR(510) NULL,
 "PARENT_ID_" VARCHAR(128) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "SUPER_EXEC_" VARCHAR(128) NULL,
 "ACT_ID_" VARCHAR(510) NULL,
 "IS_ACTIVE_" NUMBER(4,0) NULL,
 "IS_CONCURRENT_" NUMBER(4,0) NULL,
 "IS_SCOPE_" NUMBER(4,0) NULL,
 "IS_EVENT_SCOPE_" NUMBER(4,0) NULL,
 "SUSPENSION_STATE_" NUMBER(11,0) NULL,
 "CACHED_ENT_STATE_" NUMBER(11,0) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT '',
 "NAME_" VARCHAR(510) NULL,
 "LOCK_TIME_" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_EVENT_SUBSCR');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_EVENT_SUBSCR';
END IF;
END;
CREATE TABLE "ACT_RU_EVENT_SUBSCR"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "EVENT_TYPE_" VARCHAR(510) NOT NULL,
 "EVENT_NAME_" VARCHAR(510) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "ACTIVITY_ID_" VARCHAR(128) NULL,
 "CONFIGURATION_" VARCHAR(510) NULL,
 "CREATED_" TIMESTAMP(0) NOT NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT ''
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_PROCDEF');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_PROCDEF';
END IF;
END;
CREATE TABLE "ACT_RE_PROCDEF"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "CATEGORY_" VARCHAR(510) NULL,
 "NAME_" VARCHAR(510) NULL,
 "KEY_" VARCHAR(510) NOT NULL,
 "VERSION_" NUMBER(11,0) NOT NULL,
 "DEPLOYMENT_ID_" VARCHAR(128) NULL,
 "RESOURCE_NAME_" VARCHAR(4000) NULL,
 "DGRM_RESOURCE_NAME_" VARCHAR(4000) NULL,
 "DESCRIPTION_" VARCHAR(4000) NULL,
 "HAS_START_FORM_KEY_" NUMBER(4,0) NULL,
 "HAS_GRAPHICAL_NOTATION_" NUMBER(4,0) NULL,
 "SUSPENSION_STATE_" NUMBER(11,0) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT '',
 "MAIN_PROCESS" VARCHAR(8) DEFAULT '0',
 "REAL_VERSION" VARCHAR(255)
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_MODEL');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_MODEL';
END IF;
END;
CREATE TABLE "ACT_RE_MODEL"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "NAME_" VARCHAR(510) NULL,
 "KEY_" VARCHAR(510) NULL,
 "CATEGORY_" VARCHAR(510) NULL,
 "CREATE_TIME_" TIMESTAMP(0) NULL,
 "LAST_UPDATE_TIME_" TIMESTAMP(0) NULL,
 "VERSION_" NUMBER(11,0) NULL,
 "META_INFO_" VARCHAR(4000) NULL,
 "DEPLOYMENT_ID_" VARCHAR(128) NULL,
 "EDITOR_SOURCE_VALUE_ID_" VARCHAR(128) NULL,
 "EDITOR_SOURCE_EXTRA_VALUE_ID_" VARCHAR(128) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT ''
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_DEPLOYMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_DEPLOYMENT';
END IF;
END;
CREATE TABLE "ACT_RE_DEPLOYMENT"
(
 "ID_" VARCHAR(128) NOT NULL,
 "NAME_" VARCHAR(510) NULL,
 "CATEGORY_" VARCHAR(510) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT '',
 "DEPLOY_TIME_" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_PROCDEF_INFO');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_PROCDEF_INFO';
END IF;
END;
CREATE TABLE "ACT_PROCDEF_INFO"
(
 "ID_" VARCHAR(128) NOT NULL,
 "PROC_DEF_ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "INFO_JSON_ID_" VARCHAR(128) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_USER');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_USER';
END IF;
END;
CREATE TABLE "ACT_ID_USER"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "FIRST_" VARCHAR(510) NULL,
 "LAST_" VARCHAR(510) NULL,
 "EMAIL_" VARCHAR(510) NULL,
 "PWD_" VARCHAR(510) NULL,
 "PICTURE_ID_" VARCHAR(128) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_MEMBERSHIP');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_MEMBERSHIP';
END IF;
END;
CREATE TABLE "ACT_ID_MEMBERSHIP"
(
 "USER_ID_" VARCHAR(128) NOT NULL,
 "GROUP_ID_" VARCHAR(128) NOT NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_INFO');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_INFO';
END IF;
END;
CREATE TABLE "ACT_ID_INFO"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "USER_ID_" VARCHAR(128) NULL,
 "TYPE_" VARCHAR(128) NULL,
 "KEY_" VARCHAR(510) NULL,
 "VALUE_" VARCHAR(510) NULL,
 "PASSWORD_" BLOB NULL,
 "PARENT_ID_" VARCHAR(510) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_GROUP');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_GROUP';
END IF;
END;
CREATE TABLE "ACT_ID_GROUP"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "NAME_" VARCHAR(510) NULL,
 "TYPE_" VARCHAR(510) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_VARINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_VARINST';
END IF;
END;
CREATE TABLE "ACT_HI_VARINST"
(
 "ID_" VARCHAR(128) NOT NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "NAME_" VARCHAR(510) NOT NULL,
 "VAR_TYPE_" VARCHAR(200) NULL,
 "REV_" NUMBER(11,0) NULL,
 "BYTEARRAY_ID_" VARCHAR(128) NULL,
 "DOUBLE_" NUMBER NULL,
 "LONG_" NUMBER(20,0) NULL,
 "TEXT_" NVARCHAR2(4000) NULL,
 "TEXT2_" NVARCHAR2(4000) NULL,
 "CREATE_TIME_" TIMESTAMP(0) NULL,
 "LAST_UPDATED_TIME_" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_TASKINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_TASKINST';
END IF;
END;
CREATE TABLE "ACT_HI_TASKINST"
(
 "ID_" VARCHAR(128) NOT NULL,
 "PROC_DEF_ID_" VARCHAR(128) NULL,
 "TASK_DEF_KEY_" VARCHAR(510) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "NAME_" VARCHAR(510) NULL,
 "PARENT_TASK_ID_" VARCHAR(128) NULL,
 "DESCRIPTION_" VARCHAR(4000) NULL,
 "OWNER_" VARCHAR(510) NULL,
 "ASSIGNEE_" VARCHAR(510) NULL,
 "START_TIME_" TIMESTAMP(0) NULL,
 "CLAIM_TIME_" TIMESTAMP(0) NULL,
 "END_TIME_" TIMESTAMP(0) NULL,
 "DURATION_" NUMBER(20,0) NULL,
 "DELETE_REASON_" VARCHAR(4000) NULL,
 "PRIORITY_" NUMBER(11,0) NULL,
 "DUE_DATE_" TIMESTAMP(0) NULL,
 "FORM_KEY_" VARCHAR(510) NULL,
 "CATEGORY_" VARCHAR(510) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT ''
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_PROCINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_PROCINST';
END IF;
END;
CREATE TABLE "ACT_HI_PROCINST"
(
 "ID_" VARCHAR(128) NOT NULL,
 "PROC_INST_ID_" VARCHAR(128) NOT NULL,
 "BUSINESS_KEY_" VARCHAR(510) NULL,
 "PROC_DEF_ID_" VARCHAR(128) NOT NULL,
 "START_TIME_" TIMESTAMP(0) NULL,
 "END_TIME_" TIMESTAMP(0) NULL,
 "DURATION_" NUMBER(20,0) NULL,
 "START_USER_ID_" VARCHAR(510) NULL,
 "START_ACT_ID_" VARCHAR(510) NULL,
 "END_ACT_ID_" VARCHAR(510) NULL,
 "SUPER_PROCESS_INSTANCE_ID_" VARCHAR(128) NULL,
 "DELETE_REASON_" VARCHAR(2000) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT '',
 "NAME_" VARCHAR(510) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_IDENTITYLINK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_IDENTITYLINK';
END IF;
END;
CREATE TABLE "ACT_HI_IDENTITYLINK"
(
 "ID_" VARCHAR(128) NOT NULL,
 "GROUP_ID_" VARCHAR(510) NULL,
 "TYPE_" VARCHAR(510) NULL,
 "USER_ID_" VARCHAR(510) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_DETAIL');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_DETAIL';
END IF;
END;
CREATE TABLE "ACT_HI_DETAIL"
(
 "ID_" VARCHAR(128) NOT NULL,
 "TYPE_" VARCHAR(510) NOT NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "EXECUTION_ID_" VARCHAR(128) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "ACT_INST_ID_" VARCHAR(128) NULL,
 "NAME_" VARCHAR(510) NOT NULL,
 "VAR_TYPE_" VARCHAR(510) NULL,
 "REV_" NUMBER(11,0) NULL,
 "TIME_" TIMESTAMP(0) NULL,
 "BYTEARRAY_ID_" VARCHAR(128) NULL,
 "DOUBLE_" NUMBER NULL,
 "LONG_" NUMBER(20,0) NULL,
 "TEXT_" VARCHAR(4000) NULL,
 "TEXT2_" VARCHAR(4000) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_COMMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_COMMENT';
END IF;
END;
CREATE TABLE "ACT_HI_COMMENT"
(
 "ID_" VARCHAR(128) NOT NULL,
 "TYPE_" VARCHAR(510) NULL,
 "TIME_" TIMESTAMP(0) NULL,
 "USER_ID_" VARCHAR(510) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "ACTION_" VARCHAR(510) NULL,
 "MESSAGE_" VARCHAR(4000) NULL,
 "FULL_MSG_" BLOB NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_ATTACHMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_ATTACHMENT';
END IF;
END;
CREATE TABLE "ACT_HI_ATTACHMENT"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "USER_ID_" VARCHAR(510) NULL,
 "NAME_" VARCHAR(510) NULL,
 "DESCRIPTION_" VARCHAR(4000) NULL,
 "TYPE_" VARCHAR(510) NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "PROC_INST_ID_" VARCHAR(128) NULL,
 "URL_" VARCHAR(4000) NULL,
 "CONTENT_ID_" VARCHAR(128) NULL,
 "TIME_" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_ACTINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_ACTINST';
END IF;
END;
CREATE TABLE "ACT_HI_ACTINST"
(
 "ID_" VARCHAR(128) NOT NULL,
 "PROC_DEF_ID_" VARCHAR(128) NOT NULL,
 "PROC_INST_ID_" VARCHAR(128) NOT NULL,
 "EXECUTION_ID_" VARCHAR(128) NOT NULL,
 "ACT_ID_" VARCHAR(510) NOT NULL,
 "TASK_ID_" VARCHAR(128) NULL,
 "CALL_PROC_INST_ID_" VARCHAR(128) NULL,
 "ACT_NAME_" VARCHAR(510) NULL,
 "ACT_TYPE_" VARCHAR(510) NOT NULL,
 "ASSIGNEE_" VARCHAR(510) NULL,
 "START_TIME_" TIMESTAMP(0) NULL,
 "END_TIME_" TIMESTAMP(0) NULL,
 "DURATION_" NUMBER(20,0) NULL,
 "TENANT_ID_" VARCHAR(510) DEFAULT ''
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_GE_PROPERTY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_GE_PROPERTY';
END IF;
END;
CREATE TABLE "ACT_GE_PROPERTY"
(
 "NAME_" VARCHAR(128) NOT NULL,
 "VALUE_" VARCHAR(600) NULL,
 "REV_" NUMBER(11,0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_GE_BYTEARRAY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_GE_BYTEARRAY';
END IF;
END;
CREATE TABLE "ACT_GE_BYTEARRAY"
(
 "ID_" VARCHAR(128) NOT NULL,
 "REV_" NUMBER(11,0) NULL,
 "NAME_" VARCHAR(510) NULL,
 "DEPLOYMENT_ID_" VARCHAR(128) NULL,
 "BYTES_" BLOB NULL,
 "GENERATED_" NUMBER(1,0) CHECK (GENERATED_ IN (1,0))
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_FUNCTION');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_FUNCTION';
END IF;
END;
CREATE TABLE "SYS_ACT_FUNCTION"
(
 "FUNCTION_ID" VARCHAR(72) NOT NULL,
 "FUNCTION_NAME" VARCHAR(510) NULL,
 "FUNCTION_BEAN" VARCHAR(510) NULL,
 "CREATE_TIME" TIMESTAMP(0) NULL,
 "UPDATE_TIME" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_FUNCTION_PARM');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_FUNCTION_PARM';
END IF;
END;
CREATE TABLE "SYS_ACT_FUNCTION_PARM"
(
 "PARM_ID" VARCHAR(72) NOT NULL,
 "FUNCTION_ID" VARCHAR(72) NULL,
 "PARM_NAME" VARCHAR(510) NULL,
 "PARM_KEY" VARCHAR(510) NULL,
 "CREATE_TIME" TIMESTAMP(0) NULL,
 "UPDATE_TIME" TIMESTAMP(0) NULL
);

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_TIMEOUT_ACTIVITY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_TIMEOUT_ACTIVITY';
END IF;
END;
CREATE TABLE "SYS_ACT_TIMEOUT_ACTIVITY"
(
    "TASK_ID" VARCHAR(64) NOT NULL,
    "ASSIGNEE" VARCHAR(255) NULL,
    "DUE_TIME" TIMESTAMP(0) NULL,
    "CREATE_TIME" TIMESTAMP(0) NULL,
    "TIME_OUT_TYPE" VARCHAR(255) NULL,
    "TENANT_ID" VARCHAR(255) NULL,
    "MAP" VARCHAR(2000) NULL
);

INSERT INTO "ACT_GE_PROPERTY"("NAME_","VALUE_","REV_") VALUES('next.dbid','447501',180);
INSERT INTO "ACT_GE_PROPERTY"("NAME_","VALUE_","REV_") VALUES('schema.history','create(5.22.0.0)',1);
INSERT INTO "ACT_GE_PROPERTY"("NAME_","VALUE_","REV_") VALUES('schema.version','5.22.0.0',1);

ALTER TABLE "SYS_ACT_HI_LINE" ADD CONSTRAINT "SYS_C00616690" PRIMARY KEY("ID");

ALTER TABLE "SYS_ACT_EXTEND_PROPERTIES" ADD CONSTRAINT "SYS_C00616689" PRIMARY KEY("ID");

ALTER TABLE "SYS_ACT_ENTRUST" ADD CONSTRAINT "SYS_C00616688" PRIMARY KEY("ID");

ALTER TABLE "SYS_ACT_FUNCTION_PARM" ADD CONSTRAINT "SYS_C00616687" PRIMARY KEY("PARM_ID");

ALTER TABLE "SYS_ACT_TIMEOUT_ACTIVITY" ADD CONSTRAINT "SYS_C00616686" PRIMARY KEY("TASK_ID");

ALTER TABLE "SYS_ACT_FUNCTION" ADD CONSTRAINT "SYS_C00616685" PRIMARY KEY("FUNCTION_ID");

ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616669" PRIMARY KEY("LOG_NR_");

ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616684" PRIMARY KEY("ID_");

ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT "SYS_C00616683" PRIMARY KEY("ID_");

ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616682" PRIMARY KEY("USER_ID_","GROUP_ID_");

ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT "SYS_C00616681" PRIMARY KEY("ID_");

ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT "SYS_C00616680" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616679" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT "SYS_C00616678" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616677" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616676" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616675" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT "SYS_C00616674" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT "SYS_C00616673" PRIMARY KEY("ID_");

ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616672" PRIMARY KEY("ID_");

ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT "SYS_C00616671" PRIMARY KEY("NAME_");

ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "SYS_C00616670" PRIMARY KEY("ID_");

COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_ID" IS '主键';

COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_NAME" IS '函数名称';

COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_BEAN" IS '函数beanId';

COMMENT ON COLUMN "SYS_ACT_FUNCTION"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "SYS_ACT_FUNCTION"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_ID" IS '主键';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."FUNCTION_ID" IS '函数主键';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_NAME" IS '参数名称';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_KEY" IS '参数标识';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TASK_ID" IS '任务id';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."ASSIGNEE" IS '参与者';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."CREATE_TIME" IS '开始时间';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."DUE_TIME" IS '到期时间';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TIME_OUT_TYPE" IS '超时处理类型';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TENANT_ID" IS '租户id';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."MAP" IS '接口类型额外参数';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."ID" IS '主键';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_ID" IS '任务id';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_INST_ID" IS '实例id';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_NAME" IS '流程名称';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_NAME" IS '任务名称';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."SEND_USER" IS '发送人';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."RECEIVE_USER" IS '接收人';

COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TEXT" IS '待办配置';

COMMENT ON TABLE "SYS_ACT_MANAGE_LOG" IS '安全日志';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LOG_ID" IS '安全日志编码';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."SESSION_ID" IS '会话标识';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ID" IS '用户账户';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_NAME" IS '用户名称';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_ID" IS '公司编码';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_NAME" IS '公司名称';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ACCOUNT" IS '用户登录账号';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';

COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."STATE" IS '事件类型';

COMMENT ON TABLE "SYS_ACT_INTERFACE_LOG" IS '安全日志';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ACCOUNT" IS '用户登录账号';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."STATE" IS '事件类型';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LOG_ID" IS '安全日志编码';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."SESSION_ID" IS '会话标识';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ID" IS '用户账户';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_NAME" IS '用户名称';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_ID" IS '公司编码';

COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_NAME" IS '公司名称';

COMMENT ON TABLE "SYS_ACT_HI_LINE" IS '记录流程在办理过程中连线的办理历史';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."ID" IS '主键';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_INST_ID" IS '流程实例id';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_ID" IS '流程定义id';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_KEY" IS '流程定义key';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_ID" IS '连线id';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_TIME" IS '办理时间';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_USER" IS '办理人';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_NAME" IS '连线名称';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROCESS_NAME" IS '流程名称';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE" IS '出线节点';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE_NAME" IS '出现节点名称';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE" IS '入线节点';

COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE_NAME" IS '入线节点名称';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ID" IS '主键采用流程定义id和节点id拼接组成';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."PROC_DEF_ID" IS '流程定义id';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_KEY" IS '节点id';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_NAME" IS '节点名称';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."FORM_DETAIL_KEY" IS '表单地址';

COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ATTRIBUTE" IS '标识扩展的属性类型';

COMMENT ON TABLE "SYS_ACT_ENTRUST" IS '委托表';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."ID" IS 'ID主键，uuid';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNOR" IS '委托人';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_ID" IS '流程id';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_NAME" IS '流程名称';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE" IS '被委托人id';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE_NAME" IS '被委托人姓名';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."START_TIME" IS '开始时间';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."END_TIME" IS '结束时间';

COMMENT ON COLUMN "SYS_ACT_ENTRUST"."STATE" IS '状态';

COMMENT ON COLUMN "SYS_ACT_CONFIG"."TENANT_ID" IS '租户id';

COMMENT ON COLUMN "SYS_ACT_CONFIG"."PROJECT_ADDRESS" IS '项目地址';

COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MULTI_TENANT" IS '是否共库 1是 0否';

COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MQ_USE" IS '是否启用mq 1启用 0不启用';

COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_GOD_AXE" IS '是否天斧 1是 0否';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."ID" IS '主键';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_ID" IS '任务id';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_INST_ID" IS '实例id';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_NAME" IS '流程名称';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_NAME" IS '任务名称';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."SEND_USER" IS '发送人';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."RECEIVE_USER" IS '接收人';

COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TEXT" IS '待办配置';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."FILE_ID" IS '文件id';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_KEY" IS '流程标识';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_ID" IS '流程id';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."VERSION" IS '版本号';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TYPE" IS '文件类型';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CONTENT" IS '文件内容';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."MODEL_ID" IS '模块id';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TENANT_ID" IS '租户id';

COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "ACT_RE_PROCDEF"."MAIN_PROCESS" IS '1主版本 0 不是主版本 2 临时版本';

COMMENT ON COLUMN "ACT_RE_PROCDEF"."REAL_VERSION" IS '临时版本流程真实版本号';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TASK_ID" IS '任务id';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."ASSIGNEE" IS '参与者';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."CREATE_TIME" IS '开始时间';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."DUE_TIME" IS '到期时间';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TIME_OUT_TYPE" IS '超时处理类型';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TENANT_ID" IS '租户id';

COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."MAP" IS '接口类型额外参数';

CREATE UNIQUE INDEX "ACT_UNIQ_INFO_PROCDEF"
ON "ACT_PROCDEF_INFO"("PROC_DEF_ID_");

CREATE INDEX "ACT_FK_MEMB_GROUP"
ON "ACT_ID_MEMBERSHIP"("GROUP_ID_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_NAME_TYPE"
ON "ACT_HI_VARINST"("NAME_","VAR_TYPE_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_TASK_ID"
ON "ACT_HI_VARINST"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_PROC_INST"
ON "ACT_HI_VARINST"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_TASK_INST_PROCINST"
ON "ACT_HI_TASKINST"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_PRO_I_BUSKEY"
ON "ACT_HI_PROCINST"("BUSINESS_KEY_");

CREATE INDEX "ACT_IDX_HI_PRO_INST_END"
ON "ACT_HI_PROCINST"("END_TIME_");

CREATE UNIQUE INDEX "PROC_INST_ID_"
ON "ACT_HI_PROCINST"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_PROCINST"
ON "ACT_HI_IDENTITYLINK"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_TASK"
ON "ACT_HI_IDENTITYLINK"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_USER"
ON "ACT_HI_IDENTITYLINK"("USER_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_PROC_INST"
ON "ACT_HI_DETAIL"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_TIME"
ON "ACT_HI_DETAIL"("TIME_");

CREATE INDEX "ACT_IDX_HI_DETAIL_TASK_ID"
ON "ACT_HI_DETAIL"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_ACT_INST"
ON "ACT_HI_DETAIL"("ACT_INST_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_NAME"
ON "ACT_HI_DETAIL"("NAME_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_START"
ON "ACT_HI_ACTINST"("START_TIME_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_PROCINST"
ON "ACT_HI_ACTINST"("ACT_ID_","PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_EXEC"
ON "ACT_HI_ACTINST"("EXECUTION_ID_","ACT_ID_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_END"
ON "ACT_HI_ACTINST"("END_TIME_");

CREATE INDEX "ACT_FK_BYTEARR_DEPL"
ON "ACT_GE_BYTEARRAY"("DEPLOYMENT_ID_");

CREATE INDEX "ACT_IDX_HI_COMMENT_TASK_ID"
ON "ACT_HI_COMMENT"("TASK_ID_");

COMMENT ON TABLE ACT_EVT_LOG IS '事件日志表';
COMMENT ON TABLE ACT_GE_BYTEARRAY IS '二进制数据表';
COMMENT ON TABLE ACT_GE_PROPERTY IS '属性数据表';
COMMENT ON TABLE ACT_HI_ACTINST IS '历史节点表';
COMMENT ON TABLE ACT_HI_ATTACHMENT IS '历史附件表';
COMMENT ON TABLE ACT_HI_COMMENT IS '历史意见表';
COMMENT ON TABLE ACT_HI_DETAIL IS '历史详情表';
COMMENT ON TABLE ACT_HI_IDENTITYLINK IS '历史流程人员表';
COMMENT ON TABLE ACT_HI_PROCINST IS '历史流程实例表';
COMMENT ON TABLE ACT_HI_TASKINST IS '历史任务实例表';
COMMENT ON TABLE ACT_HI_VARINST IS '历史变量表';
COMMENT ON TABLE ACT_ID_GROUP IS '用户组信息表';
COMMENT ON TABLE ACT_ID_INFO IS '用户扩展信息表';
COMMENT ON TABLE ACT_ID_MEMBERSHIP IS '用户与分组对应信息表';
COMMENT ON TABLE ACT_ID_USER IS '用户信息表';
COMMENT ON TABLE ACT_PROCDEF_INFO IS '流程定义信息表';
COMMENT ON TABLE ACT_RE_DEPLOYMENT IS '部署信息表';
COMMENT ON TABLE ACT_RE_MODEL IS '流程设计模型部署表';
COMMENT ON TABLE ACT_RE_PROCDEF IS '流程定义数据表';
COMMENT ON TABLE ACT_RU_EVENT_SUBSCR IS '运行实例表';
COMMENT ON TABLE ACT_RU_EXECUTION IS '运行时流程执行实例表';
COMMENT ON TABLE ACT_RU_IDENTITYLINK IS '运行时流程人员表';
COMMENT ON TABLE ACT_RU_JOB IS '运行时定时任务数据表';
COMMENT ON TABLE ACT_RU_TASK IS '运行时任务节点表';
COMMENT ON TABLE ACT_RU_VARIABLE IS '运行时流程变量数据表';
COMMENT ON TABLE SYS_ACT_CC_TASK IS '抄送表';
COMMENT ON TABLE SYS_ACT_CONFIG IS '配置表';
COMMENT ON TABLE SYS_ACT_ENTRUST IS '委托表';
COMMENT ON TABLE SYS_ACT_EXTEND_PROPERTIES IS '流程拓展信息表';
COMMENT ON TABLE SYS_ACT_FUNCTION IS '函数表';
COMMENT ON TABLE SYS_ACT_FUNCTION_PARM IS '函数参数表';
COMMENT ON TABLE SYS_ACT_HI_LINE IS '历史线表';
COMMENT ON TABLE SYS_ACT_INTERFACE_LOG IS '接口日志表';
COMMENT ON TABLE SYS_ACT_MANAGE_LOG IS '操作日志表';
COMMENT ON TABLE SYS_ACT_PROCESS_FILE IS '工作流文件表';
COMMENT ON TABLE SYS_ACT_TIMEOUT_ACTIVITY IS '超时信息表';
COMMENT ON TABLE SYS_ACT_URGE_TASK IS '催办表';