/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.login;

import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.common.response.IResultCode;
import com.jxdinfo.hussar.bpm.common.response.ResultCode;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogManager;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogTaskFactory;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController {
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String index() {
        return "redirect:static/bpm/index.html";
    }

    @RequestMapping(value={"/getLoginInf"}, method={RequestMethod.POST})
    @ManageBusinessLog(key="/getLoginInf", type="\u767b\u5f55", value="\u7528\u6237\u767b\u5f55\u4fe1\u606f")
    @ResponseBody
    public ApiResponse<?> getLoginInf() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", this.lcdpBpmProperties.getVersion());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ManageBusinessLog(key="/login", type="\u767b\u5f55", value="\u7528\u6237\u767b\u5f55")
    @ResponseBody
    public ApiResponse<?> login(@RequestBody Map<String, String> body) {
        String userAccount = body.get("userAccount");
        String cipher = body.get("cipher");
        cipher = CryptoUtil.decode(cipher);
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(userAccount, cipher.toCharArray());
        currentUser.login((AuthenticationToken)token);
        Session session = currentUser.getSession();
        SysUser sysUser = ShiroUser.getUser();
        String userName = sysUser != null ? sysUser.getUserName() : "";
        session.setAttribute((Object)"userName", (Object)userName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", CryptoUtil.encode(String.valueOf(session.getId())));
        map.put("userName", userName);
        map.put("userId", sysUser != null ? sysUser.getUserAccount() : "");
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    @ResponseBody
    public ApiResponse<?> logOut() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        ManageLogManager.me().executeLog(ManageLogTaskFactory.exitLog(ShiroUser.getUser(), "\u767b\u51fa", info));
        ShiroUser.getSubject().logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public ApiResponse<?> check() {
        SysUser sysUser = ShiroUser.getUser();
        if (ToolUtil.isNotEmpty((Object)sysUser)) {
            return ApiResponse.data((Object)"admin".equals(sysUser.getUserAccount()));
        }
        return ApiResponse.data((Object)false);
    }
}

