/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.controller;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.common.utils.InitTableUtil;
import com.jxdinfo.hussar.common.utils.JdbcUrlUtil;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantController {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    ITenantConfigService tenantConfigService;
    @Autowired
    ChangeDatasource changeDatasource;
    @Value(value="${spring.datasource.url:}")
    private String databaseUrl;
    private final String SYNCHRONIZATION_MODEL = "allDataSynchronization.xls";

    @RequestMapping(value={"/tenantQuery"})
    @ManageBusinessLog(key="/tenant/tenantQuery", value="\u67e5\u8be2\u79df\u6237\u7ba1\u7406\u5217\u8868", type="\u67e5\u8be2")
    @TargetDataSource(value="master")
    public ApiResponse<Map<String, Object>> queryTenantList(@RequestParam(required=false) String userName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        Map map = this.sysUserService.queryTenantList(userName, page, limit);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/tenantUpdate"})
    @ManageBusinessLog(key="/tenant/tenantUpdate", value="\u4fee\u6539\u8d26\u53f7\u548c\u540d\u79f0", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantUpdate(SysUser sysUser) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_account", (Object)sysUser.getUserAccount());
            queryWrapper.ne((Object)"user_name", (Object)sysUser.getUserName());
            ((QueryWrapper)queryWrapper.or()).and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"user_name", (Object)sysUser.getUserName())).ne((Object)"user_account", (Object)sysUser.getUserAccount());
            });
            List sysUserList = this.sysUserService.list((Wrapper)queryWrapper);
            for (SysUser sysUsers : sysUserList) {
                if (sysUser.getUserAccount().equals(sysUsers.getUserAccount())) {
                    return ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getCode(), (String)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getMessage());
                }
                if (!sysUser.getUserName().equals(sysUsers.getUserName())) continue;
                return ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USERNAME.getCode(), (String)BpmEnum.ERROR_EXIST_USERNAME.getMessage());
            }
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    @RequestMapping(value={"/tenantGetInf"})
    @ManageBusinessLog(key="/tenant/tenantGetInf", value="\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f", type="\u67e5\u8be2")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> tenantGetInf(SysUser sysUser) {
        try {
            DynamicDataSource dynamicDataSource = (DynamicDataSource)SpringContextHolder.getBean(DynamicDataSource.class);
            DruidDataSource dataSource = (DruidDataSource)dynamicDataSource.getDynamicTargetDataSources().get("master");
            String url = dataSource.getUrl();
            String dbType = url.split(":")[1];
            dbType = dbType.substring(0, 1).toUpperCase() + dbType.substring(1);
            sysUser.setDbType(SM4Util.encrypt((String)dbType, (String)"frontkey"));
            if ("Oscar".equals(dbType) || "Dm".equals(dbType)) {
                sysUser.setDbName(SM4Util.encrypt((String)url.split("/")[3], (String)"frontkey"));
                sysUser.setConnectionIp(SM4Util.encrypt((String)url.split("/")[2].split(":")[0], (String)"frontkey"));
                sysUser.setConnectionPort(SM4Util.encrypt((String)url.split("/")[2].split(":")[1], (String)"frontkey"));
            } else if ("Oracle".equals(dbType)) {
                sysUser.setDbName(SM4Util.encrypt((String)url.split("/")[1], (String)"frontkey"));
                sysUser.setConnectionIp(SM4Util.encrypt((String)url.split(":")[3].split("@")[1], (String)"frontkey"));
                sysUser.setConnectionPort(SM4Util.encrypt((String)url.split(":")[4].split("/")[0], (String)"frontkey"));
            } else {
                sysUser.setDbName(SM4Util.encrypt((String)"", (String)"frontkey"));
                sysUser.setConnectionIp(SM4Util.encrypt((String)url.split("/")[2].split(":")[0], (String)"frontkey"));
                sysUser.setConnectionPort(SM4Util.encrypt((String)url.split("/")[2].split(":")[1], (String)"frontkey"));
            }
            return ApiResponse.data((Object)sysUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.CONNECTION_FAIL.getCode(), (String)BpmEnum.CONNECTION_FAIL.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/tenantInsert"})
    @Transactional(rollbackFor={Exception.class})
    @ManageBusinessLog(key="/tenant/tenantInsert", value="\u65b0\u589e\u79df\u6237", type="\u65b0\u589e")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantInsert(SysUser sysUser) {
        this.changeDatasource.change();
        try {
            String decryptDbName = SM4Util.decrypt((String)sysUser.getDbName(), (String)"frontkey");
            String decryptConnectionIp = SM4Util.decrypt((String)sysUser.getConnectionIp(), (String)"frontkey");
            String decryptConnectionPort = SM4Util.decrypt((String)sysUser.getConnectionPort(), (String)"frontkey");
            String decryptConnectionName = SM4Util.decrypt((String)sysUser.getConnectionName(), (String)"frontkey");
            String decryptConnectionPass = SM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"frontkey");
            sysUser.setDbName(SM4Util.encrypt((String)decryptDbName, (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionIp(SM4Util.encrypt((String)decryptConnectionIp, (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionPort(SM4Util.encrypt((String)decryptConnectionPort, (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionName(SM4Util.encrypt((String)decryptConnectionName, (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionPass(SM4Util.encrypt((String)decryptConnectionPass, (String)"admin#$%^kopoiuy"));
            if ("Mysql".equals(sysUser.getDbType())) {
                sysUser.setDbName(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getDbName().toLowerCase(), (String)"admin#$%^kopoiuy"), (String)"admin#$%^kopoiuy"));
            } else if ("Oracle".equals(sysUser.getDbType()) || "Dm".equals(sysUser.getDbType()) || "Oscar".equals(sysUser.getDbType())) {
                sysUser.setConnectionName(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionName().toUpperCase(), (String)"admin#$%^kopoiuy"), (String)"admin#$%^kopoiuy"));
                sysUser.setConnectionPass(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionPass().toUpperCase(), (String)"admin#$%^kopoiuy"), (String)"admin#$%^kopoiuy"));
            }
            boolean userExist = false;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_account", (Object)sysUser.getUserAccount());
            ((QueryWrapper)queryWrapper.or()).eq((Object)"user_name", (Object)sysUser.getUserName());
            List sysUserList = this.sysUserService.list((Wrapper)queryWrapper);
            for (SysUser sysUsers : sysUserList) {
                if (sysUser.getUserAccount().equals(sysUsers.getUserAccount())) {
                    return ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getCode(), (String)BpmEnum.ERROR_EXIST_USER_ACCOUNT.getMessage());
                }
                if (!sysUser.getUserName().equals(sysUsers.getUserName())) continue;
                return ApiResponse.fail((int)BpmEnum.ERROR_EXIST_USERNAME.getCode(), (String)BpmEnum.ERROR_EXIST_USERNAME.getMessage());
            }
            if ("Mysql".equals(sysUser.getDbType())) {
                if (this.sysUserService.getMysqlUser(decryptConnectionName, this.databaseUrl.split(":")[1])) {
                    userExist = true;
                }
            } else if (this.sysUserService.getOracleUser(decryptConnectionName.toUpperCase(), this.databaseUrl.split(":")[1])) {
                userExist = true;
            }
            sysUser.setUserId(IdWorker.get32UUID());
            sysUser.setTenantId(IdWorker.get32UUID());
            sysUser.setTenantCipher(IdWorker.get32UUID());
            sysUser.setPassword(MD5Util.encrypt((String)this.lcdpBpmProperties.getDefaultPass()));
            sysUser.setCreateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("1");
            Map<String, String> map = JdbcUrlUtil.getIpAndPort(this.databaseUrl);
            if ("1".equals(sysUser.getUseOutside())) {
                this.changeDatasource.change(sysUser);
                boolean state = this.sysUserService.testConn(sysUser.getTenantId());
                if (!state) return ApiResponse.fail((int)BpmEnum.OUTSIDE_CONNECTION_FAIL.getCode(), (String)BpmEnum.OUTSIDE_CONNECTION_FAIL.getMessage());
                InitTableUtil.createTable(sysUser, this.databaseUrl);
            } else {
                if (userExist) {
                    this.changeDatasource.change(sysUser);
                    boolean state = this.sysUserService.testConn(sysUser.getTenantId());
                    if (!state) {
                        return ApiResponse.fail((int)BpmEnum.USER_CONNECTION_FAIL.getCode(), (String)BpmEnum.USER_CONNECTION_FAIL.getMessage());
                    }
                }
                sysUser.setConnectionIp(SM4Util.encrypt((String)map.get("ip"), (String)"admin#$%^kopoiuy"));
                sysUser.setConnectionPort(SM4Util.encrypt((String)map.get("port"), (String)"admin#$%^kopoiuy"));
                ApiResponse str = this.sysUserService.createDatabase(decryptDbName, decryptConnectionName, decryptConnectionPass, userExist, this.databaseUrl);
                if (str != null) {
                    return str;
                }
                InitTableUtil.createTable(sysUser, this.databaseUrl);
            }
            this.sysUserService.save((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_INSERT.getCode(), (String)BpmEnum.SUCCESS_INSERT.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_INSERT.getCode(), (String)BpmEnum.ERROR_INSERT.getMessage());
        }
    }

    @RequestMapping(value={"/tenantDelete"})
    @ManageBusinessLog(key="/tenant/tenantDelete", value="\u5220\u9664\u79df\u6237", type="\u5220\u9664")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantDelete(String userId, Boolean flag, String userAccount) {
        try {
            if (flag.booleanValue()) {
                this.sysUserService.removeDatabase(userAccount);
            }
            this.sysUserService.removeById((Serializable)((Object)userId));
            return ApiResponse.success((int)BpmEnum.DELETE_SUCCESS.getCode(), (String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @RequestMapping(value={"/tenantReset"})
    @ManageBusinessLog(key="/tenant/tenantReset", value="\u91cd\u7f6e\u5bc6\u7801", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantReset(SysUser sysUser) {
        try {
            sysUser.setPassword(MD5Util.encrypt((String)CryptoUtil.decode(sysUser.getPassword())));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_RESET.getCode(), (String)BpmEnum.SUCCESS_RESET.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_RESET.getCode(), (String)BpmEnum.ERROR_RESET.getMessage());
        }
    }

    @RequestMapping(value={"/editPwd"})
    @ManageBusinessLog(key="/tenant/editPwd", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u5bc6\u7801", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> editPwd(@RequestParam(value="oldPwd", required=false) String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        try {
            SysUser sysUser = ShiroUser.getUser();
            if (!sysUser.getPassword().equals(MD5Util.encrypt((String)CryptoUtil.decode(oldPwd)))) {
                return ApiResponse.fail((int)BpmEnum.ERROR_OLD_PASSWORD.getCode(), (String)BpmEnum.ERROR_OLD_PASSWORD.getMessage());
            }
            sysUser.setPassword(MD5Util.encrypt((String)CryptoUtil.decode(newPwd)));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    @RequestMapping(value={"/editUserConfig"})
    @ManageBusinessLog(key="/tenant/editUserConfig", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u9879\u76ee\u914d\u7f6e", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<?> editUserConfig(String isMqUse, String address, String isGodAxe) {
        try {
            TenantConfig tenantConfig = new TenantConfig();
            tenantConfig.setProjectAddress(address);
            tenantConfig.setIsMqUse(isMqUse);
            tenantConfig.setIsGodAxe(isGodAxe);
            SysUser sysUser = ShiroUser.getUser();
            tenantConfig.setTenantId(sysUser.getTenantId());
            this.tenantConfigService.editTenantConfig(tenantConfig);
            return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    @RequestMapping(value={"/getUserAddress"})
    @ManageBusinessLog(key="/tenant/getUserAddress", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u9879\u76ee\u5730\u5740", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<?> getUserAddress() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        if (tenantConfig == null) {
            return ApiResponse.data(null);
        }
        return ApiResponse.data((Object)tenantConfig.getProjectAddress());
    }

    @RequestMapping(value={"/getUserConfig"})
    @ManageBusinessLog(key="/tenant/getUserConfig", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u914d\u7f6e\u4fe1\u606f", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<?> getUserConfig() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        return ApiResponse.data((Object)tenantConfig);
    }

    @RequestMapping(value={"/startUsing"})
    @ManageBusinessLog(key="/tenant/startUsing", value="\u542f\u7528", type="\u542f\u7528")
    @TargetDataSource(value="master")
    public ApiResponse<?> startUsing(SysUser sysUser) {
        try {
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("1");
            this.sysUserService.updateById((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_START.getCode(), (String)BpmEnum.SUCCESS_START.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_START.getCode(), (String)BpmEnum.ERROR_START.getMessage());
        }
    }

    @RequestMapping(value={"/stopUsing"})
    @ManageBusinessLog(key="/tenant/stopUsing", value="\u7981\u7528", type="\u7981\u7528")
    @TargetDataSource(value="master")
    public ApiResponse<?> stopUsing(SysUser sysUser) {
        try {
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("0");
            this.sysUserService.updateById((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_STOP.getCode(), (String)BpmEnum.SUCCESS_STOP.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_STOP.getCode(), (String)BpmEnum.ERROR_STOP.getMessage());
        }
    }

    @RequestMapping(value={"/personalQuery"})
    @ManageBusinessLog(key="/tenant/personalQuery", value="\u67e5\u8be2", type="\u67e5\u8be2")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> getPersonalMsg() {
        if (ShiroUser.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        String userId = ShiroUser.getUser().getUserId();
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)userId));
        return ApiResponse.data((Object)sysUser);
    }

    @RequestMapping(value={"/resetCipher"})
    @ManageBusinessLog(key="/tenant/resetCipher", value="\u91cd\u7f6e\u79d8\u94a5", type="\u91cd\u7f6e\u5bc6\u7801")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> resetCipher(SysUser sysUser) {
        if (ShiroUser.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        try {
            String userId = ShiroUser.getUser().getUserId();
            sysUser.setTenantCipher(IdWorker.get32UUID());
            sysUser.setUserId(userId);
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((int)BpmEnum.SUCCESS_RESET.getCode(), (String)BpmEnum.SUCCESS_RESET.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_RESET.getCode(), (String)BpmEnum.ERROR_RESET.getMessage());
        }
    }

    @RequestMapping(value={"/getModel"})
    @ManageBusinessLog(key="/tenant/getModel", value="\u4e0b\u8f7d\u5168\u91cf\u6570\u636e\u540c\u6b65\u6a21\u677f", type="\u4e0b\u8f7d")
    @TargetDataSource
    public void getModel(HttpServletResponse response) {
        try {
            InputStream in = TenantController.class.getClassLoader().getResourceAsStream("allDataSynchronization.xls");
            this.sysUserService.getModel(in, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/editDbMessage"})
    @ManageBusinessLog(key="/tenant/editDbMessage", value="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> editDbMessage(SysUser sysUser) {
        try {
            sysUser.setConnectionName(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionName(), (String)"frontkey"), (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionPass(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"frontkey"), (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionIp(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionIp(), (String)"frontkey"), (String)"admin#$%^kopoiuy"));
            sysUser.setConnectionPort(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getConnectionPort(), (String)"frontkey"), (String)"admin#$%^kopoiuy"));
            sysUser.setDbName(SM4Util.encrypt((String)SM4Util.decrypt((String)sysUser.getDbName(), (String)"frontkey"), (String)"admin#$%^kopoiuy"));
            if (this.sysUserService.updateDbMessage(false, sysUser)) {
                return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.CONNECTION_FAIL.getCode(), (String)BpmEnum.CONNECTION_FAIL.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }
}

