/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taskManager"})
public class TaskManagerController {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    private ITenantConfigService tenantConfigService;

    @RequestMapping(value={"/getTaskManager"})
    @ManageBusinessLog(key="/taskManager/getTaskManager", value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> getTaskManager(@RequestParam Map<String, Object> map) {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        if (tenantConfig == null || !"1".equals(tenantConfig.getIsMqUse()) && (tenantConfig.getProjectAddress() == null || "".equals(tenantConfig.getProjectAddress()))) {
            return ApiResponse.data(null);
        }
        map.put("tenantId", ShiroUser.getTenantId());
        Page pages = new Page((long)Integer.parseInt((String)map.get("page")), (long)Integer.parseInt((String)map.get("limit")));
        List list = this.taskManagerService.getTask(pages, map);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("count", pages.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/suspendTaskById"})
    @ManageBusinessLog(key="/taskManager/suspendTaskById", value="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", type="\u6302\u8d77")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> suspendTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.suspendTaskById(instId);
    }

    @RequestMapping(value={"/activateTaskById"})
    @ManageBusinessLog(key="/taskManager/activateTaskById", value="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", type="\u6fc0\u6d3b")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> activateTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.activateTaskById(instId);
    }
}

