/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.function.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.function.service.ISysActFunctionParmService;
import com.jxdinfo.hussar.bsp.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/function"})
public class SysActFunctionController
extends BaseController {
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Autowired
    private ISysActFunctionParmService sysActFunctionParmService;

    @RequestMapping(value={"/add"})
    @TargetDataSource
    @ManageBusinessLog(key="/function/add", value="\u65b0\u589e\u51fd\u6570", type="\u65b0\u589e")
    public ApiResponse<?> add(@RequestBody Map<String, String> map) {
        String functionName = map.get("functionName");
        String functionBean = map.get("functionBean");
        String functionParm = map.get("functionParm");
        return this.sysActFunctionService.add(functionName, functionBean, functionParm);
    }

    @RequestMapping(value={"/update"})
    @TargetDataSource
    @ManageBusinessLog(key="/function/update", value="\u4fee\u6539\u51fd\u6570", type="\u4fee\u6539")
    public ApiResponse<?> update(@RequestBody Map<String, String> map) {
        String functionName = map.get("functionName");
        String functionBean = map.get("functionBean");
        String functionId = map.get("functionId");
        boolean change = Boolean.parseBoolean(map.get("change"));
        if (ToolUtil.isEmpty((Object)functionId)) {
            return ApiResponse.enumeration((BpmEnum)BpmEnum.ERROR_UPDATE);
        }
        String functionParm = map.get("functionParm");
        String delIds = map.get("delIds");
        return this.sysActFunctionService.update(functionId, functionName, functionBean, change, functionParm, delIds);
    }

    @RequestMapping(value={"/list"})
    @TargetDataSource
    @ManageBusinessLog(key="/function/list", value="\u83b7\u53d6\u51fd\u6570\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<?> list(@RequestParam(required=false, defaultValue="") String functionName, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="100") int limit) {
        Page pages = new Page(page == 0 ? 1L : (long)page, limit == 0 ? 10L : (long)limit);
        JSONObject jsonObject = new JSONObject();
        List list = this.sysActFunctionService.queryFunctionList(pages, functionName);
        jsonObject.put("count", (Object)pages.getTotal());
        jsonObject.put("list", (Object)list);
        return ApiResponse.data((Object)jsonObject);
    }

    @RequestMapping(value={"/detail"})
    @TargetDataSource
    @ManageBusinessLog(key="/function/detail", value="\u83b7\u53d6\u51fd\u6570\u8be6\u7ec6\u4fe1\u606f", type="\u67e5\u8be2")
    public ApiResponse<?> detail(String functionId) {
        QueryWrapper wrapper = new QueryWrapper();
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            wrapper.eq((Object)"function_id", (Object)functionId);
        }
        List parmList = this.sysActFunctionParmService.list((Wrapper)wrapper);
        return ApiResponse.data((Object)parmList);
    }

    @RequestMapping(value={"/delete"})
    @TargetDataSource
    @ManageBusinessLog(key="/function/delete", value="\u5220\u9664\u51fd\u6570", type="\u5220\u9664")
    public ApiResponse<?> delete(String functionId) {
        this.sysActFunctionParmService.remove((Wrapper)new QueryWrapper().eq((Object)"function_id", (Object)functionId));
        boolean remove = this.sysActFunctionService.removeById((Serializable)((Object)functionId));
        if (!remove) {
            return ApiResponse.enumeration((BpmEnum)BpmEnum.DELETE_FAIL);
        }
        return ApiResponse.enumeration((BpmEnum)BpmEnum.DELETE_SUCCESS);
    }
}

