/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmntoxml.service.Bpm2XMLService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.common.exception.BpmException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/json2Xml"})
public class Json2XmlController {
    private Bpm2XMLService bpm2XMLService;
    private SysActProcessFileService sysActProcessFileService;
    private SysActProcessFileMapper sysActProcessFileMapper;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private ProcessDefinitionsMapper processDefinitionsMapper;
    private ModelService modelService;

    @Autowired
    public Json2XmlController(Bpm2XMLService bpm2XMLService, ModelService modelService, SysActProcessFileService sysActProcessFileService, RepositoryService repositoryService, ISysActExtendPropertiesService iSysActExtendPropertiesService, ProcessDefinitionsMapper processDefinitionsMapper, SysActProcessFileMapper sysActProcessFileMapper) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActProcessFileMapper = sysActProcessFileMapper;
        this.processDefinitionsMapper = processDefinitionsMapper;
        this.repositoryService = repositoryService;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
    }

    @RequestMapping(value={"/publish"})
    @TargetDataSource
    @ManageBusinessLog(key="/json2Xml/publish", value="\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u53d1\u5e03")
    public ApiResponse<?> genWorkFlowXml(@RequestBody String processIdentityKey) {
        SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)processIdentityKey)).eq((Object)"type", (Object)"meta")).eq((Object)"version", (Object)0));
        String modelId = metaInfo.getModelId();
        if (ToolUtil.isEmpty((Object)modelId)) {
            return ApiResponse.fail((int)BpmEnum.DEPLOY_FAIL.getCode(), (String)BpmEnum.DEPLOY_FAIL.getMessage());
        }
        try {
            this.modelService.deployModel(modelId, ShiroUser.getTenantId());
        }
        catch (Exception e) {
            return ApiResponse.fail((int)BpmEnum.DEPLOY_FAIL.getCode(), (String)BpmEnum.DEPLOY_FAIL.getMessage());
        }
        return ApiResponse.success((int)BpmEnum.DEPLOY_SUCCESS.getCode(), (String)BpmEnum.DEPLOY_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/updateProcess"})
    @TargetDataSource
    @ManageBusinessLog(key="/json2Xml/updateProcess", value="\u6d41\u7a0b\u5fae\u8c03", type="\u4fee\u6539")
    public ApiResponse<?> updateProcess(@RequestBody WorkFlow workFlow) {
        String tenantId = ShiroUser.getTenantId();
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId);
                this.saveModelExtendProperties(modelId, workFlow.getName());
                return ApiResponse.success((int)BpmEnum.SUCCESS_SAVE.getCode(), (String)BpmEnum.SUCCESS_SAVE.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.MODEL_NOT_FOUND.getCode(), (String)BpmEnum.MODEL_NOT_FOUND.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private void saveModelExtendProperties(String modelId, String name) {
        ModelBuild modelBuild = this.modelService.queryModel(modelId);
        if (modelBuild != null) {
            String procDefId = modelBuild.getProcessDefinitionId();
            this.processDefinitionsMapper.updateProcessName(procDefId, name);
            BpmnModel model = this.repositoryService.getBpmnModel(procDefId);
            ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
            if (model != null) {
                Collection flowElements = model.getMainProcess().getFlowElements();
                for (FlowElement node : flowElements) {
                    if (!(node instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    JSONObject object = new JSONObject();
                    if (!ToolUtil.isNotEmpty((Object)formDetailKey)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                    if (jsonObject != null) {
                        for (String key : jsonObject.keySet()) {
                            object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setId(procDefId + userTask.getId());
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)object));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
            if (sysActExtendProperties.size() > 0) {
                this.iSysActExtendPropertiesService.saveOrUpdateBatch(sysActExtendProperties);
            }
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    @RequestMapping(value={"/save"})
    @TargetDataSource
    @ManageBusinessLog(key="/json2Xml/save", value="\u4fdd\u5b58\u6d41\u7a0b\u6a21\u578b", type="\u65b0\u589e")
    public ApiResponse<?> saveDataInfo(@RequestBody WorkFlow workFlow) {
        String tenantId = ShiroUser.getTenantId();
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (ToolUtil.isEmpty((Object)modelId)) {
                    return ApiResponse.fail((int)BpmEnum.ERROR_SAVE.getCode(), (String)BpmEnum.ERROR_SAVE.getMessage());
                }
            } else {
                String id = this.modelService.getIdByIdentity(workFlow.getIdentity());
                if (ToolUtil.isNotEmpty((Object)id)) {
                    return ApiResponse.fail((int)BpmEnum.SAME_IDENTITY.getCode(), (String)BpmEnum.SAME_IDENTITY.getMessage());
                }
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (ToolUtil.isEmpty((Object)modelId)) {
                    return ApiResponse.fail((int)BpmEnum.ERROR_SAVE.getCode(), (String)BpmEnum.ERROR_SAVE.getMessage());
                }
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            return ApiResponse.success((int)BpmEnum.SUCCESS_SAVE.getCode(), (String)BpmEnum.SUCCESS_SAVE.getMessage());
        }
        catch (BpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    @TargetDataSource
    @ManageBusinessLog(key="/json2Xml/update", value="\u4fee\u6539\u6d41\u7a0b\u6a21\u578b", type="\u4fee\u6539")
    public ApiResponse<?> updateWorkFlow(@RequestBody String processIdentityKey) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processIdentityKey, ShiroUser.getTenantId(), Integer.valueOf(0));
        return ApiResponse.data((Object)workFlow);
    }
}

