/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmntoxml.service.Bpm2XMLService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.common.exception.BpmException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"godaxeModel"})
public class GodAxeModelController {
    private Bpm2XMLService bpm2XMLService;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private BpmConstantProperties bpmConstantProperties;
    private ModelService modelService;
    private SysActProcessFileService sysActProcessFileService;
    private ProcessDefinitionsMapper processDefinitionsMapper;
    private InstanceEngineService instanceEngineService;

    @Autowired
    public GodAxeModelController(Bpm2XMLService bpm2XMLService, ModelService modelService, InstanceEngineService instanceEngineService, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ProcessDefinitionsMapper processDefinitionsMapper, ISysActExtendPropertiesService iSysActExtendPropertiesService) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.instanceEngineService = instanceEngineService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.processDefinitionsMapper = processDefinitionsMapper;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
    }

    @RequestMapping(value={"/saveAndPublish"})
    @ManageBusinessLog(key="/godaxeModel/saveAndPublish", value="\u4fdd\u5b58\u5e76\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u4fdd\u5b58\u5e76\u53d1\u5e03")
    public ApiResponse<?> saveAndPublish(WorkFlow workFlow, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        try {
            List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
            if (baseList.size() == 2) {
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            } else {
                String id = this.modelService.getIdByIdentity(workFlow.getIdentity());
                if (ToolUtil.isNotEmpty((Object)id)) {
                    return ApiResponse.fail((String)this.bpmConstantProperties.getSameIdentity());
                }
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
            }
            String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
            if (ToolUtil.isEmpty((Object)modelId)) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrorSave());
            }
            if (ToolUtil.isEmpty((Object)oldWorkFlow) || ToolUtil.isEmpty((Object)oldWorkFlow.getModelId())) {
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            String processId = this.modelService.deployModel(modelId, tenantId);
            return ApiResponse.success((String)processId);
        }
        catch (BpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBusinessLog(key="/godaxeModel/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    public ApiResponse<?> deleteModel(String identity, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identity, tenantId, Integer.valueOf(0));
        String modelId = workFlow.getModelId();
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            this.repositoryService.deleteModel(modelId);
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getDeleteSuccess());
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBusinessLog(key="/godaxeModel/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, String variables, HttpServletRequest request) {
        Map body = (Map)JSON.parseObject((String)variables, HashMap.class);
        HashMap map = new HashMap();
        if (body != null) {
            for (Map.Entry vo : body.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, map, request.getParameter("tenantId"));
    }

    @RequestMapping(value={"/doneList"})
    public ApiResponse<?> doneList(String businessKey, HttpServletRequest request) {
        return this.modelService.doneList(businessKey, request.getParameter("tenantId"));
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @ManageBusinessLog(key="/godaxeModel/deleteProcessInstanceByBusinessKey", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/updateMeta"})
    @ManageBusinessLog(key="/godaxeModel/updateMeta", value="\u4fee\u6539meta\u6587\u4ef6", type="\u4fee\u6539")
    public ApiResponse<?> updateMeta(String identity, String name, String category, String tenantId) {
        try {
            if (this.modelService.updateCategory(identity, category) > 0) {
                this.sysActProcessFileService.updateMetaByIdentity(identity, name, category, tenantId);
            }
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/updateProcess"})
    @ManageBusinessLog(key="/godaxeModel/updateProcess", value="\u6d41\u7a0b\u5fae\u8c03", type="\u4fee\u6539")
    public ApiResponse<?> updateProcess(WorkFlow workFlow, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId);
                this.saveModelExtendProperties(modelId, workFlow.getName());
                return ApiResponse.success((int)BpmEnum.SUCCESS_SAVE.getCode(), (String)BpmEnum.SUCCESS_SAVE.getMessage());
            }
            return ApiResponse.fail((int)BpmEnum.MODEL_NOT_FOUND.getCode(), (String)BpmEnum.MODEL_NOT_FOUND.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private void saveModelExtendProperties(String modelId, String name) {
        ModelBuild modelBuild = this.modelService.queryModel(modelId);
        if (modelBuild != null) {
            String procDefId = modelBuild.getProcessDefinitionId();
            this.processDefinitionsMapper.updateProcessName(procDefId, name);
            BpmnModel model = this.repositoryService.getBpmnModel(procDefId);
            ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
            if (model != null) {
                Collection flowElements = model.getMainProcess().getFlowElements();
                for (FlowElement node : flowElements) {
                    if (!(node instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    JSONObject object = new JSONObject();
                    if (!ToolUtil.isNotEmpty((Object)formDetailKey)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                    if (jsonObject != null) {
                        for (String key : jsonObject.keySet()) {
                            object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setId(procDefId + userTask.getId());
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)object));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
            if (sysActExtendProperties.size() > 0) {
                this.iSysActExtendPropertiesService.saveOrUpdateBatch(sysActExtendProperties);
            }
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }
}

