/*
 Navicat Premium Data Transfer

 Source Server         : oracle
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 192.168.2.79:1521
 Source Schema         : LCDPBPMT

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 13/08/2020 17:54:19
*/

-- ----------------------------
-- Table structure for ACT_EVT_LOG
-- ----------------------------
CREATE TABLE "ACT_EVT_LOG" (
  "LOG_NR_" NUMBER(20) NOT NULL ,
  "TYPE_" NVARCHAR2(64) ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "TIME_STAMP_" DATE NOT NULL ,
  "USER_ID_" NVARCHAR2(255) ,
  "DATA_" BLOB ,
  "LOCK_OWNER_" NVARCHAR2(255) ,
  "LOCK_TIME_" DATE ,
  "IS_PROCESSED_" NUMBER(4)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_GE_BYTEARRAY
-- ----------------------------
CREATE TABLE "ACT_GE_BYTEARRAY" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "NAME_" NVARCHAR2(255) ,
  "DEPLOYMENT_ID_" NVARCHAR2(64) ,
  "BYTES_" BLOB ,
  "GENERATED_" NUMBER(4)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_GE_PROPERTY
-- ----------------------------
CREATE TABLE "ACT_GE_PROPERTY" (
  "NAME_" NVARCHAR2(64) NOT NULL ,
  "VALUE_" NVARCHAR2(300) ,
  "REV_" NUMBER(11)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO "ACT_GE_PROPERTY" VALUES ('next.dbid', '447501', '180');
INSERT INTO "ACT_GE_PROPERTY" VALUES ('schema.history', 'create(5.22.0.0)', '1');
INSERT INTO "ACT_GE_PROPERTY" VALUES ('schema.version', '5.22.0.0', '1');

-- ----------------------------
-- Table structure for ACT_HI_ACTINST
-- ----------------------------
CREATE TABLE "ACT_HI_ACTINST" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_DEF_ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_INST_ID_" NVARCHAR2(64) NOT NULL ,
  "EXECUTION_ID_" NVARCHAR2(64) NOT NULL ,
  "ACT_ID_" NVARCHAR2(255) NOT NULL ,
  "TASK_ID_" NVARCHAR2(64) ,
  "CALL_PROC_INST_ID_" NVARCHAR2(64) ,
  "ACT_NAME_" NVARCHAR2(255) ,
  "ACT_TYPE_" NVARCHAR2(255) NOT NULL ,
  "ASSIGNEE_" NVARCHAR2(255) ,
  "START_TIME_" DATE ,
  "END_TIME_" DATE ,
  "DURATION_" NUMBER(20) ,
  "TENANT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_ATTACHMENT
-- ----------------------------
CREATE TABLE "ACT_HI_ATTACHMENT" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "USER_ID_" NVARCHAR2(255) ,
  "NAME_" NVARCHAR2(255) ,
  "DESCRIPTION_" NCLOB ,
  "TYPE_" NVARCHAR2(255) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "URL_" NCLOB ,
  "CONTENT_ID_" NVARCHAR2(64) ,
  "TIME_" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_COMMENT
-- ----------------------------
CREATE TABLE "ACT_HI_COMMENT" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "TYPE_" NVARCHAR2(255) ,
  "TIME_" DATE ,
  "USER_ID_" NVARCHAR2(255) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "ACTION_" NVARCHAR2(255) ,
  "MESSAGE_" NCLOB ,
  "FULL_MSG_" BLOB
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_DETAIL
-- ----------------------------
CREATE TABLE "ACT_HI_DETAIL" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "TYPE_" NVARCHAR2(255) NOT NULL ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "ACT_INST_ID_" NVARCHAR2(64) ,
  "NAME_" NVARCHAR2(255) NOT NULL ,
  "VAR_TYPE_" NVARCHAR2(255) ,
  "REV_" NUMBER(11) ,
  "TIME_" DATE ,
  "BYTEARRAY_ID_" NVARCHAR2(64) ,
  "DOUBLE_" NUMBER ,
  "LONG_" NUMBER(20) ,
  "TEXT_" NCLOB ,
  "TEXT2_" NCLOB
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_IDENTITYLINK
-- ----------------------------
CREATE TABLE "ACT_HI_IDENTITYLINK" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "GROUP_ID_" NVARCHAR2(255) ,
  "TYPE_" NVARCHAR2(255) ,
  "USER_ID_" NVARCHAR2(255) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_PROCINST
-- ----------------------------
CREATE TABLE "ACT_HI_PROCINST" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_INST_ID_" NVARCHAR2(64) NOT NULL ,
  "BUSINESS_KEY_" NVARCHAR2(255) ,
  "PROC_DEF_ID_" NVARCHAR2(64) NOT NULL ,
  "START_TIME_" DATE ,
  "END_TIME_" DATE ,
  "DURATION_" NUMBER(20) ,
  "START_USER_ID_" NVARCHAR2(255) ,
  "START_ACT_ID_" NVARCHAR2(255) ,
  "END_ACT_ID_" NVARCHAR2(255) ,
  "SUPER_PROCESS_INSTANCE_ID_" NVARCHAR2(64) ,
  "DELETE_REASON_" NVARCHAR2(2000) ,
  "TENANT_ID_" NVARCHAR2(255) ,
  "NAME_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_TASKINST
-- ----------------------------
CREATE TABLE "ACT_HI_TASKINST" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "TASK_DEF_KEY_" NVARCHAR2(255) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "NAME_" NVARCHAR2(255) ,
  "PARENT_TASK_ID_" NVARCHAR2(64) ,
  "DESCRIPTION_" NCLOB ,
  "OWNER_" NVARCHAR2(255) ,
  "ASSIGNEE_" NVARCHAR2(255) ,
  "START_TIME_" DATE ,
  "CLAIM_TIME_" DATE ,
  "END_TIME_" DATE ,
  "DURATION_" NUMBER(20) ,
  "DELETE_REASON_" NCLOB ,
  "PRIORITY_" NUMBER(11) ,
  "DUE_DATE_" DATE ,
  "FORM_KEY_" NVARCHAR2(2000) ,
  "CATEGORY_" NVARCHAR2(255) ,
  "TENANT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_VARINST
-- ----------------------------
CREATE TABLE "ACT_HI_VARINST" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "NAME_" NVARCHAR2(255) NOT NULL ,
  "VAR_TYPE_" NVARCHAR2(100) ,
  "REV_" NUMBER(11) ,
  "BYTEARRAY_ID_" NVARCHAR2(64) ,
  "DOUBLE_" NUMBER ,
  "LONG_" NUMBER(20) ,
  "TEXT_" NCLOB ,
  "TEXT2_" NCLOB ,
  "CREATE_TIME_" DATE ,
  "LAST_UPDATED_TIME_" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_GROUP
-- ----------------------------
CREATE TABLE "ACT_ID_GROUP" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "NAME_" NVARCHAR2(255) ,
  "TYPE_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_INFO
-- ----------------------------
CREATE TABLE "ACT_ID_INFO" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "USER_ID_" NVARCHAR2(64) ,
  "TYPE_" NVARCHAR2(64) ,
  "KEY_" NVARCHAR2(255) ,
  "VALUE_" NVARCHAR2(255) ,
  "PASSWORD_" BLOB ,
  "PARENT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_MEMBERSHIP
-- ----------------------------
CREATE TABLE "ACT_ID_MEMBERSHIP" (
  "USER_ID_" NVARCHAR2(64) NOT NULL ,
  "GROUP_ID_" NVARCHAR2(64) NOT NULL
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_USER
-- ----------------------------
CREATE TABLE "ACT_ID_USER" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "FIRST_" NVARCHAR2(255) ,
  "LAST_" NVARCHAR2(255) ,
  "EMAIL_" NVARCHAR2(255) ,
  "PWD_" NVARCHAR2(255) ,
  "PICTURE_ID_" NVARCHAR2(64)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_PROCDEF_INFO
-- ----------------------------
CREATE TABLE "ACT_PROCDEF_INFO" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "PROC_DEF_ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "INFO_JSON_ID_" NVARCHAR2(64)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_DEPLOYMENT
-- ----------------------------
CREATE TABLE "ACT_RE_DEPLOYMENT" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "NAME_" NVARCHAR2(255) ,
  "CATEGORY_" NVARCHAR2(255) ,
  "TENANT_ID_" NVARCHAR2(255) ,
  "DEPLOY_TIME_" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_MODEL
-- ----------------------------
CREATE TABLE "ACT_RE_MODEL" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "NAME_" NVARCHAR2(255) ,
  "KEY_" NVARCHAR2(255) ,
  "CATEGORY_" NVARCHAR2(255) ,
  "CREATE_TIME_" DATE ,
  "LAST_UPDATE_TIME_" DATE ,
  "VERSION_" NUMBER(11) ,
  "META_INFO_" NCLOB ,
  "DEPLOYMENT_ID_" NVARCHAR2(64) ,
  "EDITOR_SOURCE_VALUE_ID_" NVARCHAR2(64) ,
  "EDITOR_SOURCE_EXTRA_VALUE_ID_" NVARCHAR2(64) ,
  "TENANT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_PROCDEF
-- ----------------------------
CREATE TABLE "ACT_RE_PROCDEF" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "CATEGORY_" NVARCHAR2(255) ,
  "NAME_" NVARCHAR2(255) ,
  "KEY_" NVARCHAR2(255) NOT NULL ,
  "VERSION_" NUMBER(11) NOT NULL ,
  "DEPLOYMENT_ID_" NVARCHAR2(64) ,
  "RESOURCE_NAME_" NCLOB ,
  "DGRM_RESOURCE_NAME_" NCLOB ,
  "DESCRIPTION_" NCLOB ,
  "HAS_START_FORM_KEY_" NUMBER(4) ,
  "HAS_GRAPHICAL_NOTATION_" NUMBER(4) ,
  "SUSPENSION_STATE_" NUMBER(11) ,
  "TENANT_ID_" NVARCHAR2(255) ,
  "MAIN_PROCESS" NVARCHAR2(4) ,
  "REAL_VERSION" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "ACT_RE_PROCDEF"."MAIN_PROCESS" IS '1主版本 0 不是主版本';

-- ----------------------------
-- Table structure for ACT_RU_EVENT_SUBSCR
-- ----------------------------
CREATE TABLE "ACT_RU_EVENT_SUBSCR" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "EVENT_TYPE_" NVARCHAR2(255) NOT NULL ,
  "EVENT_NAME_" NVARCHAR2(255) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "ACTIVITY_ID_" NVARCHAR2(64) ,
  "CONFIGURATION_" NVARCHAR2(255) ,
  "CREATED_" DATE NOT NULL ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "TENANT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_EXECUTION
-- ----------------------------
CREATE TABLE "ACT_RU_EXECUTION" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "BUSINESS_KEY_" NVARCHAR2(255) ,
  "PARENT_ID_" NVARCHAR2(64) ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "SUPER_EXEC_" NVARCHAR2(64) ,
  "ACT_ID_" NVARCHAR2(255) ,
  "IS_ACTIVE_" NUMBER(4) ,
  "IS_CONCURRENT_" NUMBER(4) ,
  "IS_SCOPE_" NUMBER(4) ,
  "IS_EVENT_SCOPE_" NUMBER(4) ,
  "SUSPENSION_STATE_" NUMBER(11) ,
  "CACHED_ENT_STATE_" NUMBER(11) ,
  "TENANT_ID_" NVARCHAR2(255) ,
  "NAME_" NVARCHAR2(255) ,
  "LOCK_TIME_" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_IDENTITYLINK
-- ----------------------------
CREATE TABLE "ACT_RU_IDENTITYLINK" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "GROUP_ID_" NVARCHAR2(255) ,
  "TYPE_" NVARCHAR2(255) ,
  "USER_ID_" NVARCHAR2(255) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "PROC_DEF_ID_" NVARCHAR2(64)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_JOB
-- ----------------------------
CREATE TABLE "ACT_RU_JOB" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "TYPE_" NVARCHAR2(255) NOT NULL ,
  "LOCK_EXP_TIME_" DATE ,
  "LOCK_OWNER_" NVARCHAR2(255) ,
  "EXCLUSIVE_" NUMBER(4) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "PROCESS_INSTANCE_ID_" NVARCHAR2(64) ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "RETRIES_" NUMBER(11) ,
  "EXCEPTION_STACK_ID_" NVARCHAR2(64) ,
  "EXCEPTION_MSG_" NCLOB ,
  "DUEDATE_" DATE ,
  "REPEAT_" NVARCHAR2(255) ,
  "HANDLER_TYPE_" NVARCHAR2(255) ,
  "HANDLER_CFG_" NCLOB ,
  "TENANT_ID_" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_TASK
-- ----------------------------
CREATE TABLE "ACT_RU_TASK" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "PROC_DEF_ID_" NVARCHAR2(64) ,
  "NAME_" NVARCHAR2(255) ,
  "PARENT_TASK_ID_" NVARCHAR2(64) ,
  "DESCRIPTION_" NVARCHAR2(2000) ,
  "TASK_DEF_KEY_" NVARCHAR2(255) ,
  "OWNER_" NVARCHAR2(255) ,
  "ASSIGNEE_" NVARCHAR2(255) ,
  "DELEGATION_" NVARCHAR2(64) ,
  "PRIORITY_" NUMBER(11) ,
  "CREATE_TIME_" DATE ,
  "DUE_DATE_" DATE ,
  "CATEGORY_" NVARCHAR2(255) ,
  "SUSPENSION_STATE_" NUMBER(11) ,
  "TENANT_ID_" NVARCHAR2(255) ,
  "FORM_KEY_" NVARCHAR2(2000)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_VARIABLE
-- ----------------------------
CREATE TABLE "ACT_RU_VARIABLE" (
  "ID_" NVARCHAR2(64) NOT NULL ,
  "REV_" NUMBER(11) ,
  "TYPE_" NVARCHAR2(255) NOT NULL ,
  "NAME_" NVARCHAR2(255) NOT NULL ,
  "EXECUTION_ID_" NVARCHAR2(64) ,
  "PROC_INST_ID_" NVARCHAR2(64) ,
  "TASK_ID_" NVARCHAR2(64) ,
  "BYTEARRAY_ID_" NVARCHAR2(64) ,
  "DOUBLE_" NUMBER ,
  "LONG_" NUMBER(20) ,
  "TEXT_" NCLOB ,
  "TEXT2_" NCLOB
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for HUSSAR_BPM_ORGAN
-- ----------------------------
CREATE TABLE "HUSSAR_BPM_ORGAN" (
  "ORGAN_ID" NVARCHAR2(36) NOT NULL ,
  "ORGAN_CODE" NVARCHAR2(255) ,
  "ORGAN_NAME" NVARCHAR2(255) ,
  "PARENT_ID" NVARCHAR2(255) ,
  "TYPE" NVARCHAR2(255) ,
  "SORT" NUMBER(8,0) ,
  "STATE" NVARCHAR2(255) ,
  "WECHAT" NVARCHAR2(255) ,
  "EMAIL" NVARCHAR2(255) ,
  "MOBILE" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."ORGAN_ID" IS '组织机构id';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."ORGAN_CODE" IS '组织编码';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."ORGAN_NAME" IS '组织机构名称';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."PARENT_ID" IS '上级组织机构id';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."TYPE" IS '类型';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."SORT" IS '排序';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."STATE" IS '状态';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."WECHAT" IS '微信';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."EMAIL" IS '邮箱';
COMMENT ON COLUMN "HUSSAR_BPM_ORGAN"."MOBILE" IS '电话';

-- ----------------------------
-- Table structure for HUSSAR_BPM_ROLE
-- ----------------------------
CREATE TABLE "HUSSAR_BPM_ROLE" (
  "ROLE_ID" NVARCHAR2(36) NOT NULL ,
  "ROLE_NAME" NVARCHAR2(255) ,
  "PARENT_ID" NVARCHAR2(255) ,
  "SORT" NUMBER(8,0) ,
  "TYPE" NVARCHAR2(255)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "HUSSAR_BPM_ROLE"."ROLE_ID" IS '角色id';
COMMENT ON COLUMN "HUSSAR_BPM_ROLE"."ROLE_NAME" IS '角色名称';
COMMENT ON COLUMN "HUSSAR_BPM_ROLE"."PARENT_ID" IS '上级id';
COMMENT ON COLUMN "HUSSAR_BPM_ROLE"."SORT" IS '排序';
COMMENT ON COLUMN "HUSSAR_BPM_ROLE"."TYPE" IS '类型';

-- ----------------------------
-- Table structure for HUSSAR_BPM_USER_ROLE
-- ----------------------------
CREATE TABLE "HUSSAR_BPM_USER_ROLE" (
  "USER_ID" NVARCHAR2(36) NOT NULL ,
  "GRANTED_ROLE" NVARCHAR2(36) NOT NULL
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "HUSSAR_BPM_USER_ROLE"."USER_ID" IS '人员id';
COMMENT ON COLUMN "HUSSAR_BPM_USER_ROLE"."GRANTED_ROLE" IS '角色id';

-- ----------------------------
-- Table structure for SYS_ACT_CC_TASK
-- ----------------------------
CREATE TABLE "SYS_ACT_CC_TASK" (
  "ID" NVARCHAR2(32) NOT NULL ,
  "TASK_ID" NVARCHAR2(64) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_NAME" NVARCHAR2(255) ,
  "TASK_NAME" NVARCHAR2(255) ,
  "SEND_USER" NVARCHAR2(32) ,
  "RECEIVE_USER" NVARCHAR2(32) ,
  "SEND_TIME" DATE ,
  "FORM_KEY" NVARCHAR2(1000) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "BUSINESS_ID" NVARCHAR2(255) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TEXT" NCLOB
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_INST_ID" IS '实例id';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_NAME" IS '任务名称';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."SEND_USER" IS '发送人';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."RECEIVE_USER" IS '接收人';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TEXT" IS '待办配置';

-- ----------------------------
-- Table structure for SYS_ACT_CONFIG
-- ----------------------------
CREATE TABLE "SYS_ACT_CONFIG" (
  "TENANT_ID" NVARCHAR2(32) NOT NULL ,
  "PROJECT_ADDRESS" NVARCHAR2(2000) ,
  "IS_MQ_USE" NVARCHAR2(2) ,
  "IS_GOD_AXE" NVARCHAR2(2) ,
  "IS_DATA_PUSH" NVARCHAR2(2) ,
  "DATA_PUSH_ADDRESS" NVARCHAR2(2000) ,
  "CODE_PREFIX" NVARCHAR2(2000)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_CONFIG"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."PROJECT_ADDRESS" IS '项目地址';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MQ_USE" IS '是否启用mq 1启用 0不启用';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_GOD_AXE" IS '是否天斧 1是 0否';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_DATA_PUSH" IS '是否数据推送 1是 0否';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATA_PUSH_ADDRESS" IS '数据推送地址';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."CODE_PREFIX" IS '流程实例编码前缀';

-- ----------------------------
-- Table structure for SYS_ACT_ENTRUST
-- ----------------------------
CREATE TABLE "SYS_ACT_ENTRUST" (
  "ID" NVARCHAR2(36) NOT NULL ,
  "CONSIGNOR" NVARCHAR2(36) ,
  "PROCESS_ID" NVARCHAR2(36) ,
  "PROCESS_NAME" NVARCHAR2(40) ,
  "CONSIGNEE" NVARCHAR2(36) ,
  "CONSIGNEE_NAME" NVARCHAR2(30) ,
  "START_TIME" DATE ,
  "END_TIME" DATE ,
  "STATE" NCHAR(1)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."ID" IS 'ID主键，uuid';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNOR" IS '委托人';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_ID" IS '流程id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE" IS '被委托人id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE_NAME" IS '被委托人姓名';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."STATE" IS '状态';
COMMENT ON TABLE "SYS_ACT_ENTRUST" IS '委托表';

-- ----------------------------
-- Table structure for SYS_ACT_ENTRUST
-- ----------------------------
CREATE TABLE "SYS_ACT_ENTRUST_COMPLETE_HI" (
  "ID" NVARCHAR2(36) NOT NULL ,
  "TASK_ID" NVARCHAR2(36) ,
  "TASK_DEFINITION_KEY" NVARCHAR2(255) ,
  "TASK_DEFINITION_NAME" NVARCHAR2(255) ,
  "PROCESS_DEFINITION_KEY" NVARCHAR2(255) ,
  "PROCESS_INST_ID" NVARCHAR2(36) ,
  "CONSIGNOR" NVARCHAR2(36) ,
  "CONSIGNEE" NVARCHAR2(36) ,
  "CREATE_TIME" DATE ,
  "STATE" NVARCHAR2(2) ,
  "UPDATE_TIME" DATE ,
  "COMMENTS" NVARCHAR2(2000) ,
  "TYPE" NVARCHAR2(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_DEFINITION_KEY" IS '流程节点id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_DEFINITION_NAME" IS '流程节点名称';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."PROCESS_DEFINITION_KEY" IS '流程标识';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."PROCESS_INST_ID" IS '流程实例id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CONSIGNOR" IS '委托人';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CONSIGNEE" IS '被委托人id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CREATE_TIME" IS '委托时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."STATE" IS '状态1有效委托0无效委托';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."UPDATE_TIME" IS '完成时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."COMMENTS" IS '转办意见';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TYPE" IS '是否撤销转办';

-- ----------------------------
-- Table structure for SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
CREATE TABLE "SYS_ACT_EXTEND_PROPERTIES" (
  "ID" NVARCHAR2(200) ,
  "PROC_DEF_ID" NVARCHAR2(64) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TASK_DEF_NAME" NVARCHAR2(1000) ,
  "FORM_DETAIL_KEY" NCLOB ,
  "ATTRIBUTE" NVARCHAR2(32)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ID" IS '主键采用流程定义id和节点id拼接组成';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."PROC_DEF_ID" IS '流程定义id';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_KEY" IS '节点id';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_NAME" IS '节点名称';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."FORM_DETAIL_KEY" IS '表单地址';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ATTRIBUTE" IS '标识扩展的属性类型';

-- ----------------------------
-- Table structure for SYS_ACT_HI_LINE
-- ----------------------------
CREATE TABLE "SYS_ACT_HI_LINE" (
  "ID" NVARCHAR2(32) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_DEF_ID" NVARCHAR2(64) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "LINE_ID" NVARCHAR2(64) ,
  "COMPLETE_TIME" DATE ,
  "COMPLETE_USER" NVARCHAR2(64) ,
  "LINE_NAME" NVARCHAR2(256) ,
  "PROCESS_NAME" NVARCHAR2(256) ,
  "OUT_NODE" NVARCHAR2(64) ,
  "OUT_NODE_NAME" NVARCHAR2(256) ,
  "IN_NODE" NVARCHAR2(64) ,
  "IN_NODE_NAME" NVARCHAR2(256)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_INST_ID" IS '流程实例id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_ID" IS '流程定义id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_KEY" IS '流程定义key';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_ID" IS '连线id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_TIME" IS '办理时间';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_USER" IS '办理人';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_NAME" IS '连线名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROCESS_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE" IS '出线节点';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE_NAME" IS '出现节点名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE" IS '入线节点';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE_NAME" IS '入线节点名称';
COMMENT ON TABLE "SYS_ACT_HI_LINE" IS '记录流程在办理过程中连线的办理历史';

-- ----------------------------
-- Table structure for SYS_ACT_INTERFACE_LOG
-- ----------------------------
CREATE TABLE "SYS_ACT_INTERFACE_LOG" (
  "LOG_ID" NVARCHAR2(32) NOT NULL ,
  "SESSION_ID" NVARCHAR2(128) ,
  "USER_ID" NVARCHAR2(32) ,
  "USER_NAME" NVARCHAR2(32) ,
  "CORPORATION_ID" NVARCHAR2(32) ,
  "CORPORATION_NAME" NVARCHAR2(128) ,
  "LOG_TIME" DATE ,
  "REMOTEADDR" NVARCHAR2(128) ,
  "REMOTEHOST" NVARCHAR2(128) ,
  "REMOTEPORT" NVARCHAR2(8) ,
  "LOCALADDR" NVARCHAR2(128) ,
  "LOCALHOST" NVARCHAR2(128) ,
  "LOCALPORT" NVARCHAR2(8) ,
  "RESOURCE_ID" NVARCHAR2(32) ,
  "RESOURCE_ALIAS" NVARCHAR2(128) ,
  "SECURITY_LEVEL" NUMBER(11) ,
  "LOG_TYPE" NVARCHAR2(32) ,
  "LOG_TYPE_NAME" NVARCHAR2(64) ,
  "LOG_CONTENT" NCLOB ,
  "USER_ACCOUNT" NVARCHAR2(32) ,
  "LEVEL_EVENT" NVARCHAR2(1) ,
  "STATE" NVARCHAR2(1)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LOG_ID" IS '安全日志编码';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."SESSION_ID" IS '会话标识';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ID" IS '用户账户';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."STATE" IS '事件类型';
COMMENT ON TABLE "SYS_ACT_INTERFACE_LOG" IS '安全日志';

-- ----------------------------
-- Table structure for SYS_ACT_MANAGE_LOG
-- ----------------------------
CREATE TABLE "SYS_ACT_MANAGE_LOG" (
  "LOG_ID" NVARCHAR2(32) NOT NULL ,
  "SESSION_ID" NVARCHAR2(128) ,
  "USER_ID" NVARCHAR2(32) ,
  "USER_NAME" NVARCHAR2(32) ,
  "CORPORATION_ID" NVARCHAR2(32) ,
  "CORPORATION_NAME" NVARCHAR2(128) ,
  "LOG_TIME" DATE ,
  "REMOTEADDR" NVARCHAR2(128) ,
  "REMOTEHOST" NVARCHAR2(128) ,
  "REMOTEPORT" NVARCHAR2(8) ,
  "LOCALADDR" NVARCHAR2(128) ,
  "LOCALHOST" NVARCHAR2(128) ,
  "LOCALPORT" NVARCHAR2(8) ,
  "RESOURCE_ID" NVARCHAR2(32) ,
  "RESOURCE_ALIAS" NVARCHAR2(128) ,
  "SECURITY_LEVEL" NUMBER(11) ,
  "LOG_TYPE" NVARCHAR2(32) ,
  "LOG_TYPE_NAME" NVARCHAR2(64) ,
  "LOG_CONTENT" NCLOB ,
  "USER_ACCOUNT" NVARCHAR2(32) ,
  "LEVEL_EVENT" NVARCHAR2(1) ,
  "STATE" NVARCHAR2(1)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LOG_ID" IS '安全日志编码';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."SESSION_ID" IS '会话标识';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ID" IS '用户账户';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."STATE" IS '事件类型';
COMMENT ON TABLE "SYS_ACT_MANAGE_LOG" IS '安全日志';


-- ----------------------------
-- Table structure for SYS_ACT_URGE_TASK
-- ----------------------------
CREATE TABLE "SYS_ACT_URGE_TASK" (
  "ID" NVARCHAR2(32) NOT NULL ,
  "TASK_ID" NVARCHAR2(64) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_NAME" NVARCHAR2(255) ,
  "TASK_NAME" NVARCHAR2(255) ,
  "SEND_USER" NVARCHAR2(32) ,
  "RECEIVE_USER" NVARCHAR2(32) ,
  "SEND_TIME" DATE ,
  "FORM_KEY" NVARCHAR2(1000) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "BUSINESS_ID" NVARCHAR2(255) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TEXT" NCLOB
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_INST_ID" IS '实例id';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_NAME" IS '任务名称';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."SEND_USER" IS '发送人';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."RECEIVE_USER" IS '接收人';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TEXT" IS '待办配置';

-- ----------------------------
-- Table structure for SYS_ACT_PROCESS_FILE
-- ----------------------------
CREATE TABLE "SYS_ACT_PROCESS_FILE" (
  "FILE_ID" NVARCHAR2(64) NOT NULL ,
  "PROCESS_KEY" NVARCHAR2(64) ,
  "PROCESS_ID" NVARCHAR2(64) ,
  "VERSION" NUMBER(11) ,
  "TYPE" NVARCHAR2(8) ,
  "CONTENT" BLOB ,
  "MODEL_ID" NVARCHAR2(64) ,
  "TENANT_ID" NVARCHAR2(64) ,
  "CREATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."FILE_ID" IS '文件id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_KEY" IS '流程标识';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_ID" IS '流程id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."VERSION" IS '版本号';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TYPE" IS '文件类型';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CONTENT" IS '文件内容';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."MODEL_ID" IS '模块id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CREATE_TIME" IS '创建时间';

-- ----------------------------
-- Primary Key structure for table ACT_EVT_LOG
-- ----------------------------
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616669" PRIMARY KEY ("LOG_NR_");

-- ----------------------------
-- Checks structure for table ACT_EVT_LOG
-- ----------------------------
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616613" CHECK ("LOG_NR_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616614" CHECK ("TIME_STAMP_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_GE_BYTEARRAY
-- ----------------------------
ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "SYS_C00616670" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_GE_BYTEARRAY
-- ----------------------------
ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "SYS_C00616615" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_GE_BYTEARRAY
-- ----------------------------
CREATE INDEX "ACT_FK_BYTEARR_DEPL"
  ON "ACT_GE_BYTEARRAY" ("DEPLOYMENT_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_GE_PROPERTY
-- ----------------------------
ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT "SYS_C00616671" PRIMARY KEY ("NAME_");

-- ----------------------------
-- Checks structure for table ACT_GE_PROPERTY
-- ----------------------------
ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT "SYS_C00616616" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_ACTINST
-- ----------------------------
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616672" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_ACTINST
-- ----------------------------
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616617" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616618" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616619" CHECK ("PROC_INST_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616620" CHECK ("EXECUTION_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616621" CHECK ("ACT_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616622" CHECK ("ACT_TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_ACTINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_ACT_INST_END"
  ON "ACT_HI_ACTINST" ("END_TIME_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_EXEC"
  ON "ACT_HI_ACTINST" ("EXECUTION_ID_" ASC, "ACT_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_PROCINST"
  ON "ACT_HI_ACTINST" ("ACT_ID_" ASC, "PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_START"
  ON "ACT_HI_ACTINST" ("START_TIME_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_ATTACHMENT
-- ----------------------------
ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT "SYS_C00616673" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_ATTACHMENT
-- ----------------------------
ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT "SYS_C00616623" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_COMMENT
-- ----------------------------
ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT "SYS_C00616674" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_COMMENT
-- ----------------------------
ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT "SYS_C00616624" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_DETAIL
-- ----------------------------
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616675" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_DETAIL
-- ----------------------------
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616625" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616626" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616627" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_DETAIL
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_DETAIL_ACT_INST"
  ON "ACT_HI_DETAIL" ("ACT_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_NAME"
  ON "ACT_HI_DETAIL" ("NAME_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_PROC_INST"
  ON "ACT_HI_DETAIL" ("PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_TASK_ID"
  ON "ACT_HI_DETAIL" ("TASK_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_TIME"
  ON "ACT_HI_DETAIL" ("TIME_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616676" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616628" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_PROCINST"
  ON "ACT_HI_IDENTITYLINK" ("PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_TASK"
  ON "ACT_HI_IDENTITYLINK" ("TASK_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_USER"
  ON "ACT_HI_IDENTITYLINK" ("USER_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_PROCINST
-- ----------------------------
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616677" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_PROCINST
-- ----------------------------
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616629" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616630" CHECK ("PROC_INST_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616631" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_PROCINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_PRO_INST_END"
  ON "ACT_HI_PROCINST" ("END_TIME_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PRO_I_BUSKEY"
  ON "ACT_HI_PROCINST" ("BUSINESS_KEY_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE UNIQUE INDEX "PROC_INST_ID_"
  ON "ACT_HI_PROCINST" ("PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_TASKINST
-- ----------------------------
ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT "SYS_C00616678" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_TASKINST
-- ----------------------------
ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT "SYS_C00616632" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_TASKINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_TASK_INST_PROCINST"
  ON "ACT_HI_TASKINST" ("PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_VARINST
-- ----------------------------
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616679" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_VARINST
-- ----------------------------
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616633" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616634" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_VARINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_PROCVAR_NAME_TYPE"
  ON "ACT_HI_VARINST" ("NAME_" ASC, "VAR_TYPE_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PROCVAR_PROC_INST"
  ON "ACT_HI_VARINST" ("PROC_INST_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PROCVAR_TASK_ID"
  ON "ACT_HI_VARINST" ("TASK_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PROCVAR_EXECUTION_ID"
  ON "ACT_HI_VARINST" ("EXECUTION_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_ID_GROUP
-- ----------------------------
ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT "SYS_C00616680" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_GROUP
-- ----------------------------
ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT "SYS_C00616635" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_ID_INFO
-- ----------------------------
ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT "SYS_C00616681" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_INFO
-- ----------------------------
ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT "SYS_C00616636" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616682" PRIMARY KEY ("USER_ID_", "GROUP_ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616637" CHECK ("USER_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616638" CHECK ("GROUP_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
CREATE INDEX "ACT_FK_MEMB_GROUP"
  ON "ACT_ID_MEMBERSHIP" ("GROUP_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_ID_USER
-- ----------------------------
ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT "SYS_C00616683" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_USER
-- ----------------------------
ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT "SYS_C00616639" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_PROCDEF_INFO
-- ----------------------------
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616684" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_PROCDEF_INFO
-- ----------------------------
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616640" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616641" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_PROCDEF_INFO
-- ----------------------------
CREATE UNIQUE INDEX "ACT_UNIQ_INFO_PROCDEF"
  ON "ACT_PROCDEF_INFO" ("PROC_DEF_ID_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Checks structure for table ACT_RE_DEPLOYMENT
-- ----------------------------
ALTER TABLE "ACT_RE_DEPLOYMENT" ADD CONSTRAINT "SYS_C00616642" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RE_MODEL
-- ----------------------------
ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT "SYS_C00616643" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RE_PROCDEF
-- ----------------------------
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616644" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616645" CHECK ("KEY_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616646" CHECK ("VERSION_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_EVENT_SUBSCR
-- ----------------------------
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616647" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616648" CHECK ("EVENT_TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616649" CHECK ("CREATED_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_EXECUTION
-- ----------------------------
ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "SYS_C00616650" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616651" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_JOB
-- ----------------------------
ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "SYS_C00616652" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "SYS_C00616653" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_TASK
-- ----------------------------
ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT "SYS_C00616654" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_VARIABLE
-- ----------------------------
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616655" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616656" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616657" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table HUSSAR_BPM_ORGAN
-- ----------------------------
ALTER TABLE "HUSSAR_BPM_ORGAN" ADD CONSTRAINT "SYS_C00616658" CHECK ("ORGAN_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table HUSSAR_BPM_ROLE
-- ----------------------------
ALTER TABLE "HUSSAR_BPM_ROLE" ADD CONSTRAINT "SYS_C00616659" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table HUSSAR_BPM_USER_ROLE
-- ----------------------------
ALTER TABLE "HUSSAR_BPM_USER_ROLE" ADD CONSTRAINT "SYS_C00616660" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "HUSSAR_BPM_USER_ROLE" ADD CONSTRAINT "SYS_C00616661" CHECK ("GRANTED_ROLE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_CC_TASK
-- ----------------------------
ALTER TABLE "SYS_ACT_CC_TASK" ADD CONSTRAINT "SYS_C00616662" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_CONFIG
-- ----------------------------
ALTER TABLE "SYS_ACT_CONFIG" ADD CONSTRAINT "SYS_C00616663" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_ENTRUST
-- ----------------------------
ALTER TABLE "SYS_ACT_ENTRUST" ADD CONSTRAINT "SYS_C00616664" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_INTERFACE_LOG
-- ----------------------------
ALTER TABLE "SYS_ACT_INTERFACE_LOG" ADD CONSTRAINT "SYS_C00616665" CHECK ("LOG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

CREATE INDEX "ACT_FK_INTERFACE_STATE"
  ON "SYS_ACT_INTERFACE_LOG" ("STATE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Checks structure for table SYS_ACT_MANAGE_LOG
-- ----------------------------
ALTER TABLE "SYS_ACT_MANAGE_LOG" ADD CONSTRAINT "SYS_C00616666" CHECK ("LOG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_URGE_TASK
-- ----------------------------
ALTER TABLE "SYS_ACT_URGE_TASK" ADD CONSTRAINT "SYS_C00616668" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

CREATE TABLE "SYS_ACT_FUNCTION" (
  "FUNCTION_ID" NVARCHAR2(36) NOT NULL,
  "FUNCTION_NAME" NVARCHAR2(255),
  "FUNCTION_BEAN" NVARCHAR2(255),
  "CREATE_TIME" DATE,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_NAME" IS '函数名称';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_BEAN" IS '函数beanId';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."UPDATE_TIME" IS '修改时间';

-- ----------------------------
-- Table structure for SYS_ACT_FUNCTION_PARM
-- ----------------------------
CREATE TABLE "SYS_ACT_FUNCTION_PARM" (
  "PARM_ID" NVARCHAR2(36) NOT NULL,
  "FUNCTION_ID" NVARCHAR2(36),
  "PARM_NAME" NVARCHAR2(255),
  "PARM_KEY" NVARCHAR2(255),
  "CREATE_TIME" DATE,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."FUNCTION_ID" IS '函数主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_NAME" IS '参数名称';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_KEY" IS '参数标识';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."UPDATE_TIME" IS '修改时间';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_FUNCTION
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION" ADD CONSTRAINT "SYS_C0083941" PRIMARY KEY ("FUNCTION_ID");

-- ----------------------------
-- Checks structure for table SYS_ACT_FUNCTION
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION" ADD CONSTRAINT "SYS_C0083939" CHECK ("FUNCTION_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table SYS_ACT_FUNCTION_PARM
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION_PARM" ADD CONSTRAINT "SYS_C0083942" PRIMARY KEY ("PARM_ID");

-- ----------------------------
-- Checks structure for table SYS_ACT_FUNCTION_PARM
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION_PARM" ADD CONSTRAINT "SYS_C0083940" CHECK ("PARM_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

CREATE TABLE "SYS_ACT_PROC_PATH" (
  "ID" VARCHAR2(36 BYTE) NOT NULL,
  "PROC_DEF_KEY" VARCHAR2(255 BYTE),
  "PROC_PATH" VARCHAR2(255 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_PROC_PATH"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_PROC_PATH"."PROCESSINSTANCEID" IS '流程标识';
COMMENT ON COLUMN "SYS_ACT_PROC_PATH"."OPERATIONTASKID" IS '项目地址';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_PROC_PATH
-- ----------------------------
ALTER TABLE "SYS_ACT_PROC_PATH" ADD CONSTRAINT "SYS_C0019278" PRIMARY KEY ("ID");

CREATE TABLE "SYS_ACT_SAMELEVEL_TASKID" (
  "ID" VARCHAR2(64 BYTE) NOT NULL,
  "PROCESSINSTANCEID" VARCHAR2(100 BYTE),
  "OPERATIONTASKID" VARCHAR2(100 BYTE),
  "OPERATIONSAMELEVELTASKID" BLOB,
  "TYPE" VARCHAR2(100 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_SAMELEVEL_TASKID"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_SAMELEVEL_TASKID"."PROCESSINSTANCEID" IS '流程实例id';
COMMENT ON COLUMN "SYS_ACT_SAMELEVEL_TASKID"."OPERATIONTASKID" IS '被操作的任务id';
COMMENT ON COLUMN "SYS_ACT_SAMELEVEL_TASKID"."OPERATIONSAMELEVELTASKID" IS '被操作的任务的同级任务id';
COMMENT ON COLUMN "SYS_ACT_SAMELEVEL_TASKID"."TYPE" IS '任务类型（会签 0 网关 1）';

-- ----------------------------
-- Primary Key structure for table sys_act_samelevel_taskid
-- ----------------------------
ALTER TABLE "SYS_ACT_SAMELEVEL_TASKID" ADD CONSTRAINT "SYS_C0019277" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table sys_act_samelevel_taskid
-- ----------------------------
ALTER TABLE "SYS_ACT_SAMELEVEL_TASKID" ADD CONSTRAINT "SYS_C0019276" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
