/*
 Navicat Premium Data Transfer

 Source Server         : oracle
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 192.168.2.79:1521
 Source Schema         : LCDPBPMT

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 13/08/2020 17:54:19
*/

-- ----------------------------
-- Table structure for ACT_EVT_LOG
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_EVT_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_EVT_LOG';
END IF;
END;
/
CREATE TABLE "ACT_EVT_LOG" (
   LOG_NR_ NUMBER(19),
    TYPE_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    TIME_STAMP_ TIMESTAMP(6) not null,
    USER_ID_ NVARCHAR2(255),
    DATA_ BLOB,
    LOCK_OWNER_ NVARCHAR2(255),
    LOCK_TIME_ TIMESTAMP(6) null,
    IS_PROCESSED_ NUMBER(3) default 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_GE_BYTEARRAY
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_GE_BYTEARRAY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_GE_BYTEARRAY';
END IF;
END;
/
CREATE TABLE "ACT_GE_BYTEARRAY" (
   ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    DEPLOYMENT_ID_ NVARCHAR2(64),
    BYTES_ BLOB,
    GENERATED_ NUMBER(1,0)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_GE_PROPERTY
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_GE_PROPERTY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_GE_PROPERTY';
END IF;
END;
/
CREATE TABLE "ACT_GE_PROPERTY" (
  NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO "ACT_GE_PROPERTY" VALUES ('next.dbid', '447501', '180');
INSERT INTO "ACT_GE_PROPERTY" VALUES ('schema.history', 'create(5.22.0.0)', '1');
INSERT INTO "ACT_GE_PROPERTY" VALUES ('schema.version', '5.22.0.0', '1');

-- ----------------------------
-- Table structure for ACT_HI_ACTINST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_ACTINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_ACTINST';
END IF;
END;
/
CREATE TABLE "ACT_HI_ACTINST" (
  ID_ NVARCHAR2(64) not null,
    PROC_DEF_ID_ NVARCHAR2(64) not null,
    PROC_INST_ID_ NVARCHAR2(64) not null,
    EXECUTION_ID_ NVARCHAR2(64) not null,
    ACT_ID_ NVARCHAR2(255) not null,
    TASK_ID_ NVARCHAR2(64),
    CALL_PROC_INST_ID_ NVARCHAR2(64),
    ACT_NAME_ NVARCHAR2(255),
    ACT_TYPE_ NVARCHAR2(255) not null,
    ASSIGNEE_ NVARCHAR2(255),
    START_TIME_ TIMESTAMP(6) not null,
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    TENANT_ID_ NVARCHAR2(255) default ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_ATTACHMENT
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_ATTACHMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_ATTACHMENT';
END IF;
END;
/
CREATE TABLE "ACT_HI_ATTACHMENT" (
  ID_ NVARCHAR2(64) not null,
    REV_ INTEGER,
    USER_ID_ NVARCHAR2(255),
    NAME_ NVARCHAR2(255),
    DESCRIPTION_ NVARCHAR2(2000),
    TYPE_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    URL_ NVARCHAR2(2000),
    CONTENT_ID_ NVARCHAR2(64),
    TIME_ TIMESTAMP(6)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_COMMENT
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_COMMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_COMMENT';
END IF;
END;
/
CREATE TABLE "ACT_HI_COMMENT" (
  ID_ NVARCHAR2(64) not null,
    TYPE_ NVARCHAR2(255),
    TIME_ TIMESTAMP(6) not null,
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    ACTION_ NVARCHAR2(255),
    MESSAGE_ NVARCHAR2(2000),
    FULL_MSG_ BLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_DETAIL
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_DETAIL');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_DETAIL';
END IF;
END;
/
CREATE TABLE "ACT_HI_DETAIL" (
 ID_ NVARCHAR2(64) not null,
    TYPE_ NVARCHAR2(255) not null,
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    ACT_INST_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255) not null,
    VAR_TYPE_ NVARCHAR2(64),
    REV_ INTEGER,
    TIME_ TIMESTAMP(6) not null,
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_IDENTITYLINK
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_IDENTITYLINK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_IDENTITYLINK';
END IF;
END;
/
CREATE TABLE "ACT_HI_IDENTITYLINK" (
  ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_PROCINST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_PROCINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_PROCINST';
END IF;
END;
/
CREATE TABLE "ACT_HI_PROCINST" (
    ID_ NVARCHAR2(64) not null,
    PROC_INST_ID_ NVARCHAR2(64) not null,
    BUSINESS_KEY_ NVARCHAR2(255),
    PROC_DEF_ID_ NVARCHAR2(64) not null,
    START_TIME_ TIMESTAMP(6) not null,
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    START_USER_ID_ NVARCHAR2(255),
    START_ACT_ID_ NVARCHAR2(255),
    END_ACT_ID_ NVARCHAR2(255),
    SUPER_PROCESS_INSTANCE_ID_ NVARCHAR2(64),
    DELETE_REASON_ NVARCHAR2(2000),
    TENANT_ID_ NVARCHAR2(255) default '',
    NAME_ NVARCHAR2(255)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_TASKINST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_TASKINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_TASKINST';
END IF;
END;
/
CREATE TABLE "ACT_HI_TASKINST" (
   ID_ NVARCHAR2(64) not null,
    PROC_DEF_ID_ NVARCHAR2(64),
    TASK_DEF_KEY_ NVARCHAR2(255),
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    PARENT_TASK_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    DESCRIPTION_ NVARCHAR2(2000),
    OWNER_ NVARCHAR2(255),
    ASSIGNEE_ NVARCHAR2(255),
    START_TIME_ TIMESTAMP(6) not null,
    CLAIM_TIME_ TIMESTAMP(6),
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    DELETE_REASON_ NVARCHAR2(2000),
    PRIORITY_ INTEGER,
    DUE_DATE_ TIMESTAMP(6),
    FORM_KEY_ NVARCHAR2(2000),
    CATEGORY_ NVARCHAR2(255),
    TENANT_ID_ NVARCHAR2(255) default ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_HI_VARINST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_HI_VARINST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_HI_VARINST';
END IF;
END;
/
CREATE TABLE "ACT_HI_VARINST" (
  ID_ NVARCHAR2(64) not null,
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255) not null,
    VAR_TYPE_ NVARCHAR2(100),
    REV_ INTEGER,
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),
    CREATE_TIME_ TIMESTAMP(6),
    LAST_UPDATED_TIME_ TIMESTAMP(6)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_GROUP
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_GROUP');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_GROUP';
END IF;
END;
/
CREATE TABLE "ACT_ID_GROUP" (
   ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_INFO
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_INFO');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_INFO';
END IF;
END;
/
CREATE TABLE "ACT_ID_INFO" (
 ID_ NVARCHAR2(64),
    REV_ INTEGER,
    USER_ID_ NVARCHAR2(64),
    TYPE_ NVARCHAR2(64),
    KEY_ NVARCHAR2(255),
    VALUE_ NVARCHAR2(255),
    PASSWORD_ BLOB,
    PARENT_ID_ NVARCHAR2(255)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_MEMBERSHIP
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_MEMBERSHIP');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_MEMBERSHIP';
END IF;
END;
/
CREATE TABLE "ACT_ID_MEMBERSHIP" (
   USER_ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(64)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_ID_USER
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_ID_USER');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_ID_USER';
END IF;
END;
/
CREATE TABLE "ACT_ID_USER" (
   ID_ NVARCHAR2(64),
    REV_ INTEGER,
    FIRST_ NVARCHAR2(255),
    LAST_ NVARCHAR2(255),
    EMAIL_ NVARCHAR2(255),
    PWD_ NVARCHAR2(255),
    PICTURE_ID_ NVARCHAR2(64)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_PROCDEF_INFO
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_PROCDEF_INFO');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_PROCDEF_INFO';
END IF;
END;
/
CREATE TABLE "ACT_PROCDEF_INFO" (
 ID_ NVARCHAR2(64) not null,
    PROC_DEF_ID_ NVARCHAR2(64) not null,
    REV_ integer,
    INFO_JSON_ID_ NVARCHAR2(64)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_DEPLOYMENT
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_DEPLOYMENT');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_DEPLOYMENT';
END IF;
END;
/
CREATE TABLE "ACT_RE_DEPLOYMENT" (
 ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    CATEGORY_ NVARCHAR2(255),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    DEPLOY_TIME_ TIMESTAMP(6)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_MODEL
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_MODEL');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_MODEL';
END IF;
END;
/
CREATE TABLE "ACT_RE_MODEL" (
 ID_ NVARCHAR2(64) not null,
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    KEY_ NVARCHAR2(255),
    CATEGORY_ NVARCHAR2(255),
    CREATE_TIME_ TIMESTAMP(6),
    LAST_UPDATE_TIME_ TIMESTAMP(6),
    VERSION_ INTEGER,
    META_INFO_ NVARCHAR2(2000),
    DEPLOYMENT_ID_ NVARCHAR2(64),
    EDITOR_SOURCE_VALUE_ID_ NVARCHAR2(64),
    EDITOR_SOURCE_EXTRA_VALUE_ID_ NVARCHAR2(64),
    TENANT_ID_ NVARCHAR2(255) DEFAULT ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RE_PROCDEF
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RE_PROCDEF');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RE_PROCDEF';
END IF;
END;
/
CREATE TABLE "ACT_RE_PROCDEF" (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    CATEGORY_ NVARCHAR2(255),
    NAME_ NVARCHAR2(255),
    KEY_ NVARCHAR2(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ NVARCHAR2(64),
    RESOURCE_NAME_ NVARCHAR2(2000),
    DGRM_RESOURCE_NAME_ varchar(4000),
    DESCRIPTION_ NVARCHAR2(2000),
    HAS_START_FORM_KEY_ NUMBER(1,0),
    HAS_GRAPHICAL_NOTATION_ NUMBER(1,0) ,
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    MAIN_PROCESS NVARCHAR2(4) default 0,
    REAL_VERSION INTEGER
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "ACT_RE_PROCDEF"."MAIN_PROCESS" IS '1主版本 0 不是主版本 2 临时版本';
COMMENT ON COLUMN "ACT_RE_PROCDEF"."REAL_VERSION" IS '临时版本流程真实版本号';

-- ----------------------------
-- Table structure for ACT_RU_EVENT_SUBSCR
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_EVENT_SUBSCR');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_EVENT_SUBSCR';
END IF;
END;
/
CREATE TABLE "ACT_RU_EVENT_SUBSCR" (
  ID_ NVARCHAR2(64) not null,
    REV_ integer,
    EVENT_TYPE_ NVARCHAR2(255) not null,
    EVENT_NAME_ NVARCHAR2(255),
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    ACTIVITY_ID_ NVARCHAR2(64),
    CONFIGURATION_ NVARCHAR2(255),
    CREATED_ TIMESTAMP(6) not null,
    PROC_DEF_ID_ NVARCHAR2(64),
    TENANT_ID_ NVARCHAR2(255) DEFAULT ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_EXECUTION
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_EXECUTION');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_EXECUTION';
END IF;
END;
/
CREATE TABLE "ACT_RU_EXECUTION" (
  ID_ NVARCHAR2(64),
    REV_ INTEGER,
    PROC_INST_ID_ NVARCHAR2(64),
    BUSINESS_KEY_ NVARCHAR2(255),
    PARENT_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    SUPER_EXEC_ NVARCHAR2(64),
    ACT_ID_ NVARCHAR2(255),
    IS_ACTIVE_ NUMBER(1,0) CHECK (IS_ACTIVE_ IN (1,0)),
    IS_CONCURRENT_ NUMBER(1,0) CHECK (IS_CONCURRENT_ IN (1,0)),
    IS_SCOPE_ NUMBER(1,0) CHECK (IS_SCOPE_ IN (1,0)),
    IS_EVENT_SCOPE_ NUMBER(1,0) CHECK (IS_EVENT_SCOPE_ IN (1,0)),
    SUSPENSION_STATE_ INTEGER,
    CACHED_ENT_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    NAME_ NVARCHAR2(255),
    LOCK_TIME_ TIMESTAMP(6)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_IDENTITYLINK
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_IDENTITYLINK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_IDENTITYLINK';
END IF;
END;
/
CREATE TABLE "ACT_RU_IDENTITYLINK" (
  ID_ NVARCHAR2(64),
    REV_ INTEGER,
    GROUP_ID_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_JOB
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_JOB');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_JOB';
END IF;
END;
/
CREATE TABLE "ACT_RU_JOB" (
  ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ NVARCHAR2(255) NOT NULL,
    LOCK_EXP_TIME_ TIMESTAMP(6),
    LOCK_OWNER_ NVARCHAR2(255),
    EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)),
    EXECUTION_ID_ NVARCHAR2(64),
    PROCESS_INSTANCE_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    RETRIES_ INTEGER,
    EXCEPTION_STACK_ID_ NVARCHAR2(64),
    EXCEPTION_MSG_ NVARCHAR2(2000),
    DUEDATE_ TIMESTAMP(6),
    REPEAT_ NVARCHAR2(255),
    HANDLER_TYPE_ NVARCHAR2(255),
    HANDLER_CFG_ NVARCHAR2(2000),
    TENANT_ID_ NVARCHAR2(255) DEFAULT ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_TASK
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_TASK';
END IF;
END;
/
CREATE TABLE "ACT_RU_TASK" (
   ID_ NVARCHAR2(64),
    REV_ INTEGER,
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    PARENT_TASK_ID_ NVARCHAR2(64),
    DESCRIPTION_ NVARCHAR2(2000),
    TASK_DEF_KEY_ NVARCHAR2(255),
    OWNER_ NVARCHAR2(255),
    ASSIGNEE_ NVARCHAR2(255),
    DELEGATION_ NVARCHAR2(64),
    PRIORITY_ INTEGER,
    CREATE_TIME_ TIMESTAMP(6),
    DUE_DATE_ TIMESTAMP(6),
    CATEGORY_ NVARCHAR2(255),
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    FORM_KEY_ NVARCHAR2(2000)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Table structure for ACT_RU_VARIABLE
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('ACT_RU_VARIABLE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE ACT_RU_VARIABLE';
END IF;
END;
/
CREATE TABLE "ACT_RU_VARIABLE" (
  ID_ NVARCHAR2(64) not null,
    REV_ INTEGER,
    TYPE_ NVARCHAR2(255) not null,
    NAME_ NVARCHAR2(255) not null,
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
-- ----------------------------
-- Table structure for SYS_ACT_CC_TASK
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_CC_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_CC_TASK';
END IF;
END;
/
CREATE TABLE "SYS_ACT_CC_TASK" (
  "ID" NVARCHAR2(32) NOT NULL ,
  "TASK_ID" NVARCHAR2(64) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_NAME" NVARCHAR2(255) ,
  "TASK_NAME" NVARCHAR2(255) ,
  "SEND_USER" NVARCHAR2(32) ,
  "RECEIVE_USER" NVARCHAR2(32) ,
  "SEND_TIME" DATE ,
  "FORM_KEY" NVARCHAR2(1000) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "BUSINESS_ID" NVARCHAR2(255) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TEXT" NCLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_INST_ID" IS '实例id';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."PROC_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TASK_NAME" IS '任务名称';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."SEND_USER" IS '发送人';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."RECEIVE_USER" IS '接收人';
COMMENT ON COLUMN "SYS_ACT_CC_TASK"."TEXT" IS '待办配置';

-- ----------------------------
-- Table structure for SYS_ACT_CONFIG
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_CONFIG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_CONFIG';
END IF;
END;
/
CREATE TABLE "SYS_ACT_CONFIG" (
  "TENANT_ID" NVARCHAR2(32) NOT NULL ,
  "PROJECT_ADDRESS" NVARCHAR2(255) ,
  "IS_MQ_USE" NVARCHAR2(255) ,
  "IS_GOD_AXE" NVARCHAR2(255),
  "IS_MULTI_TENANT" NCHAR(1),
  "IS_DATAPUSH" NCHAR(1),
  "DATAPUSH_TOUSER" NVARCHAR2(4000),
  "DATAPUSH_URL" NVARCHAR2(1000),
  "DATAPUSH_AGENTID" NVARCHAR2(255),
  "DATAPUSH_CORPID" NVARCHAR2(255),
  "DATAPUSH_CORPSECRET" NVARCHAR2(255)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_CONFIG"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."PROJECT_ADDRESS" IS '项目地址';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MULTI_TENANT" IS '是否共库 1是 0否';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MQ_USE" IS '是否启用mq 1启用 0不启用';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_GOD_AXE" IS '是否天斧 1是 0否';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_MULTI_TENANT" IS '是否共库 1是 0否';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."IS_DATAPUSH" IS '是否开启数据推送';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATAPUSH_TOUSER" IS '数据推送人，多个之间以|隔开';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATAPUSH_URL" IS '数据推送url';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATAPUSH_AGENTID" IS '应用id';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATAPUSH_CORPID" IS '企业id';
COMMENT ON COLUMN "SYS_ACT_CONFIG"."DATAPUSH_CORPSECRET" IS '应用的凭证密钥';

-- ----------------------------
-- Table structure for SYS_ACT_ENTRUST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_ENTRUST');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_ENTRUST';
END IF;
END;
/
CREATE TABLE "SYS_ACT_ENTRUST" (
  "ID" NVARCHAR2(36) NOT NULL ,
  "CONSIGNOR" NVARCHAR2(36) ,
  "PROCESS_ID" NVARCHAR2(255) ,
  "PROCESS_NAME" NVARCHAR2(255) ,
  "CONSIGNEE" NVARCHAR2(36) ,
  "CONSIGNEE_NAME" NVARCHAR2(255) ,
  "START_TIME" DATE ,
  "END_TIME" DATE ,
  "STATE" NCHAR(1)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."ID" IS 'ID主键，uuid';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNOR" IS '委托人';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_ID" IS '流程id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."PROCESS_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE" IS '被委托人id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."CONSIGNEE_NAME" IS '被委托人姓名';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST"."STATE" IS '状态';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
ALTER TABLE "SYS_ACT_ENTRUST" ADD CONSTRAINT "SYS_C00616687" PRIMARY KEY ("ID");


-- ----------------------------
-- Table structure for SYS_ACT_ENTRUST
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_ENTRUST_COMPLETE_HI');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_ENTRUST_COMPLETE_HI';
END IF;
END;
/
CREATE TABLE "SYS_ACT_ENTRUST_COMPLETE_HI" (
    "ID" NVARCHAR2(36) NOT NULL ,
    "TASK_ID" NVARCHAR2(36) ,
    "TASK_DEFINITION_KEY" NVARCHAR2(255) ,
    "TASK_DEFINITION_NAME" NVARCHAR2(255) ,
    "PROCESS_DEFINITION_KEY" NVARCHAR2(255) ,
    "PROCESS_INST_ID" NVARCHAR2(36) ,
    "CONSIGNOR" NVARCHAR2(36) ,
    "CONSIGNEE" NVARCHAR2(36) ,
    "CREATE_TIME" DATE ,
    "STATE" NVARCHAR2(2) ,
    "UPDATE_TIME" DATE ,
    "COMMENTS" NVARCHAR2(2000) ,
    "TYPE" NVARCHAR2(20)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_DEFINITION_KEY" IS '流程节点id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TASK_DEFINITION_NAME" IS '流程节点名称';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."PROCESS_DEFINITION_KEY" IS '流程标识';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."PROCESS_INST_ID" IS '流程实例id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CONSIGNOR" IS '委托人';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CONSIGNEE" IS '被委托人id';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."CREATE_TIME" IS '委托时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."STATE" IS '状态1有效委托0无效委托';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."UPDATE_TIME" IS '完成时间';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."COMMENTS" IS '转办意见';
COMMENT ON COLUMN "SYS_ACT_ENTRUST_COMPLETE_HI"."TYPE" IS '是否撤销转办';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
ALTER TABLE "SYS_ACT_ENTRUST_COMPLETE_HI" ADD CONSTRAINT "SYS_C00616689" PRIMARY KEY ("ID");

-- ----------------------------
-- Indexes structure for table ACT_HI_ACTINST
-- ----------------------------
CREATE INDEX "IDX_ENTRUST_HI_CONSIGNOR"
  ON "SYS_ACT_ENTRUST_COMPLETE_HI" ("CONSIGNOR" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_ENTRUST_HI_TASKID"
  ON "SYS_ACT_ENTRUST_COMPLETE_HI" ("TASK_ID" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_ENTRUST_HI_STATE"
  ON "SYS_ACT_ENTRUST_COMPLETE_HI" ("STATE" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_ENTRUST_HI_PROCESINSTID"
  ON "SYS_ACT_ENTRUST_COMPLETE_HI" ("PROCESS_INST_ID" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Table structure for SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_EXTEND_PROPERTIES');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_EXTEND_PROPERTIES';
END IF;
END;
/
CREATE TABLE "SYS_ACT_EXTEND_PROPERTIES" (
  "ID" NVARCHAR2(200) ,
  "PROC_DEF_ID" NVARCHAR2(64) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TASK_DEF_NAME" NVARCHAR2(1000) ,
  "FORM_DETAIL_KEY" NCLOB ,
  "ATTRIBUTE" NVARCHAR2(32)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ID" IS '主键采用流程定义id和节点id拼接组成';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."PROC_DEF_ID" IS '流程定义id';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_KEY" IS '节点id';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."TASK_DEF_NAME" IS '节点名称';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."FORM_DETAIL_KEY" IS '表单地址';
COMMENT ON COLUMN "SYS_ACT_EXTEND_PROPERTIES"."ATTRIBUTE" IS '标识扩展的属性类型';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
ALTER TABLE "SYS_ACT_EXTEND_PROPERTIES" ADD CONSTRAINT "SYS_C00616685" PRIMARY KEY ("ID");

-- ----------------------------
-- Table structure for SYS_ACT_HI_LINE
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_HI_LINE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_HI_LINE';
END IF;
END;
/
CREATE TABLE "SYS_ACT_HI_LINE" (
  "ID" NVARCHAR2(32) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_DEF_ID" NVARCHAR2(64) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "LINE_ID" NVARCHAR2(64) ,
  "COMPLETE_TIME" DATE ,
  "COMPLETE_USER" NVARCHAR2(64) ,
  "LINE_NAME" NVARCHAR2(256) ,
  "PROCESS_NAME" NVARCHAR2(256) ,
  "OUT_NODE" NVARCHAR2(64) ,
  "OUT_NODE_NAME" NVARCHAR2(256) ,
  "IN_NODE" NVARCHAR2(64) ,
  "IN_NODE_NAME" NVARCHAR2(256)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_INST_ID" IS '流程实例id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_ID" IS '流程定义id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROC_DEF_KEY" IS '流程定义key';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_ID" IS '连线id';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_TIME" IS '办理时间';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."COMPLETE_USER" IS '办理人';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."LINE_NAME" IS '连线名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."PROCESS_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE" IS '出线节点';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."OUT_NODE_NAME" IS '出现节点名称';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE" IS '入线节点';
COMMENT ON COLUMN "SYS_ACT_HI_LINE"."IN_NODE_NAME" IS '入线节点名称';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
ALTER TABLE "SYS_ACT_HI_LINE" ADD CONSTRAINT "SYS_C00616686" PRIMARY KEY ("ID");

-- ----------------------------
-- Table structure for SYS_ACT_INTERFACE_LOG
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_INTERFACE_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_INTERFACE_LOG';
END IF;
END;
/
CREATE TABLE "SYS_ACT_INTERFACE_LOG" (
  "LOG_ID" NVARCHAR2(32) NOT NULL ,
  "SESSION_ID" NVARCHAR2(128) ,
  "USER_ID" NVARCHAR2(32) ,
  "USER_NAME" NVARCHAR2(32) ,
  "CORPORATION_ID" NVARCHAR2(32) ,
  "CORPORATION_NAME" NVARCHAR2(128) ,
  "LOG_TIME" DATE ,
  "REMOTEADDR" NVARCHAR2(128) ,
  "REMOTEHOST" NVARCHAR2(128) ,
  "REMOTEPORT" NVARCHAR2(8) ,
  "LOCALADDR" NVARCHAR2(128) ,
  "LOCALHOST" NVARCHAR2(128) ,
  "LOCALPORT" NVARCHAR2(8) ,
  "RESOURCE_ID" NVARCHAR2(32) ,
  "RESOURCE_ALIAS" NVARCHAR2(128) ,
  "SECURITY_LEVEL" NUMBER(11) ,
  "LOG_TYPE" NVARCHAR2(32) ,
  "LOG_TYPE_NAME" NVARCHAR2(64) ,
  "LOG_CONTENT" NCLOB ,
  "USER_ACCOUNT" NVARCHAR2(32) ,
  "LEVEL_EVENT" NVARCHAR2(1) ,
  "STATE" NVARCHAR2(1)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LOG_ID" IS '安全日志编码';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."SESSION_ID" IS '会话标识';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ID" IS '用户账户';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';
COMMENT ON COLUMN "SYS_ACT_INTERFACE_LOG"."STATE" IS '事件类型';

-- ----------------------------
-- Table structure for SYS_ACT_MANAGE_LOG
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_MANAGE_LOG');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_MANAGE_LOG';
END IF;
END;
/
CREATE TABLE "SYS_ACT_MANAGE_LOG" (
  "LOG_ID" NVARCHAR2(32) NOT NULL ,
  "SESSION_ID" NVARCHAR2(128) ,
  "USER_ID" NVARCHAR2(32) ,
  "USER_NAME" NVARCHAR2(32) ,
  "CORPORATION_ID" NVARCHAR2(32) ,
  "CORPORATION_NAME" NVARCHAR2(128) ,
  "LOG_TIME" DATE ,
  "REMOTEADDR" NVARCHAR2(128) ,
  "REMOTEHOST" NVARCHAR2(128) ,
  "REMOTEPORT" NVARCHAR2(8) ,
  "LOCALADDR" NVARCHAR2(128) ,
  "LOCALHOST" NVARCHAR2(128) ,
  "LOCALPORT" NVARCHAR2(8) ,
  "RESOURCE_ID" NVARCHAR2(32) ,
  "RESOURCE_ALIAS" NVARCHAR2(128) ,
  "SECURITY_LEVEL" NUMBER(11) ,
  "LOG_TYPE" NVARCHAR2(32) ,
  "LOG_TYPE_NAME" NVARCHAR2(64) ,
  "LOG_CONTENT" NCLOB ,
  "USER_ACCOUNT" NVARCHAR2(32) ,
  "LEVEL_EVENT" NVARCHAR2(1) ,
  "STATE" NVARCHAR2(1)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LOG_ID" IS '安全日志编码';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."SESSION_ID" IS '会话标识';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ID" IS '用户账户';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_ID" IS '公司编码';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."CORPORATION_NAME" IS '公司名称';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."RESOURCE_ALIAS" IS '资源业务语义';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."USER_ACCOUNT" IS '用户登录账号';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."LEVEL_EVENT" IS '1系统级/2业务级事件';
COMMENT ON COLUMN "SYS_ACT_MANAGE_LOG"."STATE" IS '事件类型';


-- ----------------------------
-- Table structure for SYS_ACT_URGE_TASK
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_URGE_TASK');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_URGE_TASK';
END IF;
END;
/
CREATE TABLE "SYS_ACT_URGE_TASK" (
  "ID" NVARCHAR2(32) NOT NULL ,
  "TASK_ID" NVARCHAR2(64) ,
  "PROC_INST_ID" NVARCHAR2(64) ,
  "PROC_NAME" NVARCHAR2(255) ,
  "TASK_NAME" NVARCHAR2(255) ,
  "SEND_USER" NVARCHAR2(32) ,
  "RECEIVE_USER" NVARCHAR2(32) ,
  "SEND_TIME" DATE ,
  "FORM_KEY" NVARCHAR2(1000) ,
  "PROC_DEF_KEY" NVARCHAR2(64) ,
  "BUSINESS_ID" NVARCHAR2(255) ,
  "TASK_DEF_KEY" NVARCHAR2(64) ,
  "TEXT" NCLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_INST_ID" IS '实例id';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."PROC_NAME" IS '流程名称';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TASK_NAME" IS '任务名称';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."SEND_USER" IS '发送人';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."RECEIVE_USER" IS '接收人';
COMMENT ON COLUMN "SYS_ACT_URGE_TASK"."TEXT" IS '待办配置';

-- ----------------------------
-- Table structure for SYS_ACT_PROCESS_FILE
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_PROCESS_FILE');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_PROCESS_FILE';
END IF;
END;
/
CREATE TABLE "SYS_ACT_PROCESS_FILE" (
  "FILE_ID" NVARCHAR2(64) NOT NULL ,
  "PROCESS_KEY" NVARCHAR2(64) ,
  "PROCESS_ID" NVARCHAR2(64) ,
  "VERSION" NUMBER(11) ,
  "TYPE" NVARCHAR2(8) ,
  "CONTENT" BLOB ,
  "MODEL_ID" NVARCHAR2(64) ,
  "TENANT_ID" NVARCHAR2(64) ,
  "CREATE_TIME" DATE
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."FILE_ID" IS '文件id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_KEY" IS '流程标识';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."PROCESS_ID" IS '流程id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."VERSION" IS '版本号';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TYPE" IS '文件类型';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CONTENT" IS '文件内容';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."MODEL_ID" IS '模块id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "SYS_ACT_PROCESS_FILE"."CREATE_TIME" IS '创建时间';

-- ----------------------------
-- Table structure for SYS_ACT_TIMEOUT_ACTIVITY
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_TIMEOUT_ACTIVITY');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_TIMEOUT_ACTIVITY';
END IF;
END;
/
CREATE TABLE "SYS_ACT_TIMEOUT_ACTIVITY" (
  "TASK_ID" NVARCHAR2(64) NOT NULL ,
  "ASSIGNEE" NVARCHAR2(255) ,
  "DUE_TIME" TIMESTAMP(6) ,
  "CREATE_TIME" TIMESTAMP(6) ,
  "TIME_OUT_TYPE" NVARCHAR2(255) ,
  "TENANT_ID" NVARCHAR2(255) ,
  "MAP" NVARCHAR2(2000)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TASK_ID" IS '任务id';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."ASSIGNEE" IS '参与者';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."CREATE_TIME" IS '开始时间';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."DUE_TIME" IS '到期时间';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TIME_OUT_TYPE" IS '超时处理类型';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "SYS_ACT_TIMEOUT_ACTIVITY"."MAP" IS '接口类型额外参数';




-- ----------------------------
-- Primary Key structure for table ACT_EVT_LOG
-- ----------------------------
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616669" PRIMARY KEY ("LOG_NR_");

-- ----------------------------
-- Checks structure for table ACT_EVT_LOG
-- ----------------------------
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616613" CHECK ("LOG_NR_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT "SYS_C00616614" CHECK ("TIME_STAMP_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_GE_BYTEARRAY
-- ----------------------------
ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "SYS_C00616670" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_GE_BYTEARRAY
-- ----------------------------
ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "SYS_C00616615" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_GE_BYTEARRAY
-- ----------------------------
CREATE INDEX "ACT_FK_BYTEARR_DEPL"
  ON "ACT_GE_BYTEARRAY" ("DEPLOYMENT_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_GE_PROPERTY
-- ----------------------------
ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT "SYS_C00616671" PRIMARY KEY ("NAME_");

-- ----------------------------
-- Checks structure for table ACT_GE_PROPERTY
-- ----------------------------
ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT "SYS_C00616616" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_ACTINST
-- ----------------------------
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616672" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_ACTINST
-- ----------------------------
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616617" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616618" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616619" CHECK ("PROC_INST_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616620" CHECK ("EXECUTION_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616621" CHECK ("ACT_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT "SYS_C00616622" CHECK ("ACT_TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_ACTINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_ACT_INST_END"
  ON "ACT_HI_ACTINST" ("END_TIME_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_EXEC"
  ON "ACT_HI_ACTINST" ("EXECUTION_ID_" ASC, "ACT_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_PROCINST"
  ON "ACT_HI_ACTINST" ("ACT_ID_" ASC, "PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_ACT_INST_START"
  ON "ACT_HI_ACTINST" ("START_TIME_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_ATTACHMENT
-- ----------------------------
ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT "SYS_C00616673" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_ATTACHMENT
-- ----------------------------
ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT "SYS_C00616623" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_COMMENT
-- ----------------------------
ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT "SYS_C00616674" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_COMMENT
-- ----------------------------
ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT "SYS_C00616624" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_HI_DETAIL
-- ----------------------------
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616675" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_DETAIL
-- ----------------------------
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616625" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616626" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT "SYS_C00616627" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_DETAIL
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_DETAIL_ACT_INST"
  ON "ACT_HI_DETAIL" ("ACT_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_NAME"
  ON "ACT_HI_DETAIL" ("NAME_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_PROC_INST"
  ON "ACT_HI_DETAIL" ("PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_TASK_ID"
  ON "ACT_HI_DETAIL" ("TASK_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_DETAIL_TIME"
  ON "ACT_HI_DETAIL" ("TIME_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616676" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616628" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_IDENTITYLINK
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_PROCINST"
  ON "ACT_HI_IDENTITYLINK" ("PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_TASK"
  ON "ACT_HI_IDENTITYLINK" ("TASK_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_IDENT_LNK_USER"
  ON "ACT_HI_IDENTITYLINK" ("USER_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_PROCINST
-- ----------------------------
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616677" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_PROCINST
-- ----------------------------
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616629" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616630" CHECK ("PROC_INST_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "SYS_C00616631" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_PROCINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_PRO_INST_END"
  ON "ACT_HI_PROCINST" ("END_TIME_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PRO_I_BUSKEY"
  ON "ACT_HI_PROCINST" ("BUSINESS_KEY_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE UNIQUE INDEX "PROC_INST_ID_"
  ON "ACT_HI_PROCINST" ("PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_TASKINST
-- ----------------------------
ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT "SYS_C00616678" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_TASKINST
-- ----------------------------
ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT "SYS_C00616632" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_TASKINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_TASK_INST_PROCINST"
  ON "ACT_HI_TASKINST" ("PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_HI_VARINST
-- ----------------------------
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616679" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_HI_VARINST
-- ----------------------------
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616633" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT "SYS_C00616634" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_HI_VARINST
-- ----------------------------
CREATE INDEX "ACT_IDX_HI_PROCVAR_NAME_TYPE"
  ON "ACT_HI_VARINST" ("NAME_" ASC, "VAR_TYPE_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PROCVAR_PROC_INST"
  ON "ACT_HI_VARINST" ("PROC_INST_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX "ACT_IDX_HI_PROCVAR_TASK_ID"
  ON "ACT_HI_VARINST" ("TASK_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_ID_GROUP
-- ----------------------------
ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT "SYS_C00616680" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_GROUP
-- ----------------------------
ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT "SYS_C00616635" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_ID_INFO
-- ----------------------------
ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT "SYS_C00616681" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_INFO
-- ----------------------------
ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT "SYS_C00616636" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616682" PRIMARY KEY ("USER_ID_", "GROUP_ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616637" CHECK ("USER_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "SYS_C00616638" CHECK ("GROUP_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_ID_MEMBERSHIP
-- ----------------------------
CREATE INDEX "ACT_FK_MEMB_GROUP"
  ON "ACT_ID_MEMBERSHIP" ("GROUP_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table ACT_ID_USER
-- ----------------------------
ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT "SYS_C00616683" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_ID_USER
-- ----------------------------
ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT "SYS_C00616639" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table ACT_PROCDEF_INFO
-- ----------------------------
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616684" PRIMARY KEY ("ID_");

-- ----------------------------
-- Checks structure for table ACT_PROCDEF_INFO
-- ----------------------------
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616640" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "SYS_C00616641" CHECK ("PROC_DEF_ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table ACT_PROCDEF_INFO
-- ----------------------------
CREATE UNIQUE INDEX "ACT_UNIQ_INFO_PROCDEF"
  ON "ACT_PROCDEF_INFO" ("PROC_DEF_ID_" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Checks structure for table ACT_RE_DEPLOYMENT
-- ----------------------------
ALTER TABLE "ACT_RE_DEPLOYMENT" ADD CONSTRAINT "SYS_C00616642" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RE_MODEL
-- ----------------------------
ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT "SYS_C00616643" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RE_PROCDEF
-- ----------------------------
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616644" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616645" CHECK ("KEY_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "SYS_C00616646" CHECK ("VERSION_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_EVENT_SUBSCR
-- ----------------------------
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616647" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616648" CHECK ("EVENT_TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "SYS_C00616649" CHECK ("CREATED_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_EXECUTION
-- ----------------------------
ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "SYS_C00616650" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_IDENTITYLINK
-- ----------------------------
ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT "SYS_C00616651" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_JOB
-- ----------------------------
ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "SYS_C00616652" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "SYS_C00616653" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_TASK
-- ----------------------------
ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT "SYS_C00616654" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table ACT_RU_VARIABLE
-- ----------------------------
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616655" CHECK ("ID_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616656" CHECK ("TYPE_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "SYS_C00616657" CHECK ("NAME_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_CC_TASK
-- ----------------------------
ALTER TABLE "SYS_ACT_CC_TASK" ADD CONSTRAINT "SYS_C00616662" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_CONFIG
-- ----------------------------
ALTER TABLE "SYS_ACT_CONFIG" ADD CONSTRAINT "SYS_C00616663" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_ENTRUST
-- ----------------------------
ALTER TABLE "SYS_ACT_ENTRUST" ADD CONSTRAINT "SYS_C00616664" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_INTERFACE_LOG
-- ----------------------------
ALTER TABLE "SYS_ACT_INTERFACE_LOG" ADD CONSTRAINT "SYS_C00616665" CHECK ("LOG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_MANAGE_LOG
-- ----------------------------
ALTER TABLE "SYS_ACT_MANAGE_LOG" ADD CONSTRAINT "SYS_C00616666" CHECK ("LOG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_ACT_URGE_TASK
-- ----------------------------
ALTER TABLE "SYS_ACT_URGE_TASK" ADD CONSTRAINT "SYS_C00616668" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_FUNCTION');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_FUNCTION';
END IF;
END;
/
CREATE TABLE "SYS_ACT_FUNCTION" (
  "FUNCTION_ID" NVARCHAR2(36) NOT NULL,
  "FUNCTION_NAME" NVARCHAR2(255),
  "FUNCTION_BEAN" NVARCHAR2(255),
  "CREATE_TIME" DATE,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_NAME" IS '函数名称';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."FUNCTION_BEAN" IS '函数beanId';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ACT_FUNCTION"."UPDATE_TIME" IS '修改时间';

-- ----------------------------
-- Table structure for SYS_ACT_FUNCTION_PARM
-- ----------------------------
DECLARE
num NUMBER;
BEGIN
SELECT COUNT(1)
INTO num
FROM USER_TABLES
WHERE TABLE_NAME = UPPER('SYS_ACT_FUNCTION_PARM');
IF num > 0 THEN
    EXECUTE IMMEDIATE 'DROP TABLE SYS_ACT_FUNCTION_PARM';
END IF;
END;
/
CREATE TABLE "SYS_ACT_FUNCTION_PARM" (
  "PARM_ID" NVARCHAR2(36) NOT NULL,
  "FUNCTION_ID" NVARCHAR2(36),
  "PARM_NAME" NVARCHAR2(255),
  "PARM_KEY" NVARCHAR2(255),
  "CREATE_TIME" DATE,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_ID" IS '主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."FUNCTION_ID" IS '函数主键';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_NAME" IS '参数名称';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."PARM_KEY" IS '参数标识';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYS_ACT_FUNCTION_PARM"."UPDATE_TIME" IS '修改时间';

-- ----------------------------
-- Primary Key structure for table SYS_ACT_FUNCTION
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION" ADD CONSTRAINT "SYS_C0083941" PRIMARY KEY ("FUNCTION_ID");

-- ----------------------------
-- Checks structure for table SYS_ACT_FUNCTION
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION" ADD CONSTRAINT "SYS_C0083939" CHECK ("FUNCTION_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table SYS_ACT_FUNCTION_PARM
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION_PARM" ADD CONSTRAINT "SYS_C0083942" PRIMARY KEY ("PARM_ID");

-- ----------------------------
-- Checks structure for table SYS_ACT_FUNCTION_PARM
-- ----------------------------
ALTER TABLE "SYS_ACT_FUNCTION_PARM" ADD CONSTRAINT "SYS_C0083940" CHECK ("PARM_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

COMMENT ON TABLE ACT_EVT_LOG IS '事件日志表';
COMMENT ON TABLE ACT_GE_BYTEARRAY IS '二进制数据表';
COMMENT ON TABLE ACT_GE_PROPERTY IS '属性数据表';
COMMENT ON TABLE ACT_HI_ACTINST IS '历史节点表';
COMMENT ON TABLE ACT_HI_ATTACHMENT IS '历史附件表';
COMMENT ON TABLE ACT_HI_COMMENT IS '历史意见表';
COMMENT ON TABLE ACT_HI_DETAIL IS '历史详情表';
COMMENT ON TABLE ACT_HI_IDENTITYLINK IS '历史流程人员表';
COMMENT ON TABLE ACT_HI_PROCINST IS '历史流程实例表';
COMMENT ON TABLE ACT_HI_TASKINST IS '历史任务实例表';
COMMENT ON TABLE ACT_HI_VARINST IS '历史变量表';
COMMENT ON TABLE ACT_ID_GROUP IS '用户组信息表';
COMMENT ON TABLE ACT_ID_INFO IS '用户扩展信息表';
COMMENT ON TABLE ACT_ID_MEMBERSHIP IS '用户与分组对应信息表';
COMMENT ON TABLE ACT_ID_USER IS '用户信息表';
COMMENT ON TABLE ACT_PROCDEF_INFO IS '流程定义信息表';
COMMENT ON TABLE ACT_RE_DEPLOYMENT IS '部署信息表';
COMMENT ON TABLE ACT_RE_MODEL IS '流程设计模型部署表';
COMMENT ON TABLE ACT_RE_PROCDEF IS '流程定义数据表';
COMMENT ON TABLE ACT_RU_EVENT_SUBSCR IS '运行实例表';
COMMENT ON TABLE ACT_RU_EXECUTION IS '运行时流程执行实例表';
COMMENT ON TABLE ACT_RU_IDENTITYLINK IS '运行时流程人员表';
COMMENT ON TABLE ACT_RU_JOB IS '运行时定时任务数据表';
COMMENT ON TABLE ACT_RU_TASK IS '运行时任务节点表';
COMMENT ON TABLE ACT_RU_VARIABLE IS '运行时流程变量数据表';
COMMENT ON TABLE SYS_ACT_CC_TASK IS '抄送表';
COMMENT ON TABLE SYS_ACT_CONFIG IS '配置表';
COMMENT ON TABLE SYS_ACT_ENTRUST IS '委托表';
COMMENT ON TABLE SYS_ACT_ENTRUST_COMPLETE_HI IS '委托历史表';
COMMENT ON TABLE SYS_ACT_EXTEND_PROPERTIES IS '流程拓展信息表';
COMMENT ON TABLE SYS_ACT_FUNCTION IS '函数表';
COMMENT ON TABLE SYS_ACT_FUNCTION_PARM IS '函数参数表';
COMMENT ON TABLE SYS_ACT_HI_LINE IS '历史线表';
COMMENT ON TABLE SYS_ACT_INTERFACE_LOG IS '接口日志表';
COMMENT ON TABLE SYS_ACT_MANAGE_LOG IS '操作日志表';
COMMENT ON TABLE SYS_ACT_PROCESS_FILE IS '工作流文件表';
COMMENT ON TABLE SYS_ACT_TIMEOUT_ACTIVITY IS '超时信息表';
COMMENT ON TABLE SYS_ACT_URGE_TASK IS '催办表';