/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.mutidatasource.aop;

import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicDataSourceAspect {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourceAspect.class);

    @Before(value="@annotation(ds)")
    public void changeDataSource(TargetDataSource ds) {
        String type = ds.value();
        if ("master".equals(type)) {
            DataSourceContextHolder.setDataSource((String)"master");
            return;
        }
        SysUser sysUser = ShiroUser.getUser();
        if (ToolUtil.isEmpty((Object)sysUser)) {
            return;
        }
        if (sysUser.getConnectionIp() == null || "".equals(sysUser.getConnectionIp())) {
            DataSourceContextHolder.setDataSource((String)"master");
            return;
        }
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change(sysUser);
    }

    @After(value="@annotation(ds)")
    public void restoreDataSource(JoinPoint point, TargetDataSource ds) {
        logger.debug("Revert DataSource : " + ds.value() + " > " + point.getSignature());
        DataSourceContextHolder.remove();
    }
}

