/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.login;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.common.response.IResultCode;
import com.jxdinfo.hussar.bpm.common.response.ResultCode;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogManager;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogTaskFactory;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.SM4Util;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController {
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ISysUserService sysUserService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String index() {
        return "redirect:static/bpm/index.html";
    }

    @RequestMapping(value={"/getLoginInf"}, method={RequestMethod.POST})
    @ManageBusinessLog(key="/getLoginInf", type="\u767b\u5f55", value="\u7528\u6237\u767b\u5f55\u4fe1\u606f")
    @ResponseBody
    public ApiResponse<?> getLoginInf() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", this.lcdpBpmProperties.getVersion());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ManageBusinessLog(key="/login", type="\u767b\u5f55", value="\u7528\u6237\u767b\u5f55")
    @ResponseBody
    public ApiResponse<?> login(@RequestBody Map<String, String> body) {
        String userAccount = body.get("userAccount");
        String cipher = body.get("cipher");
        cipher = CryptoUtil.decode(cipher);
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(userAccount, cipher.toCharArray());
        currentUser.login((AuthenticationToken)token);
        Session session = currentUser.getSession();
        SysUser sysUser = ShiroUser.getUser();
        String userName = sysUser != null ? sysUser.getUserName() : "";
        session.setAttribute((Object)"userName", (Object)userName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", CryptoUtil.encode(String.valueOf(session.getId())));
        map.put("userName", userName);
        map.put("userId", sysUser != null ? sysUser.getUserAccount() : "");
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/withoutPwdLogin"}, method={RequestMethod.POST})
    @ManageBusinessLog(key="/withoutPwdLogin", type="\u767b\u5f55", value="\u514d\u5bc6\u767b\u5f55")
    @ResponseBody
    public ApiResponse<?> withoutPwdLogin(@RequestBody Map<String, String> body) {
        Map tenantInfos;
        try {
            String tenant = SM4Util.decrypt((String)body.get("tenantInfo"), (String)"admin#$%^kopoiuy");
            tenantInfos = (Map)JSONObject.parseObject((String)tenant, HashMap.class);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"");
        }
        if (tenantInfos == null) {
            return ApiResponse.fail((String)"");
        }
        String tenantId = (String)tenantInfos.get("tenantId");
        if ("master".equals(tenantId)) {
            return ApiResponse.fail((String)"");
        }
        String tenantCipher = (String)tenantInfos.get("tenantCipher");
        if (tenantInfos.get("nowDate") == null || tenantId == null || tenantCipher == null) {
            return ApiResponse.fail((String)"");
        }
        Long currTime = new Date().getTime();
        Long nowTime = (Long)tenantInfos.get("nowDate");
        if (currTime - nowTime < 0L || currTime - nowTime > 300000L) {
            return ApiResponse.fail((String)"");
        }
        String host = body.get("host");
        boolean flag = this.sysUserService.validationTenantIsExist(tenantId, tenantCipher);
        if (flag) {
            SysUser casUser = (SysUser)this.sysUserService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"TENANT_CIPHER", (Object)tenantCipher));
            String username = casUser.getUserAccount();
            Subject currentUser = SecurityUtils.getSubject();
            String password = username;
            password = MD5Util.encrypt((String)new String(password.getBytes()));
            UsernamePasswordToken token = new UsernamePasswordToken(username, password.toCharArray(), host);
            token.setRememberMe(true);
            currentUser.login((AuthenticationToken)token);
            SysUser sysUser = ShiroUser.getUser();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("accessToken", CryptoUtil.encode(String.valueOf(currentUser.getSession().getId())));
            map.put("userName", sysUser != null ? sysUser.getUserName() : "");
            map.put("userId", sysUser != null ? sysUser.getUserAccount() : "");
            return ApiResponse.data(map);
        }
        return ApiResponse.fail((String)"");
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    @ResponseBody
    public ApiResponse<?> logOut() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        ManageLogManager.me().executeLog(ManageLogTaskFactory.exitLog(ShiroUser.getUser(), "\u767b\u51fa", info));
        ShiroUser.getSubject().logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public ApiResponse<?> check() {
        SysUser sysUser = ShiroUser.getUser();
        if (ToolUtil.isNotEmpty((Object)sysUser)) {
            return ApiResponse.data((Object)"admin".equals(sysUser.getUserAccount()));
        }
        return ApiResponse.data((Object)false);
    }
}

