/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.config;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisClusterManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSentinelManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

@Configuration
@ConditionalOnExpression(value="${bpm.stand-alone:true}==false||${bpm.use-redis:false}==true")
public class RedisConfig
extends CachingConfigurerSupport {
    @Autowired
    private RedisProperties redisProperties;

    @Bean(name={"redisTemplate"})
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer valueSerializer = new GenericJackson2JsonRedisSerializer();
        template.setConnectionFactory(factory);
        template.setKeySerializer((RedisSerializer)redisSerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        return template;
    }

    @Bean
    public RedisCacheConfiguration redisCacheConfiguration() {
        return RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer()));
    }

    @Bean
    public IRedisManager redisManager(JedisCluster jedisCluster, Pool<?> jredisPool) {
        int timeout = (int)this.redisProperties.getTimeout().getSeconds();
        int database = this.redisProperties.getDatabase();
        String password = this.redisProperties.getPassword();
        String host = this.redisProperties.getHost();
        int port = this.redisProperties.getPort();
        RedisProperties.Pool redisPool = this.redisProperties.getJedis().getPool();
        Duration maxWait = Duration.ofSeconds(-1L);
        int minIdle = 0;
        int maxIdle = 8;
        int maxActive = 8;
        if (redisPool != null) {
            maxActive = redisPool.getMaxActive();
            maxIdle = redisPool.getMaxIdle();
            minIdle = redisPool.getMinIdle();
            maxWait = redisPool.getMaxWait();
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMinIdle(minIdle);
        jedisPoolConfig.setMaxIdle(maxIdle);
        jedisPoolConfig.setMaxWaitMillis(maxWait.toMillis());
        jedisPoolConfig.setMaxTotal(maxActive);
        RedisProperties.Cluster cluster = this.redisProperties.getCluster();
        if (cluster != null) {
            StringBuffer hosts = new StringBuffer();
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            List clusterNodes = cluster.getNodes();
            for (String ipPort : clusterNodes) {
                hosts.append(ipPort).append(",");
                String[] ipPortPair = ipPort.split(":");
                nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
            }
            RedisClusterManager clusterManager = new RedisClusterManager();
            clusterManager.setJedisCluster(jedisCluster);
            host = hosts.toString();
            if (host.endsWith(",")) {
                host = host.substring(0, host.length() - 1);
            }
            clusterManager.setHost(host);
            clusterManager.setTimeout(timeout);
            clusterManager.setDatabase(database);
            clusterManager.setPassword(password);
            clusterManager.setSoTimeout(timeout);
            clusterManager.setJedisPoolConfig(jedisPoolConfig);
            return clusterManager;
        }
        RedisProperties.Sentinel redisSentinel = this.redisProperties.getSentinel();
        if (redisSentinel != null) {
            String masterName = redisSentinel.getMaster();
            List sentinelNodes = redisSentinel.getNodes();
            StringBuffer hosts = new StringBuffer();
            for (String ipPort : sentinelNodes) {
                hosts.append(ipPort).append(",");
            }
            JedisSentinelPool sentinelPool = (JedisSentinelPool)jredisPool;
            RedisSentinelManager redisSentinelManager = new RedisSentinelManager();
            redisSentinelManager.setDatabase(database);
            redisSentinelManager.setJedisPool(sentinelPool);
            redisSentinelManager.setHost(hosts.toString());
            redisSentinelManager.setMasterName(masterName);
            redisSentinelManager.setTimeout(timeout);
            redisSentinelManager.setPassword(password);
            redisSentinelManager.setJedisPoolConfig(jedisPoolConfig);
            return redisSentinelManager;
        }
        RedisManager redisManager = new RedisManager();
        redisManager.setHost(host + ":" + port);
        redisManager.setTimeout(timeout);
        redisManager.setPassword(password);
        redisManager.setJedisPoolConfig(jedisPoolConfig);
        JedisPool jedisPool = (JedisPool)jredisPool;
        redisManager.setJedisPool(jedisPool);
        return redisManager;
    }

    @Bean
    public Pool<?> redisPool() {
        RedisProperties.Sentinel redisSentinel = this.redisProperties.getSentinel();
        if (redisSentinel != null) {
            String password = this.redisProperties.getPassword();
            String masterName = redisSentinel.getMaster();
            List sentinelNodes = redisSentinel.getNodes();
            HashSet<String> sentinels = new HashSet<String>();
            for (String ipPort : sentinelNodes) {
                sentinels.add(ipPort);
            }
            JedisSentinelPool sentinelPool = new JedisSentinelPool(masterName, sentinels, password);
            return sentinelPool;
        }
        Duration timeout = this.redisProperties.getTimeout();
        String password = this.redisProperties.getPassword();
        String host = this.redisProperties.getHost();
        int port = this.redisProperties.getPort();
        RedisProperties.Pool redisPool = this.redisProperties.getJedis().getPool();
        Duration maxWait = Duration.ofSeconds(-1L);
        int minIdle = 0;
        int maxIdle = 8;
        int maxActive = 8;
        if (redisPool != null) {
            maxActive = redisPool.getMaxActive();
            maxIdle = redisPool.getMaxIdle();
            minIdle = redisPool.getMinIdle();
            maxWait = redisPool.getMaxWait();
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMinIdle(minIdle);
        jedisPoolConfig.setMaxIdle(maxIdle);
        jedisPoolConfig.setMaxWaitMillis(maxWait.toMillis());
        jedisPoolConfig.setMaxTotal(maxActive);
        RedisProperties.Cluster cluster = this.redisProperties.getCluster();
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, (int)timeout.toMillis(), password);
        return jedisPool;
    }

    @Bean
    public JedisCluster jedisCluster() {
        RedisProperties.Cluster cluster = this.redisProperties.getCluster();
        if (cluster != null) {
            Duration timeout = this.redisProperties.getTimeout();
            String password = this.redisProperties.getPassword();
            RedisProperties.Pool redisPool = this.redisProperties.getJedis().getPool();
            Duration maxWait = Duration.ofSeconds(-1L);
            int minIdle = 0;
            int maxIdle = 8;
            int maxActive = 8;
            int maxAttempts = 3;
            if (redisPool != null) {
                maxActive = redisPool.getMaxActive();
                maxIdle = redisPool.getMaxIdle();
                minIdle = redisPool.getMinIdle();
                maxWait = redisPool.getMaxWait();
            }
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setMinIdle(minIdle);
            jedisPoolConfig.setMaxIdle(maxIdle);
            jedisPoolConfig.setMaxWaitMillis(maxWait.toMillis());
            jedisPoolConfig.setMaxTotal(maxActive);
            StringBuffer hosts = new StringBuffer();
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            List clusterNodes = cluster.getNodes();
            for (String ipPort : clusterNodes) {
                hosts.append(ipPort).append(",");
                String[] ipPortPair = ipPort.split(":");
                nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
            }
            return new JedisCluster(nodes, (int)timeout.toMillis(), (int)timeout.toMillis(), maxAttempts, password, (GenericObjectPoolConfig)jedisPoolConfig);
        }
        HashSet nodes = new HashSet();
        return new JedisCluster(nodes);
    }
}

