/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmn2xml.service.Bpm2XMLService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.common.exception.BpmException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"godaxeModel"})
public class GodAxeModelController {
    private Bpm2XMLService bpm2XMLService;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private ModelService modelService;
    private SysActProcessFileService sysActProcessFileService;
    private ProcessDefinitionsMapper processDefinitionsMapper;
    private InstanceEngineService instanceEngineService;
    private TaskEngineService taskEngineService;

    @Autowired
    public GodAxeModelController(Bpm2XMLService bpm2XMLService, ModelService modelService, InstanceEngineService instanceEngineService, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, ProcessDefinitionsMapper processDefinitionsMapper, ISysActExtendPropertiesService iSysActExtendPropertiesService, TaskEngineService taskEngineService) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.instanceEngineService = instanceEngineService;
        this.processDefinitionsMapper = processDefinitionsMapper;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.taskEngineService = taskEngineService;
    }

    @RequestMapping(value={"/saveAndPublish"})
    @ManageBussinessLog(key="/godaxeModel/saveAndPublish", value="\u4fdd\u5b58\u5e76\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u4fdd\u5b58\u5e76\u53d1\u5e03")
    public ApiResponse<?> saveAndPublish(WorkFlow workFlow, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        try {
            List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
            if (baseList.size() == 2) {
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            } else {
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
            }
            String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
            if (ToolUtil.isEmpty((Object)modelId)) {
                return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            if (ToolUtil.isEmpty((Object)oldWorkFlow) || ToolUtil.isEmpty((Object)oldWorkFlow.getModelId())) {
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            String processId = this.modelService.deployModel(modelId, tenantId);
            return ApiResponse.success((String)processId);
        }
        catch (BpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    @RequestMapping(value={"/publish"})
    @ManageBussinessLog(key="/godaxeModel/publish", value="\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u53d1\u5e03")
    public ApiResponse<?> genWorkFlowXml(String processIdentityKey, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        String modelId = this.modelService.getIdByIdentity(processIdentityKey);
        if (ToolUtil.isEmpty((Object)modelId)) {
            return ApiResponse.fail((String)"\u53d1\u5e03\u5931\u8d25\uff01");
        }
        try {
            String processId = this.modelService.deployModel(modelId, tenantId);
            if (ToolUtil.isEmpty((Object)processId)) {
                return ApiResponse.fail((String)"\u53d1\u5e03\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            return ApiResponse.fail((String)("\u53d1\u5e03\u5931\u8d25\uff01" + e));
        }
        return ApiResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/save"})
    @ManageBussinessLog(key="/godaxeModel/save", value="\u4fdd\u5b58\u6d41\u7a0b\u6a21\u578b", type="\u65b0\u589e")
    public ApiResponse<?> saveDataInfo(WorkFlow workFlow, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        try {
            List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                if (ToolUtil.isNotEmpty((Object)oldWorkFlow.getModelId())) {
                    workFlow.setModelId(oldWorkFlow.getModelId());
                }
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (ToolUtil.isEmpty((Object)modelId)) {
                    return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
                }
                if (ToolUtil.isEmpty((Object)oldWorkFlow.getModelId())) {
                    workFlow.setModelId(modelId);
                    this.sysActProcessFileService.updateFile(workFlow, tenantId);
                }
            } else {
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
            }
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (BpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    @ManageBussinessLog(key="/godaxeModel/update", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="\u67e5\u8be2")
    public ApiResponse<?> updateWorkFlow(String processIdentityKey, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processIdentityKey, tenantId, Integer.valueOf(0));
        return ApiResponse.data((Object)workFlow);
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBussinessLog(key="/godaxeModel/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    public ApiResponse<?> deleteModel(String identity, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identity, tenantId, Integer.valueOf(0));
        String modelId = workFlow.getModelId();
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            this.repositoryService.deleteModel(modelId);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getAllModel"})
    @ManageBussinessLog(key="/godaxeModel/getAllModel", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="\u67e5\u8be2")
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.data((Object)this.modelService.getAllModel());
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBussinessLog(key="/godaxeModel/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, String variables, HttpServletRequest request) {
        Map body = (Map)JSON.parseObject((String)variables, HashMap.class);
        HashMap map = new HashMap();
        for (Map.Entry vo : body.entrySet()) {
            map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
        }
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, map, request.getParameter("tenantId"));
    }

    @RequestMapping(value={"/doneList"})
    public ApiResponse<?> doneList(String businessKey, HttpServletRequest request) {
        return this.modelService.doneList(businessKey, request.getParameter("tenantId"));
    }

    @RequestMapping(value={"/updateMeta"})
    @ManageBussinessLog(key="/godaxeModel/updateMeta", value="\u4fee\u6539meta\u6587\u4ef6", type="\u4fee\u6539")
    public ApiResponse<?> updateMeta(String identity, String name, String category, String tenantId) {
        try {
            if (this.modelService.updateCategory(identity, category) > 0) {
                this.sysActProcessFileService.updateMetaByIdentity(identity, name, category, tenantId);
            }
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/updateProcess"})
    @ManageBussinessLog(key="/godaxeModel/updateProcess", value="\u6d41\u7a0b\u5fae\u8c03", type="\u4fee\u6539")
    public ApiResponse<?> updateProcess(WorkFlow workFlow, HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                Map<String, Object> nodeMessage = this.getRejectFromList(workFlow, oldWorkFlow);
                Map delNodeName = (Map)nodeMessage.get("delNodeName");
                Map result = this.taskEngineService.updateRejectForm(nodeMessage);
                Integer numAll = (Integer)result.get("");
                if (numAll == null) {
                    this.sysActProcessFileService.updateFile(workFlow, tenantId);
                    String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                    this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId);
                    this.saveModelExtendProperties(modelId, workFlow.getName());
                    return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
                }
                result.remove("");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u672c\u6b21\u5fae\u8c03\u5f71\u54cd\u4e86").append(numAll).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c.\u5176\u4e2d\uff1a");
                for (String key : result.keySet()) {
                    stringBuilder.append("\u5220\u9664\u8282\u70b9\u540d\u4e3a").append((String)delNodeName.get(key)).append("\u7684\u8282\u70b9\u5f71\u54cd\u4e86");
                    stringBuilder.append(result.get(key)).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                String message = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1) + ".";
                return ApiResponse.fail((String)message);
            }
            return ApiResponse.fail((String)"\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private Map<String, Object> getRejectFromList(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
            nodeIds.add(flowObject.getId());
        }
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        List oldElements = oldFlowModel.getSlots().getElement();
        ArrayList<String> delNodeIds = new ArrayList<String>();
        HashMap<String, String> delNodeName = new HashMap<String, String>();
        for (FlowObject flowObject : oldElements) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName()) || nodeIds.contains(flowObject.getId())) continue;
            delNodeIds.add(flowObject.getId());
            delNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
        }
        map.put("delNodeName", delNodeName);
        map.put("delNodeIds", delNodeIds);
        map.put("nodeIds", nodeIds);
        map.put("procDefId", this.bpm2XMLService.getActDefIdByModelId(workFlow.getModelId()));
        return map;
    }

    private void saveModelExtendProperties(String modelId, String name) {
        ModelBuild modelBuild = this.modelService.queryModel(modelId);
        if (modelBuild != null) {
            String procDefId = modelBuild.getProcessDefinitionId();
            this.processDefinitionsMapper.updateProcessName(procDefId, name);
            BpmnModel model = this.repositoryService.getBpmnModel(procDefId);
            ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
            if (model != null) {
                Collection flowElements = model.getMainProcess().getFlowElements();
                for (FlowElement node : flowElements) {
                    if (!(node instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    JSONObject object = new JSONObject();
                    if (!ToolUtil.isNotEmpty((Object)formDetailKey)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                    if (jsonObject != null) {
                        for (String key : jsonObject.keySet()) {
                            object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setId(procDefId + userTask.getId());
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)object));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
            if (sysActExtendProperties.size() > 0) {
                this.iSysActExtendPropertiesService.saveOrUpdateBatch(sysActExtendProperties);
            }
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }
}

