/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.definition.controller;

import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processDefinition"})
public class ProcessDefinitionsController
extends BaseController {
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;

    @RequestMapping(value={"/queryProcessDefinitionsList"})
    @ManageBussinessLog(key="/processDefinition/queryProcessDefinitionsList", value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> queryProcessDefinitionsList(@RequestParam(value="definitionKey", required=false) String definitionKey, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        Map map = this.processDefinitionsService.queryProcessDefinitionsList(definitionKey, page, limit);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/setMain"})
    @ManageBussinessLog(key="/processDefinition/setMain", value="\u8bbe\u7f6e\u4e3b\u7248\u672c", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<?> setMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.setMain(processDefKey, id);
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, id, ShiroUser.getTenantId())) {
                return ApiResponse.success((String)"\u8bbe\u7f6e\u6210\u529f\uff01");
            }
            return ApiResponse.fail((String)"\u6d41\u7a0b\u6a21\u578b\u6587\u4ef6\u672a\u627e\u5230\uff01");
        }
        return ApiResponse.fail((String)"\u8bbe\u7f6e\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/cancelMain"})
    @ManageBussinessLog(key="/processDefinition/cancelMain", value="\u53d6\u6d88\u4e3b\u7248\u672c", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<?> cancelMain(String processDefKey, String id) {
        int num = this.processDefinitionsService.cancelMain(processDefKey, id);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processDefKey, processDefinition.getId(), ShiroUser.getTenantId())) {
                return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            return ApiResponse.fail((String)"\u6d41\u7a0b\u6a21\u578b\u6587\u4ef6\u672a\u627e\u5230\uff01");
        }
        return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/downloadXML"})
    @ManageBussinessLog(key="/processDefinition/downloadXML", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    @TargetDataSource
    public void downloadXml(HttpServletRequest request, HttpServletResponse response) {
        this.processDefinitionsService.downloadXml(request, response);
    }

    @RequestMapping(value={"/downloadFiles"})
    @ManageBussinessLog(key="/processDefinition/downloadFiles", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    @TargetDataSource
    public void downloadXmlTest(HttpServletRequest request, HttpServletResponse response) {
        this.processDefinitionsService.downloadFiles(ShiroUser.getTenantId(), request, response);
    }
}

