/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.jxdinfo.hussar.common.utils.AbstractCryptoProvider;
import com.jxdinfo.hussar.common.utils.RSAEncrypUtil;
import java.util.Map;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Repository;

@Repository
@DependsOn(value={"springContextHolder"})
public class RSACryptoProvider
extends AbstractCryptoProvider {
    @Override
    public String encode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return RSAEncrypUtil.encrypt(key, data);
    }

    @Override
    public String decode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return RSAEncrypUtil.decrypt(key, data);
    }
}

