/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.jxdinfo.hussar.bpm.common.constant.DatabaseType;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitTableUtil.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    private static final Map<String, String> DATABASE_DRIVER = new HashMap<String, String>();

    public static void createTable(SysUser sysUser, String url) throws SQLException, ClassNotFoundException {
        if (sysUser == null) {
            return;
        }
        Connection conn = InitTableUtil.getMySqlConnection(sysUser);
        ScriptRunner runner = new ScriptRunner(conn);
        Resources.setCharset((Charset)StandardCharsets.UTF_8);
        runner.setLogWriter(null);
        InputStream in = InitTableUtil.class.getClassLoader().getResourceAsStream(url.split(":")[1] + ".sql");
        if (in == null) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
        runner.runScript((Reader)isr);
        runner.closeConnection();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static Connection getMySqlConnection(SysUser sysUser) throws SQLException, ClassNotFoundException {
        Class.forName(DATABASE_DRIVER.get(sysUser.getDbType()));
        String ip = SM4Util.decrypt((String)sysUser.getConnectionIp(), (String)"admin#$%^kopoiuy");
        String port = SM4Util.decrypt((String)sysUser.getConnectionPort(), (String)"admin#$%^kopoiuy");
        String name = SM4Util.decrypt((String)sysUser.getConnectionName(), (String)"admin#$%^kopoiuy");
        String pass = SM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"admin#$%^kopoiuy");
        String dbName = SM4Util.decrypt((String)sysUser.getDbName(), (String)"admin#$%^kopoiuy");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{ip, port, name, pass})) {
            return null;
        }
        if ("Mysql".equals(sysUser.getDbType())) {
            return DriverManager.getConnection(DatabaseType.MYSQL.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.MYSQL.getSuffix(), name, pass);
        }
        if ("Oracle".equals(sysUser.getDbType())) {
            return DriverManager.getConnection(DatabaseType.ORACLE.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.ORACLE.getSuffix(), name, pass);
        }
        if ("Dm".equals(sysUser.getDbType())) {
            return DriverManager.getConnection(DatabaseType.DM.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.DM.getSuffix(), name.toUpperCase(), pass.toUpperCase());
        }
        return null;
    }

    static {
        DATABASE_DRIVER.put("Mysql", "com.mysql.cj.jdbc.Driver");
        DATABASE_DRIVER.put("Oracle", "oracle.jdbc.OracleDriver");
        DATABASE_DRIVER.put("Dm", "dm.jdbc.driver.DmDriver");
    }
}

