/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taskManager"})
public class TaskManagerController {
    @Autowired
    TaskManagerService taskManagerService;
    @Autowired
    ITenantConfigService tenantConfigService;
    @Autowired
    TaskEngineService taskEngineService;
    @Autowired
    SysActProcessFileService sysActProcessFileService;

    @RequestMapping(value={"/getTaskManager"})
    @ManageBussinessLog(key="/taskManager/getTaskManager", value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> getTaskManager(@RequestParam(required=false) String processName, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) String isTimeOut, @RequestParam(required=false) String suspension, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String businessKey) {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        if (tenantConfig == null || !"1".equals(tenantConfig.getIsMqUse()) && (tenantConfig.getProjectAddress() == null || tenantConfig.getProjectAddress() == "")) {
            return ApiResponse.data(null);
        }
        SysUser sysUser = ShiroUser.getUser();
        String userId = "";
        if ("3".equals(sysUser.getTenantType())) {
            userId = sysUser.getUserId();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("processName", processName);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("isTimeOut", isTimeOut);
        map.put("suspension", suspension);
        map.put("tenantId", ShiroUser.getTenantId());
        map.put("businessKey", businessKey);
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        List list = this.taskManagerService.getTask(pages, map);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("count", pages.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/suspendTaskById"})
    @ManageBussinessLog(key="/taskManager/suspendTaskById", value="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", type="\u6302\u8d77")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> suspendTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.suspendTaskById(instId);
    }

    @RequestMapping(value={"/activateTaskById"})
    @ManageBussinessLog(key="/taskManager/activateTaskById", value="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", type="\u6fc0\u6d3b")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> activateTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.activateTaskById(instId);
    }

    @RequestMapping(value={"/entrustTaskByTaskId"})
    @ManageBussinessLog(key="/taskManager/entrustTaskByTaskId", value="\u4efb\u52a1\u8f6c\u529e", type="\u4efb\u52a1\u8f6c\u529e")
    @TargetDataSource
    public ApiResponse<Object> entrustTask(String taskId, String consignee) {
        BpmResponseResult bpmResponseResult = this.taskEngineService.entrustTask(taskId, consignee);
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)"\u8f6c\u529e\u6210\u529f!");
        }
        return ApiResponse.fail((String)"\u8f6c\u529e\u5931\u8d25!");
    }

    @RequestMapping(value={"/getJumpTasks"})
    @ManageBussinessLog(key="/taskManager/getJumpTasks", value="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Object> getJumpTasks(String taskId) {
        String flowModelMessage = this.taskManagerService.getFileByTaskId(taskId);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage, FlowModel.class);
        ArrayList tasks = new ArrayList();
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName())) continue;
            HashMap<String, String> task = new HashMap<String, String>();
            task.put("id", flowObject.getId());
            task.put("value", flowObject.getProps().getFlowName());
            tasks.add(task);
        }
        return ApiResponse.data(tasks);
    }

    @RequestMapping(value={"/freeJump"})
    @ManageBussinessLog(key="/taskManager/freeJump", value="\u81ea\u7531\u8df3\u8f6c", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<Object> freeJump(String taskId, String activityId, String assignees, String userId) {
        BpmResponseResult result;
        try {
            result = this.taskEngineService.freeJump(taskId, activityId, userId, assignees, false, null, null);
        }
        catch (PublicClientException e) {
            return ApiResponse.fail((String)e.getReason());
        }
        if ("1".equals(result.getCode())) {
            return ApiResponse.success((String)"\u81ea\u7531\u8df3\u8f6c\u6210\u529f");
        }
        return ApiResponse.fail((String)result.getMsg());
    }
}

