/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processdiagram;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import com.jxdinfo.hussar.wfd2process.service.Wfd2ProcessService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processDiagram"})
public class ProcessDiagramController {
    @Autowired
    private ProcessDiagramService processDiagramService;
    @Autowired
    private Wfd2ProcessService wfd2ProcessService;
    @Autowired
    private FlowEventsService flowEventsService;
    @Autowired
    private HistoryService historyService;

    @RequestMapping(value={"/list"})
    @TargetDataSource
    @ManageBussinessLog(key="/processDiagram/list", value="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868", type="\u67e5\u8be2")
    public Map<String, Object> list(String processInstanceId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (ToolUtil.isNotEmpty((Object)processInstanceId)) {
            JSONArray json = this.processDiagramService.list(processInstanceId, ShiroUser.getTenantId());
            result.put("count", json.size());
            result.put("data", json);
        } else {
            result.put("count", 0);
            result.put("data", null);
        }
        return result;
    }

    @RequestMapping(value={"/getProcessInfo"})
    @TargetDataSource
    @ManageBussinessLog(key="/processDiagram/getProcessInfo", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONObject getProcessInfo(String processInstanceId) {
        return this.processDiagramService.getProcessInfo(processInstanceId);
    }

    @RequestMapping(value={"/getProcessCompleteInfo"})
    @TargetDataSource
    @ManageBussinessLog(key="/processDiagram/getProcessCompleteInfo", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONArray getProcessCompleteInfo(String processInstanceId) {
        return this.processDiagramService.getProcessCompleteInfo(processInstanceId, ShiroUser.getTenantId());
    }

    @RequestMapping(value={"/subProcessList"})
    @TargetDataSource
    @ManageBussinessLog(key="/processDiagram/subProcessList", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5bf9\u5e94\u7684\u5916\u90e8\u6d41\u7a0b\u6570\u636e", type="\u67e5\u8be2")
    public Map<String, Object> subProcessList(String supProcessInstId, String businessKey, String taskDefinitionKey, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isEmpty((Object)supProcessInstId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
            if (instance != null) {
                supProcessInstId = instance.getId();
            } else {
                return map;
            }
        }
        map.put("supProcessInstId", supProcessInstId);
        map.put("taskDefinitionKey", taskDefinitionKey);
        map.put("page", page);
        map.put("limit", limit);
        return this.processDiagramService.subProcessList(map);
    }

    @RequestMapping(value={"/getProcessInfoByFile"})
    @TargetDataSource
    @ManageBussinessLog(key="/processDiagram/getProcessInfoByFile", value="\u901a\u8fc7\u6587\u4ef6\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processDefKey) throws IOException {
        return this.wfd2ProcessService.getProcessInfoByFile(processIdentityKey, processDefKey, ShiroUser.getTenantId());
    }
}

