/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmn2xml.service.Bpm2XMLService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.common.exception.BpmException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/json2Xml"})
public class Json2XmlController {
    private Bpm2XMLService bpm2XMLService;
    private SysActProcessFileService sysActProcessFileService;
    private SysActProcessFileMapper sysActProcessFileMapper;
    private ModelService modelService;

    @Autowired
    public Json2XmlController(Bpm2XMLService bpm2XMLService, ModelService modelService, SysActProcessFileService sysActProcessFileService, SysActProcessFileMapper sysActProcessFileMapper) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActProcessFileMapper = sysActProcessFileMapper;
    }

    @RequestMapping(value={"/publish"})
    @TargetDataSource
    @ManageBussinessLog(key="/json2Xml/publish", value="\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u53d1\u5e03")
    public ApiResponse<?> genWorkFlowXml(@RequestBody String processIdentityKey) {
        SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)processIdentityKey)).eq((Object)"type", (Object)"meta")).eq((Object)"version", (Object)0));
        String modelId = metaInfo.getModelId();
        if (ToolUtil.isEmpty((Object)modelId)) {
            return ApiResponse.fail((String)"\u53d1\u5e03\u5931\u8d25\uff01");
        }
        try {
            this.modelService.deployModel(modelId, ShiroUser.getTenantId());
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u53d1\u5e03\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateProcess"})
    @TargetDataSource
    @ManageBussinessLog(key="/json2Xml/updateProcess", value="\u6d41\u7a0b\u5fae\u8c03", type="\u4fee\u6539")
    public ApiResponse<?> updateProcess(@RequestBody WorkFlow workFlow) {
        String tenantId = ShiroUser.getTenantId();
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId)) {
                    return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
                }
                return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            return ApiResponse.fail((String)"\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/save"})
    @TargetDataSource
    @ManageBussinessLog(key="/json2Xml/save", value="\u4fdd\u5b58\u6d41\u7a0b\u6a21\u578b", type="\u65b0\u589e")
    public ApiResponse<?> saveDataInfo(@RequestBody WorkFlow workFlow) {
        String tenantId = ShiroUser.getTenantId();
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (ToolUtil.isEmpty((Object)modelId)) {
                    return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
                }
            } else {
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
                String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                if (ToolUtil.isEmpty((Object)modelId)) {
                    return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
                }
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (BpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    @TargetDataSource
    @ManageBussinessLog(key="/json2Xml/update", value="\u4fee\u6539\u6d41\u7a0b\u6a21\u578b", type="\u4fee\u6539")
    public ApiResponse<?> updateWorkFlow(@RequestBody String processIdentityKey) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processIdentityKey, ShiroUser.getTenantId(), Integer.valueOf(0));
        return ApiResponse.data((Object)workFlow);
    }
}

