/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.controller;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.common.utils.InitTableUtil;
import com.jxdinfo.hussar.common.utils.JdbcUrlUtil;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantController {
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    ITenantConfigService tenantConfigService;
    @Value(value="${spring.datasource.url}")
    private String databaseUrl;
    private final String SYNCHRONIZATION_MODEL = "model\\allDataSynchronization.xls";

    @RequestMapping(value={"/tenantQuery"})
    @ManageBussinessLog(key="/tenant/tenantQuery", value="\u67e5\u8be2\u79df\u6237\u7ba1\u7406\u5217\u8868", type="\u67e5\u8be2")
    @TargetDataSource(value="master")
    public ApiResponse<Map<String, Object>> queryTenantList(@RequestParam(required=false) String userName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        SysUser sysUser = ShiroUser.getUser();
        String type = "2";
        if ("2".equals(sysUser.getTenantType())) {
            type = "3";
        }
        Map map = this.sysUserService.queryTenantList(userName, type, sysUser.getTenantId(), page, limit);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/tenantUpdate"})
    @ManageBussinessLog(key="/tenant/tenantUpdate", value="\u4fee\u6539\u8d26\u53f7\u548c\u540d\u79f0", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantUpdate(SysUser sysUser) {
        try {
            List sysUserList = this.sysUserService.list();
            for (SysUser sysUsers : sysUserList) {
                if (sysUser.getUserAccount().equals(sysUsers.getUserAccount())) {
                    return ApiResponse.fail((String)"\u7cfb\u7edf\u8d26\u53f7\u5df2\u5b58\u5728\uff01");
                }
                if (!sysUser.getUserName().equals(sysUsers.getUserName())) continue;
                return ApiResponse.fail((String)"\u7cfb\u7edf\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/tenantInsert"})
    @Transactional(rollbackFor={Exception.class})
    @ManageBussinessLog(key="/tenant/tenantInsert", value="\u65b0\u589e\u79df\u6237", type="\u65b0\u589e")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantInsert(SysUser sysUser) {
        try {
            SysUser user = ShiroUser.getUser();
            String account = sysUser.getUserAccount();
            if ("mysql".equals(this.databaseUrl.split(":")[1])) {
                sysUser.setUserAccount(account.toLowerCase());
            } else {
                sysUser.setUserAccount(account.toUpperCase());
            }
            List sysUserList = this.sysUserService.list();
            for (SysUser sysUsers : sysUserList) {
                if (sysUser.getUserAccount().equals(sysUsers.getUserAccount())) {
                    return ApiResponse.fail((String)"\u7cfb\u7edf\u8d26\u53f7\u5df2\u5b58\u5728\uff01");
                }
                if (!sysUser.getUserName().equals(sysUsers.getUserName())) continue;
                return ApiResponse.fail((String)"\u7cfb\u7edf\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            Map<String, String> map = JdbcUrlUtil.getIpAndPort(this.databaseUrl);
            sysUser.setUserId(IdWorker.get32UUID());
            sysUser.setPassword(MD5Util.encrypt((String)this.lcdpBpmProperties.getDefaultPass()));
            sysUser.setCreateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("1");
            if ("2".equals(user.getTenantType())) {
                sysUser.setTenantId(user.getTenantId());
                sysUser.setTenantCipher(user.getTenantCipher());
                sysUser.setTenantType("3");
                sysUser.setDbType(user.getDbType());
                sysUser.setDbName(user.getDbName());
                sysUser.setConnectionIp(user.getConnectionIp());
                sysUser.setConnectionPort(user.getConnectionPort());
                sysUser.setConnectionName(user.getConnectionName());
                sysUser.setConnectionPass(user.getConnectionPass());
            } else {
                sysUser.setTenantId(IdWorker.get32UUID());
                sysUser.setTenantCipher(IdWorker.get32UUID());
                sysUser.setTenantType("2");
                if ("mysql".equals(this.databaseUrl.split(":")[1])) {
                    sysUser.setDbType("Mysql");
                    sysUser.setDbName(SM4Util.encrypt((String)sysUser.getUserAccount(), (String)"admin#$%^kopoiuy"));
                } else if ("oracle".equals(this.databaseUrl.split(":")[1])) {
                    sysUser.setDbType("Oracle");
                    sysUser.setDbName(SM4Util.encrypt((String)this.databaseUrl.split("/")[this.databaseUrl.split("/").length - 1], (String)"admin#$%^kopoiuy"));
                } else if ("dm".equals(this.databaseUrl.split(":")[1])) {
                    sysUser.setDbType("Dm");
                    sysUser.setDbName(SM4Util.encrypt((String)this.databaseUrl.split("/")[this.databaseUrl.split("/").length - 1], (String)"admin#$%^kopoiuy"));
                }
                sysUser.setConnectionIp(SM4Util.encrypt((String)map.get("ip"), (String)"admin#$%^kopoiuy"));
                sysUser.setConnectionPort(SM4Util.encrypt((String)map.get("port"), (String)"admin#$%^kopoiuy"));
                sysUser.setConnectionName(SM4Util.encrypt((String)sysUser.getUserAccount(), (String)"admin#$%^kopoiuy"));
                sysUser.setConnectionPass(SM4Util.encrypt((String)sysUser.getUserAccount(), (String)"admin#$%^kopoiuy"));
                String str = this.sysUserService.createDatabase(sysUser.getUserAccount(), this.databaseUrl);
                if (str != null) {
                    return ApiResponse.fail((String)str);
                }
                InitTableUtil.createTable(sysUser, this.databaseUrl);
            }
            sysUser.setUserAccount(account);
            this.sysUserService.save((Object)sysUser);
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/tenantDelete"})
    @ManageBussinessLog(key="/tenant/tenantDelete", value="\u5220\u9664\u79df\u6237", type="\u5220\u9664")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantDelete(String userId, Boolean flage, String userAccount) {
        try {
            if (flage.booleanValue()) {
                this.sysUserService.removeDatabase(userAccount);
            }
            if ("2".equals(ShiroUser.getUser().getTenantType())) {
                this.sysUserService.removeById((Serializable)((Object)userId));
            } else {
                this.sysUserService.deleteUser(userId);
            }
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/tenantReset"})
    @ManageBussinessLog(key="/tenant/tenantReset", value="\u91cd\u7f6e\u5bc6\u7801", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> tenantReset(SysUser sysUser) {
        try {
            sysUser.setPassword(MD5Util.encrypt((String)CryptoUtil.decode(sysUser.getPassword())));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((String)"\u91cd\u7f6e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u91cd\u7f6e\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/editPwd"})
    @ManageBussinessLog(key="/tenant/editPwd", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u5bc6\u7801", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<?> editPwd(@RequestParam(value="oldPwd", required=false) String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        try {
            SysUser sysUser = ShiroUser.getUser();
            if (!sysUser.getPassword().equals(MD5Util.encrypt((String)CryptoUtil.decode(oldPwd)))) {
                return ApiResponse.fail((String)"\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
            }
            sysUser.setPassword(MD5Util.encrypt((String)CryptoUtil.decode(newPwd)));
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/editUserConfig"})
    @ManageBussinessLog(key="/tenant/editUserConfig", value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u9879\u76ee\u914d\u7f6e", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<?> editUserConfig(String isMqUse, String address, String isGodAxe, String isDataPush, String dataPushAddress, String codePrefix) {
        try {
            TenantConfig tenantConfig = new TenantConfig();
            tenantConfig.setProjectAddress(address);
            tenantConfig.setIsMqUse(isMqUse);
            tenantConfig.setIsGodAxe(isGodAxe);
            tenantConfig.setIsDataPush(isDataPush);
            tenantConfig.setDataPushAddress(dataPushAddress);
            tenantConfig.setCodePrefix(codePrefix);
            SysUser sysUser = ShiroUser.getUser();
            tenantConfig.setTenantId(sysUser.getTenantId());
            this.tenantConfigService.editTenantConfig(tenantConfig);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/getUserAddress"})
    @ManageBussinessLog(key="/tenant/getUserAddress", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u9879\u76ee\u5730\u5740", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<?> getUserAddress() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        if (tenantConfig == null) {
            return ApiResponse.data(null);
        }
        return ApiResponse.data((Object)tenantConfig.getProjectAddress());
    }

    @RequestMapping(value={"/getUserConfig"})
    @ManageBussinessLog(key="/tenant/getUserConfig", value="\u67e5\u8be2\u5bf9\u5e94\u8d26\u53f7\u7684\u914d\u7f6e\u4fe1\u606f", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<?> getUserConfig() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        return ApiResponse.data((Object)tenantConfig);
    }

    @RequestMapping(value={"/startUsing"})
    @ManageBussinessLog(key="/tenant/startUsing", value="\u542f\u7528", type="\u542f\u7528")
    @TargetDataSource(value="master")
    public ApiResponse<?> startUsing(SysUser sysUser) {
        try {
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("1");
            this.sysUserService.updateById((Object)sysUser);
            return ApiResponse.success((String)"\u542f\u7528\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u542f\u7528\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/stopUsing"})
    @ManageBussinessLog(key="/tenant/stopUsing", value="\u7981\u7528", type="\u7981\u7528")
    @TargetDataSource(value="master")
    public ApiResponse<?> stopUsing(SysUser sysUser) {
        try {
            sysUser.setUpdateTime(Timestamp.valueOf(DateUtil.getTime()));
            sysUser.setState("0");
            this.sysUserService.updateById((Object)sysUser);
            return ApiResponse.success((String)"\u7981\u7528\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u7981\u7528\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/personalQuery"})
    @ManageBussinessLog(key="/tenant/personalQuery", value="\u67e5\u8be2", type="\u67e5\u8be2")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> getPersonalMsg() {
        if (ShiroUser.getUser() == null) {
            return ApiResponse.fail((String)"\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        String userId = ShiroUser.getUser().getUserId();
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)userId));
        return ApiResponse.data((Object)sysUser);
    }

    @RequestMapping(value={"/resetCipher"})
    @ManageBussinessLog(key="/tenant/resetCipher", value="\u91cd\u7f6e\u79d8\u94a5", type="\u91cd\u7f6e\u5bc6\u7801")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> resetCipher(SysUser sysUser) {
        if (ShiroUser.getUser() == null) {
            return ApiResponse.fail((String)"\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        try {
            String userId = ShiroUser.getUser().getUserId();
            sysUser.setTenantCipher(IdWorker.get32UUID());
            sysUser.setUserId(userId);
            this.sysUserService.saveOrUpdate((Object)sysUser);
            return ApiResponse.success((String)"\u91cd\u7f6e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u91cd\u7f6e\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/getModel"})
    @ManageBussinessLog(key="/tenant/getModel", value="\u4e0b\u8f7d\u5168\u91cf\u6570\u636e\u540c\u6b65\u6a21\u677f", type="\u4e0b\u8f7d")
    @TargetDataSource
    public void getModel(HttpServletResponse response) {
        try {
            InputStream in = TenantController.class.getClassLoader().getResourceAsStream("model\\allDataSynchronization.xls");
            this.sysUserService.getModel(in, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/editDbMessage"})
    @ManageBussinessLog(key="/tenant/editDbMessage", value="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f", type="\u4fee\u6539")
    @TargetDataSource(value="master")
    public ApiResponse<SysUser> editDbMessage(SysUser sysUser) {
        try {
            if (this.sysUserService.updateDbMessage("false", sysUser)) {
                return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            return ApiResponse.fail((String)"\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
    }
}

