/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.controller;

import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processInst"})
public class ProcessInstController
extends BaseController {
    @Autowired
    private ProcessInstService processInstService;

    @RequestMapping(value={"/getProcessList"})
    @ManageBussinessLog(key="/processInst/getProcessList", value="\u5c55\u793a\u6d41\u7a0b\u5b9e\u65bd\u5217\u8868", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> getRunningProcessList(@RequestParam(name="definitionName", required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startTime, @RequestParam(required=false) String startTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit, @RequestParam(required=false) Integer suspension) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUser sysUser = ShiroUser.getUser();
        String userId = "";
        if ("3".equals(sysUser.getTenantType())) {
            userId = sysUser.getUserId();
        }
        map.put("userId", userId);
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("startTime", startTime);
        map.put("startTimeEnd", startTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        map.put("suspension", suspension);
        return ApiResponse.data((Object)this.processInstService.getProcessList(map));
    }

    @RequestMapping(value={"/deleteProcessById"})
    @ManageBussinessLog(key="/processInst/deleteProcessById", value="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> deleteProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/deleteFinishedProcessById"})
    @ManageBussinessLog(key="/processInst/deleteFinishedProcessById", value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<?> deleteFinishedProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteFinishedProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/suspendProcessById"})
    @ManageBussinessLog(key="/processInst/suspendProcessById", value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", type="\u6302\u8d77")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> suspendProcessById(@RequestParam(value="instId") String instId) {
        return this.processInstService.suspendProcessInstanceById(instId);
    }

    @RequestMapping(value={"/activateProcessById"})
    @ManageBussinessLog(key="/processInst/activateProcessById", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", type="\u6fc0\u6d3b")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> activateProcessById(@RequestParam(value="instId") String instId) {
        return this.processInstService.activateProcessById(instId);
    }
}

