/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/model"})
public class ModelController {
    @Autowired
    private ModelService modelService;

    @RequestMapping(value={"/modelQuery"})
    @ManageBussinessLog(key="/model/modelQuery", value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> queryModelList(@RequestParam(required=false) String modelName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            SysUser sysUser = ShiroUser.getUser();
            String userId = "";
            if ("3".equals(sysUser.getTenantType())) {
                userId = sysUser.getUserId();
            }
            Map map = this.modelService.queryModelList(modelName, userId, page, limit);
            return ApiResponse.data((Object)map);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    @ManageBussinessLog(key="/model/modelDeploy", value="\u90e8\u7f72\u6d41\u7a0b", type="\u53d1\u5e03")
    @TargetDataSource
    public ApiResponse<?> deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            this.modelService.deployModel(modelId, ShiroUser.getTenantId());
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        return ApiResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/assignedProcess"})
    @ManageBussinessLog(key="/model/assignedProcess", value="\u5206\u914d\u6d41\u7a0b", type="\u53d1\u5e03")
    @TargetDataSource
    public ApiResponse<?> assignedProcess(@RequestParam(value="modelId") String modelId, @RequestParam(value="userId") String userId) {
        try {
            this.modelService.assignedProcess(modelId, userId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        return ApiResponse.success((String)"\u5206\u914d\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/modelImport"})
    @ManageBussinessLog(key="/model/modelImport", value="\u5bfc\u5165", type="\u5bfc\u5165")
    @TargetDataSource
    public ApiResponse<?> importModel(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        return this.modelService.importModel(ShiroUser.getTenantId(), file, request);
    }

    @RequestMapping(value={"/batchImport"})
    @ManageBussinessLog(key="/model/batchImport", value="\u6279\u91cf\u5bfc\u5165", type="\u6279\u91cf\u5bfc\u5165")
    @TargetDataSource
    public ApiResponse<?> batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        try {
            ApiResponse response = this.modelService.importModel(ShiroUser.getTenantId(), file, request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/export"})
    @ManageBussinessLog(key="/model/export", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    @TargetDataSource
    public void export(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportModel(modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/exportFiles"})
    @ManageBussinessLog(key="/model/exportFiles", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    @TargetDataSource
    public void exportAllFile(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportAllFileModel(ShiroUser.getTenantId(), modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBussinessLog(key="/model/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<?> deleteModel(String modelId) {
        try {
            return this.modelService.deleteModel(ShiroUser.getTenantId(), modelId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/deleteModelWithVersion"})
    @ManageBussinessLog(key="/model/deleteModelWithVersion", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<?> deleteModelWithVersion(String processDefId) {
        try {
            return this.modelService.deleteModelWithVersion(ShiroUser.getTenantId(), processDefId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/getAllModel"})
    @ManageBussinessLog(key="/model/getAllModel", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.data((Object)this.modelService.getAllModel());
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBussinessLog(key="/model/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    @TargetDataSource
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, Map<String, Object> variables) {
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, variables, ShiroUser.getTenantId());
    }

    @RequestMapping(value={"/doneList"})
    @TargetDataSource
    public ApiResponse<?> doneList(String businessKey) {
        return this.modelService.doneList(businessKey, ShiroUser.getTenantId());
    }
}

