/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.shrio;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.response.ResultCode;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class KickoutSessionFilter
extends AccessControlFilter {
    private static Logger logger = LoggerFactory.getLogger(KickoutSessionFilter.class);
    public final String ERROR_TIPS = "tips";
    private SessionDAO sessionDAO;
    private Long maxSession = 1000000L;
    private SessionManager sessionManager;

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    public Long getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(Long maxSession) {
        this.maxSession = maxSession;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HashMap<String, Object> resultMap;
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)request);
        HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
        String requestUri = httpServletRequest.getRequestURI();
        String ua = this.getUsreAgent(httpServletRequest);
        String ip = this.getIP(httpServletRequest);
        logger.debug(String.format("URL:%s | IP: %s | USER-AGENT: %s", requestUri, ip, ua));
        String tips = httpServletRequest.getParameter("tips");
        if (tips != null) {
            httpServletRequest.setAttribute("tips", (Object)tips);
        } else {
            httpServletRequest.setAttribute("tips", (Object)"");
        }
        Subject subject = this.getSubject(request, response);
        Boolean isRemembered = subject.isRemembered();
        Session session = subject.getSession();
        SysUser shiroUser = ShiroUser.getUser();
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            resultMap = new HashMap<String, Object>();
            resultMap.put("code", ResultCode.UN_AUTHORIZED.getCode());
            resultMap.put("msg", ResultCode.UN_AUTHORIZED.getMessage());
            this.out(response, resultMap);
        }
        if (!subject.isAuthenticated() && !isRemembered.booleanValue()) {
            if (shiroUser != null && session.getAttribute((Object)"csrfFlag") == null) {
                resultMap = new HashMap();
                resultMap.put("code", ResultCode.UN_AUTHORIZED.getCode());
                resultMap.put("msg", ResultCode.UN_AUTHORIZED.getMessage());
                this.out(response, resultMap);
                return false;
            }
            httpServletRequest.getRequestURI();
            httpServletRequest.getRemoteHost();
            if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
                httpServletResponse.setHeader("sessionstatus", "timeout");
                return false;
            }
            String referer = httpServletRequest.getHeader("Referer");
            if (referer == null) {
                return false;
            }
            return false;
        }
        return true;
    }

    private void out(ServletResponse hresponse, Map<String, Object> resultMap) throws IOException {
        hresponse.setCharacterEncoding("UTF-8");
        PrintWriter out = hresponse.getWriter();
        out.println(JSON.toJSONString(resultMap));
        out.flush();
        out.close();
    }

    private String getIP(HttpServletRequest request) {
        StringBuffer ip = new StringBuffer();
        ip.append("X-Requested-For\uff1a").append(request.getHeader("X-Requested-For")).append(" , ");
        ip.append("X-Forwarded-For\uff1a").append(request.getHeader("X-Forwarded-For")).append(" , ");
        ip.append("Proxy-Client-IP\uff1a").append(request.getHeader("Proxy-Client-IP")).append(" , ");
        ip.append("WL-Proxy-Client-IP\uff1a").append(request.getHeader("WL-Proxy-Client-IP")).append(" , ");
        ip.append("HTTP_CLIENT_IP\uff1a").append(request.getHeader("HTTP_CLIENT_IP")).append(" , ");
        ip.append("HTTP_X_FORWARDED_FOR\uff1a").append(request.getHeader("HTTP_X_FORWARDED_FOR")).append(" , ");
        ip.append("RemoteAddr\uff1a").append(request.getRemoteAddr());
        return ip.toString();
    }

    private String getUsreAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }
}

