/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.login;

import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.common.response.IResultCode;
import com.jxdinfo.hussar.bpm.common.response.ResultCode;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBussinessLog;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogManager;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogTaskFactory;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.common.utils.CryptoUtil;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    private static final String ADMIN_ACCOUNT = "admin";

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ManageBussinessLog(key="/login", type="\u767b\u5f55", value="\u7528\u6237\u767b\u5f55")
    public ApiResponse<?> login(@RequestBody Map<String, String> body) {
        String userAccount = body.get("userAccount");
        String cipher = body.get("cipher");
        cipher = CryptoUtil.decode(cipher);
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(userAccount, cipher.toCharArray());
        currentUser.login((AuthenticationToken)token);
        Session session = currentUser.getSession();
        SysUser sysUser = ShiroUser.getUser();
        session.setAttribute((Object)"userName", (Object)sysUser.getUserName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", CryptoUtil.encode(String.valueOf(session.getId())));
        map.put("userName", sysUser.getUserName());
        map.put("userId", sysUser.getUserAccount());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    public ApiResponse<?> logOut() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        ManageLogManager.me().executeLog(ManageLogTaskFactory.exitLog(ShiroUser.getUser(), "\u767b\u51fa", info));
        ShiroUser.getSubject().logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    public ApiResponse<?> check() {
        SysUser sysUser = ShiroUser.getUser();
        if (ToolUtil.isNotEmpty((Object)sysUser)) {
            return ApiResponse.data((Object)sysUser.getTenantType());
        }
        return ApiResponse.data((Object)false);
    }
}

