/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.shrio;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bsp.exception.TenantLockedByWrongPwdException;
import com.jxdinfo.hussar.bsp.exception.TenantLockedExceededFrequencyException;
import com.jxdinfo.hussar.bsp.exception.WrongPwdException;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import com.jxdinfo.hussar.core.util.MD5Util;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.system.lock.LoginLock;
import com.jxdinfo.hussar.system.shrio.SecretFreeIpConfig;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class AbstractCredentialsMatcher
extends SimpleCredentialsMatcher {
    public boolean doCredentialsMatch(AuthenticationToken authenticationToken, AuthenticationInfo info) {
        SecretFreeIpConfig secretFreeIpConfig = (SecretFreeIpConfig)SpringContextHolder.getBean(SecretFreeIpConfig.class);
        ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
        LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = DataSourceContextHolder.getDataSource();
        String[] hostList = secretFreeIpConfig.getSecretFreeIp();
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        String userName = token.getUsername();
        String password = String.valueOf(token.getPassword());
        String host = token.getHost();
        if (loginLock.userIsLock(userName, connName)) {
            throw new TenantLockedExceededFrequencyException();
        }
        boolean flag = false;
        if (StringUtils.isNotEmpty((CharSequence)host) && hostList != null && hostList.length != 0 && (Arrays.asList(hostList).contains("//") || Arrays.asList(hostList).contains(host))) {
            flag = this.equals(this.passwordEncode(userName.getBytes()), password);
        } else {
            String tokenCredentials = this.passwordEncode(password.getBytes());
            Object accountCredentials = this.getCredentials(info);
            flag = this.equals(tokenCredentials, accountCredentials);
        }
        if (!flag) {
            int failNumber = lcdpBpmProperties.getLoginFailNumber();
            loginLock.addUserCache(userName, connName, failNumber);
            int loginChance = failNumber - loginLock.userLockNum(userName, connName);
            int loginChanceTime = Math.max(loginChance, 0);
            if (loginChanceTime == 0) {
                sysUserService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"state", (Object)5)).eq((Object)"user_account", (Object)userName));
                throw new TenantLockedByWrongPwdException();
            }
            throw new WrongPwdException().setLoginChanceTime(loginChanceTime);
        }
        loginLock.removeUserCache(userName, connName);
        return flag;
    }

    public String passwordEncode(byte[] plainByte) {
        return MD5Util.encrypt((String)new String(plainByte));
    }
}

