/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/model"})
public class ModelController {
    @Autowired
    private ModelService modelService;
    @Autowired
    private InstanceEngineService instanceEngineService;

    @RequestMapping(value={"/modelQuery"})
    @ManageBusinessLog(key="/model/modelQuery", value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> queryModelList(@RequestParam(required=false) String modelName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            Map map = this.modelService.queryModelList(modelName, page, limit);
            return ApiResponse.data((Object)map);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    @ManageBusinessLog(key="/model/modelDeploy", value="\u90e8\u7f72\u6d41\u7a0b", type="\u53d1\u5e03")
    @TargetDataSource
    public ApiResponse<?> deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            this.modelService.deployModel(modelId, ShiroUser.getTenantId());
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        return ApiResponse.success((int)BpmEnum.DEPLOY_SUCCESS.getCode(), (String)BpmEnum.DEPLOY_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/batchImport"})
    @ManageBusinessLog(key="/model/batchImport", value="\u6279\u91cf\u5bfc\u5165", type="\u6279\u91cf\u5bfc\u5165")
    @TargetDataSource
    public ApiResponse<?> batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        return this.modelService.importModel(ShiroUser.getTenantId(), file, request);
    }

    @RequestMapping(value={"/exportFiles"})
    @ManageBusinessLog(key="/model/exportFiles", value="\u5bfc\u51fa", type="\u5bfc\u51fa")
    @TargetDataSource
    public void exportAllFile(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportAllFileModel(ShiroUser.getTenantId(), modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBusinessLog(key="/model/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<?> deleteModel(String modelId) {
        try {
            return this.modelService.deleteModel(ShiroUser.getTenantId(), modelId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @RequestMapping(value={"/deleteModelWithVersion"})
    @ManageBusinessLog(key="/model/deleteModelWithVersion", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    @TargetDataSource
    public ApiResponse<?> deleteModelWithVersion(String processDefId) {
        try {
            return this.modelService.deleteModelWithVersion(ShiroUser.getTenantId(), processDefId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.DELETE_FAIL.getCode(), (String)BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @RequestMapping(value={"/getAllModel"})
    @ManageBusinessLog(key="/model/getAllModel", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.data((Object)this.modelService.getAllModel());
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBusinessLog(key="/model/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    @TargetDataSource
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, String variables) {
        Map body = (Map)JSON.parseObject((String)variables, HashMap.class);
        HashMap map = new HashMap();
        if (body != null) {
            for (Map.Entry vo : body.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, map, ShiroUser.getTenantId());
    }

    @RequestMapping(value={"/doneList"})
    @TargetDataSource
    public ApiResponse<?> doneList(String businessKey) {
        return this.modelService.doneList(businessKey, ShiroUser.getTenantId());
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @ManageBusinessLog(key="/model/deleteProcessInstanceByBusinessKey", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    @TargetDataSource
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }
}

