/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.lock;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.bpm.timeouthandle.util.HussarEhcacheManager;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.system.lock.LoginLock;
import com.jxdinfo.hussar.system.lock.UserLockModel;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginLockImpl
implements LoginLock {
    private static final String LOGIN_LOCK = "Login_Lock";
    private static boolean isUseRedis;
    @Value(value="${bpm.stand-alone:true}")
    private boolean standAlone;
    @Value(value="${bpm.login-fail-number}")
    private int failNumber;
    @Value(value="${bpm.login-fail-lock-time}")
    private int failLockTime;
    @Value(value="${bpm.login-fail-times}")
    private int failTimes;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final HussarEhcacheManager hussarEhcacheManager;
    private final ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
    private static final Logger logger;
    private static final String SHIRO_IS_LOCK = "shiro_is_lock:";
    private static final String SHIRO_LOGIN_COUNT = "shiro_login_count:";
    private static final String SEP_STR = "-";

    @PostConstruct
    private void init() {
        isUseRedis = !this.standAlone;
    }

    @Override
    public boolean userIsLock(String userId, String connName) {
        String key = userId + SEP_STR + connName;
        boolean flag = false;
        if (isUseRedis) {
            try {
                if ("LOCK".equals(this.redisTemplate.opsForValue().get((Object)(SHIRO_IS_LOCK + key)))) {
                    flag = true;
                } else {
                    this.sysUserService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"state", (Object)1)).eq((Object)"user_account", (Object)userId)).eq((Object)"state", (Object)5));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u83b7\u53d6\u7528\u6237\u9501\u5b9a\u72b6\u6001\u5931\u8d25{}", (Object)e.toString());
            }
            return flag;
        }
        UserLockModel model = (UserLockModel)hussarEhcacheManager.getObject(LOGIN_LOCK, key);
        if (ToolUtil.isNotEmpty((Object)model) && ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
            if (DateUtil.compareDate((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (Date)model.getExpireTime()) == -1) {
                flag = true;
            } else {
                this.sysUserService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"state", (Object)1)).eq((Object)"user_account", (Object)userId)).eq((Object)"state", (Object)5));
            }
        } else {
            this.sysUserService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"state", (Object)1)).eq((Object)"user_account", (Object)userId)).eq((Object)"state", (Object)5));
        }
        return flag;
    }

    @Override
    public int userLockNum(String userId, String connName) {
        if (isUseRedis) {
            try {
                long count = this.redisTemplate.opsForValue().increment((Object)(SHIRO_LOGIN_COUNT + userId + SEP_STR + connName), 0L);
                return (int)count;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u83b7\u53d6\u7528\u6237\u9501\u5b9a\u6b21\u6570\u5931\u8d25{}", (Object)e.toString());
            }
        }
        int num = 0;
        UserLockModel model = (UserLockModel)hussarEhcacheManager.getObject(LOGIN_LOCK, userId + SEP_STR + connName);
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    @Override
    public void addUserCache(String userId) {
        if (isUseRedis) {
            try {
                long count = this.redisTemplate.opsForValue().increment((Object)(SHIRO_LOGIN_COUNT + userId), 1L);
                if (count >= (long)this.failNumber) {
                    this.redisTemplate.opsForValue().set((Object)(SHIRO_IS_LOCK + userId), (Object)"LOCK");
                    this.redisTemplate.expire((Object)(SHIRO_IS_LOCK + userId), (long)this.failLockTime, TimeUnit.HOURS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u767b\u5f55\u5931\u8d25\u65f6\u52a0\u5165\u7f13\u5b58\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        UserLockModel model = (UserLockModel)hussarEhcacheManager.getObject(LOGIN_LOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            if (ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
                model.setFailNum(0);
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            model.setFailNum(model.getFailNum() + 1);
            if (model.getFailNum() >= this.failNumber) {
                model.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.failLockTime));
            }
        } else {
            UserLockModel newModel = new UserLockModel();
            newModel.setUserid(userId);
            newModel.setFailNum(1);
            if (newModel.getFailNum() >= this.failNumber) {
                newModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                newModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.failLockTime));
            }
            hussarEhcacheManager.setObject(LOGIN_LOCK, userId, (Object)newModel);
        }
    }

    @Override
    public void removeUserCache(String userId, String connName) {
        if (isUseRedis) {
            try {
                this.redisTemplate.delete((Object)(SHIRO_LOGIN_COUNT + userId + SEP_STR + connName));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u7f13\u5b58\u4e2d\u79fb\u9664\u7528\u6237\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        hussarEhcacheManager.delete(LOGIN_LOCK, userId + SEP_STR + connName);
    }

    @Override
    public void addUserCache(String userId, String connName, int tryLogin) {
        String key = userId + SEP_STR + connName;
        this.addNewUserCache(key, userId, tryLogin);
    }

    private void addNewUserCache(String key, String userId, int tryLogin) {
        if (isUseRedis) {
            try {
                long count = this.redisTemplate.opsForValue().increment((Object)(SHIRO_LOGIN_COUNT + key), 1L);
                if (count == 1L) {
                    this.redisTemplate.expire((Object)(SHIRO_LOGIN_COUNT + key), (long)this.failTimes, TimeUnit.MINUTES);
                }
                if (count >= (long)tryLogin) {
                    this.redisTemplate.opsForValue().set((Object)(SHIRO_IS_LOCK + key), (Object)"LOCK");
                    this.redisTemplate.expire((Object)(SHIRO_IS_LOCK + key), (long)this.failLockTime, TimeUnit.MINUTES);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u6dfb\u52a0\u7528\u6237\u5230\u7f13\u5b58\u4e2d\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        UserLockModel model = (UserLockModel)hussarEhcacheManager.getObject(LOGIN_LOCK, key);
        if (ToolUtil.isNotEmpty((Object)model)) {
            if (ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
                model.setFailNum(0);
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            if (DateUtil.addMinute((Date)model.getFirstFailTime(), (int)this.failTimes).getTime() < System.currentTimeMillis()) {
                model.setFailNum(0);
                model.setFirstFailTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            model.setFailNum(model.getFailNum() + 1);
            if (model.getFailNum() >= tryLogin) {
                model.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.failLockTime));
            }
        } else {
            UserLockModel newModel = new UserLockModel();
            newModel.setUserid(userId);
            newModel.setFirstFailTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            newModel.setFailNum(1);
            if (newModel.getFailNum() >= tryLogin) {
                newModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                newModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.failLockTime));
            }
            hussarEhcacheManager.setObject(LOGIN_LOCK, key, (Object)newModel);
        }
    }

    static {
        hussarEhcacheManager = (HussarEhcacheManager)SpringContextHolder.getBean(HussarEhcacheManager.class);
        logger = LogManager.getLogger(LoginLockImpl.class);
    }
}

