--
-- Kingbase database dump
--

-- Dumped from database version 12.1
-- Dumped by sys_dump version 12.1


--
-- Name: act_evt_log; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_evt_log (
    log_nr_ bigint NOT NULL,
    type_ character varying(64 char),
    proc_def_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    execution_id_ character varying(64 char),
    task_id_ character varying(64 char),
    time_stamp_ timestamp(0) without time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    user_id_ character varying(255 char),
    data_ bytea,
    lock_owner_ character varying(255 char),
    lock_time_ timestamp(0) without time zone,
    is_processed_ smallint DEFAULT 0
);


ALTER TABLE public.act_evt_log OWNER TO current_user;

--
-- Name: TABLE act_evt_log; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_evt_log IS '事件日志表';


--
-- Name: act_evt_log_log_nr__seq; Type: SEQUENCE; Schema: public; Owner: current_user
--

CREATE SEQUENCE public.act_evt_log_log_nr__seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.act_evt_log_log_nr__seq OWNER TO current_user;

--
-- Name: act_evt_log_log_nr__seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: current_user
--

ALTER SEQUENCE public.act_evt_log_log_nr__seq OWNED BY public.act_evt_log.log_nr_;


--
-- Name: act_ge_bytearray; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ge_bytearray (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    name_ character varying(255 char),
    deployment_id_ character varying(64 char),
    bytes_ bytea,
    generated_ smallint
);


ALTER TABLE public.act_ge_bytearray OWNER TO current_user;

--
-- Name: TABLE act_ge_bytearray; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ge_bytearray IS '二进制数据表';


--
-- Name: act_ge_property; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ge_property (
    name_ character varying(64 char) NOT NULL,
    value_ character varying(300 char),
    rev_ integer
);


ALTER TABLE public.act_ge_property OWNER TO current_user;

--
-- Name: TABLE act_ge_property; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ge_property IS '属性数据表';


--
-- Name: act_hi_actinst; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_actinst (
    id_ character varying(64 char) NOT NULL,
    proc_def_id_ character varying(64 char) NOT NULL,
    proc_inst_id_ character varying(64 char) NOT NULL,
    execution_id_ character varying(64 char) NOT NULL,
    act_id_ character varying(255 char) NOT NULL,
    task_id_ character varying(64 char),
    call_proc_inst_id_ character varying(64 char),
    act_name_ character varying(255 char),
    act_type_ character varying(255 char) NOT NULL,
    assignee_ character varying(255 char),
    start_time_ timestamp without time zone,
    end_time_ timestamp without time zone,
    duration_ bigint,
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying
);


ALTER TABLE public.act_hi_actinst OWNER TO current_user;

--
-- Name: TABLE act_hi_actinst; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_actinst IS '历史节点表';


--
-- Name: act_hi_attachment; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_attachment (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    user_id_ character varying(255 char),
    name_ character varying(255 char),
    description_ character varying(4000 char),
    type_ character varying(255 char),
    task_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    url_ character varying(4000 char),
    content_id_ character varying(64 char),
    time_ timestamp without time zone
);


ALTER TABLE public.act_hi_attachment OWNER TO current_user;

--
-- Name: TABLE act_hi_attachment; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_attachment IS '历史附件表';


--
-- Name: act_hi_comment; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_comment (
    id_ character varying(64 char) NOT NULL,
    type_ character varying(255 char),
    time_ timestamp without time zone,
    user_id_ character varying(255 char),
    task_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    action_ character varying(255 char),
    message_ character varying(4000 char),
    full_msg_ bytea
);


ALTER TABLE public.act_hi_comment OWNER TO current_user;

--
-- Name: TABLE act_hi_comment; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_comment IS '历史意见表';


--
-- Name: act_hi_detail; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_detail (
    id_ character varying(64 char) NOT NULL,
    type_ character varying(255 char) NOT NULL,
    proc_inst_id_ character varying(64 char),
    execution_id_ character varying(64 char),
    task_id_ character varying(64 char),
    act_inst_id_ character varying(64 char),
    name_ character varying(255 char) NOT NULL,
    var_type_ character varying(255 char),
    rev_ integer,
    time_ timestamp without time zone,
    bytearray_id_ character varying(64 char),
    double_ double precision,
    long_ bigint,
    text_ character varying(4000 char),
    text2_ character varying(4000 char)
);


ALTER TABLE public.act_hi_detail OWNER TO current_user;

--
-- Name: TABLE act_hi_detail; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_detail IS '历史详情表';


--
-- Name: act_hi_identitylink; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_identitylink (
    id_ character varying(64 char) NOT NULL,
    group_id_ character varying(255 char),
    type_ character varying(255 char),
    user_id_ character varying(255 char),
    task_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char)
);


ALTER TABLE public.act_hi_identitylink OWNER TO current_user;

--
-- Name: TABLE act_hi_identitylink; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_identitylink IS '历史流程人员表';


--
-- Name: act_hi_procinst; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_procinst (
    id_ character varying(64 char) NOT NULL,
    proc_inst_id_ character varying(64 char) NOT NULL,
    business_key_ character varying(255 char),
    proc_def_id_ character varying(64 char) NOT NULL,
    start_time_ timestamp without time zone,
    end_time_ timestamp without time zone,
    duration_ bigint,
    start_user_id_ character varying(255 char),
    start_act_id_ character varying(255 char),
    end_act_id_ character varying(255 char),
    super_process_instance_id_ character varying(64 char),
    delete_reason_ character varying(4000 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying,
    name_ character varying(255 char)
);


ALTER TABLE public.act_hi_procinst OWNER TO current_user;

--
-- Name: TABLE act_hi_procinst; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_procinst IS '历史流程实例表';


--
-- Name: act_hi_taskinst; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_taskinst (
    id_ character varying(64 char) NOT NULL,
    proc_def_id_ character varying(64 char),
    task_def_key_ character varying(255 char),
    proc_inst_id_ character varying(64 char),
    execution_id_ character varying(64 char),
    name_ character varying(255 char),
    parent_task_id_ character varying(64 char),
    description_ character varying(4000 char),
    owner_ character varying(255 char),
    assignee_ character varying(255 char),
    start_time_ timestamp without time zone,
    claim_time_ timestamp without time zone,
    end_time_ timestamp without time zone,
    duration_ bigint,
    delete_reason_ character varying(4000 char),
    priority_ integer,
    due_date_ timestamp without time zone,
    form_key_ character varying(2000 char),
    category_ character varying(255 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying
);


ALTER TABLE public.act_hi_taskinst OWNER TO current_user;

--
-- Name: TABLE act_hi_taskinst; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_taskinst IS '历史任务实例表';


--
-- Name: act_hi_varinst; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_hi_varinst (
    id_ character varying(64 char) NOT NULL,
    proc_inst_id_ character varying(64 char),
    execution_id_ character varying(64 char),
    task_id_ character varying(64 char),
    name_ character varying(255 char) NOT NULL,
    var_type_ character varying(100 char),
    rev_ integer,
    bytearray_id_ character varying(64 char),
    double_ double precision,
    long_ bigint,
    text_ character varying(4000 char),
    text2_ character varying(4000 char),
    create_time_ timestamp without time zone,
    last_updated_time_ timestamp without time zone
);


ALTER TABLE public.act_hi_varinst OWNER TO current_user;

--
-- Name: TABLE act_hi_varinst; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_hi_varinst IS '历史变量表';


--
-- Name: act_id_group; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_id_group (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    name_ character varying(255 char),
    type_ character varying(255 char)
);


ALTER TABLE public.act_id_group OWNER TO current_user;

--
-- Name: TABLE act_id_group; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_id_group IS '用户组信息表';


--
-- Name: act_id_info; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_id_info (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    user_id_ character varying(64 char),
    type_ character varying(64 char),
    key_ character varying(255 char),
    value_ character varying(255 char),
    password_ bytea,
    parent_id_ character varying(255 char)
);


ALTER TABLE public.act_id_info OWNER TO current_user;

--
-- Name: TABLE act_id_info; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_id_info IS '用户扩展信息表';


--
-- Name: act_id_membership; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_id_membership (
    user_id_ character varying(64 char) NOT NULL,
    group_id_ character varying(64 char) NOT NULL
);


ALTER TABLE public.act_id_membership OWNER TO current_user;

--
-- Name: TABLE act_id_membership; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_id_membership IS '用户与分组对应信息表';


--
-- Name: act_id_user; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_id_user (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    first_ character varying(255 char),
    last_ character varying(255 char),
    email_ character varying(255 char),
    pwd_ character varying(255 char),
    picture_id_ character varying(64 char)
);


ALTER TABLE public.act_id_user OWNER TO current_user;

--
-- Name: TABLE act_id_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_id_user IS '用户信息表';


--
-- Name: act_procdef_info; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_procdef_info (
    id_ character varying(64 char) NOT NULL,
    proc_def_id_ character varying(64 char) NOT NULL,
    rev_ integer,
    info_json_id_ character varying(64 char)
);


ALTER TABLE public.act_procdef_info OWNER TO current_user;

--
-- Name: TABLE act_procdef_info; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_procdef_info IS '流程定义信息表';


--
-- Name: act_re_deployment; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_re_deployment (
    id_ character varying(64 char) NOT NULL,
    name_ character varying(255 char),
    category_ character varying(255 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying,
    deploy_time_ timestamp(0) without time zone
);


ALTER TABLE public.act_re_deployment OWNER TO current_user;

--
-- Name: TABLE act_re_deployment; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_re_deployment IS '部署信息表';


--
-- Name: act_re_model; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_re_model (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    name_ character varying(255 char),
    key_ character varying(255 char),
    category_ character varying(255 char),
    create_time_ timestamp(0) without time zone,
    last_update_time_ timestamp(0) without time zone,
    version_ integer,
    meta_info_ character varying(4000 char),
    deployment_id_ character varying(64 char),
    editor_source_value_id_ character varying(64 char),
    editor_source_extra_value_id_ character varying(64 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying
);


ALTER TABLE public.act_re_model OWNER TO current_user;

--
-- Name: TABLE act_re_model; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_re_model IS '流程设计模型部署表';


--
-- Name: act_re_procdef; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_re_procdef (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    category_ character varying(255 char),
    name_ character varying(255 char),
    key_ character varying(255 char) NOT NULL,
    version_ integer NOT NULL,
    deployment_id_ character varying(64 char),
    resource_name_ character varying(4000 char),
    dgrm_resource_name_ character varying(4000 char),
    description_ character varying(4000 char),
    has_start_form_key_ smallint,
    has_graphical_notation_ smallint,
    suspension_state_ integer,
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying,
    main_process character varying(4 char) DEFAULT '0'::character varying,
    real_version integer
);


ALTER TABLE public.act_re_procdef OWNER TO current_user;

--
-- Name: TABLE act_re_procdef; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_re_procdef IS '流程定义数据表';


--
-- Name: COLUMN act_re_procdef.main_process; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.act_re_procdef.main_process IS '1主版本 0 不是主版本 2 临时版本';


--
-- Name: COLUMN act_re_procdef.real_version; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.act_re_procdef.real_version IS '临时版本流程真实版本号';


--
-- Name: act_ru_event_subscr; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_event_subscr (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    event_type_ character varying(255 char) NOT NULL,
    event_name_ character varying(255 char),
    execution_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    activity_id_ character varying(64 char),
    configuration_ character varying(255 char),
    created_ timestamp(0) without time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    proc_def_id_ character varying(64 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying
);


ALTER TABLE public.act_ru_event_subscr OWNER TO current_user;

--
-- Name: TABLE act_ru_event_subscr; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_event_subscr IS '运行实例表';


--
-- Name: act_ru_execution; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_execution (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    proc_inst_id_ character varying(64 char),
    business_key_ character varying(255 char),
    parent_id_ character varying(64 char),
    proc_def_id_ character varying(64 char),
    super_exec_ character varying(64 char),
    act_id_ character varying(255 char),
    is_active_ smallint,
    is_concurrent_ smallint,
    is_scope_ smallint,
    is_event_scope_ smallint,
    suspension_state_ integer,
    cached_ent_state_ integer,
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying,
    name_ character varying(255 char),
    lock_time_ timestamp(0) without time zone
);


ALTER TABLE public.act_ru_execution OWNER TO current_user;

--
-- Name: TABLE act_ru_execution; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_execution IS '运行时流程执行实例表';


--
-- Name: act_ru_identitylink; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_identitylink (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    group_id_ character varying(255 char),
    type_ character varying(255 char),
    user_id_ character varying(255 char),
    task_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    proc_def_id_ character varying(64 char)
);


ALTER TABLE public.act_ru_identitylink OWNER TO current_user;

--
-- Name: TABLE act_ru_identitylink; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_identitylink IS '运行时流程人员表';


--
-- Name: act_ru_job; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_job (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    type_ character varying(255 char) NOT NULL,
    lock_exp_time_ timestamp(0) without time zone,
    lock_owner_ character varying(255 char),
    exclusive_ boolean,
    execution_id_ character varying(64 char),
    process_instance_id_ character varying(64 char),
    proc_def_id_ character varying(64 char),
    retries_ integer,
    exception_stack_id_ character varying(64 char),
    exception_msg_ character varying(4000 char),
    duedate_ timestamp(0) without time zone,
    repeat_ character varying(255 char),
    handler_type_ character varying(255 char),
    handler_cfg_ character varying(4000 char),
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying
);


ALTER TABLE public.act_ru_job OWNER TO current_user;

--
-- Name: TABLE act_ru_job; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_job IS '运行时定时任务数据表';


--
-- Name: act_ru_task; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_task (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    execution_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    proc_def_id_ character varying(64 char),
    name_ character varying(255 char),
    parent_task_id_ character varying(64 char),
    description_ character varying(4000 char),
    task_def_key_ character varying(255 char),
    owner_ character varying(255 char),
    assignee_ character varying(255 char),
    delegation_ character varying(64 char),
    priority_ integer,
    create_time_ timestamp(0) without time zone,
    due_date_ timestamp without time zone,
    category_ character varying(255 char),
    suspension_state_ integer,
    tenant_id_ character varying(255 char) DEFAULT NULL::character varying,
    form_key_ character varying(2000 char)
);


ALTER TABLE public.act_ru_task OWNER TO current_user;

--
-- Name: TABLE act_ru_task; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_task IS '运行时任务节点表';


--
-- Name: act_ru_variable; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.act_ru_variable (
    id_ character varying(64 char) NOT NULL,
    rev_ integer,
    type_ character varying(255 char) NOT NULL,
    name_ character varying(255 char) NOT NULL,
    execution_id_ character varying(64 char),
    proc_inst_id_ character varying(64 char),
    task_id_ character varying(64 char),
    bytearray_id_ character varying(64 char),
    double_ double precision,
    long_ bigint,
    text_ character varying(4000 char),
    text2_ character varying(4000 char)
);


ALTER TABLE public.act_ru_variable OWNER TO current_user;

--
-- Name: TABLE act_ru_variable; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.act_ru_variable IS '运行时流程变量数据表';


--
-- Name: sys_act_cc_task; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_cc_task (
    id character varying(32 char) NOT NULL,
    task_id character varying(64 char),
    proc_inst_id character varying(64 char),
    proc_name character varying(255 char),
    task_name character varying(255 char),
    send_user character varying(32 char),
    receive_user character varying(32 char),
    send_time timestamp(0) without time zone,
    form_key character varying(1000 char),
    proc_def_key character varying(64 char),
    business_id character varying(255 char),
    task_def_key character varying(64 char),
    text text
);


ALTER TABLE public.sys_act_cc_task OWNER TO current_user;

--
-- Name: TABLE sys_act_cc_task; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_cc_task IS '抄送表';


--
-- Name: COLUMN sys_act_cc_task.id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.id IS '主键';


--
-- Name: COLUMN sys_act_cc_task.task_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.task_id IS '任务ID';


--
-- Name: COLUMN sys_act_cc_task.proc_inst_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.proc_inst_id IS '实例ID';


--
-- Name: COLUMN sys_act_cc_task.proc_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.proc_name IS '流程名称';


--
-- Name: COLUMN sys_act_cc_task.task_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.task_name IS '任务名称';


--
-- Name: COLUMN sys_act_cc_task.send_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.send_user IS '发送人';


--
-- Name: COLUMN sys_act_cc_task.receive_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.receive_user IS '接收人';


--
-- Name: COLUMN sys_act_cc_task.text; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_cc_task.text IS '待办配置';


--
-- Name: sys_act_config; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_config (
    tenant_id character varying(32 char) NOT NULL,
    project_address character varying(255 char),
    is_mq_use character varying(255 char),
    is_god_axe character varying(255 char),
    is_multi_tenant character(1 char)
);


ALTER TABLE public.sys_act_config OWNER TO current_user;

--
-- Name: TABLE sys_act_config; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_config IS '配置表';


--
-- Name: COLUMN sys_act_config.tenant_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_config.tenant_id IS '租户ID';


--
-- Name: COLUMN sys_act_config.project_address; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_config.project_address IS '项目地址';


--
-- Name: COLUMN sys_act_config.is_mq_use; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_config.is_mq_use IS '是否启用MQ 1启用 0不启用';


--
-- Name: COLUMN sys_act_config.is_god_axe; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_config.is_god_axe IS '是否天斧 1是 0否';


--
-- Name: COLUMN sys_act_config.is_multi_tenant; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_config.is_multi_tenant IS '是否共库 1是 0否';


--
-- Name: sys_act_entrust; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_entrust (
    id character varying(36 char) NOT NULL,
    consignor character varying(36 char),
    process_id character varying(255 char),
    process_name character varying(255 char),
    consignee character varying(36 char),
    consignee_name character varying(255 char),
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    state character(1 char)
);


ALTER TABLE public.sys_act_entrust OWNER TO current_user;

--
-- Name: TABLE sys_act_entrust; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_entrust IS '委托表';


--
-- Name: COLUMN sys_act_entrust.id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.id IS 'ID主键，UUID';


--
-- Name: COLUMN sys_act_entrust.consignor; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.consignor IS '委托人';


--
-- Name: COLUMN sys_act_entrust.process_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.process_id IS '流程ID';


--
-- Name: COLUMN sys_act_entrust.process_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.process_name IS '流程名称';


--
-- Name: COLUMN sys_act_entrust.consignee; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.consignee IS '被委托人ID';


--
-- Name: COLUMN sys_act_entrust.consignee_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.consignee_name IS '被委托人姓名';


--
-- Name: COLUMN sys_act_entrust.start_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.start_time IS '开始时间';


--
-- Name: COLUMN sys_act_entrust.end_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.end_time IS '结束时间';


--
-- Name: COLUMN sys_act_entrust.state; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_entrust.state IS '状态';


--
-- Name: sys_act_extend_properties; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_extend_properties (
    id character varying(200 char) NOT NULL,
    proc_def_id character varying(64 char),
    task_def_key character varying(64 char),
    task_def_name character varying(1000 char),
    form_detail_key text,
    attribute character varying(32 char)
);


ALTER TABLE public.sys_act_extend_properties OWNER TO current_user;

--
-- Name: TABLE sys_act_extend_properties; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_extend_properties IS '流程拓展信息表';


--
-- Name: COLUMN sys_act_extend_properties.id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.id IS '主键采用流程定义ID和节点ID拼接组成';


--
-- Name: COLUMN sys_act_extend_properties.proc_def_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.proc_def_id IS '流程定义ID';


--
-- Name: COLUMN sys_act_extend_properties.task_def_key; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.task_def_key IS '节点ID';


--
-- Name: COLUMN sys_act_extend_properties.task_def_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.task_def_name IS '节点名称';


--
-- Name: COLUMN sys_act_extend_properties.form_detail_key; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.form_detail_key IS '表单地址';


--
-- Name: COLUMN sys_act_extend_properties.attribute; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_extend_properties.attribute IS '标识扩展的属性类型';


--
-- Name: sys_act_function; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_function (
    function_id character varying(36 char) NOT NULL,
    function_name character varying(255 char),
    function_bean character varying(255 char),
    create_time timestamp without time zone,
    update_time timestamp without time zone
);


ALTER TABLE public.sys_act_function OWNER TO current_user;

--
-- Name: TABLE sys_act_function; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_function IS '函数表';


--
-- Name: COLUMN sys_act_function.function_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function.function_id IS '主键';


--
-- Name: COLUMN sys_act_function.function_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function.function_name IS '函数名称';


--
-- Name: COLUMN sys_act_function.function_bean; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function.function_bean IS '函数BEANID';


--
-- Name: COLUMN sys_act_function.create_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function.create_time IS '创建时间';


--
-- Name: COLUMN sys_act_function.update_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function.update_time IS '修改时间';


--
-- Name: sys_act_function_parm; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_function_parm (
    parm_id character varying(36 char) NOT NULL,
    function_id character varying(36 char),
    parm_name character varying(255 char),
    parm_key character varying(255 char),
    create_time timestamp without time zone,
    update_time timestamp without time zone
);


ALTER TABLE public.sys_act_function_parm OWNER TO current_user;

--
-- Name: TABLE sys_act_function_parm; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_function_parm IS '函数参数表';


--
-- Name: COLUMN sys_act_function_parm.parm_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.parm_id IS '主键';


--
-- Name: COLUMN sys_act_function_parm.function_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.function_id IS '函数主键';


--
-- Name: COLUMN sys_act_function_parm.parm_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.parm_name IS '参数名称';


--
-- Name: COLUMN sys_act_function_parm.parm_key; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.parm_key IS '参数标识';


--
-- Name: COLUMN sys_act_function_parm.create_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.create_time IS '创建时间';


--
-- Name: COLUMN sys_act_function_parm.update_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_function_parm.update_time IS '修改时间';


--
-- Name: sys_act_hi_line; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_hi_line (
    id character varying(32 char) NOT NULL,
    proc_inst_id character varying(64 char),
    proc_def_id character varying(64 char),
    proc_def_key character varying(64 char),
    line_id character varying(64 char),
    complete_time timestamp without time zone,
    complete_user character varying(64 char),
    line_name character varying(256 char),
    process_name character varying(256 char),
    out_node character varying(64 char),
    out_node_name character varying(256 char),
    in_node character varying(64 char),
    in_node_name character varying(256 char)
);


ALTER TABLE public.sys_act_hi_line OWNER TO current_user;

--
-- Name: TABLE sys_act_hi_line; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_hi_line IS '历史线表';


--
-- Name: COLUMN sys_act_hi_line.id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.id IS '主键';


--
-- Name: COLUMN sys_act_hi_line.proc_inst_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.proc_inst_id IS '流程实例ID';


--
-- Name: COLUMN sys_act_hi_line.proc_def_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.proc_def_id IS '流程定义ID';


--
-- Name: COLUMN sys_act_hi_line.proc_def_key; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.proc_def_key IS '流程定义KEY';


--
-- Name: COLUMN sys_act_hi_line.line_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.line_id IS '连线ID';


--
-- Name: COLUMN sys_act_hi_line.complete_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.complete_time IS '办理时间';


--
-- Name: COLUMN sys_act_hi_line.complete_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.complete_user IS '办理人';


--
-- Name: COLUMN sys_act_hi_line.line_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.line_name IS '连线名称';


--
-- Name: COLUMN sys_act_hi_line.process_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.process_name IS '流程名称';


--
-- Name: COLUMN sys_act_hi_line.out_node; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.out_node IS '出线节点';


--
-- Name: COLUMN sys_act_hi_line.out_node_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.out_node_name IS '出线节点名称';


--
-- Name: COLUMN sys_act_hi_line.in_node; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.in_node IS '入线节点';


--
-- Name: COLUMN sys_act_hi_line.in_node_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_hi_line.in_node_name IS '入线节点名称';


--
-- Name: sys_act_interface_log; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_interface_log (
    log_id character varying(32 char) NOT NULL,
    session_id character varying(128 char),
    user_id character varying(32 char),
    user_name character varying(32 char),
    corporation_id character varying(32 char),
    corporation_name character varying(128 char),
    log_time timestamp without time zone,
    remoteaddr character varying(128 char),
    remotehost character varying(128 char),
    remoteport character varying(8 char),
    localaddr character varying(128 char),
    localhost character varying(128 char),
    localport character varying(8 char),
    resource_id character varying(32 char),
    resource_alias character varying(128 char),
    security_level integer,
    log_type character varying(32 char),
    log_type_name character varying(64 char),
    log_content text,
    user_account character varying(32 char),
    level_event character varying(1 char),
    state character varying(1 char)
);


ALTER TABLE public.sys_act_interface_log OWNER TO current_user;

--
-- Name: TABLE sys_act_interface_log; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_interface_log IS '接口日志表';


--
-- Name: COLUMN sys_act_interface_log.log_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.log_id IS '安全日志编码';


--
-- Name: COLUMN sys_act_interface_log.session_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.session_id IS '会话标识';


--
-- Name: COLUMN sys_act_interface_log.user_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.user_id IS '用户账户';


--
-- Name: COLUMN sys_act_interface_log.user_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.user_name IS '用户名称';


--
-- Name: COLUMN sys_act_interface_log.corporation_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.corporation_id IS '公司编码';


--
-- Name: COLUMN sys_act_interface_log.corporation_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.corporation_name IS '公司名称';


--
-- Name: COLUMN sys_act_interface_log.resource_alias; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.resource_alias IS '资源业务语义';


--
-- Name: COLUMN sys_act_interface_log.user_account; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.user_account IS '用户登录账号';


--
-- Name: COLUMN sys_act_interface_log.level_event; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.level_event IS '1系统级/2业务级事件';


--
-- Name: COLUMN sys_act_interface_log.state; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_interface_log.state IS '事件类型';


--
-- Name: sys_act_manage_log; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_manage_log (
    log_id character varying(32 char) NOT NULL,
    session_id character varying(128 char),
    user_id character varying(32 char),
    user_name character varying(32 char),
    corporation_id character varying(32 char),
    corporation_name character varying(128 char),
    log_time timestamp without time zone,
    remoteaddr character varying(128 char),
    remotehost character varying(128 char),
    remoteport character varying(8 char),
    localaddr character varying(128 char),
    localhost character varying(128 char),
    localport character varying(8 char),
    resource_id character varying(32 char),
    resource_alias character varying(128 char),
    security_level integer,
    log_type character varying(32 char),
    log_type_name character varying(64 char),
    log_content text,
    user_account character varying(32 char),
    level_event character varying(1 char),
    state character varying(1 char)
);


ALTER TABLE public.sys_act_manage_log OWNER TO current_user;

--
-- Name: TABLE sys_act_manage_log; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_manage_log IS '操作日志表';


--
-- Name: COLUMN sys_act_manage_log.log_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.log_id IS '安全日志编码';


--
-- Name: COLUMN sys_act_manage_log.session_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.session_id IS '会话标识';


--
-- Name: COLUMN sys_act_manage_log.user_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.user_id IS '用户账户';


--
-- Name: COLUMN sys_act_manage_log.user_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.user_name IS '用户名称';


--
-- Name: COLUMN sys_act_manage_log.corporation_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.corporation_id IS '公司编码';


--
-- Name: COLUMN sys_act_manage_log.corporation_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.corporation_name IS '公司名称';


--
-- Name: COLUMN sys_act_manage_log.resource_alias; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.resource_alias IS '资源业务语义';


--
-- Name: COLUMN sys_act_manage_log.user_account; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.user_account IS '用户登录账号';


--
-- Name: COLUMN sys_act_manage_log.level_event; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.level_event IS '1系统级/2业务级事件';


--
-- Name: COLUMN sys_act_manage_log.state; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_manage_log.state IS '事件类型';


--
-- Name: sys_act_process_file; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_process_file (
    file_id character varying(64 char) NOT NULL,
    process_key character varying(64 char),
    process_id character varying(64 char),
    version integer,
    type character varying(8 char),
    content bytea,
    model_id character varying(64 char),
    tenant_id character varying(64 char),
    create_time timestamp without time zone
);


ALTER TABLE public.sys_act_process_file OWNER TO current_user;

--
-- Name: TABLE sys_act_process_file; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_process_file IS '工作流文件表';


--
-- Name: COLUMN sys_act_process_file.file_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.file_id IS '文件ID';


--
-- Name: COLUMN sys_act_process_file.process_key; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.process_key IS '流程标识';


--
-- Name: COLUMN sys_act_process_file.process_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.process_id IS '流程ID';


--
-- Name: COLUMN sys_act_process_file.version; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.version IS '版本号';


--
-- Name: COLUMN sys_act_process_file.type; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.type IS '文件类型';


--
-- Name: COLUMN sys_act_process_file.content; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.content IS '文件内容';


--
-- Name: COLUMN sys_act_process_file.model_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.model_id IS '模块ID';


--
-- Name: COLUMN sys_act_process_file.tenant_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.tenant_id IS '租户ID';


--
-- Name: COLUMN sys_act_process_file.create_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_process_file.create_time IS '创建时间';


--
-- Name: sys_act_timeout_activity; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_timeout_activity (
    task_id character varying(64 char) NOT NULL,
    assignee character varying(255 char),
    due_time timestamp(0) without time zone,
    create_time timestamp(0) without time zone,
    time_out_type character varying(255 char),
    tenant_id character varying(255 char),
    map character varying(2000 char)
);


ALTER TABLE public.sys_act_timeout_activity OWNER TO current_user;

--
-- Name: TABLE sys_act_timeout_activity; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_timeout_activity IS '超时信息表';


--
-- Name: COLUMN sys_act_timeout_activity.task_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.task_id IS '任务id';


--
-- Name: COLUMN sys_act_timeout_activity.assignee; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.assignee IS '参与者';


--
-- Name: COLUMN sys_act_timeout_activity.due_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.due_time IS '到期时间';


--
-- Name: COLUMN sys_act_timeout_activity.create_time; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.create_time IS '开始时间';


--
-- Name: COLUMN sys_act_timeout_activity.time_out_type; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.time_out_type IS '超时处理类型';


--
-- Name: COLUMN sys_act_timeout_activity.tenant_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.tenant_id IS '租户id';


--
-- Name: COLUMN sys_act_timeout_activity.map; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_timeout_activity.map IS '接口类型额外参数';


--
-- Name: sys_act_urge_task; Type: TABLE; Schema: public; Owner: current_user
--

CREATE TABLE public.sys_act_urge_task (
    id character varying(32 char) NOT NULL,
    task_id character varying(64 char),
    proc_inst_id character varying(64 char),
    proc_name character varying(255 char),
    task_name character varying(255 char),
    send_user character varying(32 char),
    receive_user character varying(32 char),
    send_time timestamp(0) without time zone,
    form_key character varying(1000 char),
    proc_def_key character varying(64 char),
    business_id character varying(255 char),
    task_def_key character varying(64 char),
    text text
);


ALTER TABLE public.sys_act_urge_task OWNER TO current_user;

--
-- Name: TABLE sys_act_urge_task; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON TABLE public.sys_act_urge_task IS '催办表';


--
-- Name: COLUMN sys_act_urge_task.id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.id IS '主键';


--
-- Name: COLUMN sys_act_urge_task.task_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.task_id IS '任务ID';


--
-- Name: COLUMN sys_act_urge_task.proc_inst_id; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.proc_inst_id IS '实例ID';


--
-- Name: COLUMN sys_act_urge_task.proc_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.proc_name IS '流程名称';


--
-- Name: COLUMN sys_act_urge_task.task_name; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.task_name IS '任务名称';


--
-- Name: COLUMN sys_act_urge_task.send_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.send_user IS '发送人';


--
-- Name: COLUMN sys_act_urge_task.receive_user; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.receive_user IS '接收人';


--
-- Name: COLUMN sys_act_urge_task.text; Type: COMMENT; Schema: public; Owner: current_user
--

COMMENT ON COLUMN public.sys_act_urge_task.text IS '待办配置';


--
-- Name: act_evt_log log_nr_; Type: DEFAULT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_evt_log ALTER COLUMN log_nr_ SET DEFAULT nextval('act_evt_log_log_nr__seq'::regclass);


--
-- Data for Name: act_evt_log; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ge_bytearray; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ge_property; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_actinst; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_attachment; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_comment; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_detail; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_identitylink; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_procinst; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_taskinst; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_hi_varinst; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_id_group; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_id_info; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_id_membership; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_id_user; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_procdef_info; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_re_deployment; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_re_model; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_re_procdef; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_event_subscr; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_execution; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_identitylink; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_job; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_task; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: act_ru_variable; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_cc_task; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_config; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_entrust; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_extend_properties; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_function; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_function_parm; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_hi_line; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_interface_log; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_manage_log; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_process_file; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_timeout_activity; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Data for Name: sys_act_urge_task; Type: TABLE DATA; Schema: public; Owner: current_user
--



--
-- Name: act_evt_log_log_nr__seq; Type: SEQUENCE SET; Schema: public; Owner: current_user
--

SELECT pg_catalog.setval('public.act_evt_log_log_nr__seq', 1, false);


--
-- Name: act_procdef_info act_uniq_info_procdef; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_procdef_info
    ADD CONSTRAINT act_uniq_info_procdef UNIQUE (proc_def_id_);


--
-- Name: act_re_procdef act_uniq_procdef; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_procdef
    ADD CONSTRAINT act_uniq_procdef UNIQUE (key_, version_, tenant_id_);


--
-- Name: act_ru_variable primary; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_variable
    ADD CONSTRAINT "primary" PRIMARY KEY (id_);


--
-- Name: act_evt_log primary_1; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_evt_log
    ADD CONSTRAINT primary_1 PRIMARY KEY (log_nr_);


--
-- Name: act_hi_taskinst primary_10; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_taskinst
    ADD CONSTRAINT primary_10 PRIMARY KEY (id_);


--
-- Name: act_hi_varinst primary_11; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_varinst
    ADD CONSTRAINT primary_11 PRIMARY KEY (id_);


--
-- Name: act_id_group primary_12; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_group
    ADD CONSTRAINT primary_12 PRIMARY KEY (id_);


--
-- Name: act_id_info primary_13; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_info
    ADD CONSTRAINT primary_13 PRIMARY KEY (id_);


--
-- Name: act_id_membership primary_14; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_membership
    ADD CONSTRAINT primary_14 PRIMARY KEY (group_id_, user_id_);


--
-- Name: act_id_user primary_15; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_user
    ADD CONSTRAINT primary_15 PRIMARY KEY (id_);


--
-- Name: act_procdef_info primary_16; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_procdef_info
    ADD CONSTRAINT primary_16 PRIMARY KEY (id_);


--
-- Name: act_re_deployment primary_17; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_deployment
    ADD CONSTRAINT primary_17 PRIMARY KEY (id_);


--
-- Name: act_re_model primary_18; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_model
    ADD CONSTRAINT primary_18 PRIMARY KEY (id_);


--
-- Name: act_re_procdef primary_19; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_procdef
    ADD CONSTRAINT primary_19 PRIMARY KEY (id_);


--
-- Name: act_ge_bytearray primary_2; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ge_bytearray
    ADD CONSTRAINT primary_2 PRIMARY KEY (id_);


--
-- Name: act_ru_event_subscr primary_20; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_event_subscr
    ADD CONSTRAINT primary_20 PRIMARY KEY (id_);


--
-- Name: act_ru_execution primary_21; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_execution
    ADD CONSTRAINT primary_21 PRIMARY KEY (id_);


--
-- Name: act_ru_identitylink primary_22; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_identitylink
    ADD CONSTRAINT primary_22 PRIMARY KEY (id_);


--
-- Name: act_ru_job primary_23; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_job
    ADD CONSTRAINT primary_23 PRIMARY KEY (id_);


--
-- Name: act_ru_task primary_24; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_task
    ADD CONSTRAINT primary_24 PRIMARY KEY (id_);


--
-- Name: sys_act_cc_task primary_25; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_cc_task
    ADD CONSTRAINT primary_25 PRIMARY KEY (id);


--
-- Name: sys_act_config primary_26; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_config
    ADD CONSTRAINT primary_26 PRIMARY KEY (tenant_id);


--
-- Name: sys_act_entrust primary_27; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_entrust
    ADD CONSTRAINT primary_27 PRIMARY KEY (id);


--
-- Name: sys_act_extend_properties primary_28; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_extend_properties
    ADD CONSTRAINT primary_28 PRIMARY KEY (id);


--
-- Name: sys_act_function primary_29; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_function
    ADD CONSTRAINT primary_29 PRIMARY KEY (function_id);


--
-- Name: act_ge_property primary_3; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ge_property
    ADD CONSTRAINT primary_3 PRIMARY KEY (name_);


--
-- Name: sys_act_function_parm primary_30; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_function_parm
    ADD CONSTRAINT primary_30 PRIMARY KEY (parm_id);


--
-- Name: sys_act_hi_line primary_31; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_hi_line
    ADD CONSTRAINT primary_31 PRIMARY KEY (id);


--
-- Name: sys_act_interface_log primary_32; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_interface_log
    ADD CONSTRAINT primary_32 PRIMARY KEY (log_id);


--
-- Name: sys_act_manage_log primary_33; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_manage_log
    ADD CONSTRAINT primary_33 PRIMARY KEY (log_id);


--
-- Name: sys_act_process_file primary_34; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_process_file
    ADD CONSTRAINT primary_34 PRIMARY KEY (file_id);


--
-- Name: sys_act_timeout_activity primary_35; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_timeout_activity
    ADD CONSTRAINT primary_35 PRIMARY KEY (task_id);


--
-- Name: sys_act_urge_task primary_36; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.sys_act_urge_task
    ADD CONSTRAINT primary_36 PRIMARY KEY (id);


--
-- Name: act_hi_identitylink primary_37; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_identitylink
    ADD CONSTRAINT primary_37 PRIMARY KEY (id_);


--
-- Name: act_hi_actinst primary_4; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_actinst
    ADD CONSTRAINT primary_4 PRIMARY KEY (id_);


--
-- Name: act_hi_attachment primary_5; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_attachment
    ADD CONSTRAINT primary_5 PRIMARY KEY (id_);


--
-- Name: act_hi_comment primary_6; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_comment
    ADD CONSTRAINT primary_6 PRIMARY KEY (id_);


--
-- Name: act_hi_detail primary_7; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_detail
    ADD CONSTRAINT primary_7 PRIMARY KEY (id_);


--
-- Name: act_hi_procinst primary_9; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_procinst
    ADD CONSTRAINT primary_9 PRIMARY KEY (id_);


--
-- Name: act_hi_procinst proc_inst_id_; Type: CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_hi_procinst
    ADD CONSTRAINT proc_inst_id_ UNIQUE (proc_inst_id_);


--
-- Name: act_fk_bytearr_depl; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_bytearr_depl ON public.act_ge_bytearray USING btree (deployment_id_);


--
-- Name: act_fk_event_exec; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_event_exec ON public.act_ru_event_subscr USING btree (execution_id_);


--
-- Name: act_fk_exe_parent; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_exe_parent ON public.act_ru_execution USING btree (parent_id_);


--
-- Name: act_fk_exe_procdef; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_exe_procdef ON public.act_ru_execution USING btree (proc_def_id_);


--
-- Name: act_fk_exe_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_exe_procinst ON public.act_ru_execution USING btree (proc_inst_id_);


--
-- Name: act_fk_exe_super; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_exe_super ON public.act_ru_execution USING btree (super_exec_);


--
-- Name: act_fk_idl_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_idl_procinst ON public.act_ru_identitylink USING btree (proc_inst_id_);


--
-- Name: act_fk_info_json_ba; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_info_json_ba ON public.act_procdef_info USING btree (info_json_id_);


--
-- Name: act_fk_job_exception; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_job_exception ON public.act_ru_job USING btree (exception_stack_id_);


--
-- Name: act_fk_memb_group; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_memb_group ON public.act_id_membership USING btree (group_id_);


--
-- Name: act_fk_model_deployment; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_model_deployment ON public.act_re_model USING btree (deployment_id_);


--
-- Name: act_fk_model_source; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_model_source ON public.act_re_model USING btree (editor_source_value_id_);


--
-- Name: act_fk_model_source_extra; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_model_source_extra ON public.act_re_model USING btree (editor_source_extra_value_id_);


--
-- Name: act_fk_task_exe; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_task_exe ON public.act_ru_task USING btree (execution_id_);


--
-- Name: act_fk_task_procdef; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_task_procdef ON public.act_ru_task USING btree (proc_def_id_);


--
-- Name: act_fk_task_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_task_procinst ON public.act_ru_task USING btree (proc_inst_id_);


--
-- Name: act_fk_tskass_task; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_tskass_task ON public.act_ru_identitylink USING btree (task_id_);


--
-- Name: act_fk_var_bytearray; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_var_bytearray ON public.act_ru_variable USING btree (bytearray_id_);


--
-- Name: act_fk_var_exe; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_var_exe ON public.act_ru_variable USING btree (execution_id_);


--
-- Name: act_fk_var_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_fk_var_procinst ON public.act_ru_variable USING btree (proc_inst_id_);


--
-- Name: act_idx_athrz_procedef; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_athrz_procedef ON public.act_ru_identitylink USING btree (proc_def_id_);


--
-- Name: act_idx_event_subscr_config_; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_event_subscr_config_ ON public.act_ru_event_subscr USING btree (configuration_);


--
-- Name: act_idx_exec_buskey; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_exec_buskey ON public.act_ru_execution USING btree (business_key_);


--
-- Name: act_idx_hi_act_inst_end; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_act_inst_end ON public.act_hi_actinst USING btree (end_time_);


--
-- Name: act_idx_hi_act_inst_exec; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_act_inst_exec ON public.act_hi_actinst USING btree (execution_id_, act_id_);


--
-- Name: act_idx_hi_act_inst_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_act_inst_procinst ON public.act_hi_actinst USING btree (proc_inst_id_, act_id_);


--
-- Name: act_idx_hi_act_inst_start; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_act_inst_start ON public.act_hi_actinst USING btree (start_time_);


--
-- Name: act_idx_hi_detail_act_inst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_detail_act_inst ON public.act_hi_detail USING btree (act_inst_id_);


--
-- Name: act_idx_hi_detail_name; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_detail_name ON public.act_hi_detail USING btree (name_);


--
-- Name: act_idx_hi_detail_proc_inst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_detail_proc_inst ON public.act_hi_detail USING btree (proc_inst_id_);


--
-- Name: act_idx_hi_detail_task_id; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_detail_task_id ON public.act_hi_detail USING btree (task_id_);


--
-- Name: act_idx_hi_detail_time; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_detail_time ON public.act_hi_detail USING btree (time_);


--
-- Name: act_idx_hi_ident_lnk_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_ident_lnk_procinst ON public.act_hi_identitylink USING btree (proc_inst_id_);


--
-- Name: act_idx_hi_ident_lnk_task; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_ident_lnk_task ON public.act_hi_identitylink USING btree (task_id_);


--
-- Name: act_idx_hi_ident_lnk_user; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_ident_lnk_user ON public.act_hi_identitylink USING btree (user_id_);


--
-- Name: act_idx_hi_pro_i_buskey; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_pro_i_buskey ON public.act_hi_procinst USING btree (business_key_);


--
-- Name: act_idx_hi_pro_inst_end; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_pro_inst_end ON public.act_hi_procinst USING btree (end_time_);


--
-- Name: act_idx_hi_procvar_name_type; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_procvar_name_type ON public.act_hi_varinst USING btree (name_, var_type_);


--
-- Name: act_idx_hi_procvar_proc_inst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_procvar_proc_inst ON public.act_hi_varinst USING btree (proc_inst_id_);


--
-- Name: act_idx_hi_procvar_task_id; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_procvar_task_id ON public.act_hi_varinst USING btree (task_id_);


--
-- Name: act_idx_hi_task_inst_procinst; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_hi_task_inst_procinst ON public.act_hi_taskinst USING btree (proc_inst_id_);


--
-- Name: act_idx_ident_lnk_group; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_ident_lnk_group ON public.act_ru_identitylink USING btree (group_id_);


--
-- Name: act_idx_ident_lnk_user; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_ident_lnk_user ON public.act_ru_identitylink USING btree (user_id_);


--
-- Name: act_idx_info_procdef; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_info_procdef ON public.act_procdef_info USING btree (proc_def_id_);


--
-- Name: act_idx_task_create; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_task_create ON public.act_ru_task USING btree (create_time_);


--
-- Name: act_idx_variable_task_id; Type: INDEX; Schema: public; Owner: current_user
--

CREATE INDEX act_idx_variable_task_id ON public.act_ru_variable USING btree (task_id_);


--
-- Name: act_ge_bytearray act_ge_bytearray_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ge_bytearray
    ADD CONSTRAINT act_ge_bytearray_ibfk_1 FOREIGN KEY (deployment_id_) REFERENCES act_re_deployment(id_);


--
-- Name: act_id_membership act_id_membership_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_membership
    ADD CONSTRAINT act_id_membership_ibfk_1 FOREIGN KEY (group_id_) REFERENCES act_id_group(id_);


--
-- Name: act_id_membership act_id_membership_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_id_membership
    ADD CONSTRAINT act_id_membership_ibfk_2 FOREIGN KEY (user_id_) REFERENCES act_id_user(id_);


--
-- Name: act_procdef_info act_procdef_info_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_procdef_info
    ADD CONSTRAINT act_procdef_info_ibfk_1 FOREIGN KEY (info_json_id_) REFERENCES act_ge_bytearray(id_);


--
-- Name: act_procdef_info act_procdef_info_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_procdef_info
    ADD CONSTRAINT act_procdef_info_ibfk_2 FOREIGN KEY (proc_def_id_) REFERENCES act_re_procdef(id_);


--
-- Name: act_re_model act_re_model_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_model
    ADD CONSTRAINT act_re_model_ibfk_1 FOREIGN KEY (deployment_id_) REFERENCES act_re_deployment(id_);


--
-- Name: act_re_model act_re_model_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_model
    ADD CONSTRAINT act_re_model_ibfk_2 FOREIGN KEY (editor_source_value_id_) REFERENCES act_ge_bytearray(id_);


--
-- Name: act_re_model act_re_model_ibfk_3; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_re_model
    ADD CONSTRAINT act_re_model_ibfk_3 FOREIGN KEY (editor_source_extra_value_id_) REFERENCES act_ge_bytearray(id_);


--
-- Name: act_ru_event_subscr act_ru_event_subscr_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_event_subscr
    ADD CONSTRAINT act_ru_event_subscr_ibfk_1 FOREIGN KEY (execution_id_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_execution act_ru_execution_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_execution
    ADD CONSTRAINT act_ru_execution_ibfk_1 FOREIGN KEY (parent_id_) REFERENCES act_ru_execution(id_) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: act_ru_execution act_ru_execution_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_execution
    ADD CONSTRAINT act_ru_execution_ibfk_2 FOREIGN KEY (proc_def_id_) REFERENCES act_re_procdef(id_);


--
-- Name: act_ru_execution act_ru_execution_ibfk_3; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_execution
    ADD CONSTRAINT act_ru_execution_ibfk_3 FOREIGN KEY (proc_inst_id_) REFERENCES act_ru_execution(id_) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: act_ru_execution act_ru_execution_ibfk_4; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_execution
    ADD CONSTRAINT act_ru_execution_ibfk_4 FOREIGN KEY (super_exec_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_identitylink act_ru_identitylink_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_identitylink
    ADD CONSTRAINT act_ru_identitylink_ibfk_1 FOREIGN KEY (proc_def_id_) REFERENCES act_re_procdef(id_);


--
-- Name: act_ru_identitylink act_ru_identitylink_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_identitylink
    ADD CONSTRAINT act_ru_identitylink_ibfk_2 FOREIGN KEY (proc_inst_id_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_identitylink act_ru_identitylink_ibfk_3; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_identitylink
    ADD CONSTRAINT act_ru_identitylink_ibfk_3 FOREIGN KEY (task_id_) REFERENCES act_ru_task(id_);


--
-- Name: act_ru_job act_ru_job_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_job
    ADD CONSTRAINT act_ru_job_ibfk_1 FOREIGN KEY (exception_stack_id_) REFERENCES act_ge_bytearray(id_);


--
-- Name: act_ru_task act_ru_task_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_task
    ADD CONSTRAINT act_ru_task_ibfk_1 FOREIGN KEY (execution_id_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_task act_ru_task_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_task
    ADD CONSTRAINT act_ru_task_ibfk_2 FOREIGN KEY (proc_def_id_) REFERENCES act_re_procdef(id_);


--
-- Name: act_ru_task act_ru_task_ibfk_3; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_task
    ADD CONSTRAINT act_ru_task_ibfk_3 FOREIGN KEY (proc_inst_id_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_variable act_ru_variable_ibfk_1; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_variable
    ADD CONSTRAINT act_ru_variable_ibfk_1 FOREIGN KEY (bytearray_id_) REFERENCES act_ge_bytearray(id_);


--
-- Name: act_ru_variable act_ru_variable_ibfk_2; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_variable
    ADD CONSTRAINT act_ru_variable_ibfk_2 FOREIGN KEY (execution_id_) REFERENCES act_ru_execution(id_);


--
-- Name: act_ru_variable act_ru_variable_ibfk_3; Type: FK CONSTRAINT; Schema: public; Owner: current_user
--

ALTER TABLE ONLY public.act_ru_variable
    ADD CONSTRAINT act_ru_variable_ibfk_3 FOREIGN KEY (proc_inst_id_) REFERENCES act_ru_execution(id_);


--
-- Name: SCHEMA sys; Type: ACL; Schema: -; Owner: current_user
--

GRANT USAGE ON SCHEMA sys TO PUBLIC;


--
-- Name: SCHEMA sys_catalog; Type: ACL; Schema: -; Owner: current_user
--

GRANT USAGE ON SCHEMA sys_catalog TO PUBLIC;


--
-- Name: FUNCTION sys_config(name OUT text, setting OUT text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_config(name OUT text, setting OUT text) FROM PUBLIC;


--
-- Name: FUNCTION sys_create_restore_point(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_create_restore_point(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_current_logfile(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_current_logfile() FROM PUBLIC;


--
-- Name: FUNCTION sys_current_logfile(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_current_logfile(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_hba_file_rules(line_number OUT integer, type OUT text, database OUT text[], user_name OUT text[], address OUT text, netmask OUT text, auth_method OUT text, options OUT text[], error OUT text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_hba_file_rules(line_number OUT integer, type OUT text, database OUT text[], user_name OUT text[], address OUT text, netmask OUT text, auth_method OUT text, options OUT text[], error OUT text) FROM PUBLIC;


--
-- Name: FUNCTION sys_ls_archive_statusdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_archive_statusdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) FROM PUBLIC;
GRANT ALL ON FUNCTION sys_catalog.sys_ls_archive_statusdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) TO pg_monitor;


--
-- Name: FUNCTION sys_ls_dir(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_dir(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_ls_dir(text, boolean, boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_dir(text, boolean, boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_ls_logdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_logdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) FROM PUBLIC;
GRANT ALL ON FUNCTION sys_catalog.sys_ls_logdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) TO pg_monitor;


--
-- Name: FUNCTION sys_ls_tmpdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_tmpdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) FROM PUBLIC;
GRANT ALL ON FUNCTION sys_catalog.sys_ls_tmpdir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) TO pg_monitor;


--
-- Name: FUNCTION sys_ls_tmpdir(tablespace oid, name OUT text, size OUT bigint, modification OUT timestamp with time zone); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_tmpdir(tablespace oid, name OUT text, size OUT bigint, modification OUT timestamp with time zone) FROM PUBLIC;
GRANT ALL ON FUNCTION sys_catalog.sys_ls_tmpdir(tablespace oid, name OUT text, size OUT bigint, modification OUT timestamp with time zone) TO pg_monitor;


--
-- Name: FUNCTION sys_ls_waldir(name OUT text, size OUT bigint, modification OUT timestamp with time zone); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_ls_waldir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) FROM PUBLIC;
GRANT ALL ON FUNCTION sys_catalog.sys_ls_waldir(name OUT text, size OUT bigint, modification OUT timestamp with time zone) TO pg_monitor;


--
-- Name: FUNCTION sys_promote(wait boolean, wait_seconds integer); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_promote(wait boolean, wait_seconds integer) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_binary_file(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_binary_file(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_binary_file(text, bigint, bigint); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_binary_file(text, bigint, bigint) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_binary_file(text, bigint, bigint, boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_binary_file(text, bigint, bigint, boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_file(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_file(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_file(text, bigint, bigint); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_file(text, bigint, bigint) FROM PUBLIC;


--
-- Name: FUNCTION sys_read_file(text, bigint, bigint, boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_read_file(text, bigint, bigint, boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_rotate_logfile(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_rotate_logfile() FROM PUBLIC;


--
-- Name: FUNCTION sys_show_all_file_settings(sourcefile OUT text, sourceline OUT integer, seqno OUT integer, name OUT text, setting OUT text, applied OUT boolean, error OUT text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_show_all_file_settings(sourcefile OUT text, sourceline OUT integer, seqno OUT integer, name OUT text, setting OUT text, applied OUT boolean, error OUT text) FROM PUBLIC;


--
-- Name: FUNCTION sys_start_backup(label text, fast boolean, exclusive boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_start_backup(label text, fast boolean, exclusive boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_file(filename text, size OUT bigint, access OUT timestamp with time zone, modification OUT timestamp with time zone, change OUT timestamp with time zone, creation OUT timestamp with time zone, isdir OUT boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_file(filename text, size OUT bigint, access OUT timestamp with time zone, modification OUT timestamp with time zone, change OUT timestamp with time zone, creation OUT timestamp with time zone, isdir OUT boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_file(filename text, missing_ok boolean, size OUT bigint, access OUT timestamp with time zone, modification OUT timestamp with time zone, change OUT timestamp with time zone, creation OUT timestamp with time zone, isdir OUT boolean); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_file(filename text, missing_ok boolean, size OUT bigint, access OUT timestamp with time zone, modification OUT timestamp with time zone, change OUT timestamp with time zone, creation OUT timestamp with time zone, isdir OUT boolean) FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_reset(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_reset() FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_reset_shared(text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_reset_shared(text) FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_reset_single_function_counters(oid); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_reset_single_function_counters(oid) FROM PUBLIC;


--
-- Name: FUNCTION sys_stat_reset_single_table_counters(oid); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stat_reset_single_table_counters(oid) FROM PUBLIC;


--
-- Name: FUNCTION sys_stop_backup(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stop_backup() FROM PUBLIC;


--
-- Name: FUNCTION sys_stop_backup(exclusive boolean, wait_for_archive boolean, lsn OUT pg_lsn, labelfile OUT text, spcmapfile OUT text); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_stop_backup(exclusive boolean, wait_for_archive boolean, lsn OUT pg_lsn, labelfile OUT text, spcmapfile OUT text) FROM PUBLIC;


--
-- Name: FUNCTION sys_switch_wal(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_switch_wal() FROM PUBLIC;


--
-- Name: FUNCTION sys_wal_replay_pause(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_wal_replay_pause() FROM PUBLIC;


--
-- Name: FUNCTION sys_wal_replay_resume(); Type: ACL; Schema: sys_catalog; Owner: current_user
--

REVOKE ALL ON FUNCTION sys_catalog.sys_wal_replay_resume() FROM PUBLIC;


--
-- Name: TABLE pg_triggers; Type: ACL; Schema: pg_catalog; Owner: current_user
--

GRANT SELECT ON TABLE pg_catalog.pg_triggers TO PUBLIC;


--
-- Name: TABLE all_col_comments; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_col_comments TO PUBLIC;


--
-- Name: TABLE all_col_privs; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_col_privs TO PUBLIC;


--
-- Name: TABLE all_cons_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_cons_columns TO PUBLIC;


--
-- Name: TABLE all_constraints; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_constraints TO PUBLIC;


--
-- Name: TABLE all_db_links; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_db_links TO PUBLIC;


--
-- Name: TABLE all_directories; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_directories TO PUBLIC;


--
-- Name: TABLE all_ind_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_ind_columns TO PUBLIC;


--
-- Name: TABLE all_indexes; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_indexes TO PUBLIC;


--
-- Name: TABLE all_objects; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_objects TO PUBLIC;


--
-- Name: TABLE all_sequences; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_sequences TO PUBLIC;


--
-- Name: TABLE all_source; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_source TO PUBLIC;


--
-- Name: TABLE all_synonyms; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_synonyms TO PUBLIC;


--
-- Name: TABLE all_tab_cols; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_tab_cols TO PUBLIC;


--
-- Name: TABLE all_tab_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_tab_columns TO PUBLIC;


--
-- Name: TABLE all_tab_comments; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_tab_comments TO PUBLIC;


--
-- Name: TABLE all_tab_privs; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_tab_privs TO PUBLIC;


--
-- Name: TABLE all_tables; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_tables TO PUBLIC;


--
-- Name: TABLE all_trigger_cols; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_trigger_cols TO PUBLIC;


--
-- Name: TABLE all_triggers; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_triggers TO PUBLIC;


--
-- Name: TABLE all_users; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_users TO PUBLIC;


--
-- Name: TABLE all_views; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.all_views TO PUBLIC;


--
-- Name: TABLE dual; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.dual TO PUBLIC;


--
-- Name: TABLE sys_session; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.sys_session TO PUBLIC;


--
-- Name: TABLE user_col_comments; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_col_comments TO PUBLIC;


--
-- Name: TABLE user_col_privs; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_col_privs TO PUBLIC;


--
-- Name: TABLE user_cons_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_cons_columns TO PUBLIC;


--
-- Name: TABLE user_constraints; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_constraints TO PUBLIC;


--
-- Name: TABLE user_db_links; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_db_links TO PUBLIC;


--
-- Name: TABLE user_directories; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_directories TO PUBLIC;


--
-- Name: TABLE user_ind_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_ind_columns TO PUBLIC;


--
-- Name: TABLE user_indexes; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_indexes TO PUBLIC;


--
-- Name: TABLE user_objects; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_objects TO PUBLIC;


--
-- Name: TABLE user_role_privs; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_role_privs TO PUBLIC;


--
-- Name: TABLE user_sequences; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_sequences TO PUBLIC;


--
-- Name: TABLE user_source; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_source TO PUBLIC;


--
-- Name: TABLE user_synonyms; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_synonyms TO PUBLIC;


--
-- Name: TABLE user_tab_cols; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tab_cols TO PUBLIC;


--
-- Name: TABLE user_tab_columns; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tab_columns TO PUBLIC;


--
-- Name: TABLE user_tab_comments; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tab_comments TO PUBLIC;


--
-- Name: TABLE user_tab_privs; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tab_privs TO PUBLIC;


--
-- Name: TABLE user_table_cols; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_table_cols TO PUBLIC;


--
-- Name: TABLE user_tables; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tables TO PUBLIC;


--
-- Name: TABLE user_tablespace; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tablespace TO PUBLIC;


--
-- Name: TABLE user_tablespaces; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_tablespaces TO PUBLIC;


--
-- Name: TABLE user_trigger_cols; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_trigger_cols TO PUBLIC;


--
-- Name: TABLE user_triggers; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_triggers TO PUBLIC;


--
-- Name: TABLE user_users; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_users TO PUBLIC;


--
-- Name: TABLE user_views; Type: ACL; Schema: sys; Owner: current_user
--

GRANT SELECT ON TABLE sys.user_views TO PUBLIC;


--
-- Name: TABLE sys_aggregate; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_aggregate TO PUBLIC;


--
-- Name: TABLE sys_am; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_am TO PUBLIC;


--
-- Name: TABLE sys_amop; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_amop TO PUBLIC;


--
-- Name: TABLE sys_amproc; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_amproc TO PUBLIC;


--
-- Name: TABLE sys_attrdef; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_attrdef TO PUBLIC;


--
-- Name: TABLE sys_attribute; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_attribute TO PUBLIC;


--
-- Name: TABLE sys_auth_members; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_auth_members TO PUBLIC;


--
-- Name: TABLE sys_available_extension_versions; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_available_extension_versions TO PUBLIC;


--
-- Name: TABLE sys_available_extensions; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_available_extensions TO PUBLIC;


--
-- Name: TABLE sys_cast; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_cast TO PUBLIC;


--
-- Name: TABLE sys_class; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_class TO PUBLIC;


--
-- Name: TABLE sys_collation; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_collation TO PUBLIC;


--
-- Name: TABLE sys_constraint; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_constraint TO PUBLIC;


--
-- Name: TABLE sys_constraint_status; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_constraint_status TO PUBLIC;


--
-- Name: TABLE sys_conversion; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_conversion TO PUBLIC;


--
-- Name: TABLE sys_cursors; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_cursors TO PUBLIC;


--
-- Name: TABLE sys_database; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_database TO PUBLIC;


--
-- Name: TABLE sys_db_role_setting; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_db_role_setting TO PUBLIC;


--
-- Name: TABLE sys_default_acl; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_default_acl TO PUBLIC;


--
-- Name: TABLE sys_depend; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_depend TO PUBLIC;


--
-- Name: TABLE sys_description; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_description TO PUBLIC;


--
-- Name: TABLE sys_enum; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_enum TO PUBLIC;


--
-- Name: TABLE sys_event_trigger; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_event_trigger TO PUBLIC;


--
-- Name: TABLE sys_extension; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_extension TO PUBLIC;


--
-- Name: TABLE sys_foreign_data_wrapper; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_foreign_data_wrapper TO PUBLIC;


--
-- Name: TABLE sys_foreign_server; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_foreign_server TO PUBLIC;


--
-- Name: TABLE sys_foreign_table; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_foreign_table TO PUBLIC;


--
-- Name: TABLE sys_group; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_group TO PUBLIC;


--
-- Name: TABLE sys_index; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_index TO PUBLIC;


--
-- Name: TABLE sys_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_indexes TO PUBLIC;


--
-- Name: TABLE sys_inherits; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_inherits TO PUBLIC;


--
-- Name: TABLE sys_init_privs; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_init_privs TO PUBLIC;


--
-- Name: TABLE sys_language; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_language TO PUBLIC;


--
-- Name: TABLE sys_largeobject_metadata; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_largeobject_metadata TO PUBLIC;


--
-- Name: TABLE sys_locks; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_locks TO PUBLIC;


--
-- Name: TABLE sys_matviews; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_matviews TO PUBLIC;


--
-- Name: TABLE sys_namespace; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_namespace TO PUBLIC;


--
-- Name: TABLE sys_opclass; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_opclass TO PUBLIC;


--
-- Name: TABLE sys_operator; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_operator TO PUBLIC;


--
-- Name: TABLE sys_opfamily; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_opfamily TO PUBLIC;


--
-- Name: TABLE sys_partitioned_table; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_partitioned_table TO PUBLIC;


--
-- Name: TABLE sys_pltemplate; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_pltemplate TO PUBLIC;


--
-- Name: TABLE sys_policies; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_policies TO PUBLIC;


--
-- Name: TABLE sys_policy; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_policy TO PUBLIC;


--
-- Name: TABLE sys_prepared_statements; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_prepared_statements TO PUBLIC;


--
-- Name: TABLE sys_prepared_xacts; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_prepared_xacts TO PUBLIC;


--
-- Name: TABLE sys_proc; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_proc TO PUBLIC;


--
-- Name: TABLE sys_publication; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_publication TO PUBLIC;


--
-- Name: TABLE sys_publication_rel; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_publication_rel TO PUBLIC;


--
-- Name: TABLE sys_publication_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_publication_tables TO PUBLIC;


--
-- Name: TABLE sys_range; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_range TO PUBLIC;


--
-- Name: TABLE sys_replication_origin; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_replication_origin TO PUBLIC;


--
-- Name: TABLE sys_replication_slots; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_replication_slots TO PUBLIC;


--
-- Name: TABLE sys_rewrite; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_rewrite TO PUBLIC;


--
-- Name: TABLE sys_roles; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_roles TO PUBLIC;


--
-- Name: TABLE sys_rules; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_rules TO PUBLIC;


--
-- Name: TABLE sys_seclabel; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_seclabel TO PUBLIC;


--
-- Name: TABLE sys_seclabels; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_seclabels TO PUBLIC;


--
-- Name: TABLE sys_sequence; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_sequence TO PUBLIC;


--
-- Name: TABLE sys_sequences; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_sequences TO PUBLIC;


--
-- Name: TABLE sys_settings; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_settings TO PUBLIC;


--
-- Name: TABLE sys_shdepend; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_shdepend TO PUBLIC;


--
-- Name: TABLE sys_shdescription; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_shdescription TO PUBLIC;


--
-- Name: TABLE sys_shseclabel; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_shseclabel TO PUBLIC;


--
-- Name: TABLE sys_stat_activity; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_activity TO PUBLIC;


--
-- Name: TABLE sys_stat_all_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_all_indexes TO PUBLIC;


--
-- Name: TABLE sys_stat_all_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_all_tables TO PUBLIC;


--
-- Name: TABLE sys_stat_archiver; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_archiver TO PUBLIC;


--
-- Name: TABLE sys_stat_bgwriter; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_bgwriter TO PUBLIC;


--
-- Name: TABLE sys_stat_database; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_database TO PUBLIC;


--
-- Name: TABLE sys_stat_database_conflicts; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_database_conflicts TO PUBLIC;


--
-- Name: TABLE sys_stat_gssapi; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_gssapi TO PUBLIC;


--
-- Name: TABLE sys_stat_msgaccum; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_msgaccum TO PUBLIC;


--
-- Name: TABLE sys_stat_progress_cluster; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_progress_cluster TO PUBLIC;


--
-- Name: TABLE sys_stat_progress_create_index; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_progress_create_index TO PUBLIC;


--
-- Name: TABLE sys_stat_progress_vacuum; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_progress_vacuum TO PUBLIC;


--
-- Name: TABLE sys_stat_replication; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_replication TO PUBLIC;


--
-- Name: TABLE sys_stat_ssl; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_ssl TO PUBLIC;


--
-- Name: TABLE sys_stat_subscription; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_subscription TO PUBLIC;


--
-- Name: TABLE sys_stat_sys_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_sys_indexes TO PUBLIC;


--
-- Name: TABLE sys_stat_sys_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_sys_tables TO PUBLIC;


--
-- Name: TABLE sys_stat_user_functions; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_user_functions TO PUBLIC;


--
-- Name: TABLE sys_stat_user_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_user_indexes TO PUBLIC;


--
-- Name: TABLE sys_stat_user_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_user_tables TO PUBLIC;


--
-- Name: TABLE sys_stat_waitaccum; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_waitaccum TO PUBLIC;


--
-- Name: TABLE sys_stat_wal_receiver; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_wal_receiver TO PUBLIC;


--
-- Name: TABLE sys_stat_xact_all_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_xact_all_tables TO PUBLIC;


--
-- Name: TABLE sys_stat_xact_sys_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_xact_sys_tables TO PUBLIC;


--
-- Name: TABLE sys_stat_xact_user_functions; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_xact_user_functions TO PUBLIC;


--
-- Name: TABLE sys_stat_xact_user_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stat_xact_user_tables TO PUBLIC;


--
-- Name: TABLE sys_statio_all_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_all_indexes TO PUBLIC;


--
-- Name: TABLE sys_statio_all_sequences; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_all_sequences TO PUBLIC;


--
-- Name: TABLE sys_statio_all_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_all_tables TO PUBLIC;


--
-- Name: TABLE sys_statio_sys_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_sys_indexes TO PUBLIC;


--
-- Name: TABLE sys_statio_sys_sequences; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_sys_sequences TO PUBLIC;


--
-- Name: TABLE sys_statio_sys_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_sys_tables TO PUBLIC;


--
-- Name: TABLE sys_statio_user_indexes; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_user_indexes TO PUBLIC;


--
-- Name: TABLE sys_statio_user_sequences; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_user_sequences TO PUBLIC;


--
-- Name: TABLE sys_statio_user_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statio_user_tables TO PUBLIC;


--
-- Name: TABLE sys_statistic_ext; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_statistic_ext TO PUBLIC;


--
-- Name: TABLE sys_stats; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stats TO PUBLIC;


--
-- Name: TABLE sys_stats_ext; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_stats_ext TO PUBLIC;


--
-- Name: TABLE sys_subscription_rel; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_subscription_rel TO PUBLIC;


--
-- Name: TABLE sys_tables; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_tables TO PUBLIC;


--
-- Name: TABLE sys_tablespace; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_tablespace TO PUBLIC;


--
-- Name: TABLE sys_timezone_abbrevs; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_timezone_abbrevs TO PUBLIC;


--
-- Name: TABLE sys_timezone_names; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_timezone_names TO PUBLIC;


--
-- Name: TABLE sys_transform; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_transform TO PUBLIC;


--
-- Name: TABLE sys_trigger; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_trigger TO PUBLIC;


--
-- Name: TABLE sys_triggers; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_triggers TO PUBLIC;


--
-- Name: TABLE sys_ts_config; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_ts_config TO PUBLIC;


--
-- Name: TABLE sys_ts_config_map; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_ts_config_map TO PUBLIC;


--
-- Name: TABLE sys_ts_dict; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_ts_dict TO PUBLIC;


--
-- Name: TABLE sys_ts_parser; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_ts_parser TO PUBLIC;


--
-- Name: TABLE sys_ts_template; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_ts_template TO PUBLIC;


--
-- Name: TABLE sys_type; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_type TO PUBLIC;


--
-- Name: TABLE sys_user; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_user TO PUBLIC;


--
-- Name: TABLE sys_user_mappings; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_user_mappings TO PUBLIC;


--
-- Name: TABLE sys_views; Type: ACL; Schema: sys_catalog; Owner: current_user
--

GRANT SELECT ON TABLE sys_catalog.sys_views TO PUBLIC;


INSERT INTO public.act_ge_property VALUES ('next.dbid', '447501', 180);
INSERT INTO public.act_ge_property VALUES ('schema.history', 'create(5.22.0.0)', 1);
INSERT INTO public.act_ge_property VALUES ('schema.version', '5.22.0.0', 1);
--
-- Kingbase database dump complete
--

