/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmntoxml.service.Bpm2XMLService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.FlowProps;
import com.jxdinfo.hussar.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.flowmodel.FlowSequence;
import com.jxdinfo.hussar.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.flowmodel.FlowVariables;
import com.jxdinfo.hussar.flowmodel.LineConfig;
import com.jxdinfo.hussar.flowmodel.MultiUser;
import com.jxdinfo.hussar.flowmodel.SequenceSourceTarget;
import com.jxdinfo.hussar.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/addCustomNode"})
public class AddCustomNodeController {
    private static final String ADD_CUSTOM_PATH_ID_PREFIX = "jxd_bpm_custom_path";
    private Bpm2XMLService xmlService;
    private SysActProcessFileService sysActProcessFileService;
    private TaskService taskService;
    private ModelService modelService;
    private BpmConstantProperties bpmConstantProperties;

    @Autowired
    public AddCustomNodeController(Bpm2XMLService xmlService, ModelService modelService, SysActProcessFileService sysActProcessFileService, TaskService taskService, BpmConstantProperties bpmConstantProperties) {
        this.xmlService = xmlService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.taskService = taskService;
        this.bpmConstantProperties = bpmConstantProperties;
    }

    @RequestMapping(value={"/isAddParallel"})
    @TargetDataSource
    @InterfaceLog(key="/addCustomNode/isAddParallel", value="\u5224\u65ad\u5f53\u524d\u8282\u70b9\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8282\u70b9\u8ffd\u52a0", type="\u67e5\u8be2")
    public BpmResponseResult isAddParallel(String taskId, String tenantId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (ToolUtil.isEmpty((Object)task)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        String identityId = task.getProcessDefinitionId().split(":")[0];
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId(), tenantId);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(task.getTaskDefinitionKey())) continue;
            String nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getIsAddParallel(), null);
            }
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getIsNotAddParallel(), null);
    }

    @RequestMapping(value={"/add"})
    @TargetDataSource
    @InterfaceLog(key="/addCustomNode/add", value="\u6307\u5b9a\u6d41\u7a0b\u5b9e\u4f8b\u6dfb\u52a0\u4e34\u65f6\u8282\u70b9", type="\u4fee\u6539")
    public BpmResponseResult addNode(String taskId, String addList, String tenantId, String parallel) {
        try {
            List list = (List)JSON.parseObject((String)addList, List.class);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (ToolUtil.isEmpty((Object)task)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            String identityId = task.getProcessDefinitionId().split(":")[0];
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId(), tenantId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nodeId", task.getTaskDefinitionKey());
            map.put("addList", list);
            map.put("parallel", parallel);
            WorkFlow newWorkFlow = this.getNewWorkFlow(workFlow, map);
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(newWorkFlow, identityId, tenantId);
            SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)identityId)).eq((Object)"TYPE", (Object)"meta")).eq((Object)"VERSION", (Object)0));
            String modelId = metaInfo.getModelId();
            String version = this.modelService.getRealVersion(task.getProcessDefinitionId());
            if (!task.getProcessDefinitionId().split(":")[1].equals(version)) {
                this.xmlService.updateModel(newWorkFlow, bpmnModel, task.getProcessDefinitionId());
                this.modelService.addNodeSaveModelExtendProperties(bpmnModel, task.getProcessDefinitionId());
            } else {
                this.modelService.deployModelByWorkFlowXml(newWorkFlow, bpmnModel, modelId, tenantId, task.getProcessInstanceId(), version);
            }
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorAddCustomNode(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private WorkFlow getNewWorkFlow(WorkFlow workFlow, Map<String, Object> map) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        JSONObject formAddress = null;
        String formDetailAddress = null;
        ArrayList<FlowVariables> useVariables = new ArrayList();
        List addList = (List)map.get("addList");
        String nextNodeId = "";
        boolean isParallel = false;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            nextNodeId = path.getEnd().getKey();
            break;
        }
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        for (int i = 0; i < addList.size(); ++i) {
            addIds.add(this.getNewId());
        }
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        for (FlowObject flowObject : elements) {
            if (flowObject.getId().equals(map.get("nodeId"))) {
                formAddress = flowObject.getProps().getFormAddress();
                useVariables = flowObject.getProps().getUseVariables();
                formDetailAddress = flowObject.getProps().getFormDetailAddress();
            }
            if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
            isParallel = true;
            List goOutPath = flowObject.getGoOutPathes();
            goOutPath.add(newPathId);
            for (Map map2 : addIds) {
                goOutPath.add(map2.get("pathId"));
            }
            flowObject.setGoOutPathes(goOutPath);
        }
        if (isParallel && "true".equals(map.get("parallel"))) {
            void var19_25;
            String endPointNodeId = this.getNextParallelNodeId(elements, paths, nextNodeId);
            ArrayList<String> nodeIds = new ArrayList<String>();
            List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, addList.size(), nodeIds);
            boolean bl = false;
            while (var19_25 < pointsList.size()) {
                String nodeId = (String)((Map)addIds.get((int)var19_25)).get("nodeId") + "parallel_node" + (String)nodeIds.get(0);
                Map<String, List<FlowSequenceXy>> points = pointsList.get((int)var19_25);
                FlowSequenceXy point = points.get("startPoints").get(3);
                elements.add(this.newNode(nodeId, ((Map)addList.get((int)var19_25)).get("nodeName"), (String)((Map)addIds.get((int)var19_25)).get("endPathId"), ((Map)addList.get((int)var19_25)).get("nodeAssignee"), ((Map)addList.get((int)var19_25)).get("counterSwitch"), ((Map)addList.get((int)var19_25)).get("multiType"), ((Map)addList.get((int)var19_25)).get("multiNumber"), Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), formAddress, useVariables, formDetailAddress));
                paths.add(this.newPath((String)((Map)addIds.get((int)var19_25)).get("pathId"), nextNodeId, nodeId, 0.0, 0.0, 0, points.get("startPoints")));
                paths.add(this.newPath((String)((Map)addIds.get((int)var19_25)).get("endPathId"), nodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                ++var19_25;
            }
            workFlow.setData(JSON.toJSONString((Object)flowModel));
            return workFlow;
        }
        double x = 0.0;
        double y = 0.0;
        double d = 0.0;
        String pathId = "";
        int moveWidth = 140;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            pathId = path.getId();
            path.getStart().setKey(newNodeId);
            if (!"L".equals(path.getStart().getPort())) continue;
            moveWidth = -140;
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getInstanceKey().equals(map.get("nodeId"))) continue;
            flowObject.getGoOutPathes().set(0, newPathId);
            d = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            x = Double.parseDouble(flowObject.getLeft());
            if (moveWidth > 0) {
                x += Double.parseDouble(flowObject.getWidth());
            }
            y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            if (moveWidth > 0 && flowObjectX > d || moveWidth < 0 && flowObjectX < d) {
                flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                continue;
            }
            list.add(flowObject.getId());
        }
        for (FlowSequence path : paths) {
            FlowSequenceXy flowSequenceXy;
            int i;
            boolean isStartNotMove = list.contains(path.getStart().getKey());
            boolean isEndNotMove = list.contains(path.getEnd().getKey());
            List listXy = path.getPoints();
            for (i = 0; i < listXy.size(); ++i) {
                if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < d || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > d)) continue;
                flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
            }
            for (i = 0; i < listXy.size() - 1; ++i) {
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                listXy.add(i + 1, flowSequenceXyNewPoint1);
                listXy.add(i + 2, flowSequenceXyNewPoint2);
            }
        }
        paths.add(this.newPath(newPathId, (String)map.get("nodeId"), newNodeId, x, y, moveWidth, null));
        x = moveWidth < 0 ? (x += (double)moveWidth) : (x += 70.0);
        elements.add(this.newNode(newNodeId, ((Map)addList.get(0)).get("nodeName"), pathId, ((Map)addList.get(0)).get("nodeAssignee"), ((Map)addList.get(0)).get("counterSwitch"), ((Map)addList.get(0)).get("multiType"), ((Map)addList.get(0)).get("multiNumber"), x, y, formAddress, useVariables, formDetailAddress));
        workFlow.setData(JSON.toJSONString((Object)flowModel));
        return workFlow;
    }

    private String getNextParallelNodeId(List<FlowObject> elements, List<FlowSequence> paths, String nodeId) {
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nodeId)) continue;
            String nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) {
                    return nextNodeId;
                }
                return this.getNextParallelNodeId(elements, paths, nextNodeId);
            }
        }
        return null;
    }

    private List<Map<String, List<FlowSequenceXy>>> getParallelNewPathPoints(List<FlowSequence> paths, String nextNodeId, String endPointNodeId, int num, List<String> nodeIds) {
        ArrayList<Map<String, List<FlowSequenceXy>>> list = new ArrayList<Map<String, List<FlowSequenceXy>>>();
        HashMap map = new HashMap();
        FlowSequenceXy start1 = null;
        FlowSequenceXy start2 = null;
        FlowSequenceXy startPoint1 = new FlowSequenceXy();
        FlowSequenceXy startPoint2 = new FlowSequenceXy();
        FlowSequenceXy startPoint3 = new FlowSequenceXy();
        FlowSequenceXy startPoint4 = new FlowSequenceXy();
        FlowSequenceXy end1 = null;
        FlowSequenceXy end2 = null;
        FlowSequenceXy endPoint1 = new FlowSequenceXy();
        FlowSequenceXy endPoint2 = new FlowSequenceXy();
        FlowSequenceXy endPoint3 = new FlowSequenceXy();
        FlowSequenceXy endPoint4 = new FlowSequenceXy();
        for (FlowSequence path : paths) {
            List point;
            if (nextNodeId.equals(path.getStart().getKey())) {
                point = path.getPoints();
                if (point.size() > 2) {
                    startPoint1 = (FlowSequenceXy)point.get(0);
                    startPoint2 = (FlowSequenceXy)point.get(1);
                    startPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                    double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + 75.0;
                    if (ToolUtil.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                        startPoint3.setY(String.valueOf(addY));
                        startPoint4.setY(String.valueOf(addY));
                    }
                    startPoint4.setX(((FlowSequenceXy)point.get(3)).getX());
                } else {
                    start1 = (FlowSequenceXy)point.get(0);
                    start2 = (FlowSequenceXy)point.get(1);
                }
            }
            if (!endPointNodeId.equals(path.getEnd().getKey())) continue;
            if (!path.getStart().getKey().startsWith("jxd_bpm_custom_node")) {
                nodeIds.add(path.getStart().getKey());
            }
            if ((point = path.getPoints()).size() > 2) {
                endPoint2.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setY(((FlowSequenceXy)point.get(3)).getY());
                endPoint4 = (FlowSequenceXy)point.get(3);
                continue;
            }
            end1 = (FlowSequenceXy)point.get(0);
            end2 = (FlowSequenceXy)point.get(1);
        }
        if (ToolUtil.isEmpty((Object)startPoint3.getX())) {
            startPoint1 = start1;
            startPoint2.setY(start1.getY());
            String midX = String.valueOf((Double.parseDouble(start1.getX()) + Double.parseDouble(start2.getX())) / 2.0);
            startPoint2.setX(midX);
            startPoint3.setX(midX);
            startPoint4.setX(start2.getX());
        }
        if (ToolUtil.isNotEmpty(start1)) {
            double addY = Double.parseDouble(start1.getY()) + 75.0;
            if (ToolUtil.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                startPoint3.setY(String.valueOf(addY));
                startPoint4.setY(String.valueOf(addY));
            }
        }
        endPoint1.setY(startPoint4.getY());
        endPoint1.setX(String.valueOf(Double.parseDouble(startPoint4.getX()) + 70.0));
        endPoint2.setY(startPoint4.getY());
        if (ToolUtil.isEmpty((Object)endPoint3.getX())) {
            endPoint4 = end2;
            endPoint3.setY(end2.getY());
            String midX = String.valueOf((Double.parseDouble(end1.getX()) + Double.parseDouble(end2.getX())) / 2.0);
            endPoint2.setX(midX);
            endPoint3.setX(midX);
        }
        ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
        startPoints.add(startPoint1);
        startPoints.add(startPoint2);
        startPoints.add(startPoint3);
        startPoints.add(startPoint4);
        ArrayList<FlowSequenceXy> endPoints = new ArrayList<FlowSequenceXy>();
        endPoints.add(endPoint1);
        endPoints.add(endPoint2);
        endPoints.add(endPoint3);
        endPoints.add(endPoint4);
        map.put("startPoints", startPoints);
        map.put("endPoints", endPoints);
        list.add(map);
        for (int i = 1; i < num; ++i) {
            ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
            newStartPoints.add(startPoint1);
            newStartPoints.add(startPoint2);
            FlowSequenceXy newStartPoint3 = new FlowSequenceXy();
            newStartPoint3.setX(startPoint3.getX());
            newStartPoint3.setY(String.valueOf(Double.parseDouble(startPoint3.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint3);
            FlowSequenceXy newStartPoint4 = new FlowSequenceXy();
            newStartPoint4.setX(startPoint4.getX());
            newStartPoint4.setY(String.valueOf(Double.parseDouble(startPoint4.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint4);
            ArrayList<FlowSequenceXy> newEndPoints = new ArrayList<FlowSequenceXy>();
            FlowSequenceXy newEndPoint1 = new FlowSequenceXy();
            newEndPoint1.setX(endPoint1.getX());
            newEndPoint1.setY(String.valueOf(Double.parseDouble(endPoint1.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint1);
            FlowSequenceXy newEndPoint2 = new FlowSequenceXy();
            newEndPoint2.setX(endPoint2.getX());
            newEndPoint2.setY(String.valueOf(Double.parseDouble(endPoint2.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint2);
            newEndPoints.add(endPoint3);
            newEndPoints.add(endPoint4);
            HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
            newMap.put("startPoints", newStartPoints);
            newMap.put("endPoints", newEndPoints);
            list.add(newMap);
        }
        return list;
    }

    private Map<String, String> getNewId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeId", "jxd_bpm_custom_node_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("pathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("endPathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        return map;
    }

    private FlowObject newNode(String nodeId, Object nodeName, String pathId, Object assignees, Object counterSwitch, Object multiType, Object multiNumber, double x, double y, JSONObject formAddress, List<FlowVariables> userVariables, String formDetailAddress) {
        FlowObject flowObject = new FlowObject();
        flowObject.setInstanceKey(nodeId);
        flowObject.setName(BpmNodeTypeEnum.BPM_USER.getType());
        flowObject.setAlias("");
        flowObject.setWidth("70");
        flowObject.setHeight("50");
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        FlowProps flowProps = new FlowProps();
        flowProps.setFormAddress(formAddress);
        flowProps.setFormDetailAddress(formDetailAddress);
        flowProps.setFlowName((String)nodeName);
        FlowAssignment flowAssignment = new FlowAssignment();
        flowAssignment.setJudgeBackCondition(new ArrayList());
        List<String> assigneeIds = Arrays.asList(((String)assignees).split(","));
        StringBuilder condition = new StringBuilder(" and O.ORGAN_ID IN ('" + assigneeIds.get(0) + "')");
        for (int i = 1; i < assigneeIds.size(); ++i) {
            condition.append(" or O.ORGAN_ID IN ('").append(assigneeIds.get(i)).append("')");
        }
        flowAssignment.setDefaultBackCondtion(condition.toString());
        flowProps.setFlowAssignment(flowAssignment);
        flowProps.setFlowRecipients(new FlowRecipients());
        flowProps.setDueDate("");
        FlowTodoCondition flowTodoCondition = new FlowTodoCondition();
        flowTodoCondition.setModalPlus(new ArrayList());
        flowProps.setTodoConfiguration(flowTodoCondition);
        flowProps.setFlowSkipRepetition("");
        flowProps.setFlowDefault(false);
        MultiUser multiUser = new MultiUser();
        multiUser.setCountersignNumByRatio(100.0);
        multiUser.setCountersign(false);
        multiUser.setCountersignNumByCount(0);
        multiUser.setCountersignType("radio");
        if (((Boolean)counterSwitch).booleanValue() && ToolUtil.isNotEmpty((Object)multiType) && ToolUtil.isNotEmpty((Object)multiNumber)) {
            multiUser.setCountersign(true);
            multiUser.setCountersignType((String)multiType);
            if ("radio".equals(multiType)) {
                multiUser.setCountersignNumByRatio(Double.parseDouble(String.valueOf(multiNumber)));
            } else {
                multiUser.setCountersignNumByCount(((Integer)multiNumber).intValue());
            }
        }
        flowProps.setFlowCountersign(multiUser);
        flowProps.setUseVariables(userVariables);
        flowObject.setProps(flowProps);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        return flowObject;
    }

    private FlowSequence newPath(String pathId, String nodeId, String nextNodeId, double x, double y, int moveWidth, List<FlowSequenceXy> points) {
        FlowSequence flowSequence = new FlowSequence();
        SequenceSourceTarget start = new SequenceSourceTarget();
        SequenceSourceTarget end = new SequenceSourceTarget();
        start.setKey(nodeId);
        end.setKey(nextNodeId);
        if (moveWidth < 0) {
            start.setPort("L");
            end.setPort("R");
        } else {
            start.setPort("R");
            end.setPort("L");
        }
        flowSequence.setStart(start);
        flowSequence.setEnd(end);
        if (ToolUtil.isEmpty(points)) {
            points = new ArrayList<FlowSequenceXy>();
            FlowSequenceXy startXy = new FlowSequenceXy();
            startXy.setX(String.valueOf(x));
            startXy.setY(String.valueOf(y));
            points.add(startXy);
            FlowSequenceXy endXy = new FlowSequenceXy();
            if (moveWidth < 0) {
                endXy.setX(String.valueOf(x - 70.0));
            } else {
                endXy.setX(String.valueOf(x + 70.0));
            }
            endXy.setY(String.valueOf(y));
            points.add(endXy);
        }
        flowSequence.setPoints(points);
        flowSequence.setFlowDefault(false);
        flowSequence.setLineConfig(new LineConfig());
        flowSequence.setInstanceKey(pathId);
        flowSequence.setName(BpmNodeTypeEnum.BPM_SEQUENCE.getType());
        flowSequence.setAlias("");
        flowSequence.setWidth("0");
        flowSequence.setHeight("0");
        FlowProps flowProps = new FlowProps();
        flowProps.setFlowName("");
        flowProps.setBackFlowCondition("");
        flowSequence.setProps(flowProps);
        flowSequence.setGoOutPathes(new ArrayList());
        return flowSequence;
    }
}

