(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],{

/***/ "./src/api/personalCenter/SMEncrypt.js":
/*!*********************************************!*\
  !*** ./src/api/personalCenter/SMEncrypt.js ***!
  \*********************************************/
/*! exports provided: decryptbySM4, encryptbySM4 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "decryptbySM4", function() { return decryptbySM4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "encryptbySM4", function() { return encryptbySM4; });
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "../node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.error.cause.js */ "../node_modules/core-js/modules/es.error.cause.js");
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1__);


var charset = new function charSet() {
  this.parseUTF8 = function (data) {
    data = unescape(encodeURIComponent(data));
    var length = data.length;
    var wordarray = [];
    for (var i = 0; i < length; i++) {
      wordarray[i >>> 2] |= (data.charCodeAt(i) & 255) << 24 - i % 4 * 8;
    }
    return new WordArray(wordarray, length);
  };
  this.stringifyUTF8 = function (wordArray) {
    try {
      var rtnword;
      var words = wordArray.words;
      var sigBytes = wordArray.sigBytes;
      var utf8strings = [];
      for (var i = 0; i < sigBytes; i++) {
        var word = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
        if (word !== 0) {
          utf8strings.push(String.fromCharCode(word));
        }
      }
      rtnword = utf8strings.join('');
      return decodeURIComponent(escape(rtnword));
    } catch (i) {
      throw Error('Malformed UTF-8 data');
    }
  };
  this.HexParse = function (data) {
    var dataLength = data.length;
    var rtnData = [];
    for (var i = 0; i < dataLength; i += 2) {
      rtnData[i >>> 3] |= parseInt(data.substr(i, 2), 16) << 24 - i % 8 * 4;
    }
    return new WordArray(rtnData, dataLength / 2);
  };
  this.HexStringify = function (wordArray) {
    var words = wordArray.words;
    var sigBytes = wordArray.sigBytes;
    var hexString = [];
    for (var i = 0; i < sigBytes; i++) {
      var word = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
      hexString.push((word >>> 4).toString(16));
      hexString.push((word & 15).toString(16));
    }
    return hexString.join('');
  };
  return this;
}();

/**
 * 字符转字节数组
 * @param {字符串} words
 * @param {字节长度} sigBytes
 */
function WordArray(words, sigBytes) {
  this.words = words || [];
  if (sigBytes !== undefined) {
    this.sigBytes = sigBytes;
  } else {
    this.sigBytes = words.length * 4;
  }
  this.getArrs = function () {
    return this.words;
  };
  this.toString = function () {
    for (var thatwords = this.words, thatsigBytes = this.sigBytes, rtnBytes = [], i = 0; i < thatsigBytes; i++) {
      var tmpword = thatwords[i >>> 2] >>> 24 - i % 4 * 8 & 255;
      rtnBytes.push((tmpword >>> 4).toString(16));
      rtnBytes.push((tmpword & 15).toString(16));
    }
    return rtnBytes.join('');
  };
  return this;
}

/**
 * byte转long
 * @param {*} a
 */
function GET_ULONG_BE(a) {
  a = sm4Sbox(a);
  return bigxor(bigxor(bigxor(a, leftshift(a, 2)), bigxor(leftshift(a, 10), leftshift(a, 18))), leftshift(a, 24));
}

/**
 * long转byte
 * @param {*} b
 */
function PUT_ULONG_BE(b) {
  b = sm4Sbox(b);
  return bigxor(b, bigxor(leftshift(b, 13), leftshift(b, 23)));
}

/**
 * 异或处理
 * @param {参数1} a
 * @param {参数2} b
 */
function bigxor(a, b) {
  return a ^ b;
}

/**
 *
 * @param {参数} a
 * @param {左移位数} n
 * @param {循环移位最大位数} size
 */
function leftshift(a, n) {
  n = n % 32;
  return a << n | a >>> 32 - n;
}

/**
 * 子密钥生成系统参数
 */
// eslint-disable-next-line no-array-constructor
var FK = new Array(0xa3b1bac6, 0x56aa3350, 0x677d9197, 0xb27022dc);

/**
 * SM4的S盒表
 */
// eslint-disable-next-line no-array-constructor
var SboxTable = new Array();
// eslint-disable-next-line no-array-constructor
SboxTable[0] = new Array(0xd6, 0x90, 0xe9, 0xfe, 0xcc, 0xe1, 0x3d, 0xb7, 0x16, 0xb6, 0x14, 0xc2, 0x28, 0xfb, 0x2c, 0x05);
// eslint-disable-next-line no-array-constructor
SboxTable[1] = new Array(0x2b, 0x67, 0x9a, 0x76, 0x2a, 0xbe, 0x04, 0xc3, 0xaa, 0x44, 0x13, 0x26, 0x49, 0x86, 0x06, 0x99);
// eslint-disable-next-line no-array-constructor
SboxTable[2] = new Array(0x9c, 0x42, 0x50, 0xf4, 0x91, 0xef, 0x98, 0x7a, 0x33, 0x54, 0x0b, 0x43, 0xed, 0xcf, 0xac, 0x62);
// eslint-disable-next-line no-array-constructor
SboxTable[3] = new Array(0xe4, 0xb3, 0x1c, 0xa9, 0xc9, 0x08, 0xe8, 0x95, 0x80, 0xdf, 0x94, 0xfa, 0x75, 0x8f, 0x3f, 0xa6);
// eslint-disable-next-line no-array-constructor
SboxTable[4] = new Array(0x47, 0x07, 0xa7, 0xfc, 0xf3, 0x73, 0x17, 0xba, 0x83, 0x59, 0x3c, 0x19, 0xe6, 0x85, 0x4f, 0xa8);
// eslint-disable-next-line no-array-constructor
SboxTable[5] = new Array(0x68, 0x6b, 0x81, 0xb2, 0x71, 0x64, 0xda, 0x8b, 0xf8, 0xeb, 0x0f, 0x4b, 0x70, 0x56, 0x9d, 0x35);
// eslint-disable-next-line no-array-constructor
SboxTable[6] = new Array(0x1e, 0x24, 0x0e, 0x5e, 0x63, 0x58, 0xd1, 0xa2, 0x25, 0x22, 0x7c, 0x3b, 0x01, 0x21, 0x78, 0x87);
// eslint-disable-next-line no-array-constructor
SboxTable[7] = new Array(0xd4, 0x00, 0x46, 0x57, 0x9f, 0xd3, 0x27, 0x52, 0x4c, 0x36, 0x02, 0xe7, 0xa0, 0xc4, 0xc8, 0x9e);
// eslint-disable-next-line no-array-constructor
SboxTable[8] = new Array(0xea, 0xbf, 0x8a, 0xd2, 0x40, 0xc7, 0x38, 0xb5, 0xa3, 0xf7, 0xf2, 0xce, 0xf9, 0x61, 0x15, 0xa1);
// eslint-disable-next-line no-array-constructor
SboxTable[9] = new Array(0xe0, 0xae, 0x5d, 0xa4, 0x9b, 0x34, 0x1a, 0x55, 0xad, 0x93, 0x32, 0x30, 0xf5, 0x8c, 0xb1, 0xe3);
// eslint-disable-next-line no-array-constructor
SboxTable[10] = new Array(0x1d, 0xf6, 0xe2, 0x2e, 0x82, 0x66, 0xca, 0x60, 0xc0, 0x29, 0x23, 0xab, 0x0d, 0x53, 0x4e, 0x6f);
// eslint-disable-next-line no-array-constructor
SboxTable[11] = new Array(0xd5, 0xdb, 0x37, 0x45, 0xde, 0xfd, 0x8e, 0x2f, 0x03, 0xff, 0x6a, 0x72, 0x6d, 0x6c, 0x5b, 0x51);
// eslint-disable-next-line no-array-constructor
SboxTable[12] = new Array(0x8d, 0x1b, 0xaf, 0x92, 0xbb, 0xdd, 0xbc, 0x7f, 0x11, 0xd9, 0x5c, 0x41, 0x1f, 0x10, 0x5a, 0xd8);
// eslint-disable-next-line no-array-constructor
SboxTable[13] = new Array(0x0a, 0xc1, 0x31, 0x88, 0xa5, 0xcd, 0x7b, 0xbd, 0x2d, 0x74, 0xd0, 0x12, 0xb8, 0xe5, 0xb4, 0xb0);
// eslint-disable-next-line no-array-constructor
SboxTable[14] = new Array(0x89, 0x69, 0x97, 0x4a, 0x0c, 0x96, 0x77, 0x7e, 0x65, 0xb9, 0xf1, 0x09, 0xc5, 0x6e, 0xc6, 0x84);
// eslint-disable-next-line no-array-constructor
SboxTable[15] = new Array(0x18, 0xf0, 0x7d, 0xec, 0x3a, 0xdc, 0x4d, 0x20, 0x79, 0xee, 0x5f, 0x3e, 0xd7, 0xcb, 0x39, 0x48);

/**
 * 子密钥参数表
 */
// eslint-disable-next-line no-array-constructor
var CK = new Array(0x00070e15, 0x1c232a31, 0x383f464d, 0x545b6269, 0x70777e85, 0x8c939aa1, 0xa8afb6bd, 0xc4cbd2d9, 0xe0e7eef5, 0xfc030a11, 0x181f262d, 0x343b4249, 0x50575e65, 0x6c737a81, 0x888f969d, 0xa4abb2b9, 0xc0c7ced5, 0xdce3eaf1, 0xf8ff060d, 0x141b2229, 0x30373e45, 0x4c535a61, 0x686f767d, 0x848b9299, 0xa0a7aeb5, 0xbcc3cad1, 0xd8dfe6ed, 0xf4fb0209, 0x10171e25, 0x2c333a41, 0x484f565d, 0x646b7279);

/**
 * s盒变换
 * @param {输入} inch
 */
function sm4Sbox(inch) {
  var retVal1 = SboxTable[(inch & 0xf0000000) >>> 28][(inch & 0x0f000000) >>> 24];
  var retVal2 = SboxTable[(inch & 0x00f00000) >>> 20][(inch & 0x000f0000) >>> 16];
  var retVal3 = SboxTable[(inch & 0x0000f000) >>> 12][(inch & 0x00000f00) >>> 8];
  var retVal4 = SboxTable[(inch & 0x000000f0) >>> 4][(inch & 0x0000000f) >>> 0];
  return retVal1 << 24 | retVal2 << 16 | retVal3 << 8 | retVal4 << 0;
}

/**
 * 获取SM4轮密钥
 * @param {密钥} MK
 */
function sm4_getkey(MK) {
  // eslint-disable-next-line no-array-constructor
  var K = new Array();
  // eslint-disable-next-line no-array-constructor
  var rk = new Array();
  K[0] = bigxor(MK[0], FK[0]);
  K[1] = bigxor(MK[1], FK[1]);
  K[2] = bigxor(MK[2], FK[2]);
  K[3] = bigxor(MK[3], FK[3]);
  for (var i = 0; i < 32; i++) {
    K[i + 4] = bigxor(K[i], PUT_ULONG_BE(bigxor(bigxor(K[i + 1], K[i + 2]), bigxor(K[i + 3], CK[i]))));
    rk[i] = K[i + 4].toString(16);
  }
  return rk;
}

/**
 * SM4 加密密函数
 * @param {明文} messsage
 * @param {密钥} key
 */
function encrypt_sm4(messsage, key) {
  var MK = key;
  var X = messsage;
  var csize = Math.ceil(X.length / 4);
  // eslint-disable-next-line no-array-constructor
  var tmpArray = new Array();
  var rk = sm4_getkey(MK);
  for (var j = 0; j < csize; j++) {
    var SC = X.slice(j * 4, (j + 1) * 4);
    for (var i = 0; i < 32; i++) {
      SC[i + 4] = bigxor(SC[i], GET_ULONG_BE(bigxor(bigxor(SC[i + 1], SC[i + 2]), bigxor(SC[i + 3], parseInt(rk[i], 16)))));
    }
    tmpArray = tmpArray.concat(SC[35].toString(10), SC[34].toString(10), SC[33].toString(10), SC[32].toString(10));
  }
  return new WordArray(tmpArray);
}

/**
 * SM4 解密函数
 * @param {密文} ciphertext
 * @param {密钥} key
 */
function decrypt_sm4(ciphertext, key) {
  var MK = key;
  var X = ciphertext;
  var csize = Math.ceil(X.length / 4);
  var frk = sm4_getkey(MK);
  // eslint-disable-next-line no-array-constructor
  var rk = new Array();
  // eslint-disable-next-line no-array-constructor
  var tmpArray = new Array();
  for (var j = 0; j < csize; j++) {
    var SC = X.slice(j * 4, (j + 1) * 4);
    for (var i = frk.length - 1; i >= 0; i--) {
      rk[frk.length - 1 - i] = frk[i];
    }
    // eslint-disable-next-line no-redeclare
    for (var i = 0; i < 32; i++) {
      SC[i + 4] = bigxor(SC[i], GET_ULONG_BE(bigxor(bigxor(SC[i + 1], SC[i + 2]), bigxor(SC[i + 3], parseInt(rk[i], 16)))));
    }
    tmpArray = tmpArray.concat(SC[35].toString(10), SC[34].toString(10), SC[33].toString(10), SC[32].toString(10));
  }
  return new WordArray(tmpArray);
}

/**
 * SM4加密
 * @param {明文} messsage
 * @param {密钥} key
 */
function encryptbySM4(messsage, key) {
  var wordArray = encrypt_sm4(charset.parseUTF8(messsage).getArrs(), charset.parseUTF8(key).getArrs());
  return charset.HexStringify(wordArray);
}

/**
 * SM4解密 要求message参数位数必须是8的倍数 否则会报错 （加密后的位数都是8的倍数）
 * @param messsage
 * @param key
 * @returns {string | undefined}
 */
function decryptbySM4(message, key) {
  var wordArray = decrypt_sm4(charset.HexParse(message).getArrs(), charset.parseUTF8(key).getArrs());
  return charset.stringifyUTF8(wordArray);
}
// import所需


/***/ }),

/***/ "./src/api/personalCenter/personal.js":
/*!********************************************!*\
  !*** ./src/api/personalCenter/personal.js ***!
  \********************************************/
/*! exports provided: initTable, resetCipher, getConfig, editUserConfig, editUserDataPushConfig, importExcel, getModel, editDbMessage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "initTable", function() { return initTable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resetCipher", function() { return resetCipher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfig", function() { return getConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "editUserConfig", function() { return editUserConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "editUserDataPushConfig", function() { return editUserDataPushConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "importExcel", function() { return importExcel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getModel", function() { return getModel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "editDbMessage", function() { return editDbMessage; });
/* harmony import */ var _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/utils/hussar-default-request */ "./src/utils/hussar-default-request.js");


// 查询列表数据
function initTable(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/personalQuery', data);
}

// 重置
function resetCipher(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/resetCipher', data);
}

// 查询当前账号的项目配置
function getConfig() {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/getUserConfig');
}

// 更改启用状态
function editUserConfig(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/editUserConfig', data);
}

// 更改数据推送状态
function editUserDataPushConfig(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/editUserDataPushConfig', data);
}

// 根据Excel文件同步数据库
function importExcel(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].postFile('/synchronization/synByExcel', data);
}

// 全量数据同步模板下载
function getModel() {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].download('/tenant/getModel');
}

// 修改租户数据库信息
function editDbMessage(data) {
  return _utils_hussar_default_request__WEBPACK_IMPORTED_MODULE_0__["default"].get('/tenant/editDbMessage', data);
}

/***/ }),

/***/ "./src/assets/img/hide.png":
/*!*********************************!*\
  !*** ./src/assets/img/hide.png ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAABZklEQVQ4T+2Sv0uCcRDGn/uqZaI2VNCgDULRELU2tUQNDg0NLqalr2I4BLa0vn9BhNAg5auILe/UVn9CjuLgEgSNEWSWv/W9MEgkE4V088a747nPPXeEEQeNWA8Twf87Oj4Pr5VUjoRI+g/d50TEg1iZmZRkKsIsjgN+z8pPf4fwKpHeJNaSBJSYcEFa41aSpI/fwpeqajaV6nst1iIALEziKOg7eOgRbCfi8biFYciCaAGAEeAcgGcG3onICsDOGm8QoUKEokBrzefzFbqHdghlWRY2u+MGAo6yQezMVLQ50uGOQBkQnhhsB2OL9didBl7qTdwTUGg2KvuhUKjRQ6goip1hiNWqwh0Ou9++iROpV2i0LUmebCyRWNWxLhPwe2fbtWg0bTVZtDQ3cRYMevN/rtyNrqrqVPGz+lhenF8+cTprsizrbUuOfNFsXD91uSr9jja+txn0JsPWJ4TDOtW/b+QefgGtMngVv3Hb3QAAAABJRU5ErkJggg=="

/***/ }),

/***/ "./src/assets/img/show.png":
/*!*********************************!*\
  !*** ./src/assets/img/show.png ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAB40lEQVQ4T+2UO4gTURSG//9GsZNYqIWVsCILIhY2Cj4Q3bWwUwR1M7MzmYgg+ADtIyrbiWCZzEwykyCKCFbKFq7go/BR+UTYldVafHRicn9JQpYJKKuSTm95z38+zv3vOYcY8uGQefgP7Dkax81NFvYwpO0WWGvIvKQvIGcJ3fsukx7zJ179zP8BD8MwXS+DK5B2A3hIctrKvs4Bn9tAHsIoyL0EtoC4tdTopOu677PgBWAUNfZZ6CqkBzZnzxydnHz5qw7ovkDtyxbYaKT9xaI709d2gWGSbFYL9wVcKPnOxX4wiqKVlktCCDsJPJHN+UFwZL4Tl8S41piy0vEczVbPm3jeue8Bo+QuiLmi5wTZqqphkpAYheF5CCcEtAOvMJ7VhHHakLQq8J2xBWA1Sr6CPBh4hTsDwCh9A9ipwHfrUdQct2hdC3w3PwCsNcZk7Y3Ad5ZngdMkPxa9wqGsuBImDUOOQDwHo1OQTNF39ixeYTXZAINHJCsf5mfPlstl20mqVCqraZbVSOwQ8FRtuKWS825RD3u9l25rCzcFvWVOpwPXffzXv9xPrNevr2m1v10SdIDAMwG3Qbww0qc/7sNsNXHcXGdhC7J2F2hGSKzoTgowR2KGMqn/O5MyjFX2D66vH/yc9BXw/aIeAAAAAElFTkSuQmCC"

/***/ })

}]);
//# sourceMappingURL=3.js.map