/*
NAVICAT MYSQL DATA TRANSFER

SOURCE SERVER         : LOCALHOST
SOURCE SERVER VERSION : 50612
SOURCE HOST           : LOCALHOST:3306
SOURCE DATABASE       : BPM2

TARGET SERVER TYPE    : MYSQL
TARGET SERVER VERSION : 50612
FILE ENCODING         : 65001

DATE: 2020-07-21 10:58:49
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_EVT_LOG
-- ----------------------------
DROP TABLE IF EXISTS `ACT_EVT_LOG`;
CREATE TABLE `ACT_EVT_LOG` (
  `LOG_NR_` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `TYPE_` VARCHAR(64) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `TIME_STAMP_` TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `USER_ID_` VARCHAR(255) DEFAULT NULL,
  `DATA_` LONGBLOB,
  `LOCK_OWNER_` VARCHAR(255) DEFAULT NULL,
  `LOCK_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  `IS_PROCESSED_` TINYINT(4) DEFAULT '0',
  PRIMARY KEY (`LOG_NR_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_EVT_LOG
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_GE_BYTEARRAY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_GE_BYTEARRAY`;
CREATE TABLE `ACT_GE_BYTEARRAY` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `DEPLOYMENT_ID_` VARCHAR(64) DEFAULT NULL,
  `BYTES_` LONGBLOB,
  `GENERATED_` TINYINT(4) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_BYTEARR_DEPL` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_GE_BYTEARRAY_IBFK_1` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_GE_BYTEARRAY
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_GE_PROPERTY
-- ----------------------------
DROP TABLE IF EXISTS `ACT_GE_PROPERTY`;
CREATE TABLE `ACT_GE_PROPERTY` (
  `NAME_` VARCHAR(64) NOT NULL,
  `VALUE_` VARCHAR(300) DEFAULT NULL,
  `REV_` INT(11) DEFAULT NULL,
  PRIMARY KEY (`NAME_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO `ACT_GE_PROPERTY` VALUES ('next.dbid', '447501', '180');
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.history', 'create(5.22.0.0)', '1');
INSERT INTO `ACT_GE_PROPERTY` VALUES ('schema.version', '5.22.0.0', '1');

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_ACTINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ACTINST`;
CREATE TABLE `ACT_HI_ACTINST` (
  `ID_` VARCHAR(64) NOT NULL,
  `PROC_DEF_ID_` VARCHAR(64) NOT NULL,
  `PROC_INST_ID_` VARCHAR(64) NOT NULL,
  `EXECUTION_ID_` VARCHAR(64) NOT NULL,
  `ACT_ID_` VARCHAR(255) NOT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `CALL_PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `ACT_NAME_` VARCHAR(255) DEFAULT NULL,
  `ACT_TYPE_` VARCHAR(255) NOT NULL,
  `ASSIGNEE_` VARCHAR(255) DEFAULT NULL,
  `START_TIME_` DATETIME(3) DEFAULT NULL,
  `END_TIME_` DATETIME(3) DEFAULT NULL,
  `DURATION_` BIGINT(20) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_START` (`START_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_PROCINST` (`PROC_INST_ID_`,`ACT_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_ACT_INST_EXEC` (`EXECUTION_ID_`,`ACT_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_ACTINST
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_ATTACHMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_ATTACHMENT`;
CREATE TABLE `ACT_HI_ATTACHMENT` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `USER_ID_` VARCHAR(255) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `DESCRIPTION_` VARCHAR(4000) DEFAULT NULL,
  `TYPE_` VARCHAR(255) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `URL_` VARCHAR(4000) DEFAULT NULL,
  `CONTENT_ID_` VARCHAR(64) DEFAULT NULL,
  `TIME_` DATETIME(3) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_ATTACHMENT
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_COMMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_COMMENT`;
CREATE TABLE `ACT_HI_COMMENT` (
  `ID_` VARCHAR(64) NOT NULL,
  `TYPE_` VARCHAR(255) DEFAULT NULL,
  `TIME_` DATETIME(3) DEFAULT NULL,
  `USER_ID_` VARCHAR(255) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `ACTION_` VARCHAR(255) DEFAULT NULL,
  `MESSAGE_` VARCHAR(4000) DEFAULT NULL,
  `FULL_MSG_` LONGBLOB,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_COMMENT
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_DETAIL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_DETAIL`;
CREATE TABLE `ACT_HI_DETAIL` (
  `ID_` VARCHAR(64) NOT NULL,
  `TYPE_` VARCHAR(255) NOT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `ACT_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `NAME_` VARCHAR(255) NOT NULL,
  `VAR_TYPE_` VARCHAR(255) DEFAULT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `TIME_` DATETIME(3) DEFAULT NULL,
  `BYTEARRAY_ID_` VARCHAR(64) DEFAULT NULL,
  `DOUBLE_` DOUBLE DEFAULT NULL,
  `LONG_` BIGINT(20) DEFAULT NULL,
  `TEXT_` VARCHAR(4000) DEFAULT NULL,
  `TEXT2_` VARCHAR(4000) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_ACT_INST` (`ACT_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TIME` (`TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_NAME` (`NAME_`) USING BTREE,
  KEY `ACT_IDX_HI_DETAIL_TASK_ID` (`TASK_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_DETAIL
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_IDENTITYLINK`;
CREATE TABLE `ACT_HI_IDENTITYLINK` (
  `ID_` VARCHAR(64) NOT NULL,
  `GROUP_ID_` VARCHAR(255) DEFAULT NULL,
  `TYPE_` VARCHAR(255) DEFAULT NULL,
  `USER_ID_` VARCHAR(255) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_IDENT_LNK_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_PROCINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_PROCINST`;
CREATE TABLE `ACT_HI_PROCINST` (
  `ID_` VARCHAR(64) NOT NULL,
  `PROC_INST_ID_` VARCHAR(64) NOT NULL,
  `BUSINESS_KEY_` VARCHAR(255) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) NOT NULL,
  `START_TIME_` DATETIME(3) DEFAULT NULL,
  `END_TIME_` DATETIME(3) DEFAULT NULL,
  `DURATION_` BIGINT(20) DEFAULT NULL,
  `START_USER_ID_` VARCHAR(255) DEFAULT NULL,
  `START_ACT_ID_` VARCHAR(255) DEFAULT NULL,
  `END_ACT_ID_` VARCHAR(255) DEFAULT NULL,
  `SUPER_PROCESS_INSTANCE_ID_` VARCHAR(64) DEFAULT NULL,
  `DELETE_REASON_` VARCHAR(4000) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  `NAME_` VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `PROC_INST_ID_` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_INST_END` (`END_TIME_`) USING BTREE,
  KEY `ACT_IDX_HI_PRO_I_BUSKEY` (`BUSINESS_KEY_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_PROCINST
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_TASKINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_TASKINST`;
CREATE TABLE `ACT_HI_TASKINST` (
  `ID_` VARCHAR(64) NOT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `TASK_DEF_KEY_` VARCHAR(255) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `PARENT_TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `DESCRIPTION_` VARCHAR(4000) DEFAULT NULL,
  `OWNER_` VARCHAR(255) DEFAULT NULL,
  `ASSIGNEE_` VARCHAR(255) DEFAULT NULL,
  `START_TIME_` DATETIME(3) DEFAULT NULL,
  `CLAIM_TIME_` DATETIME(3) DEFAULT NULL,
  `END_TIME_` DATETIME(3) DEFAULT NULL,
  `DURATION_` BIGINT(20) DEFAULT NULL,
  `DELETE_REASON_` VARCHAR(4000) DEFAULT NULL,
  `PRIORITY_` INT(11) DEFAULT NULL,
  `DUE_DATE_` DATETIME(3) DEFAULT NULL,
  `FORM_KEY_` VARCHAR(2000) DEFAULT NULL,
  `CATEGORY_` VARCHAR(255) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_TASK_INST_PROCINST` (`PROC_INST_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_TASKINST
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_HI_VARINST
-- ----------------------------
DROP TABLE IF EXISTS `ACT_HI_VARINST`;
CREATE TABLE `ACT_HI_VARINST` (
  `ID_` VARCHAR(64) NOT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `NAME_` VARCHAR(255) NOT NULL,
  `VAR_TYPE_` VARCHAR(100) DEFAULT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `BYTEARRAY_ID_` VARCHAR(64) DEFAULT NULL,
  `DOUBLE_` DOUBLE DEFAULT NULL,
  `LONG_` BIGINT(20) DEFAULT NULL,
  `TEXT_` VARCHAR(4000) DEFAULT NULL,
  `TEXT2_` VARCHAR(4000) DEFAULT NULL,
  `CREATE_TIME_` DATETIME(3) DEFAULT NULL,
  `LAST_UPDATED_TIME_` DATETIME(3) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_PROC_INST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_NAME_TYPE` (`NAME_`,`VAR_TYPE_`) USING BTREE,
  KEY `ACT_IDX_HI_PROCVAR_TASK_ID` (`TASK_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_HI_VARINST
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_ID_GROUP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_GROUP`;
CREATE TABLE `ACT_ID_GROUP` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `TYPE_` VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_ID_GROUP
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_ID_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_INFO`;
CREATE TABLE `ACT_ID_INFO` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `USER_ID_` VARCHAR(64) DEFAULT NULL,
  `TYPE_` VARCHAR(64) DEFAULT NULL,
  `KEY_` VARCHAR(255) DEFAULT NULL,
  `VALUE_` VARCHAR(255) DEFAULT NULL,
  `PASSWORD_` LONGBLOB,
  `PARENT_ID_` VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_ID_INFO
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_ID_MEMBERSHIP
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_MEMBERSHIP`;
CREATE TABLE `ACT_ID_MEMBERSHIP` (
  `USER_ID_` VARCHAR(64) NOT NULL,
  `GROUP_ID_` VARCHAR(64) NOT NULL,
  PRIMARY KEY (`USER_ID_`,`GROUP_ID_`) USING BTREE,
  KEY `ACT_FK_MEMB_GROUP` (`GROUP_ID_`) USING BTREE,
  CONSTRAINT `ACT_ID_MEMBERSHIP_IBFK_1` FOREIGN KEY (`GROUP_ID_`) REFERENCES `ACT_ID_GROUP` (`ID_`),
  CONSTRAINT `ACT_ID_MEMBERSHIP_IBFK_2` FOREIGN KEY (`USER_ID_`) REFERENCES `ACT_ID_USER` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_ID_MEMBERSHIP
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_ID_USER
-- ----------------------------
DROP TABLE IF EXISTS `ACT_ID_USER`;
CREATE TABLE `ACT_ID_USER` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `FIRST_` VARCHAR(255) DEFAULT NULL,
  `LAST_` VARCHAR(255) DEFAULT NULL,
  `EMAIL_` VARCHAR(255) DEFAULT NULL,
  `PWD_` VARCHAR(255) DEFAULT NULL,
  `PICTURE_ID_` VARCHAR(64) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_ID_USER
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_PROCDEF_INFO
-- ----------------------------
DROP TABLE IF EXISTS `ACT_PROCDEF_INFO`;
CREATE TABLE `ACT_PROCDEF_INFO` (
  `ID_` VARCHAR(64) NOT NULL,
  `PROC_DEF_ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `INFO_JSON_ID_` VARCHAR(64) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_UNIQ_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_IDX_INFO_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_INFO_JSON_BA` (`INFO_JSON_ID_`) USING BTREE,
  CONSTRAINT `ACT_PROCDEF_INFO_IBFK_1` FOREIGN KEY (`INFO_JSON_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_PROCDEF_INFO_IBFK_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_PROCDEF_INFO
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RE_DEPLOYMENT
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_DEPLOYMENT`;
CREATE TABLE `ACT_RE_DEPLOYMENT` (
  `ID_` VARCHAR(64) NOT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `CATEGORY_` VARCHAR(255) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  `DEPLOY_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RE_DEPLOYMENT
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RE_MODEL
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_MODEL`;
CREATE TABLE `ACT_RE_MODEL` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `KEY_` VARCHAR(255) DEFAULT NULL,
  `CATEGORY_` VARCHAR(255) DEFAULT NULL,
  `CREATE_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  `LAST_UPDATE_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  `VERSION_` INT(11) DEFAULT NULL,
  `META_INFO_` VARCHAR(4000) DEFAULT NULL,
  `DEPLOYMENT_ID_` VARCHAR(64) DEFAULT NULL,
  `EDITOR_SOURCE_VALUE_ID_` VARCHAR(64) DEFAULT NULL,
  `EDITOR_SOURCE_EXTRA_VALUE_ID_` VARCHAR(64) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_SOURCE` (`EDITOR_SOURCE_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_SOURCE_EXTRA` (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) USING BTREE,
  KEY `ACT_FK_MODEL_DEPLOYMENT` (`DEPLOYMENT_ID_`) USING BTREE,
  CONSTRAINT `ACT_RE_MODEL_IBFK_1` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `ACT_RE_DEPLOYMENT` (`ID_`),
  CONSTRAINT `ACT_RE_MODEL_IBFK_2` FOREIGN KEY (`EDITOR_SOURCE_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RE_MODEL_IBFK_3` FOREIGN KEY (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RE_MODEL
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RE_PROCDEF
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RE_PROCDEF`;
CREATE TABLE `ACT_RE_PROCDEF` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `CATEGORY_` VARCHAR(255) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `KEY_` VARCHAR(255) NOT NULL,
  `VERSION_` INT(11) NOT NULL,
  `DEPLOYMENT_ID_` VARCHAR(64) DEFAULT NULL,
  `RESOURCE_NAME_` VARCHAR(4000) DEFAULT NULL,
  `DGRM_RESOURCE_NAME_` VARCHAR(4000) DEFAULT NULL,
  `DESCRIPTION_` VARCHAR(4000) DEFAULT NULL,
  `HAS_START_FORM_KEY_` TINYINT(4) DEFAULT NULL,
  `HAS_GRAPHICAL_NOTATION_` TINYINT(4) DEFAULT NULL,
  `SUSPENSION_STATE_` INT(11) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  `MAIN_PROCESS` VARCHAR(4) DEFAULT '0' COMMENT '1主版本 0 不是主版本 2 临时版本',
  `REAL_VERSION` VARCHAR(255) DEFAULT NULL COMMENT '临时版本流程真实版本号',
  PRIMARY KEY (`ID_`) USING BTREE,
  UNIQUE KEY `ACT_UNIQ_PROCDEF` (`KEY_`,`VERSION_`,`TENANT_ID_`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RE_PROCDEF
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_EVENT_SUBSCR
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EVENT_SUBSCR`;
CREATE TABLE `ACT_RU_EVENT_SUBSCR` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `EVENT_TYPE_` VARCHAR(255) NOT NULL,
  `EVENT_NAME_` VARCHAR(255) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `ACTIVITY_ID_` VARCHAR(64) DEFAULT NULL,
  `CONFIGURATION_` VARCHAR(255) DEFAULT NULL,
  `CREATED_` TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_EVENT_SUBSCR_CONFIG_` (`CONFIGURATION_`) USING BTREE,
  KEY `ACT_FK_EVENT_EXEC` (`EXECUTION_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_EVENT_SUBSCR_IBFK_1` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_EVENT_SUBSCR
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_EXECUTION
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_EXECUTION`;
CREATE TABLE `ACT_RU_EXECUTION` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `BUSINESS_KEY_` VARCHAR(255) DEFAULT NULL,
  `PARENT_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `SUPER_EXEC_` VARCHAR(64) DEFAULT NULL,
  `ACT_ID_` VARCHAR(255) DEFAULT NULL,
  `IS_ACTIVE_` TINYINT(4) DEFAULT NULL,
  `IS_CONCURRENT_` TINYINT(4) DEFAULT NULL,
  `IS_SCOPE_` TINYINT(4) DEFAULT NULL,
  `IS_EVENT_SCOPE_` TINYINT(4) DEFAULT NULL,
  `SUSPENSION_STATE_` INT(11) DEFAULT NULL,
  `CACHED_ENT_STATE_` INT(11) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `LOCK_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_EXEC_BUSKEY` (`BUSINESS_KEY_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_PARENT` (`PARENT_ID_`) USING BTREE,
  KEY `ACT_FK_EXE_SUPER` (`SUPER_EXEC_`) USING BTREE,
  KEY `ACT_FK_EXE_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_EXECUTION_IBFK_1` FOREIGN KEY (`PARENT_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE ON UPDATE CASCADE ,
  CONSTRAINT `ACT_RU_EXECUTION_IBFK_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_EXECUTION_IBFK_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ACT_RU_EXECUTION_IBFK_4` FOREIGN KEY (`SUPER_EXEC_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_EXECUTION
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_IDENTITYLINK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_IDENTITYLINK`;
CREATE TABLE `ACT_RU_IDENTITYLINK` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `GROUP_ID_` VARCHAR(255) DEFAULT NULL,
  `TYPE_` VARCHAR(255) DEFAULT NULL,
  `USER_ID_` VARCHAR(255) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_USER` (`USER_ID_`) USING BTREE,
  KEY `ACT_IDX_IDENT_LNK_GROUP` (`GROUP_ID_`) USING BTREE,
  KEY `ACT_IDX_ATHRZ_PROCEDEF` (`PROC_DEF_ID_`) USING BTREE,
  KEY `ACT_FK_TSKASS_TASK` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_IDL_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_IDENTITYLINK_IBFK_1` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_IDENTITYLINK_IBFK_2` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_IDENTITYLINK_IBFK_3` FOREIGN KEY (`TASK_ID_`) REFERENCES `ACT_RU_TASK` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_IDENTITYLINK
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_JOB
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_JOB`;
CREATE TABLE `ACT_RU_JOB` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `TYPE_` VARCHAR(255) NOT NULL,
  `LOCK_EXP_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  `LOCK_OWNER_` VARCHAR(255) DEFAULT NULL,
  `EXCLUSIVE_` TINYINT(1) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `RETRIES_` INT(11) DEFAULT NULL,
  `EXCEPTION_STACK_ID_` VARCHAR(64) DEFAULT NULL,
  `EXCEPTION_MSG_` VARCHAR(4000) DEFAULT NULL,
  `DUEDATE_` TIMESTAMP(3) NULL DEFAULT NULL,
  `REPEAT_` VARCHAR(255) DEFAULT NULL,
  `HANDLER_TYPE_` VARCHAR(255) DEFAULT NULL,
  `HANDLER_CFG_` VARCHAR(4000) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_FK_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_JOB_IBFK_1` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_JOB
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_TASK
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_TASK`;
CREATE TABLE `ACT_RU_TASK` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_DEF_ID_` VARCHAR(64) DEFAULT NULL,
  `NAME_` VARCHAR(255) DEFAULT NULL,
  `PARENT_TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `DESCRIPTION_` VARCHAR(4000) DEFAULT NULL,
  `TASK_DEF_KEY_` VARCHAR(255) DEFAULT NULL,
  `OWNER_` VARCHAR(255) DEFAULT NULL,
  `ASSIGNEE_` VARCHAR(255) DEFAULT NULL,
  `DELEGATION_` VARCHAR(64) DEFAULT NULL,
  `PRIORITY_` INT(11) DEFAULT NULL,
  `CREATE_TIME_` TIMESTAMP(3) NULL DEFAULT NULL,
  `DUE_DATE_` DATETIME(3) DEFAULT NULL,
  `CATEGORY_` VARCHAR(255) DEFAULT NULL,
  `SUSPENSION_STATE_` INT(11) DEFAULT NULL,
  `TENANT_ID_` VARCHAR(255) DEFAULT '',
  `FORM_KEY_` VARCHAR(2000) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_TASK_CREATE` (`CREATE_TIME_`) USING BTREE,
  KEY `ACT_FK_TASK_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_TASK_PROCDEF` (`PROC_DEF_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_TASK_IBFK_1` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_TASK_IBFK_2` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `ACT_RE_PROCDEF` (`ID_`),
  CONSTRAINT `ACT_RU_TASK_IBFK_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_TASK
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR ACT_RU_VARIABLE
-- ----------------------------
DROP TABLE IF EXISTS `ACT_RU_VARIABLE`;
CREATE TABLE `ACT_RU_VARIABLE` (
  `ID_` VARCHAR(64) NOT NULL,
  `REV_` INT(11) DEFAULT NULL,
  `TYPE_` VARCHAR(255) NOT NULL,
  `NAME_` VARCHAR(255) NOT NULL,
  `EXECUTION_ID_` VARCHAR(64) DEFAULT NULL,
  `PROC_INST_ID_` VARCHAR(64) DEFAULT NULL,
  `TASK_ID_` VARCHAR(64) DEFAULT NULL,
  `BYTEARRAY_ID_` VARCHAR(64) DEFAULT NULL,
  `DOUBLE_` DOUBLE DEFAULT NULL,
  `LONG_` BIGINT(20) DEFAULT NULL,
  `TEXT_` VARCHAR(4000) DEFAULT NULL,
  `TEXT2_` VARCHAR(4000) DEFAULT NULL,
  PRIMARY KEY (`ID_`) USING BTREE,
  KEY `ACT_IDX_VARIABLE_TASK_ID` (`TASK_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_EXE` (`EXECUTION_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_PROCINST` (`PROC_INST_ID_`) USING BTREE,
  KEY `ACT_FK_VAR_BYTEARRAY` (`BYTEARRAY_ID_`) USING BTREE,
  CONSTRAINT `ACT_RU_VARIABLE_IBFK_1` FOREIGN KEY (`BYTEARRAY_ID_`) REFERENCES `ACT_GE_BYTEARRAY` (`ID_`),
  CONSTRAINT `ACT_RU_VARIABLE_IBFK_2` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`),
  CONSTRAINT `ACT_RU_VARIABLE_IBFK_3` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `ACT_RU_EXECUTION` (`ID_`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF ACT_RU_VARIABLE
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_CC_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_CC_TASK`;
CREATE TABLE `SYS_ACT_CC_TASK` (
  `ID` VARCHAR(32) NOT NULL COMMENT '主键',
  `TASK_ID` VARCHAR(64) DEFAULT NULL COMMENT '任务ID',
  `PROC_INST_ID` VARCHAR(64) DEFAULT NULL COMMENT '实例ID',
  `PROC_NAME` VARCHAR(255) DEFAULT NULL COMMENT '流程名称',
  `TASK_NAME` VARCHAR(255) DEFAULT NULL COMMENT '任务名称',
  `SEND_USER` VARCHAR(32) DEFAULT NULL COMMENT '发送人',
  `RECEIVE_USER` VARCHAR(32) DEFAULT NULL COMMENT '接收人',
  `SEND_TIME` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `FORM_KEY` VARCHAR(1000) DEFAULT NULL,
  `PROC_DEF_KEY` VARCHAR(64) DEFAULT NULL,
  `BUSINESS_ID` VARCHAR(255) DEFAULT NULL,
  `TASK_DEF_KEY` VARCHAR(64) DEFAULT NULL,
  `TEXT` TEXT DEFAULT NULL COMMENT '待办配置',
  PRIMARY KEY (`ID`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8;

-- ----------------------------
-- RECORDS OF SYS_ACT_CC_TASK
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_CONFIG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_CONFIG`;
CREATE TABLE `SYS_ACT_CONFIG` (
  `TENANT_ID` VARCHAR(32) NOT NULL COMMENT '租户ID',
  `PROJECT_ADDRESS` VARCHAR(255) DEFAULT NULL COMMENT '项目地址',
  `IS_MQ_USE` VARCHAR(255) DEFAULT NULL COMMENT '是否启用MQ 1启用 0不启用',
  `IS_GOD_AXE` VARCHAR(255) DEFAULT NULL COMMENT '是否天斧 1是 0否',
  `IS_MULTI_TENANT` CHAR(1) DEFAULT NULL COMMENT '是否共库 1是 0否',
  PRIMARY KEY (`TENANT_ID`)
) ENGINE=INNODB DEFAULT CHARSET=UTF8;

-- ----------------------------
-- RECORDS OF SYS_ACT_CONFIG
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_ENTRUST
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_ENTRUST`;
CREATE TABLE `SYS_ACT_ENTRUST` (
  `ID` VARCHAR(36) NOT NULL COMMENT 'ID主键，UUID',
  `CONSIGNOR` VARCHAR(36) DEFAULT NULL COMMENT '委托人',
  `PROCESS_ID` VARCHAR(255) DEFAULT NULL COMMENT '流程ID',
  `PROCESS_NAME` VARCHAR(255) DEFAULT NULL COMMENT '流程名称',
  `CONSIGNEE` VARCHAR(36) DEFAULT NULL COMMENT '被委托人ID',
  `CONSIGNEE_NAME` VARCHAR(255) DEFAULT NULL COMMENT '被委托人姓名',
  `START_TIME` DATETIME DEFAULT NULL COMMENT '开始时间',
  `END_TIME` DATETIME DEFAULT NULL COMMENT '结束时间',
  `STATE` CHAR(1) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_ENTRUST
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_EXTEND_PROPERTIES`;
CREATE TABLE `SYS_ACT_EXTEND_PROPERTIES` (
  `ID` VARCHAR(200) NOT NULL COMMENT '主键采用流程定义ID和节点ID拼接组成',
  `PROC_DEF_ID` VARCHAR(64) DEFAULT NULL COMMENT '流程定义ID',
  `TASK_DEF_KEY` VARCHAR(64) DEFAULT NULL COMMENT '节点ID',
  `TASK_DEF_NAME` VARCHAR(1000) DEFAULT NULL COMMENT '节点名称',
  `FORM_DETAIL_KEY` TEXT COMMENT '表单地址',
  `ATTRIBUTE` VARCHAR(32) DEFAULT NULL COMMENT '标识扩展的属性类型',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8;

-- ----------------------------
-- RECORDS OF SYS_ACT_EXTEND_PROPERTIES
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_HI_LINE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_HI_LINE`;
CREATE TABLE `SYS_ACT_HI_LINE` (
  `ID` VARCHAR(32) NOT NULL COMMENT '主键',
  `PROC_INST_ID` VARCHAR(64) DEFAULT NULL COMMENT '流程实例ID',
  `PROC_DEF_ID` VARCHAR(64) DEFAULT NULL COMMENT '流程定义ID',
  `PROC_DEF_KEY` VARCHAR(64) DEFAULT NULL COMMENT '流程定义KEY',
  `LINE_ID` VARCHAR(64) DEFAULT NULL COMMENT '连线ID',
  `COMPLETE_TIME` DATETIME DEFAULT NULL COMMENT '办理时间',
  `COMPLETE_USER` VARCHAR(64) DEFAULT NULL COMMENT '办理人',
  `LINE_NAME` VARCHAR(256) DEFAULT NULL COMMENT '连线名称',
  `PROCESS_NAME` VARCHAR(256) DEFAULT NULL COMMENT '流程名称',
  `OUT_NODE` VARCHAR(64) DEFAULT NULL COMMENT '出线节点',
  `OUT_NODE_NAME` VARCHAR(256) DEFAULT NULL COMMENT '出线节点名称',
  `IN_NODE` VARCHAR(64) DEFAULT NULL COMMENT '入线节点',
  `IN_NODE_NAME` VARCHAR(256) DEFAULT NULL COMMENT '入线节点名称',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_HI_LINE
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_INTERFACE_LOG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_INTERFACE_LOG`;
CREATE TABLE `SYS_ACT_INTERFACE_LOG` (
  `LOG_ID` VARCHAR(32) NOT NULL COMMENT '安全日志编码',
  `SESSION_ID` VARCHAR(128) DEFAULT NULL COMMENT '会话标识',
  `USER_ID` VARCHAR(32) DEFAULT NULL COMMENT '用户账户',
  `USER_NAME` VARCHAR(32) DEFAULT NULL COMMENT '用户名称',
  `CORPORATION_ID` VARCHAR(32) DEFAULT NULL COMMENT '公司编码',
  `CORPORATION_NAME` VARCHAR(128) DEFAULT NULL COMMENT '公司名称',
  `LOG_TIME` DATETIME DEFAULT NULL,
  `REMOTEADDR` VARCHAR(128) DEFAULT NULL,
  `REMOTEHOST` VARCHAR(128) DEFAULT NULL,
  `REMOTEPORT` VARCHAR(8) DEFAULT NULL,
  `LOCALADDR` VARCHAR(128) DEFAULT NULL,
  `LOCALHOST` VARCHAR(128) DEFAULT NULL,
  `LOCALPORT` VARCHAR(8) DEFAULT NULL,
  `RESOURCE_ID` VARCHAR(32) DEFAULT NULL,
  `RESOURCE_ALIAS` VARCHAR(128) DEFAULT NULL COMMENT '资源业务语义',
  `SECURITY_LEVEL` INT(8) DEFAULT NULL,
  `LOG_TYPE` VARCHAR(32) DEFAULT NULL,
  `LOG_TYPE_NAME` VARCHAR(64) DEFAULT NULL,
  `LOG_CONTENT` TEXT,
  `USER_ACCOUNT` VARCHAR(32) DEFAULT NULL COMMENT '用户登录账号',
  `LEVEL_EVENT` VARCHAR(1) DEFAULT NULL COMMENT '1系统级/2业务级事件',
  `STATE` VARCHAR(1) DEFAULT NULL COMMENT '事件类型',
  PRIMARY KEY (`LOG_ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_INTERFACE_LOG
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_MANAGE_LOG
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_MANAGE_LOG`;
CREATE TABLE `SYS_ACT_MANAGE_LOG` (
  `LOG_ID` VARCHAR(32) NOT NULL COMMENT '安全日志编码',
  `SESSION_ID` VARCHAR(128) DEFAULT NULL COMMENT '会话标识',
  `USER_ID` VARCHAR(32) DEFAULT NULL COMMENT '用户账户',
  `USER_NAME` VARCHAR(32) DEFAULT NULL COMMENT '用户名称',
  `CORPORATION_ID` VARCHAR(32) DEFAULT NULL COMMENT '公司编码',
  `CORPORATION_NAME` VARCHAR(128) DEFAULT NULL COMMENT '公司名称',
  `LOG_TIME` DATETIME DEFAULT NULL,
  `REMOTEADDR` VARCHAR(128) DEFAULT NULL,
  `REMOTEHOST` VARCHAR(128) DEFAULT NULL,
  `REMOTEPORT` VARCHAR(8) DEFAULT NULL,
  `LOCALADDR` VARCHAR(128) DEFAULT NULL,
  `LOCALHOST` VARCHAR(128) DEFAULT NULL,
  `LOCALPORT` VARCHAR(8) DEFAULT NULL,
  `RESOURCE_ID` VARCHAR(32) DEFAULT NULL,
  `RESOURCE_ALIAS` VARCHAR(128) DEFAULT NULL COMMENT '资源业务语义',
  `SECURITY_LEVEL` INT(8) DEFAULT NULL,
  `LOG_TYPE` VARCHAR(32) DEFAULT NULL,
  `LOG_TYPE_NAME` VARCHAR(64) DEFAULT NULL,
  `LOG_CONTENT` TEXT,
  `USER_ACCOUNT` VARCHAR(32) DEFAULT NULL COMMENT '用户登录账号',
  `LEVEL_EVENT` VARCHAR(1) DEFAULT NULL COMMENT '1系统级/2业务级事件',
  `STATE` VARCHAR(1) DEFAULT NULL COMMENT '事件类型',
  PRIMARY KEY (`LOG_ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_MANAGE_LOG
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_URGE_TASK
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_URGE_TASK`;
CREATE TABLE `SYS_ACT_URGE_TASK` (
  `ID` VARCHAR(32) NOT NULL COMMENT '主键',
  `TASK_ID` VARCHAR(64) DEFAULT NULL COMMENT '任务ID',
  `PROC_INST_ID` VARCHAR(64) DEFAULT NULL COMMENT '实例ID',
  `PROC_NAME` VARCHAR(255) DEFAULT NULL COMMENT '流程名称',
  `TASK_NAME` VARCHAR(255) DEFAULT NULL COMMENT '任务名称',
  `SEND_USER` VARCHAR(32) DEFAULT NULL COMMENT '发送人',
  `RECEIVE_USER` VARCHAR(32) DEFAULT NULL COMMENT '接收人',
  `SEND_TIME` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `FORM_KEY` VARCHAR(1000) DEFAULT NULL,
  `PROC_DEF_KEY` VARCHAR(64) DEFAULT NULL,
  `BUSINESS_ID` VARCHAR(255) DEFAULT NULL,
  `TASK_DEF_KEY` VARCHAR(64) DEFAULT NULL,
  `TEXT` TEXT DEFAULT NULL COMMENT '待办配置',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_URGE_TASK
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_PROCESS_FILE
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_PROCESS_FILE`;
CREATE TABLE `SYS_ACT_PROCESS_FILE`  (
  `FILE_ID` VARCHAR(64) NOT NULL COMMENT '文件ID',
  `PROCESS_KEY` VARCHAR(64) DEFAULT NULL COMMENT '流程标识',
  `PROCESS_ID` VARCHAR(64) DEFAULT NULL COMMENT '流程ID',
  `VERSION` INT(11) DEFAULT NULL COMMENT '版本号',
  `TYPE` VARCHAR(8) DEFAULT NULL COMMENT '文件类型',
  `CONTENT` LONGBLOB NULL COMMENT '文件内容',
  `MODEL_ID` VARCHAR(64) DEFAULT NULL COMMENT '模块ID',
  `TENANT_ID` VARCHAR(64) DEFAULT NULL COMMENT '租户ID',
  `CREATE_TIME` DATETIME(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`FILE_ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- RECORDS OF SYS_ACT_PROCESS_FILE
-- ----------------------------

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_FUNCTION
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_FUNCTION`;
CREATE TABLE `SYS_ACT_FUNCTION`  (
  `FUNCTION_ID` VARCHAR(36) NOT NULL COMMENT '主键',
  `FUNCTION_NAME` VARCHAR(255) NULL DEFAULT NULL COMMENT '函数名称',
  `FUNCTION_BEAN` VARCHAR(255) NULL DEFAULT NULL COMMENT '函数BEANID',
  `CREATE_TIME` DATETIME(0) NULL DEFAULT NULL COMMENT '创建时间',
  `UPDATE_TIME` DATETIME(0) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`FUNCTION_ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- TABLE STRUCTURE FOR SYS_ACT_FUNCTION_PARM
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_FUNCTION_PARM`;
CREATE TABLE `SYS_ACT_FUNCTION_PARM`  (
  `PARM_ID` VARCHAR(36) NOT NULL COMMENT '主键',
  `FUNCTION_ID` VARCHAR(36) NULL DEFAULT NULL COMMENT '函数主键',
  `PARM_NAME` VARCHAR(255) NULL DEFAULT NULL COMMENT '参数名称',
  `PARM_KEY` VARCHAR(255) NULL DEFAULT NULL COMMENT '参数标识',
  `CREATE_TIME` DATETIME(0) NULL DEFAULT NULL COMMENT '创建时间',
  `UPDATE_TIME` DATETIME(0) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PARM_ID`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=UTF8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sys_act_function_parm
-- ----------------------------
DROP TABLE IF EXISTS `SYS_ACT_TIMEOUT_ACTIVITY`;
CREATE TABLE `SYS_ACT_TIMEOUT_ACTIVITY`  (
    `TASK_ID` varchar(64) NOT NULL COMMENT '任务id',
    `ASSIGNEE` varchar(255) NULL DEFAULT NULL COMMENT '参与者',
    `DUE_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '到期时间',
    `CREATE_TIME` timestamp(0) NULL DEFAULT NULL COMMENT '开始时间',
    `TIME_OUT_TYPE` varchar(255) NULL DEFAULT NULL COMMENT '超时处理类型',
    `TENANT_ID` varchar(255) NULL DEFAULT NULL COMMENT '租户id',
    `MAP` varchar(2000) NULL DEFAULT NULL COMMENT '接口类型额外参数',
    PRIMARY KEY (`TASK_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sys_act_entrust_complete_hi
-- ----------------------------

DROP TABLE IF EXISTS `sys_act_entrust_complete_hi`;
CREATE TABLE `sys_act_entrust_complete_hi`  (
  `id` varchar(36) NOT NULL COMMENT '主键',
  `task_id` varchar(36) NULL DEFAULT NULL COMMENT '任务id',
  `task_definition_key` varchar(255) NULL DEFAULT NULL COMMENT '流程节点id',
  `task_definition_name` varchar(255) NULL DEFAULT NULL COMMENT '流程节点名称',
  `process_definition_key` varchar(255) NULL DEFAULT NULL COMMENT '流程标识',
  `process_inst_id` varchar(36) NULL DEFAULT NULL COMMENT '流程实例id',
  `consignor` varchar(36) NULL DEFAULT NULL COMMENT '委托人',
  `consignee` varchar(36) NULL DEFAULT NULL COMMENT '被委托人id',
  `create_time` timestamp(3) NULL DEFAULT NULL COMMENT '委托时间',
  `state` varchar(2) NULL DEFAULT NULL COMMENT '状态1有效委托0无效委托',
  `update_time` timestamp(3) NULL DEFAULT NULL COMMENT '完成时间',
  `comments` varchar(2000) NULL DEFAULT NULL COMMENT '转办意见',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `ACT_IDX_SYS_ACT_ENTRUST_COMPLETE_HI_CONSIGNOR`(`consignor`) USING BTREE,
  INDEX `ACT_IDX_SYS_ACT_ENTRUST_COMPLETE_HI_TASKID`(`task_id`) USING BTREE,
  INDEX `ACT_IDX_SYS_ACT_ENTRUST_COMPLETE_HI_STATE`(`state`) USING BTREE,
  INDEX `ACT_IDX_SYS_ACT_ENTRUST_COMPLETE_HI_PROCESINSTID`(`process_inst_id`) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT = Compact;

ALTER TABLE ACT_EVT_LOG COMMENT '事件日志表';
ALTER TABLE ACT_GE_BYTEARRAY COMMENT '二进制数据表';
ALTER TABLE ACT_GE_PROPERTY COMMENT '属性数据表';
ALTER TABLE ACT_HI_ACTINST COMMENT '历史节点表';
ALTER TABLE ACT_HI_ATTACHMENT COMMENT '历史附件表';
ALTER TABLE ACT_HI_COMMENT COMMENT '历史意见表';
ALTER TABLE ACT_HI_DETAIL COMMENT '历史详情表';
ALTER TABLE ACT_HI_IDENTITYLINK COMMENT '历史流程人员表';
ALTER TABLE ACT_HI_PROCINST COMMENT '历史流程实例表';
ALTER TABLE ACT_HI_TASKINST COMMENT '历史任务实例表';
ALTER TABLE ACT_HI_VARINST COMMENT '历史变量表';
ALTER TABLE ACT_ID_GROUP COMMENT '用户组信息表';
ALTER TABLE ACT_ID_INFO COMMENT '用户扩展信息表';
ALTER TABLE ACT_ID_MEMBERSHIP COMMENT '用户与分组对应信息表';
ALTER TABLE ACT_ID_USER COMMENT '用户信息表';
ALTER TABLE ACT_PROCDEF_INFO COMMENT '流程定义信息表';
ALTER TABLE ACT_RE_DEPLOYMENT COMMENT '部署信息表';
ALTER TABLE ACT_RE_MODEL COMMENT '流程设计模型部署表';
ALTER TABLE ACT_RE_PROCDEF COMMENT '流程定义数据表';
ALTER TABLE ACT_RU_EVENT_SUBSCR COMMENT '运行实例表';
ALTER TABLE ACT_RU_EXECUTION COMMENT '运行时流程执行实例表';
ALTER TABLE ACT_RU_IDENTITYLINK COMMENT '运行时流程人员表';
ALTER TABLE ACT_RU_JOB COMMENT '运行时定时任务数据表';
ALTER TABLE ACT_RU_TASK COMMENT '运行时任务节点表';
ALTER TABLE ACT_RU_VARIABLE COMMENT '运行时流程变量数据表';
ALTER TABLE SYS_ACT_CC_TASK COMMENT '抄送表';
ALTER TABLE SYS_ACT_CONFIG COMMENT '配置表';
ALTER TABLE SYS_ACT_ENTRUST COMMENT '委托表';
ALTER TABLE SYS_ACT_ENTRUST_COMPLETE_HI COMMENT '历史委托表';
ALTER TABLE SYS_ACT_EXTEND_PROPERTIES COMMENT '流程拓展信息表';
ALTER TABLE SYS_ACT_FUNCTION COMMENT '函数表';
ALTER TABLE SYS_ACT_FUNCTION_PARM COMMENT '函数参数表';
ALTER TABLE SYS_ACT_HI_LINE COMMENT '历史线表';
ALTER TABLE SYS_ACT_INTERFACE_LOG COMMENT '接口日志表';
ALTER TABLE SYS_ACT_MANAGE_LOG COMMENT '操作日志表';
ALTER TABLE SYS_ACT_PROCESS_FILE COMMENT '工作流文件表';
ALTER TABLE SYS_ACT_TIMEOUT_ACTIVITY COMMENT '超时信息表';
ALTER TABLE SYS_ACT_URGE_TASK COMMENT '催办表';