/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@MapperScan(value={"com.jxdinfo.hussar.**.dao"})
public class MybatisPlusConfig {
    @Value(value="${spring.datasource.url:}")
    private String url;

    @Bean
    public MybatisPlusInterceptor paginationInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DbType dbType = this.url.contains("mysql") ? DbType.MYSQL : (this.url.contains("oracle") ? DbType.ORACLE : (this.url.contains("oscar") ? DbType.OSCAR : DbType.DM));
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(dbType));
        return interceptor;
    }
}

