/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.shrio;

import com.jxdinfo.hussar.system.config.BpmSessionManager;
import com.jxdinfo.hussar.system.shrio.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.system.shrio.KickoutSessionFilter;
import com.jxdinfo.hussar.system.shrio.ShiroDbRealm;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
public class ShiroConfig {
    int kilo = 1000;
    @Lazy
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;

    @Bean
    public CredentialsMatcher credentialsMatcher() {
        return this.credentialsMatcher;
    }

    @Bean
    public DefaultWebSecurityManager securityManager(DefaultWebSessionManager sessionManager, CacheManager cacheManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.shiroDbRealm());
        CookieRememberMeManager rememberMeManager = new CookieRememberMeManager();
        securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
        securityManager.setCacheManager(cacheManager);
        securityManager.setSessionManager((SessionManager)sessionManager);
        return securityManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="bpm", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
    public SessionDAO redisSessionDAO(IRedisManager redisManager) {
        RedisSessionDAO sessionDAO = null;
        sessionDAO = new RedisSessionDAO();
        sessionDAO.setRedisManager(redisManager);
        return sessionDAO;
    }

    @Bean
    @ConditionalOnProperty(prefix="bpm", name={"stand-alone"}, havingValue="true", matchIfMissing=true)
    public SessionDAO sessionDAO() {
        MemorySessionDAO sessionDAO = null;
        sessionDAO = new MemorySessionDAO();
        return sessionDAO;
    }

    @Bean
    public SessionValidationScheduler sessionValidationScheduler(BpmSessionManager sessionManager) {
        ExecutorServiceSessionValidationScheduler svs = new ExecutorServiceSessionValidationScheduler();
        svs.setInterval((long)(900 * this.kilo));
        svs.setSessionManager((ValidatingSessionManager)sessionManager);
        svs.enableSessionValidation();
        return svs;
    }

    @Bean
    public DefaultWebSessionManager defaultWebSessionManager(CacheManager cacheShiroManager, Collection<SessionListener> listeners, SessionDAO sessionDAO) {
        BpmSessionManager sessionManager = new BpmSessionManager();
        sessionManager.setSessionValidationScheduler(this.sessionValidationScheduler(sessionManager));
        sessionManager.setSessionValidationInterval(900 * this.kilo);
        sessionManager.setGlobalSessionTimeout(3600 * this.kilo);
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        sessionManager.setSessionListeners(listeners);
        sessionManager.setCacheManager(cacheShiroManager);
        sessionManager.setSessionDAO(sessionDAO);
        sessionManager.setSessionIdCookieEnabled(true);
        SimpleCookie cookie = new SimpleCookie("_hussarShiroCookie");
        cookie.setHttpOnly(true);
        sessionManager.setSessionIdCookie((Cookie)cookie);
        return sessionManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="bpm", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
    public CacheManager redisCacheShiroManager(IRedisManager redisManager) {
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setRedisManager(redisManager);
        cacheManager.setPrincipalIdFieldName("userId");
        return cacheManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="bpm", name={"stand-alone"}, havingValue="true", matchIfMissing=true)
    public CacheManager ehCacheShiroManager(EhCacheManagerFactoryBean ehcache) {
        EhCacheManager ehCacheManager = new EhCacheManager();
        ehCacheManager.setCacheManager(ehcache.getObject());
        return ehCacheManager;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager(SimpleCookie rememberMeCookie) {
        CookieRememberMeManager manager = new CookieRememberMeManager();
        manager.setCipherKey(Base64.decode((String)"SHVzc2FyVjgAAAAAAAAAA="));
        manager.setCookie((Cookie)rememberMeCookie);
        return manager;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(DefaultWebSecurityManager securityManager, DefaultWebSessionManager sessionManager, SessionDAO sessionDAO) {
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager((SecurityManager)securityManager);
        HashMap<String, KickoutSessionFilter> filters = new HashMap<String, KickoutSessionFilter>();
        filters.put("kickout", this.kickoutSessionFilter(sessionManager, sessionDAO));
        shiroFilter.setFilters(filters);
        this.loadShiroFilterChain(shiroFilter);
        return shiroFilter;
    }

    public KickoutSessionFilter kickoutSessionFilter(DefaultWebSessionManager sessionManager, SessionDAO sessionDAO) {
        KickoutSessionFilter kickoutSessionFilter = new KickoutSessionFilter();
        kickoutSessionFilter.setSessionManager((SessionManager)sessionManager);
        kickoutSessionFilter.setMaxSession(100L);
        kickoutSessionFilter.setSessionDAO(sessionDAO);
        return kickoutSessionFilter;
    }

    @Bean
    public MethodInvokingFactoryBean methodInvokingFactoryBean(DefaultWebSecurityManager securityManager) {
        MethodInvokingFactoryBean bean = new MethodInvokingFactoryBean();
        bean.setStaticMethod("org.apache.shiro.SecurityUtils.setSecurityManager");
        bean.setArguments(new Object[]{securityManager});
        return bean;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie("_rememberMe");
        simpleCookie.setComment("\u767b\u5f55\u72b6\u6001\u5df2\u88ab\u8bb0\u5f55");
        simpleCookie.setHttpOnly(true);
        int time = 604800;
        simpleCookie.setMaxAge(time);
        return simpleCookie;
    }

    @Bean
    public FilterRegistrationBean<DelegatingFilterProxy> filterRegistrationBean() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new DelegatingFilterProxy("shiroFilter"));
        filterRegistration.addInitParameter("targetFilterLifecycle", "true");
        filterRegistration.setEnabled(true);
        filterRegistration.addUrlPatterns(new String[]{"/*"});
        filterRegistration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD});
        return filterRegistration;
    }

    @Bean
    public ShiroDbRealm shiroDbRealm() {
        ShiroDbRealm shiroDbRealm = new ShiroDbRealm();
        shiroDbRealm.setCredentialsMatcher((CredentialsMatcher)new AbstractCredentialsMatcher());
        return shiroDbRealm;
    }

    private void loadShiroFilterChain(ShiroFilterFactoryBean shiroFilterFactoryBean) {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/druid/*", "anon");
        filterChainDefinitionMap.put("/static/**", "anon");
        filterChainDefinitionMap.put("/", "anon");
        filterChainDefinitionMap.put("/login", "anon");
        filterChainDefinitionMap.put("/withoutPwdLogin", "anon");
        filterChainDefinitionMap.put("/getLoginInf", "anon");
        filterChainDefinitionMap.put("/definition/**", "anon");
        filterChainDefinitionMap.put("/instance/**", "anon");
        filterChainDefinitionMap.put("/task/**", "anon");
        filterChainDefinitionMap.put("/ccTask/**", "anon");
        filterChainDefinitionMap.put("/sysActUrgeTask/**", "anon");
        filterChainDefinitionMap.put("/sysActEntrust/**", "anon");
        filterChainDefinitionMap.put("/hussarBpmDiagram/**", "anon");
        filterChainDefinitionMap.put("/godaxeModel/**", "anon");
        filterChainDefinitionMap.put("/godaxeAssignee/**", "anon");
        filterChainDefinitionMap.put("/flowChart/**", "anon");
        filterChainDefinitionMap.put("/flowEvents/**", "anon");
        filterChainDefinitionMap.put("/addCustomNode/**", "anon");
        filterChainDefinitionMap.put("/godAxeFunction/**", "anon");
        filterChainDefinitionMap.put("/tenant/tenantInsertReturnInfo", "anon");
        filterChainDefinitionMap.put("/tenant/deleteTenantList", "anon");
        filterChainDefinitionMap.put("/**", "kickout");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
    }
}

