/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.license;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.constant.HttpCode;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/license"})
public class LicenseController
extends BaseController {
    @RequestMapping(value={"/view"})
    @ManageBusinessLog(key="/license/view", type="\u67e5\u8be2", value="\u6388\u6743\u4fe1\u606f\u9875\u9762")
    public ApiResponse<Map<String, Object>> index(@RequestBody Map<String, Object> map) {
        String type = map.get("type") == null ? "" : map.get("type").toString();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("noLicense", false);
        dataMap.put("errorLicense", false);
        dataMap.put("needLicense", false);
        dataMap.put("needWarning", false);
        if ("1".equals(type)) {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put("errorLicense", true);
            } else {
                dataMap.put("noLicense", true);
            }
        } else if (this.isLicenseValid()) {
            dataMap.put("startDate", DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy-MM-dd"));
            dataMap.put("endDate", DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy-MM-dd"));
            Integer licenseType = LicenseInfo.getLicenseType();
            dataMap.put("projectName", LicenseInfo.getProjectName());
            if (licenseType == 0) {
                dataMap.put("projectName", LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                dataMap.put("licenseType", "\u5f00\u53d1\u73af\u5883\u6388\u6743");
                dataMap.put("needLicense", true);
            } else if (licenseType == 1) {
                dataMap.put("licenseType", "\u90e8\u7f72\u6388\u6743");
                if (LicenseInfo.nearEndDateWarning()) {
                    dataMap.put("needWarning", true);
                } else if (LicenseInfo.needWarning()) {
                    dataMap.put("needLicense", true);
                }
            } else if (licenseType == 2) {
                dataMap.put("licenseType", "VOL\u6279\u91cf\u6388\u6743");
            } else if (licenseType == 3) {
                dataMap.put("projectName", LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                dataMap.put("licenseType", "\u5f00\u53d1\u8005\u6388\u6743");
            } else if (licenseType == 5) {
                dataMap.put("licenseType", "\u6b63\u5f0f\u6388\u6743");
                dataMap.put("endDate", "\u4e0d\u9650");
            }
            dataMap.put("hasLicense", true);
        } else {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put("errorLicense", true);
            } else {
                dataMap.put("noLicense", true);
            }
        }
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    public ApiResponse<Tip> uploadLicenseFile(@RequestPart(value="file") MultipartFile file) {
        try {
            File path = new File(LicenseInfo.TMP_PATH);
            if (!path.exists()) {
                path.mkdirs();
            }
            file.transferTo(new File(LicenseInfo.TMP_PATH + File.separator + file.getOriginalFilename()));
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        if (this.checkLicense()) {
            this.updateLicense();
            return ApiResponse.success((int)BpmEnum.AUTHORIZATION_SUCCESS.getCode(), (String)BpmEnum.AUTHORIZATION_SUCCESS.getMessage());
        }
        return ApiResponse.fail((int)BpmEnum.ERROR_AUTHORIZATION.getCode(), (String)BpmEnum.ERROR_AUTHORIZATION.getMessage());
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/check"})
    public ApiResponse<Tip> check() {
        boolean isTrial = SecurityUtil.isTrial();
        if (isTrial) {
            JSONObject json = new JSONObject();
            json.put("startDate", (Object)DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy.MM.dd"));
            json.put("endDate", (Object)DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy.MM.dd"));
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        JSONObject json = new JSONObject();
        json.put("message", (Object)("\u6388\u6743\u5c06\u5728" + DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy.MM.dd") + "\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u7533\u8bf7\u6388\u6743"));
        if (LicenseInfo.nearEndDateWarning()) {
            json.put("days", (Object)"7");
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        if (LicenseInfo.needWarning()) {
            json.put("days", (Object)"30");
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        return ApiResponse.success((int)BpmEnum.DEFAULT_SUCCESS_MESSAGE.getCode(), (String)BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage());
    }

    private boolean isLicenseValid() {
        return LicenseInfo.isLicenseValidity();
    }

    private boolean checkLicense() {
        return LicenseInfo.checkLicense();
    }

    private void updateLicense() {
        LicenseInfo.update();
    }
}

