/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.system.mutidatasource.annotation.TargetDataSource;
import com.jxdinfo.hussar.system.utils.ShiroUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taskManager"})
public class TaskManagerController {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    TaskEngineService taskEngineService;
    @Autowired
    private ITenantConfigService tenantConfigService;
    @Autowired
    FlowEventsService flowEventsService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @RequestMapping(value={"/getTaskManager"})
    @ManageBusinessLog(key="/taskManager/getTaskManager", value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> getTaskManager(@RequestParam Map<String, Object> map) {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(ShiroUser.getTenantId());
        if (tenantConfig == null || !"1".equals(tenantConfig.getIsMqUse()) && (tenantConfig.getProjectAddress() == null || "".equals(tenantConfig.getProjectAddress()))) {
            return ApiResponse.data(null);
        }
        map.put("tenantId", ShiroUser.getTenantId());
        Page pages = new Page((long)Integer.parseInt((String)map.get("page")), (long)Integer.parseInt((String)map.get("limit")));
        List list = this.taskManagerService.getTask(pages, map);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("count", pages.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/suspendTaskById"})
    @ManageBusinessLog(key="/taskManager/suspendTaskById", value="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", type="\u6302\u8d77")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> suspendTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.suspendTaskById(instId);
    }

    @RequestMapping(value={"/activateTaskById"})
    @ManageBusinessLog(key="/taskManager/activateTaskById", value="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", type="\u6fc0\u6d3b")
    @TargetDataSource
    public ApiResponse<Map<String, Object>> activateTaskById(@RequestParam(value="instId") String instId) {
        return this.taskManagerService.activateTaskById(instId);
    }

    @RequestMapping(value={"/completeTask"})
    @ManageBusinessLog(key="/taskManager/completeTask", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    @TargetDataSource
    public ApiResponse<Object> completeTask(String taskId, String userId) {
        BpmResponseResult bpmResponseResult;
        try {
            bpmResponseResult = this.taskEngineService.completeTask(taskId, userId, null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/addUserTask"})
    @ManageBusinessLog(key="/taskManager/addUserTask", value="\u6dfb\u52a0\u53c2\u4e0e\u8005", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<Object> addUserTask(String taskId, String consignee) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = this.taskEngineService.taskAddAssignee(taskId, consignee);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)bpmResponseResult.getMsg());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/entrustTaskByTaskId"})
    @ManageBusinessLog(key="/taskManager/entrustTaskByTaskId", value="\u4efb\u52a1\u8f6c\u529e", type="\u4efb\u52a1\u8f6c\u529e")
    @TargetDataSource
    public ApiResponse<Object> entrustTask(String taskId, String consignee) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = this.taskEngineService.entrustTask(taskId, consignee, 1);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)bpmResponseResult.getMsg());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        if (String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()).equals(bpmResponseResult.getCode())) {
            return ApiResponse.fail((int)BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode(), (String)BpmEnum.ERROR_ENTRUST_ASSIGNEE.getMessage());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @RequestMapping(value={"/getJumpTasks"})
    @ManageBusinessLog(key="/taskManager/getJumpTasks", value="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9", type="\u67e5\u8be2")
    @TargetDataSource
    public ApiResponse<Object> getJumpTasks(String taskId) {
        String flowModelMessage = this.taskManagerService.getFileByTaskId(taskId);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage, FlowModel.class);
        ArrayList tasks = new ArrayList();
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName())) continue;
            HashMap<String, String> task = new HashMap<String, String>();
            task.put("id", flowObject.getId());
            task.put("value", flowObject.getProps().getFlowName());
            tasks.add(task);
        }
        return ApiResponse.data(tasks);
    }

    @RequestMapping(value={"/freeJump"})
    @ManageBusinessLog(key="/taskManager/freeJump", value="\u81ea\u7531\u8df3\u8f6c", type="\u4fee\u6539")
    @TargetDataSource
    public ApiResponse<Object> freeJump(String taskId, String activityId, String assignees, String userId) {
        BpmResponseResult result;
        try {
            result = this.taskEngineService.freeJump(taskId, activityId, userId, assignees, false, null, null);
        }
        catch (PublicClientException e) {
            return ApiResponse.fail((String)e.getReason());
        }
        if ("1".equals(result.getCode())) {
            return ApiResponse.success((String)this.bpmConstantProperties.getFreeJumpSuccess());
        }
        return ApiResponse.fail((String)result.getMsg());
    }

    @RequestMapping(value={"/urgeTask"})
    @ManageBusinessLog(key="/taskManager/urgeTask", value="\u4efb\u52a1\u50ac\u529e", type="\u4fee\u6539")
    @TargetDataSource
    public BpmResponseResult userTask(String processInstId) {
        return this.flowEventsService.urgeTask(processInstId, "superadmin");
    }
}

