/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.GodAxeModelService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.util.BpmTenantInfoUtils;
import com.jxdinfo.hussar.engine.InstanceEngineService;
import com.jxdinfo.hussar.engine.TaskEngineService;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicProcess"})
public class PublicProcessController {
    @Autowired
    public GodAxeModelService godAxeModelService;
    @Autowired
    private IInstanceEngineService iInstanceEngineService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryNextNode"})
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.queryNextNode(processDefinitionKey, taskId);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryNextNodeByLineCondition"})
    public BpmResponseResult queryNextNodeByLineCondition(String processDefinitionKey, String taskId, Map<String, Object> lineCondition) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.queryNextNode(processDefinitionKey, taskId, lineCondition);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String userId) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.queryNextAssignee(processDefinitionKey, taskId, nodeId, userId, null);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getAllProcessTraceByBusinessKey"})
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, int page, int size) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = InstanceEngineService.getAllProcessTraceByBusinessKey(businessKey, page, size);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/addCustomNode"})
    public BpmResponseResult addCustomNode(@RequestBody Map<String, Object> map) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.addCustomNode(String.valueOf(map.get("taskId")), (List)map.get("list"), String.valueOf(map.get("parallel")));
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/isAddParallel"})
    public BpmResponseResult isAddParallel(@RequestBody Map<String, String> map) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.isAddParallel(map.get("taskId"));
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/queryRejectNode"})
    public BpmResponseResult queryRejectNode(String taskId) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            BpmResponseResult bpmResponseResult = TaskEngineService.queryRejectNode(taskId);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateProcess"})
    public ApiResponse<?> updateProcess(@RequestBody Map<String, Object> map) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            String tenantId = BaseShiroKit.getUser().getTenantId();
            ApiResponse<?> apiResponse = this.godAxeModelService.updateProcess((WorkFlow)map.get("workFlow"), tenantId);
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryCompletecComments"})
    public BpmResponseResult queryCompletecComments(String processInstanceId, String businessKey) {
        try {
            BpmTenantInfoUtils.changeDataSourceByRequest();
            String tenantId = BaseShiroKit.getUser().getTenantId();
            BpmResponseResult bpmResponseResult = this.iInstanceEngineService.queryCompleteComent(businessKey, processInstanceId, tenantId);
            return bpmResponseResult;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/getModifyConfigurationOnline"})
    public ApiResponse<?> getModifyConfigurationOnline() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isModifyConfigurationOnline()));
    }

    @RequestMapping(value={"/isProductionMode"})
    public ApiResponse<?> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isEditableOnline()));
    }
}

