/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.controller;

import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.response.ApiResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processInst"})
public class ProcessInstController
extends BaseController {
    @Autowired
    private ProcessInstService processInstService;

    @RequestMapping(value={"/getProcessList"})
    @ManageBusinessLog(key="/processInst/getProcessList", value="\u5c55\u793a\u6d41\u7a0b\u5b9e\u65bd\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> getRunningProcessList(@RequestParam Map<String, Object> map) {
        map.put("processDefName", map.get("definitionName"));
        return ApiResponse.data((Object)this.processInstService.getProcessList(map));
    }

    @RequestMapping(value={"/deleteProcessById"})
    @ManageBusinessLog(key="/processInst/deleteProcessById", value="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public ApiResponse<Map<String, Object>> deleteProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/deleteFinishedProcessById"})
    @ManageBusinessLog(key="/processInst/deleteFinishedProcessById", value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public ApiResponse<?> deleteFinishedProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteFinishedProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/suspendProcessById"})
    @ManageBusinessLog(key="/processInst/suspendProcessById", value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", type="\u6302\u8d77")
    public ApiResponse<Map<String, Object>> suspendProcessById(@RequestParam(value="instId") String instId) {
        return this.processInstService.suspendProcessInstanceById(instId);
    }

    @RequestMapping(value={"/activateProcessById"})
    @ManageBusinessLog(key="/processInst/activateProcessById", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", type="\u6fc0\u6d3b")
    public ApiResponse<Map<String, Object>> activateProcessById(@RequestParam(value="instId") String instId) {
        return this.processInstService.activateProcessById(instId);
    }
}

