/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.flowchart.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.bsp.tenant.dao.SysUserMapper;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.wfdtoprocess.service.WfdToProcessService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowChart"})
public class FlowChartController {
    @Autowired
    private ProcessDiagramService processDiagramService;
    @Autowired
    private HistoryService historyService;
    @Resource
    private SysUserMapper sysUserMapper;
    @Autowired
    private WfdToProcessService wfdToProcessService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/historyList"})
    @InterfaceLog(key="/flowChart/historyList", value="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868", type="\u67e5\u8be2")
    public Map<String, Object> historyList(HttpServletRequest request, String processInstanceId, String businessKey) {
        String tenantId = request.getParameter("tenantId");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        try {
            this.changeDSIfNeed(businessKey, processInstanceId);
            if (ToolUtil.isEmpty((Object)processInstanceId)) {
                HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (instance != null) {
                    processInstanceId = instance.getId();
                } else {
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
            }
            JSONArray json = this.processDiagramService.list(processInstanceId, tenantId);
            result.put("count", json.size());
            result.put("data", json);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/historyMicroList"})
    @InterfaceLog(key="/flowChart/historyMicroList", value="\u67e5\u8be2\u79fb\u52a8\u7aef\u529e\u7406\u5386\u53f2\u5217\u8868", type="\u67e5\u8be2")
    public Map<String, Object> historyMicroList(HttpServletRequest request, String processInstanceId, String businessKey) {
        String tenantId = request.getParameter("tenantId");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        try {
            this.changeDSIfNeed(businessKey, processInstanceId);
            if (ToolUtil.isEmpty((Object)processInstanceId)) {
                HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (instance != null) {
                    processInstanceId = instance.getId();
                } else {
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
            }
            JSONArray json = this.processDiagramService.microAppList(processInstanceId, tenantId);
            result.put("count", json.size());
            result.put("data", json);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getProcessDetail"})
    @InterfaceLog(key="/flowChart/getProcessDetail", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONObject getProcessDetail(String processInstanceId, String businessKey) {
        try {
            this.changeDSIfNeed(businessKey, processInstanceId);
            if (ToolUtil.isEmpty((Object)processInstanceId)) {
                HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (instance != null) {
                    processInstanceId = instance.getId();
                } else {
                    JSONObject jSONObject = new JSONObject();
                    return jSONObject;
                }
            }
            JSONObject jSONObject = this.processDiagramService.getProcessInfo(processInstanceId);
            return jSONObject;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getProcessCompleteDetail"})
    @InterfaceLog(key="/flowChart/getProcessCompleteDetail", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONArray getProcessCompleteDetail(String processInstanceId, String businessKey, String tenantId) {
        try {
            this.changeDSIfNeed(businessKey, processInstanceId);
            if (ToolUtil.isEmpty((Object)processInstanceId)) {
                HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (instance != null) {
                    processInstanceId = instance.getId();
                } else {
                    JSONArray jSONArray = new JSONArray();
                    return jSONArray;
                }
            }
            JSONArray jSONArray = this.processDiagramService.getProcessCompleteInfo(processInstanceId, tenantId);
            return jSONArray;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/subProcessList"})
    @InterfaceLog(key="/flowChart/subProcessList", value="\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5bf9\u5e94\u7684\u5916\u90e8\u6d41\u7a0b\u6570\u636e", type="\u67e5\u8be2")
    public Map<String, Object> subProcessList(String supProcessInstId, String businessKey, String taskDefinitionKey, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="9999") Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.changeDSIfNeed(businessKey, supProcessInstId);
            if (ToolUtil.isEmpty((Object)supProcessInstId)) {
                HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (instance != null) {
                    supProcessInstId = instance.getId();
                } else {
                    HashMap<String, Object> hashMap = map;
                    return hashMap;
                }
            }
            map.put("supProcessInstId", supProcessInstId);
            map.put("taskDefinitionKey", taskDefinitionKey);
            map.put("page", page);
            map.put("limit", limit);
            Map map2 = this.processDiagramService.subProcessList(map);
            return map2;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    @RequestMapping(value={"/getProcessInfoByFile"})
    @InterfaceLog(key="/flowChart/getProcessInfoByFile", value="\u901a\u8fc7\u6587\u4ef6\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5404\u4e2a\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processDefKey, String tenantId) throws IOException {
        return this.wfdToProcessService.getProcessInfoByFile(processDefKey, processIdentityKey, tenantId);
    }

    private void changeDSIfNeed(String businessKey, String processInstanceId) {
        Map map = this.sysUserMapper.getListByBusinessKeyAndProcInstId(businessKey, processInstanceId);
        if (map == null || map.size() == 0) {
            DataSourceUtil.changeTempDs((String)"master");
        }
    }
}

