/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.controller;

import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.response.ApiResponse;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processInst"})
public class ProcessInstController
extends BaseController {
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private BussinessLogService businessLog;

    @RequestMapping(value={"/getProcessList"})
    @ManageBusinessLog(key="/processInst/getProcessList", value="\u5c55\u793a\u6d41\u7a0b\u5b9e\u65bd\u5217\u8868", type="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> getRunningProcessList(@RequestParam Map<String, Object> map) {
        map.put("processDefName", map.get("definitionName"));
        return ApiResponse.data((Object)this.processInstService.getProcessList(map));
    }

    @RequestMapping(value={"/deleteProcessById"})
    @ManageBusinessLog(key="/processInst/deleteProcessById", value="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public ApiResponse<Map<String, Object>> deleteProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/deleteFinishedProcessById"})
    @ManageBusinessLog(key="/processInst/deleteFinishedProcessById", value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public ApiResponse<?> deleteFinishedProcessById(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteFinishedProcessInstance((String)instId.get("instId"));
    }

    @RequestMapping(value={"/deleteProcessByIds"})
    @ManageBusinessLog(key="/processInst/deleteProcessByIds", value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public ApiResponse<?> deleteProcessByIds(@RequestBody Map<String, Object> instId) {
        return this.processInstService.deleteProcessByIds((String)instId.get("instIds"));
    }

    @RequestMapping(value={"/suspendProcessById"})
    @ManageBusinessLog(key="/processInst/suspendProcessById", value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", type="\u6302\u8d77")
    public ApiResponse<Map<String, Object>> suspendProcessById(@RequestParam(value="instId") String instId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(instId).singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9e\u4f8b\u7c7b\u578b\u7684\u64cd\u4f5c,\u5bf9");
        b.append(processInstance.getProcessDefinitionName());
        b.append("\u6d41\u7a0b\u8fdb\u884c\u4e86\u6302\u8d77\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("26", "/processInst/suspendProcessById", b.toString(), processInstance.getProcessDefinitionName());
        return this.processInstService.suspendProcessInstanceById(instId);
    }

    @RequestMapping(value={"/activateProcessById"})
    @ManageBusinessLog(key="/processInst/activateProcessById", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", type="\u6fc0\u6d3b")
    public ApiResponse<Map<String, Object>> activateProcessById(@RequestParam(value="instId") String instId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(instId).singleResult();
        ShiroUser user = BaseShiroKit.getUser();
        StringBuilder b = new StringBuilder();
        b.append(user.getName());
        b.append("\u5728");
        b.append(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        b.append("\u8fdb\u884c\u4e86\u6d41\u7a0b\u5b9e\u4f8b\u7c7b\u578b\u7684\u64cd\u4f5c,\u5bf9");
        b.append(processInstance.getProcessDefinitionName());
        b.append("\u8fdb\u884c\u4e86\u6fc0\u6d3b\u64cd\u4f5c");
        this.businessLog.saveBusinessLog("25", "/processInst/activateProcessById", b.toString(), processInstance.getProcessDefinitionName());
        return this.processInstService.activateProcessById(instId);
    }
}

