/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskEngineService {
    private static ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private static AddCustomNodeService addCustomNodeService = (AddCustomNodeService)SpringContextHolder.getBean(AddCustomNodeService.class);

    public static BpmResponseResult queryTask(String taskId) {
        return taskEngineService.queryTask(taskId, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult queryAllToDoTaskList(String processName, String processDefinitionKey, String startTime, String endTime, String isTimeOut, String suspension, String todoConfiguration, Integer page, Integer limit) {
        return taskEngineService.queryAllToDoTaskList(processName, processDefinitionKey, startTime, endTime, isTimeOut, suspension, todoConfiguration, BaseShiroKit.getUser().getTenantId(), page, limit);
    }

    public static BpmResponseResult queryAllToDoTaskListByBusiness(String processName, String processDefinitionKey, String startTime, String endTime, String isTimeOut, String suspension, String todoConfiguration, List<String> businessList, Integer page, Integer limit) {
        return taskEngineService.queryAllToDoTaskListByBusiness(processName, processDefinitionKey, startTime, endTime, isTimeOut, suspension, todoConfiguration, businessList, BaseShiroKit.getUser().getTenantId(), page, limit);
    }

    public static BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey) {
        return taskEngineService.queryToDoTaskList(userId, processDefinitionKey, definitionKey);
    }

    public static BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return taskEngineService.queryToDoTaskList(userId, processDefinitionKey, definitionKey, page, rows);
    }

    public static BpmResponseResult queryToDoTaskList(String userId, List<String> businessIds) {
        return taskEngineService.queryToDoTaskList(userId, businessIds);
    }

    public static BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey) {
        return taskEngineService.queryFinishedTaskList(userId, processDefinitionKey, definitionKey);
    }

    public static BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return taskEngineService.queryFinishedTaskList(userId, processDefinitionKey, definitionKey, page, rows);
    }

    public static BpmResponseResult queryUserTaskCount(String userId) {
        return taskEngineService.queryUserTaskCount(userId);
    }

    public static BpmResponseResult queryUserTaskCountByNode(String userId) {
        return taskEngineService.queryUserTaskCountByNode(userId);
    }

    public static BpmResponseResult claimTask(String taskId, String userId) {
        return taskEngineService.claimTask(taskId, userId);
    }

    public static BpmResponseResult unClaimTask(String taskId) {
        return taskEngineService.unClaimTask(taskId);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, comment, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, comment, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, comment, subProcesses, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public static BpmResponseResult completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map, false);
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return taskEngineService.completeLeapTask(taskId, userId, assigneeMap, comment, map);
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeLeapTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToLastTask(taskId, userId, comment, "", isSubmit, map, null);
    }

    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToLastTask(taskId, userId, comment, assignees, isSubmit, map, null);
    }

    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToFirstTask(taskId, userId, comment, assignees, isSubmit, map);
    }

    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToFirstTask(taskId, userId, comment, "", isSubmit, map);
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, assignees, null, isSubmit, map);
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, String> assigneeMap, Map<String, Object> map) {
        return taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, "", assigneeMap, isSubmit, map);
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, "", null, isSubmit, map);
    }

    public static BpmResponseResult queryRejectNode(String taskId) {
        return taskEngineService.queryRejectNode(taskId);
    }

    public static BpmResponseResult delegateTask(String taskId, String userId) {
        return taskEngineService.delegateTask(taskId, userId);
    }

    public static BpmResponseResult entrustTask(String taskId, String userId, String consignee) {
        return taskEngineService.entrustTask(taskId, userId, consignee);
    }

    public static BpmResponseResult entrustTask(String taskId, String consignee) {
        return taskEngineService.entrustTask(taskId, consignee, 1);
    }

    public static BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        return taskEngineService.freeJump(taskId, activitiId, userId, assignees, null, isSubmit, comment, map);
    }

    public static BpmResponseResult freeJump(String taskId, String activitiId, String userId, boolean isSubmit, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return taskEngineService.freeJump(taskId, activitiId, userId, "", assigneeMap, isSubmit, comment, map);
    }

    public static BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        return taskEngineService.multiInstanceAddAssignee(taskId, assigneeList);
    }

    public static BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return taskEngineService.queryAssigneeByTaskId(taskId);
    }

    public static BpmResponseResult addAssignees(String taskId, String businessKey, String users) {
        return taskEngineService.addAssignees(taskId, businessKey, users);
    }

    public static BpmResponseResult taskAddAssignee(String taskId, String consignee) {
        return taskEngineService.taskAddAssignee(taskId, consignee);
    }

    public static BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public static BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        if (ToolUtil.isEmpty(map)) {
            map = new HashMap<String, Object>();
        }
        map.put("flow_submiter", BaseShiroKit.getUser().getId());
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, BaseShiroKit.getUser().getTenantId(), map);
    }

    public static BpmResponseResult queryNextAssignee(String processDefinitionKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        if (ToolUtil.isEmpty(map)) {
            map = new HashMap<String, Object>();
        }
        map.put("flow_submiter", BaseShiroKit.getUser().getId());
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processDefinitionKey, taskId, nodeId, userId, map);
    }

    public static BpmResponseResult queryNextAssignee(String processDefinitionKey, String taskId, String nodeId, Map<String, Object> map) {
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processDefinitionKey, taskId, nodeId, map);
    }

    public static BpmResponseResult queryAllAssignee(String processDefinitionKey) {
        return taskEngineService.queryAllAssignee(processDefinitionKey, null);
    }

    public static BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(String processDefinitionKey, String taskDefinitionKey) {
        return taskEngineService.queryAllAssignee(processDefinitionKey, taskDefinitionKey);
    }

    public static BpmResponseResult queryHistoryActByTaskId(String taskId) {
        return taskEngineService.queryHistoryActByTaskId(taskId, null);
    }

    public static BpmResponseResult getProcessDefinitionIdAndNodeId(String processDefinitionKey, String taskId) {
        return taskEngineService.getProcessDefinitionIdAndNodeId(processDefinitionKey, taskId);
    }

    public static BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        return taskEngineService.queryTaskIdByBusinessKey(businessId);
    }

    public static BpmResponseResult queryNextNode(String taskId) {
        return taskEngineService.queryNextNode(taskId);
    }

    public static BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        return taskEngineService.queryNextNode(processDefinitionKey, taskId);
    }

    public static BpmResponseResult queryNextNode(String processDefinitionKey, String taskId, Map<String, Object> lineCondition) {
        return taskEngineService.queryNextNode(processDefinitionKey, taskId, lineCondition);
    }

    public static BpmResponseResult withdrawState(String historicTaskId) {
        return taskEngineService.withdrawState(historicTaskId);
    }

    @Deprecated
    public static BpmResponseResult withdrawStateByBusinessKey(String businessKey, String userId, String taskId) {
        return taskEngineService.withdrawState(businessKey, userId, taskId);
    }

    public static BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.revokeTask(historicTaskId, userId, comment, isSubmit, map);
    }

    public static BpmResponseResult editTaskComment(String taskId, String comment) {
        return taskEngineService.editTaskComment(taskId, comment);
    }

    public static BpmResponseResult reStartProcess(String processInstanceId, String businessKey, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.reStartProcess(processInstanceId, businessKey, taskDefinitionKey, userId, assignee, isSubmit, map);
    }

    public static BpmResponseResult addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        return addCustomNodeService.addNode(taskId, JSON.toJSONString(list), BaseShiroKit.getUser().getTenantId(), parallel);
    }

    public static BpmResponseResult isAddParallel(String taskId) {
        return addCustomNodeService.isAddParallel(taskId, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult multiInstanceDelAssignee(String taskId) {
        return taskEngineService.multiInstanceDelAssignee(taskId, null);
    }

    public static BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        return taskEngineService.multiInstanceDelAssignee(taskId, assignees);
    }

    public static BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        return taskEngineService.updateUserSecurityLevel(userId, level);
    }

    public static BpmResponseResult activeTaskCandidates(String taskId) {
        return taskEngineService.activeTaskCandidates(taskId);
    }

    public static BpmResponseResult updateStarter(String processInstanceId, String businessKey, String userId) {
        return taskEngineService.updateStarter(processInstanceId, businessKey, userId);
    }

    public static BpmResponseResult getExecutionByBusinessKey(String businessKey) {
        return taskEngineService.getExecutionByBusinessKey(businessKey);
    }

    public static BpmResponseResult receiveTaskSignal(String executionId) {
        return taskEngineService.receiveTaskSignal(executionId, null);
    }

    public static BpmResponseResult receiveTaskSignalWithVariable(String executionId, Map<String, Object> map) {
        return taskEngineService.receiveTaskSignal(executionId, map);
    }

    public static BpmResponseResult queryInfoByBusinessAndDefinitionKey(String businessKey, String taskDefinitionKey) {
        return taskEngineService.queryInfoByBusinessAndDefinitionKey(businessKey, taskDefinitionKey);
    }

    public static BpmResponseResult queryToDoTaskListWithProcDefKeys(String userId, String processDefinitionKeys, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit) {
        return taskEngineService.todoList(userId, processDefinitionKeys, message, sendUserId, startTime, endTime, page, limit, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult queryFinishTaskListWithProcDefKeys(String userId, String processDefinitionKeys, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit) {
        return taskEngineService.doneList(userId, processDefinitionKeys, message, sendUserId, startTime, endTime, page, limit, BaseShiroKit.getUser().getTenantId());
    }
}

