/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerSystemService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.util.BpmTenantInfoUtils;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.response.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerSystemServiceImpl
implements TaskManagerSystemService {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    private ITenantConfigService tenantConfigService;
    @Autowired
    FlowEventsService flowEventsService;

    @Override
    public ApiResponse<Map<String, Object>> getTaskManager(Map<String, Object> map) {
        if (BpmTenantInfoUtils.isStartAlone()) {
            TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(BaseShiroKit.getUser().getTenantId());
            if (tenantConfig == null || !"1".equals(tenantConfig.getIsMqUse()) && (tenantConfig.getProjectAddress() == null || "".equals(tenantConfig.getProjectAddress()))) {
                return ApiResponse.data(null);
            }
            map.put("tenantId", BaseShiroKit.getUser().getTenantId());
        }
        Page pages = new Page((long)Integer.parseInt((String)map.get("page")), (long)Integer.parseInt((String)map.get("limit")));
        List list = this.taskManagerService.getTask(pages, map);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("count", pages.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @Override
    public ApiResponse<Object> getJumpTasks(String taskId) {
        HashMap<String, String> task;
        FlowModel flowModel;
        Map flowModelMessage = this.taskManagerService.getFileByTaskId(taskId);
        ArrayList tasks = new ArrayList();
        if (flowModelMessage.get("main") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)((String)flowModelMessage.get("main")), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new HashMap<String, String>();
                task.put("id", flowObject.getId());
                task.put("value", flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        if (flowModelMessage.get("call") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)((String)flowModelMessage.get("call")), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new HashMap();
                task.put("id", "main_process_" + flowObject.getId());
                task.put("value", "\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        return ApiResponse.data(tasks);
    }
}

