/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SysActEntrustService {
    private static com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService sysActEntrustService = (com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService)SpringContextHolder.getBean(com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public static BpmResponseResult list(String userId, String processId, Integer page, Integer size) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)"\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        QueryWrapper ew = new QueryWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)processId), (Object)"process_id", (Object)processId);
        ew.eq((Object)"consignor", (Object)userId);
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        List list = ((Page)sysActEntrustService.page((IPage)pages, (Wrapper)ew)).getRecords();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)list);
        jsonArray.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public static BpmResponseResult add(String processId, String processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust1 = SysActEntrustService.getSysActEntrust(IdWorker.get32UUID(), processId, processName, consignor, consignee, consigneeName, state, startTime, endTime);
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust1.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust1.getProcessId());
        List list = sysActEntrustService.list((Wrapper)ew);
        if (list.size() >= 1) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getExistConsignee(), null);
        }
        sysActEntrustService.save((Object)sysActEntrust1);
        return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getSuccessSave(), null);
    }

    public static BpmResponseResult addBatch(List<String> processId, List<String> processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        List list = null;
        int isRight = 0;
        for (int i = 0; i < processId.size(); ++i) {
            String id = String.valueOf(processId.get(i));
            String name = String.valueOf(processName.get(i));
            sysActEntrust = SysActEntrustService.getSysActEntrust(IdWorker.get32UUID(), id, name, consignor, consignee, consigneeName, state, startTime, endTime);
            QueryWrapper ew = new QueryWrapper();
            ((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust.getProcessId());
            list = sysActEntrustService.list((Wrapper)ew);
            if (list.size() >= 1) continue;
            sysActEntrust = SysActEntrustService.getSysActEntrust(IdWorker.get32UUID(), id, name, consignor, consignee, consigneeName, state, startTime, endTime);
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getExistConsignee(), null);
        }
        sysActEntrustService.saveBatch(tt, processId.size());
        return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getSuccessSave(), null);
    }

    public static BpmResponseResult delete(String tEntrustId) {
        sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getDeleteSuccess(), null);
    }

    public static BpmResponseResult update(String id, String consignee, String consigneeName, String startTime, String endTime) {
        try {
            SysActEntrust sysActEntrust = SysActEntrustService.getSysActEntrust(id, null, null, null, consignee, consigneeName, null, startTime, endTime);
            sysActEntrustService.updateById((Object)sysActEntrust);
            return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getSuccessUpdate(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return InstallResult.getResult((String)"0", (String)bpmConstantProperties.getErrorUpdate(), null);
        }
    }

    public static BpmResponseResult detail(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(sysActEntrustService.getById((Serializable)((Object)tEntrustId)));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public static BpmResponseResult updateState(String tEntrustId, String state) {
        sysActEntrustService.updataState(tEntrustId, state);
        if ("1".equals(state)) {
            return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getSuccessStart(), null);
        }
        return InstallResult.getResult((String)"1", (String)bpmConstantProperties.getSuccessStop(), null);
    }

    private static SysActEntrust getSysActEntrust(String id, String processId, String processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = new SysActEntrust();
        sysActEntrust.setId(id);
        sysActEntrust.setProcessId(processId);
        sysActEntrust.setProcessName(processName);
        sysActEntrust.setConsignor(consignor);
        sysActEntrust.setConsignee(consignee);
        sysActEntrust.setConsigneeName(consigneeName);
        sysActEntrust.setState(state);
        sysActEntrust.setStartTime(Timestamp.valueOf(startTime));
        sysActEntrust.setEndTime(Timestamp.valueOf(endTime));
        return sysActEntrust;
    }
}

