/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.GodAxeModelService;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.modelassignee.model.ModelAssignee;
import com.jxdinfo.hussar.bpm.modelassignee.service.ModelAssigneeService;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.bpmntoxml.service.Bpm2XMLService;
import com.jxdinfo.hussar.common.exception.LcdpBpmException;
import com.jxdinfo.hussar.constant.BpmEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.flowmodel.FlowModel;
import com.jxdinfo.hussar.flowmodel.FlowObject;
import com.jxdinfo.hussar.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.response.ApiResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GodAxeModelServiceImpl
implements GodAxeModelService {
    private Bpm2XMLService bpm2XMLService;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private BpmConstantProperties bpmConstantProperties;
    private ModelService modelService;
    private SysActProcessFileService sysActProcessFileService;
    private ProcessDefinitionsMapper processDefinitionsMapper;
    private ITaskEngineService taskEngineService;
    private LcdpBpmProperties lcdpBpmProperties;
    private ModelAssigneeService modelAssigneeService;

    @Autowired
    public GodAxeModelServiceImpl(Bpm2XMLService bpm2XMLService, ModelService modelService, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ProcessDefinitionsMapper processDefinitionsMapper, ISysActExtendPropertiesService iSysActExtendPropertiesService, ITaskEngineService ITaskEngineService2, LcdpBpmProperties lcdpBpmProperties, ModelAssigneeService modelAssigneeService) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.processDefinitionsMapper = processDefinitionsMapper;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.taskEngineService = ITaskEngineService2;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.modelAssigneeService = modelAssigneeService;
    }

    @Override
    public ApiResponse<?> saveAndPublish(WorkFlow workFlow, String tenantId) {
        return this.saveWorkflow(workFlow, tenantId, true);
    }

    public void saveAssignee(WorkFlow workFlow) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            String identityKey = workFlow.getIdentity();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            if (ToolUtil.isEmpty((Object)flowModel.getSlots())) {
                return;
            }
            List flowObjects = flowModel.getSlots().getElement();
            ArrayList<ModelAssignee> list = new ArrayList<ModelAssignee>();
            for (FlowObject flowObject : flowObjects) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName())) continue;
                ModelAssignee assigneeModel = new ModelAssignee();
                assigneeModel.setProcTaskDefId(identityKey + ":" + "assign_model" + ":" + flowObject.getInstanceKey());
                assigneeModel.setProcDefKey(identityKey);
                assigneeModel.setType("assign_model");
                assigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                assigneeModel.setText(JSON.toJSONString((Object)flowObject.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                list.add(assigneeModel);
                ModelAssignee ccAssigneeModel = new ModelAssignee();
                ccAssigneeModel.setProcTaskDefId(identityKey + ":" + "cc_assign_model" + ":" + flowObject.getInstanceKey());
                ccAssigneeModel.setProcDefKey(identityKey);
                ccAssigneeModel.setType("cc_assign_model");
                ccAssigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                ccAssigneeModel.setText(JSON.toJSONString((Object)flowObject.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                list.add(ccAssigneeModel);
                ModelAssignee modelAssignee = new ModelAssignee();
                modelAssignee.setProcTaskDefId(identityKey + ":" + "defaultAssign" + ":" + flowObject.getInstanceKey());
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setType("defaultAssign");
                modelAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String assignee = flowObject.getProps().getFlowAssignment().getDefaultBackCondtion();
                modelAssignee.setText(assignee == null ? "".getBytes(StandardCharsets.UTF_8) : assignee.getBytes(StandardCharsets.UTF_8));
                list.add(modelAssignee);
                ModelAssignee conditionAssignee = new ModelAssignee();
                conditionAssignee.setProcTaskDefId(identityKey + ":" + "conditionAssign" + ":" + flowObject.getInstanceKey());
                conditionAssignee.setProcDefKey(identityKey);
                conditionAssignee.setType("conditionAssign");
                conditionAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeBackConditions = flowObject.getProps().getFlowAssignment().getJudgeBackCondition();
                String condAssignee = null;
                if (ToolUtil.isNotEmpty((Object)judgeBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    condAssignee = JSON.toJSONString(condition);
                }
                conditionAssignee.setText(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                list.add(conditionAssignee);
                ModelAssignee ccAssignee = new ModelAssignee();
                ccAssignee.setProcTaskDefId(identityKey + ":" + "defaultCcAssign" + ":" + flowObject.getInstanceKey());
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setType("defaultCcAssign");
                ccAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String ccAssigneeValue = flowObject.getProps().getFlowRecipients().getDefaultCcCondtion();
                ccAssignee.setText(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccAssignee);
                ModelAssignee ccConditionAssignee = new ModelAssignee();
                ccConditionAssignee.setProcTaskDefId(identityKey + ":" + "conditionCcAssign" + ":" + flowObject.getInstanceKey());
                ccConditionAssignee.setProcDefKey(identityKey);
                ccConditionAssignee.setType("conditionCcAssign");
                ccConditionAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeCcBackConditions = flowObject.getProps().getFlowRecipients().getJudgeCcCondition();
                String ccConditionAssigneeValue = null;
                if (ToolUtil.isNotEmpty((Object)judgeCcBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeCcBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    ccConditionAssigneeValue = JSON.toJSONString(condition);
                }
                ccConditionAssignee.setText(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccConditionAssignee);
            }
            this.modelAssigneeService.saveOrUpdateBatch(list);
        }
    }

    @Override
    public synchronized ApiResponse<?> saveWorkflow(WorkFlow workFlow, String tenantId, boolean isPublish) {
        try {
            if (!isPublish) {
                this.saveAssignee(workFlow);
                return ApiResponse.success((String)this.bpmConstantProperties.getSuccessSave());
            }
            List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(0));
            if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
                FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
                List flowObjects = flowModel.getSlots().getElement();
                for (FlowObject flowObject : flowObjects) {
                    if (!"com.jxdinfo.workflow.User".equals(flowObject.getName())) continue;
                    flowObject.getProps().setFlowAssignment(new FlowAssignment());
                    flowObject.getProps().setFlowRecipients(new FlowRecipients());
                }
                flowModel.getSlots().setElement(null);
                flowModel.getSlots().setElement(flowObjects);
                workFlow.setData(null);
                workFlow.setData(JSON.toJSONString((Object)flowModel));
            }
            if (baseList.size() == 2) {
                workFlow.setModelId(oldWorkFlow.getModelId());
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            } else {
                String id = this.modelService.getIdByIdentity(workFlow.getIdentity());
                if (ToolUtil.isNotEmpty((Object)id)) {
                    return ApiResponse.fail((String)this.bpmConstantProperties.getSameIdentity());
                }
                this.sysActProcessFileService.addFile(workFlow, tenantId, Integer.valueOf(0));
            }
            String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
            if (ToolUtil.isEmpty((Object)modelId)) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrorSave());
            }
            if (ToolUtil.isEmpty((Object)oldWorkFlow) || ToolUtil.isEmpty((Object)oldWorkFlow.getModelId())) {
                workFlow.setModelId(modelId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            String processId = this.modelService.deployModel(modelId, tenantId);
            return ApiResponse.success((String)processId);
        }
        catch (LcdpBpmException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    @Override
    public ApiResponse<?> deleteModel(String identity, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identity, tenantId, Integer.valueOf(0));
        String modelId = workFlow.getModelId();
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            this.repositoryService.deleteModel(modelId);
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getDeleteSuccess());
    }

    @Override
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, Map<String, Object> variables, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (variables != null) {
            for (Map.Entry<String, Object> vo : variables.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processDefinitionKey, businessKey, userId, map, tenantId);
    }

    @Override
    public ApiResponse<?> updateMeta(String identity, String name, String category, String tenantId) {
        try {
            if (this.modelService.updateCategory(identity, category) > 0) {
                this.sysActProcessFileService.updateMetaByIdentity(identity, name, category, tenantId);
            }
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public synchronized ApiResponse<?> updateProcess(WorkFlow workFlow, String tenantId) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            List flowObjects = flowModel.getSlots().getElement();
            for (FlowObject flowObject : flowObjects) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName())) continue;
                flowObject.getProps().setFlowAssignment(new FlowAssignment());
                flowObject.getProps().setFlowRecipients(new FlowRecipients());
            }
            flowModel.getSlots().setElement(null);
            flowModel.getSlots().setElement(flowObjects);
            workFlow.setData(null);
            workFlow.setData(JSON.toJSONString((Object)flowModel));
        }
        List baseList = this.sysActProcessFileService.getBaseFileList(workFlow.getIdentity(), tenantId);
        try {
            if (baseList.size() == 2) {
                List list = this.processDefinitionsMapper.getMainOrNew(workFlow.getIdentity());
                String processDefId = workFlow.getIdentity();
                if (ToolUtil.isNotEmpty((Object)list)) {
                    processDefId = ((DefinitionModel)list.get(0)).getId();
                }
                WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(workFlow.getIdentity(), processDefId, tenantId);
                workFlow.setModelId(oldWorkFlow.getModelId());
                Map<String, Object> nodeMessage = this.getRejectFromList(workFlow, oldWorkFlow);
                Map delNodeName = (Map)nodeMessage.get("delNodeName");
                Map result = this.taskEngineService.updateRejectForm(nodeMessage);
                Integer numAll = (Integer)result.get("");
                if (numAll == null) {
                    this.sysActProcessFileService.updateFile(workFlow, tenantId);
                    String modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity());
                    this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId, false);
                    this.saveModelExtendProperties(modelId, workFlow.getName());
                    return ApiResponse.success((int)BpmEnum.SUCCESS_SAVE.getCode(), (String)BpmEnum.SUCCESS_SAVE.getMessage());
                }
                result.remove("");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u672c\u6b21\u5fae\u8c03\u5f71\u54cd\u4e86").append(numAll).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c.\u5176\u4e2d\uff1a");
                for (String key : result.keySet()) {
                    stringBuilder.append("\u5220\u9664\u8282\u70b9\u540d\u4e3a").append((String)delNodeName.get(key)).append("\u7684\u8282\u70b9\u5f71\u54cd\u4e86");
                    stringBuilder.append(result.get(key)).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                String message = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1) + ".";
                return ApiResponse.fail((String)message);
            }
            return ApiResponse.fail((int)BpmEnum.MODEL_NOT_FOUND.getCode(), (String)BpmEnum.MODEL_NOT_FOUND.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private Map<String, Object> getRejectFromList(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
            nodeIds.add(flowObject.getId());
        }
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        List oldElements = oldFlowModel.getSlots().getElement();
        ArrayList<String> delNodeIds = new ArrayList<String>();
        HashMap<String, String> delNodeName = new HashMap<String, String>();
        for (FlowObject flowObject : oldElements) {
            if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName()) || nodeIds.contains(flowObject.getId())) continue;
            delNodeIds.add(flowObject.getId());
            delNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
        }
        map.put("delNodeName", delNodeName);
        map.put("delNodeIds", delNodeIds);
        map.put("nodeIds", nodeIds);
        map.put("procDefId", this.bpm2XMLService.getActDefIdByModelId(workFlow.getModelId()));
        return map;
    }

    private void saveModelExtendProperties(String modelId, String name) {
        ModelBuild modelBuild = this.modelService.queryModel(modelId);
        if (modelBuild != null) {
            String procDefId = modelBuild.getProcessDefinitionId();
            this.processDefinitionsMapper.updateProcessName(procDefId, name);
            BpmnModel model = this.repositoryService.getBpmnModel(procDefId);
            ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
            if (model != null) {
                Collection flowElements = model.getMainProcess().getFlowElements();
                for (FlowElement node : flowElements) {
                    if (!(node instanceof UserTask)) continue;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    JSONObject object = new JSONObject();
                    if (!ToolUtil.isNotEmpty((Object)formDetailKey)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                    if (jsonObject != null) {
                        for (String key : jsonObject.keySet()) {
                            object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setId(procDefId + userTask.getId());
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)object));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
            if (sysActExtendProperties.size() > 0) {
                this.iSysActExtendPropertiesService.saveOrUpdateBatch(sysActExtendProperties);
            }
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }
}

