/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.engine;

import com.jxdinfo.hussar.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.util.Map;

public class InstanceEngineService {
    private static IInstanceEngineService instanceEngineService = (IInstanceEngineService)SpringContextHolder.getBean(IInstanceEngineService.class);
    private static ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);

    public static BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessKey, Map<String, Object> variables) {
        return instanceEngineService.startProcessInstanceById(processDefinitionId, userId, businessKey, BaseShiroKit.getUser().getTenantId(), variables);
    }

    public static BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variables) {
        return instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, BaseShiroKit.getUser().getTenantId(), variables);
    }

    public static BpmResponseResult checkProcessInstByBusinessKey(String businessKey) {
        return instanceEngineService.checkProcessInstByBusinessKey(businessKey);
    }

    public static BpmResponseResult validateEditAuthority(String businessKey) {
        return instanceEngineService.validateEditAuthority(businessKey);
    }

    public static BpmResponseResult validateDeleteByBusinessKey(String businessKey) {
        return instanceEngineService.validateDeleteByBusinessKey(businessKey);
    }

    public static BpmResponseResult suspendProcessInstanceById(String processInstanceId) {
        return instanceEngineService.suspendProcessInstanceById(processInstanceId);
    }

    public static BpmResponseResult activateProcessInstanceById(String processInstanceId) {
        return instanceEngineService.activateProcessInstanceById(processInstanceId);
    }

    public static BpmResponseResult deleteProcessInstance(String processInstanceId, String reason) {
        return instanceEngineService.deleteProcessInstance(processInstanceId, reason);
    }

    public static BpmResponseResult deleteFinishedProcessInstance(String processInstanceId) {
        return instanceEngineService.deleteFinishedProcessInstance(processInstanceId);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        return instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessKey, boolean isValidate) {
        return instanceEngineService.deleteProcessInstanceByBusinessKeyList(businessKey, isValidate);
    }

    public static BpmResponseResult queryFinishedProcessInstance(String processDefinitionKey, String businessKey, int page, int rows) {
        return instanceEngineService.queryFinishedProcessInstance(processDefinitionKey, businessKey, page, rows);
    }

    public static BpmResponseResult queryProcessInstanceCompleteState(String processInstanceId) {
        return instanceEngineService.queryProcessInstanceCompleteState(processInstanceId);
    }

    public static BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessKey) {
        return instanceEngineService.queryProcessInstanceCompleteStateByBusinessKey(businessKey);
    }

    public static BpmResponseResult getProcessTrace(String processInstanceId) {
        return instanceEngineService.getProcessTrace(processInstanceId, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult getAllProcessTrace(String processInstanceId) {
        return instanceEngineService.getAllProcessTrace(processInstanceId, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult queryCallActivityTask(String businessKey, String processInstanceId) {
        return instanceEngineService.queryCallActivityTask(businessKey, processInstanceId, 0, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult queryMainActivityTask(String businessKey, String processInstanceId) {
        return instanceEngineService.queryCallActivityTask(businessKey, processInstanceId, 1, BaseShiroKit.getUser().getTenantId());
    }

    public static BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, int page, int size) {
        return instanceEngineService.getAllProcessTraceByBusinessKey(businessKey, BaseShiroKit.getUser().getTenantId(), page, size);
    }

    public static BpmResponseResult queryProcessDefinitionByInstanceId(String processInstanceId) {
        return instanceEngineService.queryProcessDefinitionByInstanceId(processInstanceId);
    }

    public static BpmResponseResult endProcess(String taskId, String userId, String reason) {
        return instanceEngineService.endProcess(taskId, userId, reason);
    }

    public static BpmResponseResult queryCompleteComent(String businessKey, String processInstanceId, String tenantId) {
        return instanceEngineService.queryCompleteComent(businessKey, processInstanceId, tenantId);
    }
}

