/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.managelog.factory;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.interfacelog.factory.LogType;
import com.jxdinfo.hussar.bsp.managelog.dao.SysActManageLogMapper;
import com.jxdinfo.hussar.bsp.managelog.factory.ManageLogFactory;
import com.jxdinfo.hussar.bsp.managelog.model.SysActManageLog;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class ManageLogTaskFactory {
    private static SysActManageLogMapper sysActManageLog = (SysActManageLogMapper)SpringContextHolder.getBean(SysActManageLogMapper.class);
    private static Logger logger = LoggerFactory.getLogger(ManageLogTaskFactory.class);

    public static TimerTask businessLog(final ShiroUser user, final String businessName, final String className, final String methodName, final String msg, final Map<String, String> info, final String type, final String levelEvent, final ShiroUser shiroUser) {
        return new TimerTask(){

            @Override
            public void run() {
                SysActManageLog sysActLog = ManageLogFactory.createSysSecurityLog(LogType.BUSINESS, user, businessName, className, methodName, msg, LogType.SUCCESS.getMessage(), info, type, levelEvent);
                try {
                    ManageLogTaskFactory.insertSecurityLog(sysActLog, shiroUser);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u4e1a\u52a1\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exitLog(final ShiroUser user, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                String msg = "\u767b\u51fa";
                SysActManageLog sysSecurityLog = ManageLogFactory.createLoginLog(LogType.EXIT, user, msg, info, type);
                try {
                    ManageLogTaskFactory.insertSecurityLog(sysSecurityLog, user);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u9000\u51fa\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    private static void insertSecurityLog(SysActManageLog sysActLog, ShiroUser shiroUser) {
        try {
            DataSourceUtil.changeTempDs((String)shiroUser.getConnName());
            sysActLog.setLogId(IdWorker.get32UUID());
            sysActManageLog.insert(sysActLog);
        }
        finally {
            DataSourceUtil.poll();
        }
    }
}

