/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.jxdinfo.hussar.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.GodAxeModelService;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.managelog.annontion.ManageBusinessLog;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.response.BpmResponseResult;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"godaxeModel"})
public class GodAxeModelController {
    private IInstanceEngineService instanceEngineService;
    private ModelService modelService;
    private GodAxeModelService godAxeModelService;

    @Autowired
    public GodAxeModelController(ModelService modelService, IInstanceEngineService IInstanceEngineService2, GodAxeModelService godAxeModelService) {
        this.modelService = modelService;
        this.instanceEngineService = IInstanceEngineService2;
        this.godAxeModelService = godAxeModelService;
    }

    @RequestMapping(value={"/saveAndPublish"})
    @ManageBusinessLog(key="/godaxeModel/saveAndPublish", value="\u4fdd\u5b58\u5e76\u53d1\u5e03\u6d41\u7a0b\u6a21\u578b", type="\u4fdd\u5b58\u5e76\u53d1\u5e03")
    public ApiResponse<?> saveAndPublish(WorkFlow workFlow) {
        return this.godAxeModelService.saveAndPublish(workFlow, BaseShiroKit.getUser().getTenantId());
    }

    @RequestMapping(value={"/deleteModel"})
    @ManageBusinessLog(key="/godaxeModel/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="\u5220\u9664")
    public ApiResponse<?> deleteModel(@RequestBody Map<String, Object> body) {
        String identity = body.get("identity") == null ? null : (String)body.get("identity");
        String tenantId = BaseShiroKit.getUser().getTenantId();
        return this.godAxeModelService.deleteModel(identity, tenantId);
    }

    @RequestMapping(value={"/validationProcess"})
    @ManageBusinessLog(key="/godaxeModel/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="\u6d4b\u8bd5\u63a5\u53e3")
    public ApiResponse<?> validationProcess(@RequestBody Map<String, Object> body) {
        String tenantId;
        try {
            tenantId = BaseShiroKit.getUser().getTenantId();
        }
        catch (NullPointerException e) {
            return ApiResponse.fail((String)"BASE\u672a\u767b\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u4fe1\u606f");
        }
        String processDefinitionKey = body.get("processDefinitionKey") == null ? null : (String)body.get("processDefinitionKey");
        String userId = body.get("userId") == null ? null : (String)body.get("userId");
        String businessKey = body.get("businessKey") == null ? null : (String)body.get("businessKey");
        Map variables = body.get("variables") == null ? null : (Map)body.get("variables");
        return this.godAxeModelService.validationProcess(processDefinitionKey, businessKey, userId, variables, tenantId);
    }

    @RequestMapping(value={"/doneList"})
    public ApiResponse<?> doneList(@RequestBody Map<String, Object> body) {
        String tenantId;
        try {
            tenantId = BaseShiroKit.getUser().getTenantId();
        }
        catch (NullPointerException e) {
            return ApiResponse.fail((String)"BASE\u672a\u767b\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u4fe1\u606f");
        }
        String businessKey = body.get("businessKey") == null ? null : (String)body.get("businessKey");
        return this.modelService.doneList(businessKey, tenantId);
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @ManageBusinessLog(key="/godaxeModel/deleteProcessInstanceByBusinessKey", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteProcessInstanceByBusinessKey(@RequestBody Map<String, Object> body) {
        try {
            String tenantId = BaseShiroKit.getUser().getTenantId();
        }
        catch (NullPointerException e) {
            BpmResponseResult bpmResponseResult = new BpmResponseResult();
            bpmResponseResult.setCode("0");
            bpmResponseResult.setMsg("BASE\u672a\u767b\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u4fe1\u606f");
        }
        String businessKey = body.get("businessKey") == null ? null : (String)body.get("businessKey");
        return this.instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/updateMeta"})
    @ManageBusinessLog(key="/godaxeModel/updateMeta", value="\u4fee\u6539meta\u6587\u4ef6", type="\u4fee\u6539")
    public ApiResponse<?> updateMeta(@RequestBody Map<String, Object> body) {
        String identity = body.get("identity") == null ? null : (String)body.get("identity");
        String name = body.get("name") == null ? null : (String)body.get("name");
        String category = body.get("category") == null ? null : (String)body.get("category");
        String tenantId = BaseShiroKit.getUser().getTenantId();
        return this.godAxeModelService.updateMeta(identity, name, category, tenantId);
    }

    @RequestMapping(value={"/updateProcess"})
    @ManageBusinessLog(key="/godaxeModel/updateProcess", value="\u6d41\u7a0b\u5fae\u8c03", type="\u4fee\u6539")
    public ApiResponse<?> updateProcess(WorkFlow workFlow) {
        String tenantId = BaseShiroKit.getUser().getTenantId();
        return this.godAxeModelService.updateProcess(workFlow, tenantId);
    }
}

